// --------------------------------------------------------------------------
// Citadel: FileMake.CPP
//
// File making routines.

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "roompriv.h"
#include "libovl.h"
#include "msg.h"
#include "log.h"
#include "hall.h"
#include "group.h"
#include "datafile.h"

// --------------------------------------------------------------------------
// Contents
//
// zapGrpFile() 	erases & reinitializes GRP.DAT
// zapHallFile()	erases & reinitializes HALL?.DAT
// zapRoomPosFile() erases & re-initializes ROOMPOS.DAT
// zapLogFile() 	erases & re-initializes LOG?.DAT
// zapRoomFile()	erases and re-initailizes ROOM.DAT


static void WriteDataFileSize(const char *FileName, long Size)
	{
	char Buffer[128];
	FILE *fd;

	sprintf(Buffer, sbs, cfg.homepath, FileName);

	if ((fd = fopen(Buffer, FO_WB)) == NULL)
		{
		crashout(getcfgmsg(171), FileName);
		}
	else
		{
		fwrite(&Size, sizeof(Size), 1, fd);
		fclose(fd);
		}
	}


// --------------------------------------------------------------------------
// buildhalls(): Builds hall table (all rooms in Maintenance).

void buildhalls(void)
	{
	int i;

	msgDisp(getcfgmsg(162), cfg.Lhall_nym, ltoac(cfg.maxrooms - 1));
	doccr();
	doccr();

	for (i = 4; i < cfg.maxrooms; ++i)
		{
		if (IsRoomInuse(i))
			{
			// Put all rooms into Maintenance, but not windowed
			HallData->GetEntry(1)->SetRoomInHall(i, TRUE);
			HallData->GetEntry(1)->SetWindowedIntoHall(i, FALSE);
			}
		}

	if (!HallData->Save())
		{
		crashout(getmsg(646));
		}
#ifdef WINCIT
	msgDisp(NULL);
	msgCaption(ns);
#endif
	}


// --------------------------------------------------------------------------
// buildroom(): builds a new room according to a message.

void buildroom(Message *mb)
	{
	r_slot roomslot;
	aRoom rBuf;

	if (*mb->GetCopyOfMessage())
		{
		return;
		}

	roomslot = mb->GetRoomNumber();

	if (mb->GetRoomNumber() < cfg.maxrooms)
		{
		getRoom(roomslot, &rBuf);

		if ((strcmp(rBuf.rbname, mb->GetCreationRoom()) != SAMESTRING) ||
				!rBuf.rbflags.IsInuse())
			{
			if (mb->GetRoomNumber() > 3)
				{
				_fmemset(&rBuf, 0, sizeof(aRoom));

				rBuf.rbflags.SetInuse(TRUE);
				rBuf.rbflags.SetPublic(TRUE);

				// recreate network rooms
				if (*mb->GetSourceID())
					{
					rBuf.rbflags.SetShared(TRUE);
					// strcpy(rBuf.netID, deansi(mb->GetCreationRoom()));
					}
				}

			// Don't bother trying to find new name of Dump>
			if (roomslot != DUMP)
				{
				strcpy(rBuf.rbname, mb->GetCreationRoom());
				}

			putRoom(roomslot, &rBuf);
			}
		}
	}


// --------------------------------------------------------------------------
// zapGrpFile(): Erases & reinitializes GRP.DAT.

void zapGrpFile(const char *FileName, const Bool Display)
	{
	if (Display)
		{
		msgDisp(getcfgmsg(163), cfg.Lgroup_nym);
		doccr();
		doccr();
		}

	GroupData->Clear();

	GroupData->GetEntry(0)->SetName(getcfgmsg(165));
	GroupData->GetEntry(0)->SetInuse(TRUE);

	GroupData->GetEntry(1)->SetName(getcfgmsg(166));
	GroupData->GetEntry(1)->SetInuse(TRUE);

	if (FileName)
		{
		if (!GroupData->Save(FileName))
			{
			crashout(getmsg(646));
			}
		}
	else
		{
		if (!GroupData->Save())
			{
			crashout(getmsg(646));
			}
		}

#ifdef WINCIT
	if (Display)
		{
		msgDisp(NULL);
		msgCaption(ns);
		}
#endif
	}


// --------------------------------------------------------------------------
// zapHallFile(): Erases & reinitializes HALL?.DAT.

void zapHallFile(void)
	{
	msgDisp(getcfgmsg(163), cfg.Lhall_nym);
	doccr();
	doccr();

	// Root.
	HallData->GetEntry(0)->SetName(getcfgmsg(168));
	HallData->GetEntry(0)->SetOwned(FALSE);
	HallData->GetEntry(0)->SetInuse(TRUE);

	HallData->GetEntry(0)->SetRoomInHall(LOBBY, TRUE);
	HallData->GetEntry(0)->SetRoomInHall(MAILROOM, TRUE);
	HallData->GetEntry(0)->SetRoomInHall(AIDEROOM, TRUE);

	// Maintenance.
	HallData->GetEntry(1)->SetName(getcfgmsg(169));
	HallData->GetEntry(1)->SetOwned(FALSE);
	HallData->GetEntry(1)->SetInuse(TRUE);

	HallData->GetEntry(1)->SetRoomInHall(LOBBY, TRUE);
	HallData->GetEntry(1)->SetRoomInHall(MAILROOM, TRUE);
	HallData->GetEntry(1)->SetRoomInHall(AIDEROOM, TRUE);

	// and a window between them
	HallData->GetEntry(0)->SetWindowedIntoHall(AIDEROOM, TRUE);
	HallData->GetEntry(1)->SetWindowedIntoHall(AIDEROOM, TRUE);

	if (!HallData->Save())
		{
		crashout(getmsg(646));
		}

#ifdef WINCIT
	msgDisp(NULL);
	msgCaption(ns);
#endif
	}


// --------------------------------------------------------------------------
// zapRoomPosFile(): Erases & re-initializes ROOMPOS.DAT.

void zapRoomPosFile(const Bool Display)
	{
	if (Display)
		{
		char String[128];
		sprintf(String, getcfgmsg(170), cfg.Lroom_nym);
		msgDisp(getcfgmsg(163), String);
		doccr();
		doccr();
		}

	for (r_slot i = 0; i < cfg.maxrooms; i++)
		{
		roomPos[i] = i;
		}
	putRoomPos();

#ifdef WINCIT
	if (Display)
		{
		msgDisp(NULL);
		msgCaption(ns);
		}
#endif
	}


// --------------------------------------------------------------------------
// zapLog2(): Erases & re-initializes LOG2.DAT.

void zapLog2(void)
	{
	LogEntry2 Log2(cfg.maxgroups);
	int i;

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		Log2.Save(i);
		}
	}


// --------------------------------------------------------------------------
// zapLog3(): Erases & re-initializes LOG3.DAT.

void zapLog3(void)
	{
	LogEntry3 Log3(cfg.maxrooms);
	int i;

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		Log3.Save(i);
		}
	}


// --------------------------------------------------------------------------
// zapLog4(): Erases & re-initializes LOG4.DAT.

void zapLog4(void)
	{
	LogEntry4 Log4(cfg.maxrooms);
	int i;

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		Log4.Save(i);
		}
	}


// --------------------------------------------------------------------------
// zapLog5(): Erases & re-initializes LOG5.DAT.

void zapLog5(void)
	{
	LogEntry5 Log5(cfg.maxrooms);
	int i;

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		Log5.Save(i);
		}
	}


// --------------------------------------------------------------------------
// zapLog6(): Erases & re-initializes LOG6.DAT.

void zapLog6(void)
	{
	LogEntry6 Log6(cfg.maxrooms);
	int i;

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		Log6.Save(i);
		}
	}


// --------------------------------------------------------------------------
// zapLogFile(): Erases & re-initializes LOG?.DAT.

void zapLogFile(const Bool UseAlternateNames, const Bool Display)
	{
	LogEntry Log(cfg.maxrooms, cfg.maxgroups, cfg.maxjumpback);

	if (Display)
		{
		msgCaption(getcfgmsg(154), ltoac(cfg.MAXLOGTAB));
		doccr();
		}

	if (UseAlternateNames)
		{
		Log.LogEntry1::SetFileName(getcfgmsg(156));
		Log.LogEntry2::SetFileName(getcfgmsg(157));
		Log.LogEntry3::SetFileName(getcfgmsg(158));
		Log.LogEntry4::SetFileName(getcfgmsg(159));
		Log.LogEntry5::SetFileName(getcfgmsg(160));
		Log.LogEntry6::SetFileName(getcfgmsg(161));
		}

	WriteDataFileSize(Log.LogEntry1::GetFileName(), sizeof(LogDatStructure));

	// write empty buffer all over file
	for (l_slot i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (Display)
			{
			msgDisp(getcfgmsg(152), getcfgmsg(155), ltoac(i + 1));
			cPrintfDOS(br);
			}

		Log.Save(i);
		}

	if (Display)
		{
		doccr();
		doccr();

#ifdef WINCIT
		msgDisp(NULL);
		msgCaption(ns);
#endif
		}
	}


// --------------------------------------------------------------------------
// zapRoomFile(): Erases and re-initailizes ROOM.DAT.

void zapRoomFile(void)
	{
	aRoom rBuf;

	citWinReOpen(&roomfl);
	citSeek(roomfl, 0, SEEK_SET);
	const long l = sizeof(aRoom);
	citWrite(&l, sizeof(l), 1, roomfl);
	citWinCloseTmp(&roomfl);

	msgCaption(getcfgmsg(151), ltoac(cfg.maxrooms));
	doccr();

	_fmemset(&rBuf, 0, sizeof(aRoom));

	for (int i = DUMP + 1; i < cfg.maxrooms; i++)
		{
		msgDisp(getcfgmsg(152), cfg.Lroom_nym, ltoac(i + 1));
		cPrintfDOS(br);
		getRoomTab(i)->locked = FALSE;
		putRoom(i, &rBuf);
		}

	// Lobby> always exists -- guarantees us a place to stand
	strcpy(rBuf.rbname, getcfgmsg(144));
	rBuf.rbflags.SetPermanent(TRUE);
	rBuf.rbflags.SetPublic(TRUE);
	rBuf.rbflags.SetInuse(TRUE);
	getRoomTab(LOBBY)->locked = FALSE;
	putRoom(LOBBY, &rBuf);

	// Mail> is also permanent...
	strcpy(rBuf.rbname, getcfgmsg(145));
	rBuf.rbflags.SetPermanent(TRUE);
	rBuf.rbflags.SetPublic(TRUE);
	rBuf.rbflags.SetInuse(TRUE);
	getRoomTab(MAILROOM)->locked = FALSE;
	putRoom(MAILROOM, &rBuf);

	// Aide) also...
	strcpy(rBuf.rbname, getcfgmsg(146));
	rBuf.rbflags.SetPermanent(TRUE);
	rBuf.rbflags.SetPublic(FALSE);
	rBuf.rbflags.SetInuse(TRUE);
	getRoomTab(AIDEROOM)->locked = FALSE;
	putRoom(AIDEROOM, &rBuf);

	// Dump> also...
	strcpy(rBuf.rbname, getcfgmsg(147));
	rBuf.rbflags.SetPermanent(TRUE);
	rBuf.rbflags.SetPublic(TRUE);
	rBuf.rbflags.SetInuse(TRUE);
	getRoomTab(DUMP)->locked = FALSE;
	putRoom(DUMP, &rBuf);

	doccr();
	doccr();

#ifdef WINCIT
	msgDisp(NULL);
	msgCaption(ns);
#endif
	}
