// --------------------------------------------------------------------------
// Citadel: ExtMsg.CPP
//
// Stuff to deal with discardable messages.

#include "ctdl.h"
#pragma hdrstop

// --------------------------------------------------------------------------
// Contents
//
// read_message 	read in the message file


// --------------------------------------------------------------------------
// read in the message file
Bool read_messages(void)
	{
	if ((msgs = readData(1, 0, 1)) == NULL)
		{
		return (FALSE);
		}

	if ((dateInfo = readData(3)) == NULL)
		{
		discardData(msgs);
		msgs = NULL;
		return (FALSE);
		}

	msgsI = (const char **) msgs->aux;

	monthTab = (const char **) dateInfo->aux;
	fullmnts = (const char **) dateInfo->next->aux;
	days = (const char **) dateInfo->next->next->aux;
	fulldays = (const char **) dateInfo->next->next->next->aux;
	amPtr = ((const char **) (dateInfo->next->next->next->next->aux))[0];
	pmPtr = ((const char **) (dateInfo->next->next->next->next->aux))[1];

	return (TRUE);
	}

static int read_net_counter;

Bool read_net_messages(void)
	{
	read_net_counter++;

	if (!netmsgs)
		{
		if ((netmsgs = readData(4)) == NULL)
			{
			read_net_counter--;
			return (FALSE);
			}
		}

	netmsgsI = (const char **) netmsgs->aux;

	return (TRUE);
	}

void dump_net_messages(void)
	{
	if (!(--read_net_counter))
		{
		discardData(netmsgs);
		netmsgs = NULL;
		netmsgsI = NULL;
		}

	if (read_net_counter < 0)
		{
		read_net_counter = 0;
		}
	}

static int read_sys_counter;

Bool read_sys_messages(void)
	{
	read_sys_counter++;

	if (!sysmsgs)
		{
		if ((sysmsgs = readData(5)) == NULL)
			{
			read_sys_counter--;
			return (FALSE);
			}
		}

	sysmsgsI = (const char **) sysmsgs->aux;

	return (TRUE);
	}

void dump_sys_messages(void)
	{
	if (!(--read_sys_counter))
		{
		discardData(sysmsgs);
		sysmsgs = NULL;
		sysmsgsI = NULL;
		}

	if (read_sys_counter < 0)
		{
		read_sys_counter = 0;
		}
	}

static int read_cfg_counter;

Bool read_cfg_messages(void)
	{
	read_cfg_counter++;

	if (!cfgmsgs)
		{
		if ((cfgmsgs = readData(0, 0, 0)) == NULL)
			{
			read_cfg_counter--;
			return (FALSE);
			}
		}

	cfgmsgsI = (const char **) cfgmsgs->aux;

	return (TRUE);
	}

void dump_cfg_messages(void)
	{
	if (!(--read_cfg_counter))
		{
		discardData(cfgmsgs);
		cfgmsgs = NULL;
		cfgmsgsI = NULL;
		}

	if (read_cfg_counter < 0)
		{
		read_cfg_counter = 0;
		}
	}

static int read_ec_counter;

Bool read_ec_messages(void)
	{
	read_ec_counter++;

	if (!ecmsgs)
		{
		if ((ecmsgs = readData(18)) == NULL)
			{
			read_ec_counter--;
			return (FALSE);
			}
		}

	ecmsgsI = (const char **) ecmsgs->aux;

	return (TRUE);
	}

void dump_ec_messages(void)
	{
	if (!(--read_ec_counter))
		{
		discardData(ecmsgs);
		ecmsgs = NULL;
		ecmsgsI = NULL;
		}

	if (read_ec_counter < 0)
		{
		read_ec_counter = 0;
		}
	}

static int read_fs_counter;

Bool read_fs_messages(void)
	{
	read_fs_counter++;

	if (!fsmsgs)
		{
		if ((fsmsgs = readData(20)) == NULL)
			{
			read_fs_counter--;
			return (FALSE);
			}
		}

	fsmsgsI = (const char **) fsmsgs->aux;

	return (TRUE);
	}

void dump_fs_messages(void)
	{
	if (!(--read_fs_counter))
		{
		discardData(fsmsgs);
		fsmsgs = NULL;
		fsmsgsI = NULL;
		}

	if (read_fs_counter < 0)
		{
		read_fs_counter = 0;
		}
	}

static int read_cw_counter;

Bool read_cw_messages(void)
	{
	read_cw_counter++;

	if (!cwmsgs)
		{
		if ((cwmsgs = readData(21)) == NULL)
			{
			read_cw_counter--;
			return (FALSE);
			}
		}

	cwmsgsI = (const char **) cwmsgs->aux;

	return (TRUE);
	}

void dump_cw_messages(void)
	{
	if (!(--read_cw_counter))
		{
		discardData(cwmsgs);
		cwmsgs = NULL;
		cwmsgsI = NULL;
		}

	if (read_cw_counter < 0)
		{
		read_cw_counter = 0;
		}
	}


static int read_zm_counter;

Bool read_zm_messages(void)
	{
	read_zm_counter++;

	if (!zmmsgs)
		{
		if ((zmmsgs = readData(19)) == NULL)
			{
			read_zm_counter--;
			return (FALSE);
			}
		}

	zmmsgsI = (const char **) zmmsgs->aux;

	return (TRUE);
	}

void dump_zm_messages(void)
	{
	if (!(--read_zm_counter))
		{
		discardData(zmmsgs);
		zmmsgs = NULL;
		zmmsgsI = NULL;
		}

	if (read_zm_counter < 0)
		{
		read_zm_counter = 0;
		}
	}

static int read_db_counter;

Bool read_db_messages(void)
	{
	read_db_counter++;

	if (!dbmsgs)
		{
		if ((dbmsgs = readData(1, 3, 3)) == NULL)
			{
			read_db_counter--;
			return (FALSE);
			}
		}

	dbmsgsI = (const char **) dbmsgs->aux;

	return (TRUE);
	}

void dump_db_messages(void)
	{
	if (!(--read_db_counter))
		{
		discardData(dbmsgs);
		dbmsgs = NULL;
		dbmsgsI = NULL;
		}

	if (read_db_counter < 0)
		{
		read_db_counter = 0;
		}
	}

// Note that these next two functions are not very "safe," as there are
// plenty of chances for crashout() to be called in the second one.
#define PurgeMsg(x) if (x##msgs)						\
						{								\
						assert(read_##x##_counter); 	\
						discardData(x##msgs);			\
						x##msgs = NULL; 				\
						x##msgsI = NULL;				\
						}								\
					else								\
						{								\
						assert(!read_##x##_counter);	\
						}

void PurgeAllSubMessages(void)
	{
	PurgeMsg(net);
	PurgeMsg(sys);
	PurgeMsg(cfg);
	PurgeMsg(ec);
	PurgeMsg(fs);
	PurgeMsg(cw);
	PurgeMsg(zm);
	PurgeMsg(db);
	}

void ReloadAllSubMessages(void)
	{
	assert(!netmsgs);
	assert(!sysmsgs);
	assert(!cfgmsgs);
	assert(!ecmsgs);
	assert(!fsmsgs);
	assert(!cwmsgs);
	assert(!zmmsgs);
	assert(!dbmsgs);

	// We turn off debug until the debug messages are loaded...
	Bool SaveDebug = debug;
	debug = FALSE;

	if (read_db_counter)
		{
		if ((dbmsgs = readData(1, 3, 3)) == NULL)
			{
			crashout(getmsg(630));
			}

		dbmsgsI = (const char **) dbmsgs->aux;
		}

	debug = SaveDebug;

	if (read_net_counter)
		{
		if ((netmsgs = readData(4)) == NULL)
			{
			crashout(getmsg(630));
			}

		netmsgsI = (const char **) netmsgs->aux;
		}

	if (read_sys_counter)
		{
		if ((sysmsgs = readData(5)) == NULL)
			{
			crashout(getmsg(630));
			}

		sysmsgsI = (const char **) sysmsgs->aux;
		}

	if (read_cfg_counter)
		{
		if ((cfgmsgs = readData(0, 0, 0)) == NULL)
			{
			crashout(getmsg(630));
			}

		cfgmsgsI = (const char **) cfgmsgs->aux;
		}

	if (read_ec_counter)
		{
		if ((ecmsgs = readData(18)) == NULL)
			{
			crashout(getmsg(630));
			}

		ecmsgsI = (const char **) ecmsgs->aux;
		}

	if (read_fs_counter)
		{
		if ((fsmsgs = readData(20)) == NULL)
			{
			crashout(getmsg(630));
			}

		fsmsgsI = (const char **) fsmsgs->aux;
		}

	if (read_cw_counter)
		{
		if ((cwmsgs = readData(21)) == NULL)
			{
			crashout(getmsg(630));
			}

		cwmsgsI = (const char **) cwmsgs->aux;
		}

	if (read_zm_counter)
		{
		if ((zmmsgs = readData(19)) == NULL)
			{
			crashout(getmsg(630));
			}

		zmmsgsI = (const char **) zmmsgs->aux;
		}
	}
