// --------------------------------------------------------------------------
// Citadel: DoUpDown.CPP
//
// .U/.D Commands

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "infofile.h"
#include "filecmd.h"
#include "log.h"
#include "msg.h"
#include "account.h"
#include "menus.h"
#include "aplic.h"
#include "miscovl.h"


// --------------------------------------------------------------------------
// Contents
//
// doFileQueue()		handles Q(ueue) command
// doDownload() 		handles D(ownload) command
// doUpload()			handles U(pload) command

void doFileQueue(void)
	{
	int ich;

	mPrintf(getmsg(335));

	switch (toupper(ich = iCharNE()))
		{
		case 'A':
			{
			mPrintf(getmsg(358));

			if (!TI()loggedIn && !cfg.unlogReadOk)
				{
				CRCRmPrintfCR(getmsg(213));
				}
			else if (!TI()CurrentUser->IsDownload())
				{
				CRCRmPrintfCR(getmsg(364), getmsg(366));
				}
			else if (IsRoomUploadOnly(TI()thisRoom) &&
					!TI()CurrentUser->HasRoomPrivileges(TI()thisRoom))
				{
				CRCRmPrintfCR(getmsg(214), cfg.Uroom_nym);
				}
			else if (CheckDirectoryRoom())
				{
				addFileQueue();
				}
			break;
			}

		case 'C':
			{
			mPrintf(getmsg(337));
			clearFileQueue();
			break;
			}

		case 'D':
			{
			mPrintf(getmsg(212));

			if (downloadFileQueue())
				{
				clearFileQueue();
				}

			break;
			}

		case 'L':
			{
			mPrintf(getmsg(340));
			listFileQueue();
			break;
			}

		case 'R':
			{
			mPrintf(getmsg(359));
			removeFileQueue();
			break;
			}

		case '?':
			{
			oChar('?');
			showMenu(M_FILEQUEUE);
			break;
			}

		case ESC:
			{
			break;
			}

		default:
			{
			BadMenuSelection(ich);
			break;
			}
		}
	}


// --------------------------------------------------------------------------
// doDownload()

void doDownload(Bool ex)
	{
	SetDoWhat(DODOWNLOAD);

	mPrintf(getmsg(212));

	if (TI()fileList)
		{
		// queue
		if (downloadFileQueue())
			{
			clearFileQueue();
			}
		}
	else if (!TI()loggedIn && !cfg.unlogReadOk)
		{
		CRCRmPrintfCR(getmsg(213));
		}
	else if (!TI()CurrentUser->IsDownload())
		{
		CRCRmPrintfCR(getmsg(364), getmsg(366));
		}
	else if (CheckDirectoryRoom())
		{
		if (IsRoomUploadOnly(TI()thisRoom) &&
				!TI()CurrentUser->HasRoomPrivileges(TI()thisRoom))
			{
			CRCRmPrintfCR(getmsg(214), cfg.Uroom_nym);
			}
		else
			{
			download((char) ((ex || !TI()CurrentUser->GetDefaultProtocol()) ?
					'\0' : TI()CurrentUser->GetDefaultProtocol()));
			}
		}
	}


// --------------------------------------------------------------------------
// doUpload()

void doUpload(Bool ex)
	{
	SetDoWhat(DOUPLOAD);

	mPrintf(getmsg(216));

	if (!TI()loggedIn && !cfg.unlogEnterOk)
		{
		CRCRmPrintfCR(getmsg(217));
		return;
		}

	if (!TI()CurrentUser->IsUpload())
		{
		CRCRmPrintfCR(getmsg(364), getmsg(365));
		return;
		}

	if (CheckDirectoryRoom())
		{
		// handle downonly flag
		if (IsRoomDownloadOnly(TI()thisRoom) &&
				!TI()CurrentUser->HasRoomPrivileges(TI()thisRoom))
			{
			CRCRmPrintfCR(getmsg(218), cfg.Uroom_nym);
			return;
			}
		else
			{
			upload((char) (

					(ex || !TI()CurrentUser->GetDefaultProtocol()) ?

					'\0' : TI()CurrentUser->GetDefaultProtocol()
					)

					, FALSE);
			}
		}
	}
