// --------------------------------------------------------------------------
// Citadel: DoInv.CPP
//
// .Invite... commands

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "log.h"
#include "menus.h"
#include "miscovl.h"


// --------------------------------------------------------------------------
// Contents
//
// doInvite()				handles .I(nvite) command

static void inviteUser(void);
static void inviteRoomList(void);
static void inviteUserList(void);

void inviteUserList(void)
	{
	label roomname;

	doCR();

	do
		{
		getString(getmsg(1279), roomname, LABELSIZE, TRUE, ECHO,
				GetRoomName(TI()thisRoom));

		if (*roomname == '?')
			{
			ListAllRooms(FALSE, FALSE, FALSE);
			}
		} while (*roomname == '?');

	r_slot roomslot = RoomExists(roomname);
	if (roomslot == CERROR)
		{
		roomslot = PartialRoomExists(roomname, TI()thisRoom, TRUE);
		}

	if ((roomslot) == CERROR || !(*roomname))
		{
		if (*roomname)
			{
			CRmPrintf(getmsg(157), cfg.Lroom_nym, roomname);
			}
		}
	else
		{
		LogEntry1 Log1;
		LogEntry3 Log3(cfg.maxrooms);
		l_slot i;

		TI()UserControl.SetOutFlag(OUTOK);

		CRmPrintfCR(getmsg(1280), cfg.Uroom_nym, GetRoomName(roomslot),
				cfg.Lusers_nym);

		TI()MRO.Verbose = FALSE;
		prtList(LIST_START);

		for (i = 0; i < cfg.MAXLOGTAB && (TI()UserControl.CanOutput()); i++)
			{
			if (LogTab->GetEntry(i)->IsInuse())
				{
				if (Log3.Load(LogTab->GetEntry(i)->GetLogIndex()) &&
						!Log3.IsInRoom(roomslot))
					{
					if (Log1.Load(LogTab->GetEntry(i)->GetLogIndex()))
						{
						prtList(Log1.GetName());
						}
					}
				}
			if (TI()UserControl.GetOutFlag() == OUTSKIP)
				{
				return;
				}
			}

		prtList(LIST_END);

		if (TI()UserControl.GetOutFlag() != OUTSKIP)
			{
			TI()UserControl.SetOutFlag(OUTOK);

			CRmPrintfCR(getmsg(1281), cfg.Uroom_nym, GetRoomName(roomslot),
					cfg.Lusers_nym);

			prtList(LIST_START);

			for (i = 0; i < cfg.MAXLOGTAB && (TI()UserControl.GetOutFlag() != OUTSKIP); i++)
				{
				if (LogTab->GetEntry(i)->IsInuse())
					{
					if (Log3.Load(LogTab->GetEntry(i)->GetLogIndex()) &&
							Log3.IsInRoom(roomslot))
						{
						if (Log1.Load(LogTab->GetEntry(i)->GetLogIndex()))
							{
							prtList(Log1.GetName());
							}
						}
					}
				}
			prtList(LIST_END);
			}
		}
	}

void inviteRoomList(void)
	{
	label who;
	l_slot logNo;

	doCR();

	do
		{
		getString(getmsg(599), who, LABELSIZE, TRUE, ECHO,
				TI()loggedIn ? TI()CurrentUser->GetName() : ns);

		if (*who == '?')
			{
			ListUsers(TI()CurrentUser->IsAide());
			}
		} while (*who == '?');
	normalizeString(who);

	logNo = FindPersonByPartialName(who);
	if (logNo == CERROR || !*who)
		{
		if (*who)
			{
			mPrintfCR(getmsg(595), who);
			}
		}
	else
		{
		LogEntry1 Log1;
		LogEntry3 Log3(cfg.maxrooms);
		r_slot i;

		if (Log1.Load(LogTab->GetEntry(logNo)->GetLogIndex()) &&
				Log3.Load(LogTab->GetEntry(logNo)->GetLogIndex()))
			{
			CopyStringToBuffer(who, Log1.GetName(), LABELSIZE);

			doCR();
			TI()UserControl.SetOutFlag(OUTOK);

			mPrintfCR(getmsg(1282), cfg.Urooms_nym, Log1.GetName());

			TI()MRO.Verbose = FALSE;
			if (!TI()CurrentUser->IsWideRoom())
				{
				prtList(LIST_START);
				}

			for (i = 0; i < cfg.maxrooms && (TI()UserControl.GetOutFlag() != OUTSKIP); i++)
				{
				if (IsRoomInuse(i) && !Log3.IsInRoom(i))
					{
					printroomVer(i, FALSE);
					}
				}

			if (TI()UserControl.GetOutFlag() != OUTSKIP)
				{
				if (!TI()CurrentUser->IsWideRoom())
					{
					prtList(LIST_END);
					}
				else
					{
					doCR();
					}

				TI()UserControl.SetOutFlag(OUTOK);

				CRmPrintfCR(getmsg(1283), cfg.Urooms_nym, Log1.GetName());

				TI()MRO.Verbose = FALSE;
				prtList(LIST_START);

				for (i = 0; i < cfg.maxrooms && (TI()UserControl.GetOutFlag() != OUTSKIP); i++)
					{
					if (IsRoomInuse(i) && Log3.IsInRoom(i))
						{
						printroomVer(i, FALSE);
						}
					}

				if (!TI()CurrentUser->IsWideRoom())
					{
					prtList(LIST_END);
					}
				else
					{
					doCR();
					}
				}
			}
		}
	}

void inviteUser(void)
	{
	label who;
	l_slot logNo;

	doCR();

	do
		{
		getString(getmsg(599), who, LABELSIZE, TRUE, ECHO,
				TI()loggedIn ? TI()CurrentUser->GetName() : ns);

		if (*who == '?')
			{
			ListUsers(TI()CurrentUser->IsAide());
			}
		} while (*who == '?');
	normalizeString(who);

	logNo = FindPersonByPartialName(who);
	if (logNo == CERROR || !*who)
		{
		if (*who)
			{
			mPrintfCR(getmsg(595), who);
			}
		}
	else
		{
		label roomname;
		r_slot roomslot;

		do
			{
			getString(getmsg(1279), roomname, LABELSIZE, TRUE, ECHO,
					GetRoomName(TI()thisRoom));

			if (*roomname == '?')
				{
				ListAllRooms(FALSE, FALSE, FALSE);
				}
			} while (*roomname == '?');

		roomslot = RoomExists(roomname);
		if (roomslot == CERROR)
			{
			roomslot = PartialRoomExists(roomname, TI()thisRoom, TRUE);
			}

		if ((roomslot) == CERROR || !(*roomname))
			{
			if (*roomname)
				{
				CRmPrintf(getmsg(157), cfg.Lroom_nym, roomname);
				}
			}
		else
			{
			LogEntry1 Log1;
			LogEntry3 Log3(cfg.maxrooms);
			char query[128];

			if (Log1.Load(LogTab->GetEntry(logNo)->GetLogIndex()) &&
					Log3.Load(LogTab->GetEntry(logNo)->GetLogIndex()))
				{
				CopyStringToBuffer(who, Log1.GetName(), LABELSIZE);

				if (!Log3.IsInRoom(roomslot))
					{
					sprintf(query, getmsg(1284), who, cfg.Lroom_nym,
							GetRoomName(roomslot));

					if (getYesNo(query, 0))
						{
						Log3.SetInRoom(roomslot, TRUE);

						if (Log3.Save(LogTab->GetEntry(logNo)->GetLogIndex()))
							{
							char TrapString[256];

							sprintf(TrapString, getmsg(1285), who,
									GetRoomName(roomslot),
									TI()CurrentUser->GetName());

							trap(TrapString, T_AIDE);
							}
						}
					}
				else
					{
					sprintf(query, getmsg(1286), who, cfg.Lroom_nym,
							GetRoomName(roomslot));

					if (getYesNo(query, 0))
						{
						Log3.SetInRoom(roomslot, FALSE);
						if (Log3.Save(LogTab->GetEntry(logNo)->GetLogIndex()))
							{
							char TrapString[256];

							sprintf(TrapString, getmsg(1278), who,
									GetRoomName(roomslot),
									TI()CurrentUser->GetName());

							trap(TrapString, T_AIDE);
							}
						}
					}

				// see if it is us
				if (TI()loggedIn &&
						SameString(TI()CurrentUser->GetName(), who))
					{
					TI()CurrentUser->SetInRoom(roomslot,
							Log3.IsInRoom(roomslot));
					}
				}
			}
		}
	}

void doInvite(void)
	{
	int ich;

	TI()MRO.Reverse = FALSE;

	mPrintf(getmsg(1277));

	switch (toupper(ich = iCharNE()))
		{
		case 'L':
			{
			mPrintf(getmsg(340));
			inviteUserList();
			break;
			}

		case 'R':
			{
			mPrintf(pcts, cfg.Urooms_nym);
			inviteRoomList();
			break;
			}

		case '\n':
		case 'U':
			{
			mPrintf(pcts, cfg.Uuser_nym);
			inviteUser();
			break;
			}

		case '?':
			{
			oChar('?');
			showMenu(M_INVITE);
			break;
			}

		case ESC:
			{
			break;
			}

		default:
			{
			BadMenuSelection(ich);
			break;
			}
		}
	}
