// --------------------------------------------------------------------------
// Citadel: DoAide.CPP
//
// Code for doAide() and some function implemetations.

#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "infofile.h"
#include "setinfo.h"
#include "filecmd.h"
#include "log.h"
#include "msg.h"
#include "hall.h"
#include "menus.h"
#include "helpfile.h"
#include "blurbs.h"
#include "miscovl.h"


// --------------------------------------------------------------------------
// Contents
//
// doAide() 	handles the aide-only menu
// msgNym() 	Aide message nym setting function


static void msgNym(void);


// --------------------------------------------------------------------------
// doAide(): Handles the aide-only menu.

void doAide(Bool moreYet, char first)
	{
	SetDoWhat(DOAIDE);

	TI()MRO.Reverse = FALSE;
	TI()MRO.Verbose = TI()CurrentUser->IsAutoVerbose();

	if (moreYet)
		{
		first = 0;
		}

	mPrintf(pctss, getmsg(323));

	int ich;
	switch (toupper(first ? (int) first : (ich = iCharNE())))
		{
		case 'A':
			{
			mPrintf(getmsg(324));

			if (CheckDirectoryRoom())
				{
				attributes();
				}

			break;
			}

		case 'C':
			{
			SetDoWhat(AIDECHAT);

			TI()chatReq = TRUE;
			if (!TI()CurrentUser->IsChat() || !(cfg.aideChatHours[hour()]))
				{
				doChat(TRUE, TRUE); // nochat.blb if NOCHAT, else by cfg.noChat
				}
			else
				{
				mPrintfCR(getmsg(219));

				const Bool oldchat = cfg.noChat;
				cfg.noChat = FALSE;

				if (TI()whichIO == MODEM)
					{
					ringSysop(TRUE, TRUE);
					}
				else
					{
					chat();
					}

				cfg.noChat = oldchat;
				}

			break;
			}

		case 'E':
			{
			mPrintfCR(getmsg(325), cfg.Lroom_nym);
			editRoom();
			break;
			}

		case 'F':
			{
			SetDoWhat(AIDEFILESET);

			mPrintf(getmsg(326));

			if (CheckDirectoryRoom())
				{
				Message *Msg = new Message;

				if (Msg)
					{
					doCR();

					if (FillFileInfo(GetCurrentRoomDirectory(),
							TI()CurrentUser->GetName(), TRUE,
							Msg->GetTextPointer(), FALSE))
						{
						Msg->SetRoomNumber(TI()thisRoom);
						systemMessage(Msg);
						}

					delete Msg;
					}
				else
					{
					mPrintf(getmsg(188), getmsg(614));
					}
				}

			break;
			}

		case 'G':
			{
			mPrintfCR(getmsg(327), cfg.Ugroup_nym);
			SetDoWhat(AIDEGROUP);

			groupfunc(NULL, NULL, 0);
			break;
			}

		case 'H':
			{
			mPrintfCR(getmsg(328), cfg.Uhall_nym);

			if (!cfg.aidehall && !TI()CurrentUser->IsSysop())
				{
				mPrintfCR(getmsg(329));
				}
			else
				{
				hallfunc();
				}

			break;
			}

		case 'I':
			{
			mPrintfCR(getmsg(330), cfg.Lmsg_nym);
			insert(TI()MS.MarkedID);
			break;
			}

		case 'J':
			{
			mPrintfCR(getmsg(538), GetRoomName(AIDEROOM), cfg.Lroom_nym,
					HallData->GetEntry(1)->GetName(), cfg.Lhall_nym);

			if (TI()CurrentUser->CanAccessRoom(AIDEROOM, FALSE, TRUE) &&
					TI()CurrentUser->CanAccessHall(1))
				{
				if (TI()CurrentUser->IsUsePersonalHall())
					{
					CRCRmPrintfCR(getmsg(617), cfg.Uhall_nym, cfg.Lhall_nym);
					}
				else
					{
					TI()thisHall = 1;	// Maintenance is hall 1.
					}

				label AideName;

				// See note in stepRoom() for explanation of this strcpy().

				strcpy(AideName, GetRoomName(AIDEROOM));

				gotoRoom(AideName, FALSE, FALSE, FALSE);
				}
			else
				{
				CRmPrintfCR(getmsg(537), cfg.Lgroup_nym);
				}

			break;
			}

		case 'K':
			{
			mPrintfCR(getmsg(331), cfg.Lroom_nym);
			killroom(NULL);
			break;
			}

		case 'L':
			{
			mPrintf(getmsg(332), cfg.Lgroup_nym);
			listgroup();
			break;
			}

		case 'M':
			{
			mPrintf(getmsg(333));
			if (CheckDirectoryRoom())
				{
				MoveFile();
				}
			break;
			}

		case 'N':
			{
			mPrintf(getmsg(334), cfg.Lmsgs_nym);
			msgNym();
			break;
			}

		case 'Q':
			{
			SetDoWhat(AIDEQUEUE);

			Bool done;

			mPrintf(getmsg(335));
			do
				{
				done = TRUE;
				switch (toupper(ich= iCharNE()))
					{
					case 'A':
						{
						mPrintf(getmsg(336));
						automark();
						break;
						}

					case 'C':
						{
						mPrintf(getmsg(337));
						clearmsglist();
						break;
						}

					case 'I':
						{
						mPrintf(getmsg(338));
						insertmsglist();
						break;
						}

					case 'K':
						{
						mPrintf(getmsg(339));
						killmsglist();
						break;
						}

					case 'L':
						{
						mPrintf(getmsg(340));
						printmsglist();
						break;
						}

					case 'M':
						{
						mPrintf(getmsg(341));	// Combine Kill and Insert
						killmsglist();
						insertmsglist();
						break;
						}

					case 'R':
						{
						mPrintf(getmsg(342), cfg.Uroom_nym);
						markroom();
						break;
						}

					case 'S':
						{
						SetDoWhat(AIDEQUEUES);

						mPrintfCR(getmsg(343));

						// sort forward
						if (getYesNo(getmsg(303), 0))
							{
							sortmsglist(0);
							}
						// sort reverse
						else if (getYesNo(getmsg(308), 0))
							{
							sortmsglist(1);
							}

						break;
						}

					case 'V':
						{
						mPrintf(getmsg(279));
						TI()MRO.Verbose = TRUE;
						done = FALSE;
						break;
						}

					case ESC:
						{
						break;
						}

					default:
						{
						oChar(ich);
						mPrintf(sqst);

						if (!TI()CurrentUser->IsExpert())
							{
							break;
							}
						}

					case '?':
						{
						if (ich == '?')
							{
							oChar('?');
							}

						showMenu(M_AIDEQUEUE);
						break;
						}
					}
				} while (!done);

			break;
			}

		case 'R':
			{
			mPrintf(getmsg(558));
			if (CheckDirectoryRoom())
				{
				renamefile();
				}
			break;
			}

		case 'S':
			{
			mPrintf(getmsg(559));
			if (CheckDirectoryRoom())
				{
				SetFileInfo();
				}
			break;
			}

		case 'U':
			{
			mPrintf(getmsg(560));

			if (CheckDirectoryRoom())
				{
				unlinkfile();
				}

			break;
			}

		case 'V':
			{
			SetDoWhat(AIDEVIEW);

			mPrintfCR(getmsg(561));
			dispHlp(H_AIDE);
			break;
			}

		case 'W':
			{
			mPrintfCR(getmsg(562), cfg.Lhall_nym);

			if (cfg.subhubs == 4)
				{
				mPrintfCR(getmsg(282));
				return;
				}

			if (!cfg.aidehall && !TI()CurrentUser->IsSysop())
				{
				mPrintfCR(getmsg(329));
				}
			else
				{
				windowfunc();
				}

			break;
			}

		case '+':
			{
			moveRoom(1, TRUE);
			break;
			}

		case '-':
			{
			moveRoom(-1, TRUE);
			break;
			}

		case '<':
			{
			mPrintfCR(getmsg(563), cfg.Lmsg_nym);
			copymsg();
			break;
			}

		case '?':
			{
			oChar('?');
			SetDoWhat(AIDEMENU);
			showMenu(M_AIDE);
			break;
			}

		case ESC:
			{
			break;
			}

		default:
			{
			BadMenuSelection(ich);
			break;
			}
		}
	}


// --------------------------------------------------------------------------
// msgNym(): Aide message nym setting function.

static void msgNym(void)
	{
	doCR();
	if (!cfg.msgNym)
		{
		CRmPrintfCR(getmsg(566));
		return;
		}

	Message *Msg = new Message;
	if (Msg)
		{
		label stuff;
		char string[64];

		SetDoWhat(AIDENYM);

		GetStringWithBlurb(getmsg(564), stuff, LABELSIZE, cfg.Lmsg_nym,
				B_MSGNYM);

		normalizeString(stuff);

		if (*stuff)
			{
			label L;
			CopyStringToBuffer(cfg.Lmsg_nym, MakeItLower(stuff, L),
					LABELSIZE);
			CopyStringToBuffer(cfg.Umsg_nym, MakeItUpper(stuff, L),
					LABELSIZE);
			}

		GetStringWithBlurb(getmsg(565), stuff, LABELSIZE, cfg.Lmsgs_nym,
				B_MSGNYM);

		normalizeString(stuff);

		if (*stuff)
			{
			label L;
			CopyStringToBuffer(cfg.Lmsgs_nym, MakeItLower(stuff, L),
					LABELSIZE);
			CopyStringToBuffer(cfg.Umsgs_nym, MakeItUpper(stuff, L),
					LABELSIZE);
			}

		sprintf(string, getmsg(567), cfg.Lmsgs_nym);
		GetStringWithBlurb(string, stuff, LABELSIZE, cfg.Lmsg_done, B_MSGNYM);

		normalizeString(stuff);

		if (*stuff)
			{
			label L;
			CopyStringToBuffer(cfg.Lmsg_done, MakeItLower(stuff, L),
					LABELSIZE);
			CopyStringToBuffer(cfg.Umsg_done, MakeItUpper(stuff, L),
					LABELSIZE);
			}

		Msg->SetTextWithFormat(getmsg(0), TI()CurrentUser->GetName(),
				cfg.Lmsg_nym, cfg.Lmsgs_nym, cfg.Lmsg_done);
		Msg->SetRoomNumber(AIDEROOM);

		systemMessage(Msg);

		delete Msg;
		}
	else
		{
		mPrintf(getmsg(188), getmsg(618));
		}
	}
