#include "ctdl.h"
#pragma hdrstop

#include "log.h"

void cyclegroup(int slot)
	{
	int i;
	LogEntry2 Log2(cfg.maxgroups);

	if (TI()loggedIn)
		{
		TI()CurrentUser->LogEntry2::Save(TI()ThisLog);
		}

	Log2.OpenFile();

	/* take all users out of this group */
	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			if (Log2.Load(LogTab->GetEntry(i)->GetLogIndex()))
				{
				Log2.SetInGroup(slot, FALSE);
				Log2.Save(LogTab->GetEntry(i)->GetLogIndex());
				}
			}
		}

	Log2.CloseFile();

	if (TI()loggedIn)
		{
		TI()CurrentUser->LogEntry2::Load(TI()ThisLog);
		}
	}

void cycleroom(int slot, Bool GiveAccess, Bool ClearIgnore)
	{
	int i;
	LogEntry3 Log3(cfg.maxrooms);
	LogEntry4 Log4(cfg.maxrooms);

	if (TI()loggedIn)
		{
		TI()CurrentUser->LogEntry3::Save(TI()ThisLog);
		TI()CurrentUser->LogEntry4::Save(TI()ThisLog);
		}

	Log3.OpenFile();
	Log4.OpenFile();

	for (i = 0; i < cfg.MAXLOGTAB; i++)
		{
		if (LogTab->GetEntry(i)->IsInuse())
			{
			if (Log3.Load(LogTab->GetEntry(i)->GetLogIndex()))
				{
				Log3.SetInRoom(slot, GiveAccess);
				Log3.Save(LogTab->GetEntry(i)->GetLogIndex());
				}

			if (ClearIgnore)
				{
				if (Log4.Load(LogTab->GetEntry(i)->GetLogIndex()) &&
						Log4.IsRoomExcluded(slot))
					{
					Log4.SetRoomExcluded(slot, FALSE);
					Log4.Save(LogTab->GetEntry(i)->GetLogIndex());
					}
				}
			}
		}

	Log3.CloseFile();
	Log4.CloseFile();

	if (TI()loggedIn)
		{
		TI()CurrentUser->LogEntry3::Load(TI()ThisLog);
		TI()CurrentUser->LogEntry4::Load(TI()ThisLog);
		}
	}
