// --------------------------------------------------------------------------
// Citadel: CSysRoom.CPP
//
// Console Sysop Room

#ifndef WINCIT
#include "ctdl.h"
#pragma hdrstop

#include "room.h"
#include "group.h"

#include "cwindows.h"
#include "consysop.h"

Bool listHandler(EVENT evt, long param, int more, CITWINDOW *wnd);

typedef enum
	{
	LST_DRAW,	LST_UP, 	LST_DOWN,	LST_GET,	LST_PGUP,	LST_PGDN,
	LST_HOME,	LST_END,	LST_NEW,	LST_DESTROY,LST_REFRESH,
	} LISTCMDS;

typedef struct
	{
	const char *(*lister)(CITWINDOW *, LISTCMDS);	// the lister to use
	int on; 								// which entry is on
	int top;								// which entry is at top
	int bottom; 							// which entry is at bottom
	void *ptr;								// in case you need more data
	} listerData;

// all of the control IDs used in this module
typedef enum
	{
	CTRL_ROOMKILLSTR,	CTRL_ROOMKILLYN,
	};

const char *roomLister(CITWINDOW *wnd, LISTCMDS cmd)
	{
	listerData *ld = (listerData *) wnd->LocalData;

	switch (cmd)
		{
		case LST_DRAW:
			{
			int i, j;

			if (!IsRoomInuse(RoomPosTableToRoom(ld->on)))
				{
				ld->on = LOBBY;
				}

			if (ld->on < ld->top)
				{
				ld->top = ld->on;
				}

			if (buildClipArray(wnd))
				{
				for (j = 1, i = ld->top; i < cfg.maxrooms; i++)
					{
					if (j >= wnd->extents.bottom - wnd->extents.top)
						{
						break;
						}

					if (IsRoomInuse(RoomPosTableToRoom(i)))
						{
						int x;
						int r = min((LABELSIZE + 4),
								(wnd->extents.right - wnd->extents.left));

						ld->bottom = i;

						CitWindowOutChr(wnd, 1, j, ' ',
								i == ld->on ? cfg.cattr : cfg.attr);

						CitWindowOutStr(wnd, 2, j,
								GetRoomName(RoomPosTableToRoom(i)),
								i == ld->on ? cfg.cattr : cfg.attr);

						for (x = strlen(GetRoomName(RoomPosTableToRoom(i))) + 2;
								x < r; x++)
							{
							CitWindowOutChr(wnd, x, j, ' ',
									i == ld->on ? cfg.cattr : cfg.attr);
							}

						if (x == LABELSIZE + 4)
							{
							if (!IsRoomGroupOnly(RoomPosTableToRoom(i)))
								{
								CitWindowOutStr(wnd, x, j, getsysmsg(338),
										i == ld->on ? cfg.cattr : cfg.attr);

								x += strlen(getsysmsg(338));
								}
							else
								{
								if (IsRoomMultiGroup(RoomPosTableToRoom(i)))
									{
									CitWindowOutStr(wnd, x, j, getsysmsg(339),
											i == ld->on ? cfg.cattr : cfg.attr);

									x += strlen(getsysmsg(339));
									}
								else
									{
									CitWindowOutStr(wnd, x, j,
											GroupData->GetEntry(GetRoomGroupNumber(RoomPosTableToRoom(i)))->GetName(),
											i == ld->on ? cfg.cattr : cfg.attr);

									x += strlen(GroupData->GetEntry(GetRoomGroupNumber(RoomPosTableToRoom(i)))->GetName());
									}
								}
							}

						for (r = wnd->extents.right - wnd->extents.left;
								x < r; x++)
							{
							CitWindowOutChr(wnd, x, j, ' ',
									i == ld->on ? cfg.cattr : cfg.attr);
							}

						j++;
						}
					}

				for (; j < wnd->extents.bottom - wnd->extents.top; j++)
					{
					CitWindowClearLine(wnd, j, cfg.attr);
					}

				freeClipArray();
				}

			break;
			}

		case LST_DOWN:
			{
			int tmp = ld->on;

			while (++ld->on < cfg.maxrooms && !IsRoomInuse(RoomPosTableToRoom(ld->on)));
			if (ld->on >= cfg.maxrooms)
				{
				ld->on = tmp;
				}

			if (ld->on > ld->bottom)
				{
				while (!IsRoomInuse(RoomPosTableToRoom(++ld->top)));
				}

			roomLister(wnd, LST_DRAW);
			break;
			}

		case LST_UP:
			{
			while (ld->on && !IsRoomInuse(RoomPosTableToRoom(--ld->on)));
			roomLister(wnd, LST_DRAW);
			break;
			}

		case LST_PGDN:
			{
			int i, j = wnd->extents.bottom - wnd->extents.top - 2;

			for (i = 0; i < j; i++)
				{
				int tmp = ld->on;

				while (++ld->on < cfg.maxrooms && !IsRoomInuse(RoomPosTableToRoom(ld->on)));
				if (ld->on >= cfg.maxrooms)
					{
					ld->on = tmp;
					}

				if (ld->on > ld->bottom)
					{
					while (!IsRoomInuse(RoomPosTableToRoom(++ld->top)));
					}
				}

			roomLister(wnd, LST_DRAW);
			break;
			}

		case LST_PGUP:
			{
			int i, j = wnd->extents.bottom - wnd->extents.top - 2;

			for (i = 0; i < j; i++)
				{
				while (ld->on && !IsRoomInuse(RoomPosTableToRoom(--ld->on)));
				}

			roomLister(wnd, LST_DRAW);
			break;
			}

		case LST_GET:
			{
			return (GetRoomName(RoomPosTableToRoom(ld->on)));
			}

		case LST_HOME:
			{
			ld->on = 0;
			ld->top = 0;
			roomLister(wnd, LST_DRAW);
			break;
			}

		case LST_END:
			{
			int i, j = wnd->extents.bottom - wnd->extents.top - 2;
			int tmp;

			for (tmp = ld->on; ; tmp = ld->on)
				{
				while (++ld->on < cfg.maxrooms && !IsRoomInuse(ld->on));

				if (ld->on >= cfg.maxrooms)
					{
					ld->on = tmp;
					break;
					}
				}

			ld->top = ld->on;
			for (i = 0; i < j; i++)
				{
				while (ld->top && !IsRoomInuse(--ld->top));
				}

			roomLister(wnd, LST_DRAW);
			break;
			}
		}

	return (NULL);
	}

void RoomControlHandler(CITWINDOW *wnd, long param)
	{
	CONTROLINFO *ci = (CONTROLINFO *) param;

	switch (ci->id)
		{
		case CTRL_ROOMKILLSTR:
			{
			if (*((char *)(ci->ptr)))
				{
				r_slot rs;

				rs = PartialRoomExists((char *) (ci->ptr), 0, TRUE);

				if (rs >= 0 && rs <= 3)
					{
					CitWindowsError(wnd, getsysmsg(340), GetRoomName(rs));
					}
				else if (rs != CERROR)
					{
					r_slot *rsp;

					if ((rsp = (r_slot *) getMemG(sizeof(*rsp), 1)) != NULL)
						{
						char pmt[80];
						label rn;

						CopyStringToBuffer(rn, GetRoomName(rs), LABELSIZE);

						sprintf(pmt, getsysmsg(341), rn);

						*rsp = rs;

						CitWindowsGetYN(pmt, 0, wnd, CTRL_ROOMKILLYN,
								rsp);
						}
					}
				else
					{
					CitWindowsError(wnd, getsysmsg(342), ci->ptr);
					}
				}

			break;
			}

		case CTRL_ROOMKILLYN:
			{
			if (*((int *)(ci->ptr)))
				{
				label rn;

				CopyStringToBuffer(rn, GetRoomName(*((r_slot *)(ci->more))),
						LABELSIZE);

				if (!killroom(rn))
					{
					CitWindowsError(wnd, getsysmsg(343), rn);
					}
				else
					{
					if (wnd->children)
						{
						if (wnd->children->wnd->func == listHandler)
							{
							(wnd->children->wnd->func)(EVT_DRAWINT,
									0, 0, wnd->children->wnd);
							}
						}
					}
				}

			break;
			}
		}
	}

Bool RoomKeyHandler(CITWINDOW *wnd, int key)
	{
	switch (key)
		{
		case CSRM_EXIT:
		case MK_ESC:
			{
			// exit hall menu stuff
			return (FALSE);
			}

		case CSRM_NEW:
			{
			break;
			}

		case CSRM_EDIT:
			{
			break;
			}

		case CSRM_KILL:
			{
			label df;

			if (wnd->children && wnd->children->wnd->func == listHandler)
				{
				CopyStringToBuffer(df, (((listerData *)
						(wnd->children->wnd->LocalData))->lister)
						(wnd->children->wnd, LST_GET), LABELSIZE);
				}
			else
				{
				df[0] = 0;
				}

			CitWindowsGetString(getsysmsg(344), LABELSIZE, df, wnd,
					CTRL_ROOMKILLSTR, NULL, FALSE);

			break;
			}

		case CSRM_MOVEBACK:
			{
			break;
			}

		case CSRM_MOVEUP:
			{
			break;
			}

		case CSRM_PREVHALL:
			{
			break;
			}

		case CSRM_NEXTHALL:
			{
			break;
			}
		}

	return (TRUE);
	}
#endif
