// --------------------------------------------------------------------------
// Citadel: Config.CPP
//
// Configuration routines.

#include "ctdl.h"
#pragma hdrstop

#include "filemake.h"
#include "config.h"
#include "meminit.h"
#include "libovl.h"
#include "resize.h"
#include "log.h"
#include "timer.h"
#include "cfgfiles.h"
#include "cwindows.h"
#include "term.h"


// --------------------------------------------------------------------------
// Contents
//
// configcit		the main configuration for citadel
// illegal			abort configuration program


Bool	resizeMsg = FALSE,		// Resize messages?
		resizeLog = FALSE,		// Resize userlog?
		resizeGrp = FALSE,		// Resize groups?
		resizeRoom = FALSE, 	// Resize rooms?
		resizeHall = FALSE; 	// Resize halls?

Bool CitadelIsConfiguring;	// Don't do some things.

void checkresize(void);


// --------------------------------------------------------------------------
// configcit(): The main configuration for Citadel

void CreateConfigurationFile(int FileNameIndex, int FileDataIndex,
		Bool PrintStuff)
	{
	discardable *d;

	if (!filexists(citfiles[FileNameIndex]))
		{
		if ((d = readData(16, FileDataIndex, FileDataIndex)) != NULL)
			{
			FILE *File;

			if ((File = fopen(citfiles[FileNameIndex], FO_W)) != NULL)
				{
				if (PrintStuff)
					{
					cPrintf(getcfgmsg(133), citfiles[FileNameIndex]);
					doccr();
					}

				const char **Data = (const char **) d->aux;

				for (int i = 0; !SameString(Data[i], getcfgmsg(244)); i++)
					{
					fprintf(File, getmsg(1294), Data[i], bn);
					}

				fclose(File);
				}
			else
				{
				if (PrintStuff)
					{
					cPrintf(getcfgmsg(134), citfiles[FileNameIndex]);
					doccr();
					}
				}

			discardData(d);
			}
		else
			{
			if (PrintStuff)
				{
				cPrintf(getmsg(188), getcfgmsg(243));
				}
			}
		}
	}

Bool configcit(void)
	{
	Bool oldresizelog = FALSE, oldresizemsg = FALSE;

	CitadelIsConfiguring = TRUE;

	VerifyHeap();

	bufferedClose(msgfl);
	citClose(&TI()OC.PrintFile);
	citClose(&trapfl);
	citClose(&roomfl);
	citClose(&journalfl);

	// read CONFIG.CIT
	if (!readconfig(0))
		{
		return (FALSE);
		}

	if (!initfiles())
		{
		return (FALSE);
		}

	VerifyHeap();

	// if we are about to make a new system, make default .CIT files.
	if (msgZap && roomZap && logZap && grpZap && hallZap && roomposZap)
		{
		CreateConfigurationFile(C_EXTERNAL_CIT, 0, TRUE);
		CreateConfigurationFile(C_NODES_CIT, 1, TRUE);
		CreateConfigurationFile(C_GRPDATA_CIT, 2, TRUE);
		CreateConfigurationFile(C_CRON_CIT, 3, TRUE);
		CreateConfigurationFile(C_MDMRESLT_CIT, 4, TRUE);
		CreateConfigurationFile(C_PROTOCOL_CIT, 5, TRUE);
		}

	VerifyHeap();

	// allocate tables here so readconfig() can be called from sysop menu
	allocateTables();
	setdefaultTerm(2);
	termCap(TERM_NORMAL);

	VerifyHeap();

#ifndef WINCIT
	if (msgZap)
		{
		zapMsgFile();
		cfg.newest = cfg.oldest = 1l;
		}
#endif
	if (roomZap)	zapRoomFile();
	if (logZap) 	zapLogFile(FALSE, TRUE);
	if (grpZap) 	zapGrpFile(NULL, TRUE);
	if (hallZap)	zapHallFile();
	if (roomposZap) zapRoomPosFile(TRUE);

	if (roomZap && !msgZap) roomBuild = TRUE;
	if (hallZap && !msgZap) hallBuild = TRUE;

	if (!logZap)
		{
		if (log2Zap)	zapLog2();
		if (log3Zap)	zapLog3();
		if (log4Zap)	zapLog4();
		if (log5Zap)	zapLog5();
		if (log6Zap)	zapLog6();
		}

	VerifyHeap();

	logInit();
	VerifyHeap();

	msgInit();

	VerifyHeap();

	RoomTabBld();

	VerifyHeap();

	if (hallBuild)
		{
		buildhalls();

		VerifyHeap();
		}

	if (resizeRoom)
		{
		resizeroomfile();

		VerifyHeap();
		}

	if (resizeGrp)
		{
		resizegrpfile();

		VerifyHeap();
		}

	if (resizeHall)
		{
		resizehallfile();

		VerifyHeap();
		}

	if (resizeLog)
		{
		resizelogfile();

		VerifyHeap();
		}

	if (resizeMsg)
		{
		resizemsgfile();

		VerifyHeap();
		}

	if (resizeLog || resizeMsg || resizeRoom || resizeGrp)
		{
		oldresizelog = resizeLog;
		oldresizemsg = resizeMsg;
		resizeLog = FALSE;
		resizeMsg = FALSE;

		bufferedClose(msgfl);
		fcloseall();

		cfg.messagek = newmessagek;
		cfg.MAXLOGTAB = newmaxlogtab;

		if (!initfiles())
			{
			return (FALSE);
			}
		}

	VerifyHeap();

	if (oldresizelog)
		{
		if (LogTab)
			{
			destroyLogTab();
			}

		createLogTab();

		VerifyHeap();

		logInit();

		VerifyHeap();
		}

	if (oldresizemsg)
		{
		destroyMsgTab();
		createMsgTab();

		VerifyHeap();

		msgInit();

		VerifyHeap();
		}

#ifndef WINCIT
	doccr();
	cPrintf(getcfgmsg(135));
	doccr();
	pause(200);
#endif

	bufferedClose(msgfl);
	citClose(&TI()OC.PrintFile);
	citClose(&trapfl);
	citClose(&roomfl);
	citClose(&journalfl);

	VerifyHeap();

	CitadelIsConfiguring = FALSE;

	return (TRUE);
	}


// --------------------------------------------------------------------------
// illegal(): Prints out configuration error message and aborts.

void cdecl illegal(const char *fmt, ...)
	{
	char buff[256];
	va_list ap;

	va_start(ap, fmt);
	vsprintf(buff, fmt, ap);
	va_end(ap);

	changedir(cfg.homepath);

#ifdef WINCIT
	errorDisp(pcts, buff);
	errorDisp(getcfgmsg(136));
#else
	doccr();
	errorDisp(pcts, buff);
	doccr();
	errorDisp(getcfgmsg(136));
	doccr();
	curson();
	DeinitializeTimer();
	critical(FALSE);
	exit(7);
#endif
	}

// Tell the user to wait until configuration is done before he can do
// something he tried to do.
void WaitUntilDoneConfiguring(void)
	{
	CitWindowsNote(NULL, getcfgmsg(286));
	}
