// this should not live long

#include "ctdl.h"
#pragma hdrstop

#include "libovl.h"
#include "room.h"
#include "roompriv.h"
#include "log.h"
#include "msg.h"
#include "net.h"
#include "hall.h"

// autoroom, auto-creates a net room
Bool autoroom(const char *roomname)
	{
	r_slot testslot, newSlot;
	m_slot i, t_size;
	int j;
	aRoom rBuf;

	if (!(*roomname))
		{
		return (FALSE);
		}

	testslot = RoomExists(roomname);

	if (testslot != CERROR)
		{
		return (FALSE);
		}

	testslot = IdExists(roomname, FALSE);
	if (testslot != CERROR)
		{
		return (FALSE);
		}

	newSlot = FindFreeRoomSlot();
	if (newSlot == CERROR)
		{
		return (FALSE);
		}

	memset(&rBuf, 0, sizeof(aRoom));

	rBuf.rbflags.SetInuse(TRUE);
	rBuf.rbflags.SetPublic(TRUE);
	rBuf.rbflags.SetShared(TRUE);

	CopyStringToBuffer(rBuf.netID, roomname, LABELSIZE);
	CopyStringToBuffer(rBuf.rbname, roomname, LABELSIZE);

	t_size = (m_slot) sizetable();
	for (i = 0; i < t_size; i++)
		{
		if (getRoomNum(i) == newSlot)
			{
			changeheader(cfg.mtoldest + i, DUMP, 255);	// No change
			}
		}

	cycleroom(newSlot, TRUE, TRUE);
	TI()CurrentUser->SetInRoom(newSlot, TRUE);

	if (TI()node->GetAutoGroup() >= 0)
		{
		rBuf.rbgrpno = TI()node->GetAutoGroup();
		rBuf.rbflags.SetGroupOnly(TRUE);
		rBuf.rbflags.SetBooleanGroup(FALSE);
		}

	putRoom(newSlot, &rBuf);

	// remove and unwindow room from all halls
	for (j = 0; j < cfg.maxhalls; j++)
		{
		HallData->GetEntry(j)->SetRoomInHall(newSlot, FALSE);
		HallData->GetEntry(j)->SetWindowedIntoHall(newSlot, FALSE);
		}

	// put room in maintenance hall
	HallData->GetEntry(1)->SetRoomInHall(newSlot, TRUE);

	// put room in hall if hall set in nodes.cit
	if (TI()node->GetAutoHall() >= 0)
		{
		HallData->GetEntry(TI()node->GetAutoHall())->SetRoomInHall(newSlot, TRUE);
		}

	HallData->Save();

	Message *Msg = new Message;

	if (Msg)
		{
		Msg->SetTextWithFormat(getmsg(110), roomname,
				roomBuf->rbflags.IsPublic() ? '>' : ')',
				TI()node->GetName());

		trap(Msg->GetText(), T_NEWROOM);

		Msg->SetTextWithFormat(getmsg(1369), cfg.Uroom_nym, roomname,
				roomBuf->rbflags.IsPublic() ? '>' : ')', TI()node->GetName());

		Msg->SetRoomNumber(newSlot);

		systemMessage(Msg);

		delete Msg;
		}
	else
		{
		mPrintf(getmsg(188), getnetmsg(181));
		}

	AddNetIDToNetIDCit(roomname, TI()node->GetName());

	return (TRUE);
	}
