// --------------------------------------------------------------------------
// Citadel: AcctCfg.CPP
//
// Time accounting code for Citadel bulletin board system.

#include "ctdl.h"
#pragma hdrstop

#include "account.h"
#include "log.h" 
#include "group.h"
#include "cfgfiles.h"


// --------------------------------------------------------------------------
// ReadGrpdataCit(): Reads grpdata.cit values into group structure.

void ReadGrpdataCit(void)
	{
	FILE *fBuf;
	g_slot GroupSlot;

	if (!AccountingData &&
			(AccountingData = new AccountInfo[cfg.maxgroups]) == NULL)
		{
		crashout(getcfgmsg(66));
		winRetN;
		}

	// initialize all accounting data
	for (GroupSlot = 0; GroupSlot < cfg.maxgroups; GroupSlot++)
		{
		int i;

		// init days
		for (i = 0; i < 7; i++)
			{
			AccountingData[GroupSlot].SetDay(i, TRUE);
			}

		// init hours & special hours
		for (i = 0; i < 24; i++)
			{
			AccountingData[GroupSlot].SetHour(i, TRUE);
			AccountingData[GroupSlot].SetSpecialHour(i, FALSE);
			}

		AccountingData[GroupSlot].SetDownloadMultiplier(-100);
		AccountingData[GroupSlot].SetUploadMultiplier(100);
		}

	char pathToGrpdataCit[128];
	sprintf(pathToGrpdataCit, sbs, cfg.homepath, citfiles[C_GRPDATA_CIT]);

	if ((fBuf = fopen(pathToGrpdataCit, FO_R)) == NULL) // ASCII mode
		{
		mPrintfCR(getmsg(15), pathToGrpdataCit);
		}
	else
		{
		discardable *d = readData(0, 7, 7);

		if (d)
			{
			char line[90];

			const char **grpkeywords = (const char **) d->aux;

			GroupSlot = CERROR;

			while (fgets(line, 90, fBuf) != NULL)
				{
				char *words[256];

				if (line[0] != '#')
					{
					continue;
					}

				int count = parse_it(words, line);

				int i;
				for (i = 0; i < GRK_NUM; i++)
					{
					if (SameString(words[0] + 1, grpkeywords[i]))
						{
						break;
						}
					}

				switch (i)
					{
					case GRK_DAYS:
						{
						int j;

						if (GroupSlot == CERROR)
							{
							break;
							}

						// init days
						for (j = 0; j < 7; j++)
							{
							AccountingData[GroupSlot].SetDay(j, FALSE);
							}

						for (j = 1; j < count; j++)
							{
							int k;

							for (k = 0; k < 7; k++)
								{
								if (SameString(words[j], days[k]) ||
										SameString(words[j], fulldays[k]))
									{
									break;
									}
								}

							if (k < 7)
								{
								AccountingData[GroupSlot].SetDay(k, TRUE);
								}
							else if (SameString(words[j], getcfgmsg(76))) // ANY
								{
								int l;

								// Years of memory corruption
								// for (l = 0; l < MAXGROUPS; ++l)
								for (l = 0; l < 7; ++l)
									{
									AccountingData[GroupSlot].SetDay(l, TRUE);
									}
								}
							else
								{
								CRmPrintfCR(getcfgmsg(77), citfiles[C_GRPDATA_CIT],
										getcfgmsg(78), words[j]);
								}
							}
						break;
						}

					case GRK_GROUP:
						{
						if ((GroupSlot = FindGroupByName(words[1])) != CERROR)
							{
							AccountingData[GroupSlot].SetAccountingOn(TRUE);
							}
						else
							{
							CRmPrintfCR(getcfgmsg(77), citfiles[C_GRPDATA_CIT],
									cfg.Lgroup_nym, words[1]);
							}

						break;
						}

					case GRK_HOURS:
						{
						int j;

						if (GroupSlot == CERROR)
							{
							break;
							}

						// init hours
						for (j = 0; j < 24; j++)
							{
							AccountingData[GroupSlot].SetHour(j, FALSE);
							}

						for (j = 1; j < count; j++)
							{
							if (SameString(words[j], getcfgmsg(76)))
								{
								int l;

								for (l = 0; l < 24; l++)
									{
									AccountingData[GroupSlot].SetHour(l, TRUE);
									}
								}
							else
								{
								int hour = atoi(words[j]);

								if (hour > 23)
									{
									CRmPrintfCR(getcfgmsg(82),
											citfiles[C_GRPDATA_CIT], ns, hour);
									}
								else
									{
									AccountingData[GroupSlot].SetHour(hour, TRUE);
									}
								}
							}
						break;
						}

					case GRK_DAYINC:
						{
						if (GroupSlot == CERROR)
							{
							break;
							}

						if (count > 1)
							{
							AccountingData[GroupSlot].SetDailyIncrement(60 * atol(words[1]));
							}
						break;
						}

					case GRK_DLMULT:
						{
						if (GroupSlot == CERROR)
							{
							break;
							}

						if (count > 1)
							{
							AccountingData[GroupSlot].SetDownloadMultiplier(atoi(words[1]));
							}
						break;
						}

					case GRK_ULMULT:
						{
						if (GroupSlot == CERROR)
							{
							break;
							}

						if (count > 1)
							{
							AccountingData[GroupSlot].SetUploadMultiplier(atoi(words[1]));
							}
						break;
						}

					case GRK_PRIORITY:
						{
						if (GroupSlot == CERROR)
							{
							break;
							}

						if (count > 1)
							{
							AccountingData[GroupSlot].SetPriority(atoi(words[1]));
							}
						break;
						}

					case GRK_MAXBAL:
						{
						if (GroupSlot == CERROR)
							{
							break;
							}

						if (count > 1)
							{
							AccountingData[GroupSlot].SetMaximumBalance(60 * atol(words[1]));
							}
						break;
						}

					case GRK_SPECIAL:
						{
						int j;

						if (GroupSlot == CERROR)
							{
							break;
							}

						// init hours
						for (j = 0; j < 24; j++)
							{
							AccountingData[GroupSlot].SetSpecialHour(j, FALSE);
							}

						for (j = 1; j < count; j++)
							{
							if (SameString(words[j], getcfgmsg(76)))
								{
								int l;

								for (l = 0; l < 24; l++)
									{
									AccountingData[GroupSlot].SetSpecialHour(l, TRUE);
									}
								}
							else
								{
								int hour;

								if ((hour = atoi(words[j])) > 23)
									{
									CRmPrintfCR(getcfgmsg(82),
											citfiles[C_GRPDATA_CIT],
											getcfgmsg(83), hour);
									}
								else
									{
									AccountingData[GroupSlot].SetSpecialHour(hour, TRUE);
									}
								}
							}
						break;
						}

					default:
						{
						CRmPrintfCR(getmsg(21), citfiles[C_GRPDATA_CIT], words[0]);
						break;
						}
					}
				}

			discardData(d);
			}
		else
			{
			mPrintf(getmsg(188), getcfgmsg(232));
			}

		fclose(fBuf);
		}
	}
