/*************************************************************************
*
*  File: translate.h    Date: 12 March 1990   Author: FJM
*
*  Purpose: Translate IBM character set for non IMB output.
*
**************************************************************************
*
*  Revisions:
*
* Date            By              Reason
* ==============  ==============  =================================
* 13 March 1990   FJM
* 18 March 1990   FJM             Fixes for entry bug
* 20 March 1990   {zm}            Change 0x7F (del) on output.
* 09 Dec   1990   FJM             Minor changes to support new cron table.
*
*************************************************************************/

 /************************
       *                       *
       * Citadel Special Chars *
       *       (output)        *
       * ctrl-a    = ctrl-a    *
	   * ctrl-b    = ctrl-b    *
       * escape    = escape    *
       * del       = del       *
       * backspace = backspace *
       * xoff      = 'P'       *
       * '\r'      = NULL      *
       * '\n'     = '\n'       *
       * '\t'      = '\t'      *
       * ctrlo     = 'N'       *
       * ctrlz     = ctrlz     *
       *                       *
       ************************/

unsigned char filt_out[] = {    /* translated character output filter    */
	'\x00', '\x01', '\x02', '\x00', '\x00', '\x00', '\x00', '\x7',  /* 0..x7 */
    '\b', '\t', '\n', '\x00', '\x00', '\x00', '\x00', 'N',
    '\x00', '\x00', '\x00', 'P', '\x00', '\x00', '\x00', '\x00',    /* x10..x17 */
    '\x00', '\x00', '\x1a', '\x1b', '\x00', '\x00', '\x00', '\x00',
    ' ', '!', '"', '#', '$', '%', '&', '\x27',  /* x20..x27 */
    '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7', /* x30..x37 */
    '8', '9', ':', ';', '<', '=', '>', '?',
    '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', /* x40..x47 */
    'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', /* x50..x57 */
    'X', 'Y', 'Z', '[', '\x5c', ']', '^', '_',
    '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', /* x60..x67 */
    'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w', /* x70..x77 */
    'x', 'y', 'z', '{', '|', '}', '~', '\x7f',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', /* x80..x87 */
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', /* x90..x97 */
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', /* xA0..xA7 */
    ' ', ' ', ' ', ' ', ' ', ' ', '<', '>',
    '%', '*', '#', '|', '+', '+', '+', '+', /* xB0..xB7 */
    '+', '+', '|', '+', '+', '+', '+', '+',
    '+', '+', '+', '+', '-', '+', '+', '+', /* xC0..xC7 */
    '+', '+', '+', '+', '+', '-', '+', '+',
    '+', '+', '+', '+', '+', '+', '+', '+', /* xD0..xD7 */
    '+', '+', '+', '#', '#', '#', '#', '#',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', /* xE0..xE7 */
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', /* xF0..xF7 */
    ' ', '.', '.', ' ', ' ', ' ', '*', '\xff'
};

 /**********************************
      *          Input Filtering        *
      *                                 *
      * ctrl-a    0x01 = ctrl-a    0x01 *
	  * ctrl-b	  0x02 = ctrl-b    0x02 *
      * backspace 0x08 = backspace 0x08 *
      * '\t'      0x09 = '\t'      0x09 *
      * newline   0x0a = null      0x00 *
      * '\r'      0x0d = NEWLINE   0x0a *
      * ctrlo     0x0f = 'N'       0x4e *
      * xoff      0x13 = 'P'       0x50 *
      * ctrlz     0x1a = ctrlz     0x1a *
      * special   0x1b = special   0x1b *
      * del       0x7f = backspace 0x08 *
      *                                 *
      **********************************/

unsigned char filt_in[] = { /* ASCII only input filter    */

	'\x00', '\x01', '\x02', '\x00', '\x00', '\x00', '\x00', '\x00',  /* 0..x7 */
    '\b', '\t', '\x00', '\x00', '\x00', '\n', '\x00', 'N',
    '\x00', '\x00', '\x00', 'P', '\x00', '\x00', '\x00', '\x00', /* x10..x17 */
    '\x00', '\x00', '\x1a', '\x1b', '\x00', '\x00', '\x00', '\x00',
    ' ', '!', '"', '#', '$', '%', '&', '\x27',   /* x20..x27 */
    '(', ')', '*', '+', ',', '-', '.', '/',
    '0', '1', '2', '3', '4', '5', '6', '7',  /* x30..x37 */
    '8', '9', ':', ';', '<', '=', '>', '?',
    '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G',  /* x40..x47 */
    'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O',
    'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W',  /* x50..x57 */
    'X', 'Y', 'Z', '[', '\x5c', ']', '^', '_',
    '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g',  /* x60..x67 */
    'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o',
    'p', 'q', 'r', 's', 't', 'u', 'v', 'w',  /* x70..x77 */
    'x', 'y', 'z', '{', '|', '}', '~', '\b',
};

/* EOF */
