/* -------------------------------------------------------------------- */
/*  TRAP.C                   Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*  Trap file and aide message code                                     */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
/* MSC */
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <alloc.h>
#include <signal.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

/* DragCit */
#include "ctdl.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  trap()          Record a line to the trap file                      */
/*  SaveAideMess()  Save aide message from AIDEMSG.TMP                  */
/*  amPrintf()      aide message printf                                 */
/*  amZap()         Zap aide message being made                         */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  08/04/90    (PAT)   File created                                    */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  External data                                                       */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static Data definitions                                             */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  trap()          Record a line to the trap file                      */
/* -------------------------------------------------------------------- */
void trap(char *string, int what)
{
    char dtstr[20];

    /* check to see if we are supposed to log this event */
    if (!cfg.trapit[what])  return;

    strftime(dtstr, 19, "%y%b%D %X", 0l); 

    fprintf(trapfl, "%s:  %s\n", dtstr, string);

    fflush(trapfl);
}

/* -------------------------------------------------------------------- */
/*  SaveAideMess()  Save aide message from AIDEMSG.TMP                  */
/* -------------------------------------------------------------------- */
void SaveAideMess(void)
{
    char temp[90];
    FILE *fd;

    /*
     * Close curent aide message (if any)
     */
    if (aideFl == NULL)
    {
        return;
    }
    fclose(aideFl);
    aideFl = NULL;

    clearmsgbuf();

    /*
     * Read the aide message
     */
    sprintf(temp, "%s\\%s", cfg.temppath, "aidemsg.tmp");
    if ((fd  = fopen(temp, "rb")) == NULL)
    {
        crashout("AIDEMSG.TMP file not found during aide message save!");
    }
    GetFileMessage(fd, msgBuf->mbtext, cfg.maxtext);

    fclose(fd);
    unlink(temp);

    if (strlen(msgBuf->mbtext) < 10)
        return;

    strcpy(msgBuf->mbauth, cfg.nodeTitle);  

    msgBuf->mbroomno = AIDEROOM;

    putMessage();
    noteMessage();
}

/* -------------------------------------------------------------------- */
/*  amPrintf()      aide message printf                                 */
/* -------------------------------------------------------------------- */
void amPrintf(char *fmt, ... )
{
    va_list ap;
    char temp[90];

    /* no message in progress? */
    if (aideFl == NULL)
    {
        sprintf(temp, "%s\\%s", cfg.temppath, "aidemsg.tmp");

        unlink(temp);
 
        if ((aideFl = fopen(temp, "w")) == NULL)
        {
            crashout("Can not open AIDEMSG.TMP!");
        }
    }

    va_start(ap, fmt);
    vfprintf(aideFl, fmt, ap);
    va_end(ap);

    fflush(aideFl);
}

/* -------------------------------------------------------------------- */
/*  amZap()         Zap aide message being made                         */
/* -------------------------------------------------------------------- */
void amZap(void)
{
    char temp[90];

    if (aideFl != NULL)
    {
        fclose(aideFl);
    }

    sprintf(temp, "%s\\%s", cfg.temppath, "aidemsg.tmp");

    unlink(temp);

    aideFl = NULL;
}


