/* -------------------------------------------------------------------- */
/*  STRFTIME.C               Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*  This file contains functions relating to the time and date          */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
#include <dos.h>
#include <string.h>
#include <time.h>
#include "ctdl.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  strftime()      formats a custom time and date string using formats */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  05/26/89    (PAT)   Created from MISC.C to break that moduel into   */
/*                      more managable and logical peices. Also draws   */
/*                      off MODEM.C                                     */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  External data                                                       */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static data/functions                                               */
/* -------------------------------------------------------------------- */
       char *monthTab[12] = {"Jan", "Feb", "Mar", "Apr", "May", "Jun",
                             "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" } ;
static char *fullmnts[12] = {"January",   "February", "March",    "April",
                             "May",       "June",     "July",     "August",
                             "September", "October",  "November", "December" };
static char *days[7]      = {"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" };
static char *fulldays[7]  = {"Sunday",   "Monday", "Tuesday", "Wednesday",
                             "Thursday", "Friday", "Saturday" } ;

extern char *tzname[2];
/* -------------------------------------------------------------------- */
/*  strftime()      formats a custom time and date string using formats */
/* -------------------------------------------------------------------- */
void strftime(char *outstr, int maxsize, char *formatstr, long tnow)
{
    int i, k;
    struct tm *tmnow;      
    char temp[50];

    if (tnow == 0l) time(&tnow);

    tmnow = localtime(&tnow);

    outstr[0] = '\0';
    
    for(i=0; formatstr[i]; i++)
    {
        if(formatstr[i] != '%')
            sprintf(temp, "%c", formatstr[i]);
        else
        {
            i++;
            temp[0] = '\0';
            if(formatstr[i])
            switch(formatstr[i])
            {
            case 'a': /* %a  abbreviated weekday name                      */
                    sprintf(temp, "%s", days[tmnow->tm_wday]);
                    break;
            case 'A': /*  %A  full weekday name                            */
                    sprintf(temp, "%s", fulldays[tmnow->tm_wday]);
                    break;
            case 'b': /*  %b  abbriviated month name                       */
                    sprintf(temp, "%s", monthTab[tmnow->tm_mon]);
                    break;
            case 'B': /*  %B  full month name                              */
                    sprintf(temp, "%s", fullmnts[tmnow->tm_mon]);
                    break;
            case 'c': /*  %c  standard date and time string                */
                    sprintf(temp, "%s", ctime(&tnow));
                    temp[strlen(temp)-1] = '\0';
                    break;
            case 'd': /*  %d  day-of-month as decimal (1-31)               */
                    sprintf(temp, "%d", tmnow->tm_mday);
                    break;
            case 'D': /*  %D  day-of-month as decimal (01-31)              */
                    sprintf(temp, "%02d", tmnow->tm_mday);
                    break;
            case 'H': /*  %H  hour, range (0-23)                           */
                    sprintf(temp, "%d", tmnow->tm_hour);
                    break;
            case 'I': /*  %I  hour, range (1-12)                           */
                    if(tmnow->tm_hour)
                    {
                        sprintf(temp, "%d", tmnow->tm_hour > 12 ?
                                            tmnow->tm_hour  -12 :
                                            tmnow->tm_hour );
                    }                
                    else
                    {
                        sprintf(temp, "%d", 12);
                    }
                    break;
            case 'j': /*  %j  day-of-year as a decimal (1-366)             */
                    sprintf(temp, "%d", tmnow->tm_yday + 1);
                    break;
            case 'm': /*  %m  month as decimal (1-12)                      */
                    sprintf(temp, "%d", tmnow->tm_mon + 1);
                    break;
            case 'M': /*  %M  minute as decimal (0-59)                     */
                    sprintf(temp, "%02d", tmnow->tm_min);
                    break;
            case 'p': /*  %p  locale's equivaent af AM or PM               */
                    sprintf(temp, "%s", tmnow->tm_hour > 11 ? "PM" : "AM");
                    break;
            case 'S': /*  %S  second as decimal (0-59)                     */
                    sprintf(temp,"%02d", tmnow->tm_sec);
                    break;
            case 'U': /*  %U  week-of-year, Sunday being first day (0-52)  */
                    k = tmnow->tm_wday - (tmnow->tm_yday % 7);
                    if(k<0) k += 7;
                    if(k != 0)
                    {
                        k = tmnow->tm_yday - (7-k);
                        if(k<0) k = 0;
                    }
                    else
                        k = tmnow->tm_yday;
                    sprintf(temp, "%d", k/7);
                    break;
            case 'W': /*  %W  week-of-year, Monday being first day (0-52)  */
                    k = tmnow->tm_wday - (tmnow->tm_yday % 7);
                    if(k<0) k += 7;
                    if(k != 1)
                    {
                        if(k==0) k = 7;
                        k = tmnow->tm_yday - (8-k);
                        if(k<0) k = 0;
                    }
                    else
                        k = tmnow->tm_yday;
                    sprintf(temp, "%d", k/7);
                    break;
            case 'w': /*  %w  weekday as a decimal (0-6, sunday being 0)   */
                    sprintf(temp, "%d", tmnow->tm_wday);
                    break;
            case 'x': /*  %x  standard date string                         */
                    sprintf(temp, "%02d/%02d/%d",   tmnow->tm_mon+1,
                                                    tmnow->tm_mday,
                                                    tmnow->tm_year);
                    break;
            case 'X': /*  %X  standard time string                         */
                    sprintf(temp, "%02d:%02d:%02d", tmnow->tm_hour,
                                                    tmnow->tm_min,
                                                    tmnow->tm_sec);
                    break;
            case 'y': /*  %y  year in decimal without century (00-99)      */
                    sprintf(temp, "%02d", tmnow->tm_year);
                    break;
            case 'Y': /*  %Y  year including century as decimal            */
                    if(tmnow->tm_year > 99)
                    {
                        tmnow->tm_year -= 100;
                        sprintf(temp, "20%02d", tmnow->tm_year);
                    }
                    else
                    {
                        sprintf(temp, "19%02d", tmnow->tm_year);
                    }
                    break;
            case 'Z': /*  %Z  timezone name                                */
                    sprintf(temp, "%s", tzname[0]);
                    break;
            case '%': /*  %%  the percent sign                             */
                    strcpy(temp, "%");
                    break;
            default:
                    strcpy(temp, "%?");
                    break;
            }  /* end of switch */

        }  /* end of if */

        if( (strlen(temp) + strlen(outstr)) > maxsize)
            break;
        else
            if(strlen(temp))
                strcat(outstr, temp);

    } /* end of for loop */
}

                             
