/* -------------------------------------------------------------------- */
/*  MSGCFG.C                 Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*               This is the high level message code.                   */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
#include <string.h>
#include <time.h>
#include "ctdl.h"
#include "keywords.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  msgInit()       builds message table from msg.dat                   */
/*  zapMsgFile()    initializes msg.dat                                 */
/*  slidemsgTab()   frees slots at beginning of msg table               */
/*  buildcopies()   copies appropriate msg index members                */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  02/26/91    (PAT)   Rearanged message code for overlays.            */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static Data                                                         */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  msgInit()       sets up lowId, highId, cfg.catSector and cfg.catChar*/
/*                  by scanning over message.buf                        */
/* -------------------------------------------------------------------- */
void msgInit(void)
{
    ulong first, here;
    int makeroom;
    int skipcounter = 0;   /* maybe need to skip a few . Dont put them in
                              message index */
    int slot;

    doccr(); doccr();
    cPrintf("Building message table"); doccr();

    /* start at the beginning */
    fseek(msgfl, 0l, 0);

    getMessage();

    /* get the ID# */
    sscanf(msgBuf->mbId, "%ld", &first);

    cPrintf("Mess# %6lu\r", first);

    /* put the index in its place */
    /* mark first entry of index as a reference point */

    cfg.mtoldest = first;
    
    indexmessage(first);

    cfg.newest = cfg.oldest = first;

    cfg.catLoc = ftell(msgfl);

    while (TRUE)
    {
        getMessage();

        sscanf(msgBuf->mbId, "%ld", &here);

        if (here == first) break;

        if (!(here % 10))
            cPrintf("Mess# %6lu\r", here);

        /* find highest and lowest message IDs: */
        /* >here< is the dip pholks             */
        if (here < cfg.oldest)
        {
            slot = ( indexslot(cfg.newest) + 1 );

            makeroom = (int)(cfg.mtoldest - here);

            /* check to see if our table can hold  remaining msgs */
            if (cfg.nmessages < (makeroom + slot))
            {
                skipcounter = (makeroom + slot) - cfg.nmessages;

                slidemsgTab(makeroom - skipcounter);

                cfg.mtoldest = (here + (ulong)skipcounter);
 
            }
            /* nmessages can handle it.. Just make room */
            else
            {
                slidemsgTab(makeroom);
                cfg.mtoldest = here;
            }
            cfg.oldest = here;
        }

        if (here > cfg.newest)
        {
            cfg.newest = here;

            /* read rest of message in and remember where it ends,      */
            /* in case it turns out to be the last message              */
            /* in which case, that's where to start writing next message*/
            getMsgStr(msgBuf->mbtext, MAXTEXT); 

            cfg.catLoc = ftell(msgfl);
        }

        /* check to see if our table is big enough to handle it */
        if ( (int)(here - cfg.mtoldest) >= cfg.nmessages)
        {
            crunchmsgTab(1);
        }

        if (skipcounter) 
        {
            skipcounter--;
        }
        else
        {
            indexmessage(here);
        }
    }    
    buildcopies();
}

/* -------------------------------------------------------------------- */
/*  zapMsgFl()  initializes message.buf                                 */
/* -------------------------------------------------------------------- */
zapMsgFile()
{
    int i;
    unsigned sect;

    /* put null message in first sector... */
    filter[0]  = 0xFF; /*                                   */
    filter[1]  = DUMP; /*  \  To the dump                   */
    filter[2]  = '\0'; /*  /  Attribute                     */
    filter[3]  =  '1'; /*  >                                */
    filter[4]  = '\0'; /*  \  Message ID "1" MS-DOS style   */
    filter[5]  =  'M'; /*  /         Null messsage          */
    filter[6]  = '\0'; /*                                   */
                                                  
    cfg.newest = cfg.oldest = 1l;

    cfg.catLoc = 7l;

    if (fwrite(filter, 128, 1, msgfl) != 1)
    {
        cPrintf("zapMsgFil: write failed"); doccr();
    }

    for (i = 0;  i < 128;  i++) filter[i] = 0;

    doccr();  doccr();
    cPrintf("MESSAGEK=%d", cfg.messagek);  doccr();
    for (sect = 1;  sect < (cfg.messagek * 8 );  sect++)
    {
        cPrintf("Clearing block %4u\r", sect);
        if (fwrite(filter, 128, 1, msgfl) != 1)
        {
            cPrintf("zapMsgFil: write failed");  doccr();
        }
    }
    return TRUE;
}


/* -------------------------------------------------------------------- */
/*  slidemsgTab()   frees slots at beginning of msg table               */
/* -------------------------------------------------------------------- */
void slidemsgTab(int howmany)
{
    hmemcpy(&msgTab[howmany], &msgTab[0],(long)
      ((long)( (long)cfg.nmessages - (long)howmany) * (long)(sizeof(*msgTab)) )
    );
}

/* -------------------------------------------------------------------- */
/*  buildcopies()   copies appropriate msg index members                */
/* -------------------------------------------------------------------- */
void buildcopies(void)
{
    int i;

    for( i = 0; i < sizetable(); ++i)
    {
        if (msgTab[i].mtmsgflags.COPY)
        {
            if (msgTab[i].mtoffset <= i)
            {
                copyindex( i, (i - msgTab[i].mtoffset));
            }
        }
    }
}


