/* -------------------------------------------------------------------- */
/*  MSG.C                    Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*               This is the high level message code.                   */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
#include <string.h>
#include <time.h>
#include "ctdl.h"
#include "keywords.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  clearmsgbuf()   this clears the message buffer out                  */
/*  mAbort()        returns TRUE if the user has aborted typeout        */
/*  indexslot()     give it a message # and it returns a slot#          */
/*  mayseemsg()     returns TRUE if person can see message. 100%        */
/*  mayseeindexmsg() Can see message by slot #. 99%                     */
/*  sizetable()     returns # messages in table                         */
/*  indexmessage()  builds one message index from msgBuf                */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  06/02/89    (PAT)   Made history, cleaned up comments, reformated   */
/*                      icky code.                                      */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static Data                                                         */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  clearmsgbuf()   this clears the message buffer out                  */
/* -------------------------------------------------------------------- */
void clearmsgbuf(void)
{
    /* clear msgBuf out */
    msgBuf->mbroomno    =   0 ;
    msgBuf->mbattr      =   0 ;
    msgBuf->mbauth[ 0]  = '\0';
    msgBuf->mbtitle[0]  = '\0';
    msgBuf->mbocont[0]  = '\0';
    msgBuf->mbfpath[0]  = '\0';
    msgBuf->mbtpath[0]  = '\0';
    msgBuf->mbczip[ 0]  = '\0';
    msgBuf->mbcopy[ 0]  = '\0';
    msgBuf->mbfwd[  0]  = '\0';
    msgBuf->mbgroup[0]  = '\0';
    msgBuf->mbtime[ 0]  = '\0';
    msgBuf->mbId[   0]  = '\0';
    msgBuf->mbsrcId[0]  = '\0';
    msgBuf->mboname[0]  = '\0';
    msgBuf->mboreg[ 0]  = '\0';
    msgBuf->mbreply[0]  = '\0';
    msgBuf->mbroom[ 0]  = '\0';
    msgBuf->mbto[   0]  = '\0';
    msgBuf->mbsur[  0]  = '\0';
    msgBuf->mblink[ 0]  = '\0';
    msgBuf->mbx[    0]  = '\0';
    msgBuf->mbzip[  0]  = '\0';
    msgBuf->mbrzip[ 0]  = '\0';
    msgBuf->mbusig[ 0]  = '\0';
    msgBuf->mbsub[  0]  = '\0';
    msgBuf->mbsig[  0]  = '\0';
    msgBuf->mbsoft[ 0]  = '\0';
}

/* -------------------------------------------------------------------- */
/*  mAbort()        returns TRUE if the user has aborted typeout        */
/* -------------------------------------------------------------------- */
BOOL mAbort(BOOL pause)
{
    char c;
    char toReturn = FALSE;
    char oldEcho;
    int  i;
    BOOL more = FALSE;
    
    /*
     * Can not abort IMPERVIOUS
     */
    if (outFlag == IMPERVIOUS)
    {
        return FALSE;
    }
    
    /*
     * Carrier loss and not on Console
     */
    if (!CARRIER)
    {
        outFlag = OUTSKIP;
        return TRUE;
    }

    /*
     *  Check for keypress..
     */
    if (BBSCharReady() || pause)
    {
        oldEcho  = echo;
    
        if (pause)
        {
            c = 'P';
            more = TRUE;
        }
        else
        {
            echo = NEITHER;
            c = (char)toupper(iChar());
        }

        if (c == 'P' || c == 19 /* XOFF */)       /* Pause! */
        {
            echo = oldEcho;
            setio(whichIO, echo, outFlag);
            
            if (more)
		putWord((uchar *)"<More>");
	   
	    echo = NEITHER;
	    
	    c = (char)toupper(iChar());             /* wait to resume */
	    
	    if (more)
		for(i=0; i<6; i++)
		    doBS();
	}
	
	echo = oldEcho;
	
	setio(whichIO, echo, outFlag);
	
	if (outFlag == NOSTOP)  
	    return FALSE;
	
	switch (c)
	{
	case 'C':
	    dotoMessage = COPY_IT;
	    toReturn    = FALSE;
	    break;
	    
	case 'J':                            /* jump paragraph:*/
	    doCR();
	    termCap(TERM_BOLD);
	    putWord((uchar *)"<Jump>");
	    termCap(TERM_NORMAL);
	    doCR();
	    outFlag     = OUTPARAGRAPH;
	    toReturn    = FALSE;
	    break;
	    
	case 'K':                            /* kill:          */
	    if (    CAN_MODERATE()
                 || (cfg.kill && (strcmpi(logBuf.lbname, 
                                          msgBuf->mbauth) == SAMESTRING))
               )
            {   
                dotoMessage = PULL_IT;
                
                doCR();
                termCap(TERM_BOLD);
		putWord((uchar *)"<Kill>");
		termCap(TERM_NORMAL);
		outFlag     = OUTNEXT;
		toReturn    = TRUE;
	    }
	    else
	    {
		toReturn               = FALSE;
	    }
	    break;
	    
	case 'M':                            /* mark:          */
	    if (aide)  dotoMessage = MARK_IT;
	    toReturn               = FALSE;
	    break;
	    
	case 'N':                            /* next:          */
	    doCR();
	    termCap(TERM_BOLD);
	    putWord((uchar *)"<Next>");
	    termCap(TERM_NORMAL);
	    doCR();
	    outFlag     = OUTNEXT;
	    toReturn    = TRUE;
	    break;
	    
        case 'S':                            /* skip:          */
            doCR();
            termCap(TERM_BOLD);
	    putWord((uchar *)"<Stop>");
	    termCap(TERM_NORMAL);
	    doCR();
	    outFlag     = OUTSKIP;
	    toReturn    = TRUE;
	    break;
	
	case 'R':
	    dotoMessage = REVERSE_READ;
	    toReturn    = FALSE;
	    break;

	case 'V':
	    dotoMessage = VERBOSE_READ;
	    toReturn    = FALSE;
	    break;

	default:
	    toReturn    = FALSE;
	    break;
	}
    }
    
    return toReturn;
}


/* -------------------------------------------------------------------- */
/*  indexslot()     give it a message # and it returns a slot#          */
/* -------------------------------------------------------------------- */
int indexslot(ulong msgno)
{ 
    if (msgno < cfg.mtoldest)
    {
        return(ERROR);
    }

    return((int)(msgno - cfg.mtoldest));
}

/* -------------------------------------------------------------------- */
/*  mayseemsg()     returns TRUE if person can see message. 100%        */
/* -------------------------------------------------------------------- */
BOOL mayseemsg(void)
{
    int i;
    uchar attr;

    if (!copyflag) attr = msgBuf->mbattr;
    else           attr = originalattr;

    /* mfUser */
    if ( mf.mfUser[0] )
    {
        if (!u_match(msgBuf->mbto, mf.mfUser)
            && !u_match(msgBuf->mbauth, mf.mfUser) )
            return (FALSE);
    }

    /* check for PUBLIC non problem user messages first */
    if ( !msgBuf->mbto[0] && !msgBuf->mbx[0] && !msgBuf->mbgroup[0])
        return(TRUE);

    if (msgBuf->mbx[0])
    {
        if ( strcmpi(msgBuf->mbauth,  logBuf.lbname) == SAMESTRING )
        {
            /* problem users cant see copys of their own messages */
            if (copyflag) return(FALSE);
        }
        else
        {
            /* but everyone else cant see the orignal if it has been released */
            if (   !copyflag 
                && ((attr & ATTR_MADEVIS) == ATTR_MADEVIS)
               ) 
                return(FALSE);
            
            /* problem user message... */    
            if (   msgBuf->mbx[0] == 'Y'
                && !/* CAN_MODERATE() */ (sysop || aide)
                && !((attr & ATTR_MADEVIS) == ATTR_MADEVIS)
               )
            {   
                return(FALSE);
            }
            
            /* moderated message... */    
            if (   msgBuf->mbx[0] == 'M' 
                && !((attr & ATTR_MADEVIS) == ATTR_MADEVIS)
               )
            {   
                if ( !(   sysop 
                       || (aide && !cfg.moderate) 
                       /* || (roomTab[thisRoom].rtflags.GRP_MOD&&pgroupseesroom()) */
                      ) 
                   )
                {   
                    return(FALSE);
                }
            }
        }
    }


    if ( msgBuf->mbto[0] )
    {
        /* author can see his own private messages */
        if (strcmpi(msgBuf->mbauth,  logBuf.lbname) == SAMESTRING)
            return(TRUE);
            
        /* recipient can see private messages      */
        if (strcmpi(msgBuf->mbto, logBuf.lbname) == SAMESTRING)
        return(TRUE);          

        /* forwardee can see private messages      */
        if (strcmpi(msgBuf->mbfwd, logBuf.lbname) == SAMESTRING)
        return(TRUE);
            
        /* sysops see messages to 'Sysop'           */
        if ( sysop && ( strcmpi(msgBuf->mbto, "Sysop") == SAMESTRING) )
        return(TRUE);

        /* aides see messages to 'Aide'           */
        if ( aide && ( strcmpi(msgBuf->mbto, "Aide") == SAMESTRING) )
        return(TRUE);

        /* none of those so cannot see message     */
        return(FALSE);
    }

    if ( msgBuf->mbgroup[0] )
    {
        for (i = 0 ; i < MAXGROUPS; ++i)
        {
            /* check to see which group message is to */
            if (strcmpi(grpBuf.group[i].groupname, msgBuf->mbgroup) == SAMESTRING)
            {
                /* if in that group */
                if (logBuf.groups[i] == grpBuf.group[i].groupgen )
                {
                    return(TRUE);
                }
                else
                {
                    return(FALSE);
                }
            }
        } /* group can't see message, return false */
        
        if (sysop)
	    mPrintf("    2Unknown group %s!0", msgBuf->mbgroup); doCR();
	return(sysop);
    }

    return(TRUE);
}

/* -------------------------------------------------------------------- */
/*  mayseeindexmsg() Can see message by slot #. 99%                     */
/* -------------------------------------------------------------------- */
BOOL mayseeindexmsg(int slot)
{
    int i;
    struct messagetable huge *msgT; 

    msgT = (msgTab + slot);

    if (msgT->mtoffset > slot)  return(FALSE);

    /* check for PUBLIC non problem user messages first */
    if (   !msgT->mttohash 
        && !msgT->mtmsgflags.PROBLEM 
        && !msgT->mtmsgflags.LIMITED
       )
    {
        return(TRUE);
    }

    if (msgT->mtmsgflags.PROBLEM)
    {
        if (msgT->mtmsgflags.COPY)
        {
            /* problem users can not see copys of their messages */
            if (msgT->mtauthhash == hash(logBuf.lbname))
            {
                return FALSE;
            }
        }
        else
        {
            if (
                  !(
                        /* if you are a aide/sop and it is not MADEVIS */
                        /* CAN_MODERATE() */ 
                        (aide || sysop)
                     || msgT->mtmsgflags.MADEVIS
                   )
                && msgT->mtauthhash != hash(logBuf.lbname)
               )
            {
                return FALSE;
            }
        }
    }   

    if (msgT->mtmsgflags.MAIL)
    {
        /* author can see his own private messages */
        if (msgT->mtauthhash == hash(logBuf.lbname)
           && ( msgT->mtorigin == NULL || msgT->mtorigin == hash(cfg.nodeTitle))
           )  
        {
            return(TRUE);
        }

        /* recipient can see private messages      */
        if (msgT->mttohash == hash(logBuf.lbname)
        && !msgT->mtmsgflags.NET)   return(TRUE);

        /* forwardee can see private messages      */
        if (msgT->mtfwdhash == hash(logBuf.lbname))  return(TRUE);
            
        /* sysops see messages to 'Sysop'           */
        if ( sysop && (msgT->mttohash == hash("Sysop")) )
        return(TRUE);

        /* aides see messages to 'Aide'           */
        if ( aide && (msgT->mttohash == hash("Aide")) )
        return(TRUE);

        /* none of those so cannot see message     */
        return(FALSE);
    }

    if (msgT->mtmsgflags.LIMITED)
    {
        for (i = 0 ; i < MAXGROUPS; ++i)
        {
            /* check to see which group message is to */
            if (hash(grpBuf.group[i].groupname) == msgT->mttohash)
            {
                /* if in that group */
                if (logBuf.groups[i] == grpBuf.group[i].groupgen )
                {
                    return(TRUE);
                }
                else
                {
                    return(FALSE);
                }
            }
        } /* group can't see message, return false */
        return(sysop);
    }
    return(TRUE);
}

/* -------------------------------------------------------------------- */
/*  sizetable()     returns # messages in table                         */
/* -------------------------------------------------------------------- */
uint sizetable(void)
{
    return (int)((cfg.newest - cfg.mtoldest) + 1);
}

/* -------------------------------------------------------------------- */
/*  indexmessage()  builds one message index from msgBuf                */
/* -------------------------------------------------------------------- */
void indexmessage(ulong here)
{
    ushort slot;
    ulong copy;
    ulong oid;
    struct messagetable huge *msgSlt;
    
    slot = indexslot(here);

    msgSlt = &msgTab[slot];

    msgSlt->mtmsgLoc            = (long)0;

    msgSlt->mtmsgflags.MAIL     = 0;
    msgSlt->mtmsgflags.RECEIVED = 0;
    msgSlt->mtmsgflags.REPLY    = 0;
    msgSlt->mtmsgflags.PROBLEM  = 0;
    msgSlt->mtmsgflags.MADEVIS  = 0;
    msgSlt->mtmsgflags.LIMITED  = 0;
    msgSlt->mtmsgflags.MODERATED= 0;
    msgSlt->mtmsgflags.RELEASED = 0;
    msgSlt->mtmsgflags.COPY     = 0;
    msgSlt->mtmsgflags.NET      = 0;

    msgSlt->mtauthhash  = 0;
    msgSlt->mttohash    = 0;
    msgSlt->mtfwdhash   = 0;
    msgSlt->mtoffset    = 0;
    msgSlt->mtorigin    = 0;
    msgSlt->mtomesg     = (long)0;

    msgSlt->mtroomno    = DUMP;

    /* --- */
    
    msgSlt->mtmsgLoc    = msgBuf->mbheadLoc;

    if (*msgBuf->mbsrcId)
    {
        sscanf(msgBuf->mbsrcId, "%ld", &oid);
        msgSlt->mtomesg = oid;
    }

    if (*msgBuf->mbauth)  msgSlt->mtauthhash =  hash(msgBuf->mbauth);

    if (*msgBuf->mbto)
    {
        msgSlt->mttohash   =  hash(msgBuf->mbto);    

        msgSlt->mtmsgflags.MAIL = 1;

        if (*msgBuf->mbfwd)  msgSlt->mtfwdhash = hash(msgBuf->mbfwd);
    }
    
    if (*msgBuf->mbgroup)
    {
        msgSlt->mttohash   =  hash(msgBuf->mbgroup);
        msgSlt->mtmsgflags.LIMITED = 1;
    }

    if (*msgBuf->mboname)
      msgSlt->mtorigin = hash(msgBuf->mboname);

    if (strcmpi(msgBuf->mbzip, cfg.nodeTitle) != SAMESTRING && *msgBuf->mbzip)
    {
        msgSlt->mtmsgflags.NET = 1;
        msgSlt->mttohash       = hash(msgBuf->mbzip);
    }

    if (*msgBuf->mbx)  msgSlt->mtmsgflags.PROBLEM = 1;

    msgSlt->mtmsgflags.RECEIVED = 
        ((msgBuf->mbattr & ATTR_RECEIVED) == ATTR_RECEIVED);

    msgSlt->mtmsgflags.REPLY    = 
        ((msgBuf->mbattr & ATTR_REPLY   ) == ATTR_REPLY   );

    msgSlt->mtmsgflags.MADEVIS  = 
        ((msgBuf->mbattr & ATTR_MADEVIS ) == ATTR_MADEVIS );

    msgSlt->mtroomno = msgBuf->mbroomno;

    /* This is special. */
    if  (*msgBuf->mbcopy)
    {
        msgSlt->mtmsgflags.COPY = TRUE;

        /* get the ID# */
        sscanf(msgBuf->mbcopy, "%ld", &copy);

        msgSlt->mtoffset = (ushort)(here - copy);
    }

    if (roomBuild) buildroom();
}


