/* -------------------------------------------------------------------- */
/*  DOWN.C                   Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*  Code to bring citadel down                                          */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
/* MSC */
#include <bios.h>
#include <conio.h>
#include <dos.h>
#include <dir.h>
#include <io.h>
#include <alloc.h>
#include <signal.h>
#include <string.h>
#include <stdarg.h>
#include <time.h>

/* DragCit */
#include "ctdl.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  crashout()      Fatal system error                                  */
/*  exitcitadel()   Done with cit, time to leave                        */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  08/04/90    (PAT)   File created                                    */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  External data                                                       */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static Data definitions                                             */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  crashout()      Fatal system error                                  */
/* -------------------------------------------------------------------- */
void crashout(char *message)
{
    FILE *fd;           /* Record some crash data */

    Hangup();

    fcloseall();

    fd = fopen("crash.cit", "w");
    fprintf(fd, message);
    fclose(fd);

    writeTables();

    cfg.attr = 7;   /* exit with white letters */

    position(0,0);
    cPrintf("Fatal System Screwup (FSS) : %s\n", message);

    drop_dtr();

    portExit();

    farfree((void far *)roomPos  );
    farfree((void far *)eventlist);
    farfree((void far *)msgBuf2  );
    farfree((void far *)msgBuf   );
    farfree((void far *)roomTab  );
    farfree((void far *)extrn    );
    farfree((void far *)hallBuf  );
    farfree((void far *)edit     );
    farfree((void far *)doors    );
    farfree((void far *)talleyBuf);
    farfree((void far *)lBuf2    );
    
    exit(199);
}

/* -------------------------------------------------------------------- */
/*  exitcitadel()   Done with cit, time to leave                        */
/* -------------------------------------------------------------------- */
void exitcitadel(void)
{
    if (!slv_door)
        drop_dtr();   /* turn DTR off */
    mPrintf("Shutting down Warp Drive..."); doCR();

    putGroup();       /* save group table */
    putHall();        /* save hall table  */

    mPrintf("Dropping out of Warp Space..."); doCR();
  
    writeTables(); 

    trap("Warp Drive Disengaged...", T_SYSOP);

    /* close all files */
    fcloseall();

    cfg.attr = 7;   /* exit with white letters */
    cls();

    portExit();

    farfree((void far *)roomPos  );
    farfree((void far *)eventlist);
    farfree((void far *)msgBuf2  );
    farfree((void far *)msgBuf   );
    farfree((void far *)roomTab  );
    farfree((void far *)extrn    );
    farfree((void far *)hallBuf  );
    farfree((void far *)edit     );
    farfree((void far *)doors    );
    farfree((void far *)talleyBuf);
    farfree((void far *)lBuf2    );

    if (gmode() != 7)
    {
        outp(0x3d9,0);
    }

    mPrintf("Bye!"); doCR();
    exit(return_code);
}


