/* -------------------------------------------------------------------- */
/*  DO.C                     Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include "ctdl.h"
#include "keywords.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*      Download() is also here...                       		*/
/*      doChat()                handles C(hat)          command         */
/*      doEnter()               handles E(nter)         command         */
/*      doGoto()                handles G(oto)          command         */
/*      doHelp()                handles H(elp)          command         */
/*      doIntro()               handles I(ntro)         command         */
/*      doKnown()               handles K(nown rooms)   command         */
/*      doLogin()               handles L(ogin)         command         */
/*      doLogout()              handles T(erminate)     command         */
/*      doRead()                handles R(ead)          command         */
/*      doNext()                handles '+' next room                   */
/*      doPrevious()            handles '-' previous room               */
/*      doNextHall()            handles '>' next room                   */
/*      doPreviousHall()        handles '<' previous room               */
/*      doSmallChat()           handles ';' chat        command         */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  08/04/90    (PAT)   Created.                                        */
/*                                                                      */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  External data                                                       */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Static Data                                                         */
/* -------------------------------------------------------------------- */

/************************************************************************/
/*      doDownload()                                                    */
/************************************************************************/
void doDownload(char ex)
{
    mPrintf("Download ");

    /* handle uponly flag! */
    if ( roomTab[thisRoom].rtflags.UPONLY && !pgroupseesroom() )
    {
        doCR();
        mPrintf(" --Room is upload only.");
        doCR();
        return;
    }

    if ( !roomBuf.rbflags.MSDOSDIR )
    {
	if (expert) mPrintf("Huh? ");
	else        mPrintf("\n Not a directory room.");
	return;
    }
    download( (ex || !logBuf.protocol) ? '\0' : logBuf.protocol);
}

/************************************************************************/
/*      doUpload()                                                      */
/************************************************************************/
void doUpload(char ex)
{
    mPrintf("Upload ");

    /* handle downonly flag! */
    if ( roomTab[thisRoom].rtflags.DOWNONLY && !pgroupseesroom())
    {
        doCR();
        doCR();
        mPrintf(" --Room is download only.");
        doCR();
        return;
    }

    if ( !roomBuf.rbflags.MSDOSDIR )
    {
	if (expert) mPrintf("Huh?");
	else        { doCR(); mPrintf(" Not a directory room."); }
	return;
    }
    
    upload( (ex || !logBuf.protocol) ? '\0' : logBuf.protocol);
    return;
}

/************************************************************************/
/*      doChat()                                                        */
/************************************************************************/
void doChat(moreYet, first)
char moreYet;   /* TRUE to accept following parameters  */
char first;     /* first parameter if TRUE              */
{
    moreYet = moreYet;  /* -W3 */
    first   = first;    /* -W3 */
    
    chatReq = TRUE;
    
    mPrintf("Chat ");

    trap("Chat request", T_CHAT);

    if (cfg.noChat)
    {
        nochat(FALSE);
        return;
    }

    if (whichIO == MODEM)  ringSysop();
    else                   chat() ;
}


/***********************************************************************/
/*     doEnter() handles E(nter) command                               */
/***********************************************************************/
void doEnter(char moreYet,char first)
{
    char done;
    char letter;

    if (moreYet)  first = '\0';

    done      = TRUE ;
    mailFlag  = FALSE;
    oldFlag   = FALSE;
    limitFlag = FALSE;
    linkMess  = FALSE;

    mPrintf("Enter ");

    do  
    {
        done    = TRUE;

        letter = (char)(toupper( first ? (char)first : (char)iCharNE()));

        /* handle readonly flag! */
        if ( roomTab[thisRoom].rtflags.READONLY && !pgroupseesroom()
        && ( (letter == '\r') || (letter == '\n') || (letter == 'M') 
        ||   (letter == 'E')  || (letter == 'O') || (letter == 'G')  ) )
        {
            mPrintf("\n\n  --Room is readonly.\n ");
            break;
        }

        /* handle steeve */
        if ( MessageRoom[thisRoom] == cfg.MessageRoom && !(sysop || aide)
        && ( (letter == '\r') || (letter == '\n') || (letter == 'M') 
        ||   (letter == 'E')  || (letter == 'O') || (letter == 'G') ) )
        {
            mPrintf("\n\n  --Only %d %s per room.\n ",cfg.MessageRoom, 
                    cfg.msgs_nym);
            break;
        }

        /* handle nomail flag! */
        if ( logBuf.lbflags.NOMAIL && (letter == 'E'))
        {
            doCR();
            doCR();
            mPrintf("  --You can't enter exclusive messages."); doCR();
            break;
        }
        
        /* no mail in anon rooms! */
        if ( roomTab[thisRoom].rtflags.ANON && (letter == 'E'))
        {
            doCR();
            doCR();
            mPrintf("  --Not in Anon rooms."); doCR();
            break;
        }

        /* handle downonly flag! */
        if ( roomTab[thisRoom].rtflags.DOWNONLY && !pgroupseesroom()
        && (  (letter == 'T') || (letter == 'W') ) ) 
        {
            mPrintf("\n\n  --Room is download only.\n ");
            break;
        }

        if ( !sysop && (letter == '*'))
        {
            mPrintf("\n\n  --You can't enter a file-linked %s.\n ", 
                    cfg.msg_nym);
            break;
        }

        if ( !sysop && (letter == 'S') && !cfg.entersur )
        {
            mPrintf("\n\n  --Users can't enter their title and surname.\n ");
            break;
        }

        if ( !sysop && (letter == 'S') && logBuf.SURNAMLOK )
        {
            mPrintf("\n\n  --Your title and surname has been locked!\n ");
            break;
        }

        switch (letter)
        {
        case '\r':
        case '\n':
        case 'M':
            mPrintf("%s ", cfg.msg_nym);
            doCR();
            makeMessage();
            break;
            
        case 'B':
            mPrintf("Border Line");
            if (!logBuf.BOARDERS && !sysop)
            {
                mPrintf("\n\n  --You can't enter a boarder.\n ");
                return;
            }
            editBorder();
            break;
            
        case 'C':
            mPrintf("Configuration ");
            configure(FALSE);
            break;
            
        case 'D':
            mPrintf("Door ");
            if (!execDoor(letter = iCharNE()))
            {
                if (letter == '?')
                {
                    tutorial("DOORS.MNU");
                }
                else
                {
                    mPrintf(" ? for list of doors");
                    doCR();
                }
            }
            break;
            
        case 'E':
            mPrintf("Exclusive %s ", cfg.msg_nym);
            doCR();
            if (whichIO != CONSOLE) echo = CALLER;
            limitFlag = FALSE; 
            mailFlag = TRUE;
            makeMessage();
            echo = BOTH;
            break;
        
        case 'H':
            mPrintf("Hallway ");
            doCR();
            enterhall();
            break;
        case 'L':
            mPrintf("Limited-access ");
            done      = FALSE;
            limitFlag = TRUE;
            break;
        case '*':
            mPrintf("File-linked ");
            done      = FALSE;
            linkMess  = TRUE;
            break;
        case 'G':
            mPrintf("Group-only %s ", cfg.msg_nym);
            doCR();
            limitFlag = TRUE;
            makeMessage();
            break;
        case 'O':
            mPrintf("Old %s ", cfg.msg_nym);
            done    = FALSE;
            oldFlag = TRUE;
            break;
        case 'P':
            mPrintf("Password ");
            doCR();
            newPW();
            break;
        case 'R':
            mPrintf("Room ");
            if (   !cfg.nonAideRoomOk 
                && !aide 
                && !hallBuf->hall[thisHall].enterRoom)
            {
                 doCR(); 
		 mPrintf(" --Sorry, ya gotta be an aide to create a room.");
		 doCR(); 
		 break;
	    }
	    doCR();
	    makeRoom();
	    break;
	case 'T':
	    mPrintf("Textfile ");
	    if (roomBuf.rbflags.MSDOSDIR != 1)
	    {
		if (expert) mPrintf("Huh? ");
		else        mPrintf("\n Not a directory room.");
		return;
	    }
	    entertextfile();
	    break;
	case 'W':
	    mPrintf("WC-protocol upload ");
	    if ( !roomBuf.rbflags.MSDOSDIR )
	    {
		if (expert) mPrintf("Huh? ");
		else        mPrintf("\n Not a directory room.");
	    }
	    else enterwc();
	    doCR();
            break;
        case 'A':
            mPrintf("Application");
            ExeAplic();
            break;
        case 'X':
            mPrintf("Exclude Room ");
            exclude();
            break;
        case 'S':
            if (cfg.surnames || cfg.titles)
            {
                label tempsur;

                mPrintf("Surname / Title"); doCR();
                
                if (cfg.titles)
                {
                    getString("title", tempsur, NAMESIZE, 0, ECHO, 
                              logBuf.title);
                    if (*tempsur)
                    {
                        strcpy(logBuf.title, tempsur);
                        normalizeString(logBuf.title);
                    }
                }
                
                if (cfg.surnames)
                {
                    getString("surname", tempsur, NAMESIZE, 0, ECHO, 
                              logBuf.surname);
                    if (*tempsur)
                    {
                        strcpy(logBuf.surname, tempsur);
                        normalizeString(logBuf.surname);
                    }
                }
                break;
            }
        default:
            mPrintf("? ");
            if (expert)  break;
        case '?':
            tutorial("entopt.mnu");
            break;
        }
    }
    while (!done && moreYet);

    oldFlag   = FALSE;
    mailFlag  = FALSE;
    limitFlag = FALSE;

}

/************************************************************************/
/*      exclude() handles X>clude room,  toggles the bit                */
/************************************************************************/
void exclude(void)
{
    if  (!logBuf.lbroom[thisRoom].xclude)
    {
	 mPrintf("\n \n Room now excluded from your G)oto loop.\n ");
	 logBuf.lbroom[thisRoom].xclude = TRUE;  
    }else{
	 mPrintf("\n \n Room now in your G)oto loop.\n ");
	 logBuf.lbroom[thisRoom].xclude = FALSE;
    }
}

/************************************************************************/
/*      doGoto() handles G(oto) command                                 */
/************************************************************************/
void doGoto(expand, skip)
char expand;    /* TRUE to accept following parameters  */
{
    label roomName;

    if (!skip)
    {
        mPrintf("Goto ");
        skiproom = FALSE;
    } 
    else 
    {
        mPrintf("Bypass to ");
        skiproom = TRUE;
    }

    if (!expand)
    {
        gotoRoom("");
        return;
    }

    getString("", roomName, NAMESIZE, 1, ECHO, "");
    normalizeString(roomName);

    if (roomName[0] == '?')
    {
        listRooms(OLDNEW, FALSE, FALSE);
    }
    else 
    {
        gotoRoom(roomName);
    }
}

/************************************************************************/
/*      doHelp() handles H(elp) command                                 */
/************************************************************************/
void doHelp(expand)
char expand;    /* TRUE to accept following parameters  */
{
    mPrintf("Help"); doCR(); doCR();
    
    Help(expand);
}

/************************************************************************/
/*      doIntro() handles Intro to ....  command.                       */
/************************************************************************/
void doIntro()
{
    mPrintf("Intro to %s\n ", cfg.nodeTitle);
    tutorial("intro.hlp");
}


/***********************************************************************/
/*      doKnown() handles K(nown rooms) command.                       */
/***********************************************************************/
void doKnown(moreYet,first)
char moreYet;           /* TRUE to accept following parameters */
char first;             /* first parameter if true             */
{
    char letter;
    char verbose = FALSE;
    char numMess = FALSE;
    char done;

    if (moreYet)  first = '\0';

    mPrintf("Known ");

    do  
    {
        done    = TRUE;

        letter = (char)(toupper( first ? (char)first : (char)iCharNE()  ));
        switch (letter)
        {
            case 'A':
                mPrintf("Application Rooms ");
                mPrintf("\n ");
                listRooms(APLRMS, verbose, numMess);
                break;
            case 'D':
                mPrintf("Directory Rooms ");
                mPrintf("\n ");
                listRooms(DIRRMS, verbose, numMess);
                break;
            case 'H':
                mPrintf("Hallways ");
                knownhalls();
                break;
            case 'G':
                mPrintf("Group only Rooms ");
                mPrintf("\n ");
                listRooms(LIMRMS, verbose, numMess);
                break;
            case 'L':
                mPrintf("Local Rooms ");
                mPrintf("\n ");
                listRooms(NOTSHRDRM, verbose, numMess);
                break;
            case 'N':
                mPrintf("New Rooms ");
                mPrintf("\n ");
                listRooms(NEWRMS, verbose, numMess);
                break;
            case 'O':
                mPrintf("Old Rooms ");
                mPrintf("\n ");
                listRooms(OLDRMS, verbose, numMess);
                break;
            case 'E':
            case 'M':
                mPrintf("Exclusive Message Rooms ");
                mPrintf("\n ");
                listRooms(MAILRM, verbose, numMess);
                break;
            case 'S':
                mPrintf("Shared Rooms ");
                mPrintf("\n ");
                listRooms(SHRDRM, verbose, numMess);
                break;
            case 'I':
                mPrintf("Room Info");
                mPrintf("\n ");
                RoomStatus();
                break;
            
            case '\r':
            case '\n':
            case 'R':
                mPrintf("Rooms"); doCR();
                listRooms(OLDNEW, verbose, numMess);
                break;
            case 'V':
                mPrintf("Verbose ");
                done    = FALSE;
                verbose = TRUE;
                break;
            case 'W':
                mPrintf("Windows "); doCR();
                if (cfg.floors)
                {
                    doCR();
                    mPrintf("-- System in floor mode, no efect."); doCR();
                    return;
                }
                listRooms(WINDWS, verbose, numMess);
                break;
            case 'X':
                mPrintf("Xcluded Rooms ");
                mPrintf("\n ");
                listRooms(XCLRMS, verbose, numMess);
                break;
            case '#':
                mPrintf("Number of %s ", cfg.msgs_nym);
                done    = FALSE;
                numMess = TRUE;
                break;
            default:
                mPrintf("? ");
                if (expert)  break;
            case '?':
                tutorial("known.mnu");
                break;
        }
    }
    while (!done && moreYet);
}

/************************************************************************/
/*      doLogout() handles T(erminate) command                          */
/************************************************************************/
void doLogout(expand, first)
char expand;    /* TRUE to accept following parameters  */
char first;     /* first parameter if TRUE              */
{
    char done = FALSE, verbose = FALSE;

    if (expand)   first = '\0';

    mPrintf("Terminate ");

    if (first == 'q')
        verbose = 1;
    
    while(!done && CARRIER)
    {
        done = TRUE;

        switch (toupper( first ? (int)first : (int)iCharNE() ))
        {
        case '?':
            mPrintf("\n Logout options:\n \n ");
    
            mPrintf("Q>uit-also\n " );
            mPrintf("S>tay\n "      );
            mPrintf("V>erbose\n "   );
            mPrintf("? -- this\n "  );
            break;
        
        case 'Y':
        case 'Q':
            mPrintf("Quit-also\n ");
            if (!expand)  
            {
                if (!getYesNo(confirm, 0))   break;
            }
            if (!CARRIER) break;
            terminate( /* hangUp == */ TRUE, verbose);
            break;
            
        case 'S':
            mPrintf("Stay\n ");
            terminate( /* hangUp == */ FALSE, verbose);
            break;
            
        case 'V':
            mPrintf("Verbose ");
            verbose = 2;
            done = FALSE;
            break;
        
        default:
            if (expert)
                mPrintf("? ");
            else
                mPrintf("? for help");
            break;
        }
        first = '\0';
    }
}

/************************************************************************/
/*      doRead() handles R(ead) command                                 */
/************************************************************************/
void doRead(moreYet, first)
char moreYet;           /* TRUE to accept following parameters */
char first;             /* first parameter if TRUE             */
{
    char abort, done, letter;
    char whichMess, revOrder, verbose;

    if (moreYet)   first = '\0';

    mPrintf("Read ");

    abort      = FALSE;
    revOrder   = FALSE;
    verbose    = FALSE;
    whichMess  = NEWoNLY;
    memset(&mf, 0, sizeof(mf));

    do
    {
        done    = TRUE;

        letter = (char)(toupper(first ? (int)first : (int)iCharNE()));

        switch (letter)
        {
        case '\n':
        case '\r':
        case 'M':
            mPrintf("Messages"); doCR();
            moreYet = FALSE;
            break;
        
        case 'T':
        case '*':
            mPrintf("Text-Search ");
            mf.mfSearch[0] = TRUE;
            done           = FALSE;
            break;
        
        case 'B':
            mPrintf("By-User ");
            mf.mfUser[0] = TRUE;
            done         = FALSE;
            break;
        
        case 'C':
            mPrintf("Configuration ");
            showconfig(&logBuf);
            abort     = TRUE;
            break;
        
        case 'D':
        case 'I':
        case 'L':
        case 'W':
        case 'Z':
            doBS();
            doCR();
            doCR();
            mPrintf("  -- Command now avalible from '.List' menu.");
            doCR();
            return;
        
        case 'E':
            mPrintf("Exclusive ");
            mf.mfMai     = TRUE;
            done         = FALSE;
            break;
        
        case 'F':
            mPrintf("Forward ");
            revOrder     = FALSE;
            whichMess    = OLDaNDnEW;
            done         = FALSE;
            break;
        
        case 'G':
            mPrintf("Group-only ");
            mf.mfLim     = TRUE;
            done         = FALSE;
            break;
        
        case 'H':
            mPrintf("Hallways ");
            readhalls();
            abort     = TRUE;
            break;
        
        case 'N':
            mPrintf("New ");
            whichMess  = NEWoNLY;
            done       = FALSE;
            break;
        
        case 'O':
            mPrintf("Old ");
            revOrder   = TRUE;
            whichMess  = OLDoNLY;
            done       = FALSE;
            break;
        
        case 'P':
            mPrintf("Public ");
            mf.mfPub     = TRUE;
            done         = FALSE;
            break;
        
        case 'R':
            mPrintf("Reverse ");
            revOrder   = TRUE;
            whichMess  = OLDaNDnEW;
            done       = FALSE;
            break;
        
        case 'S':
            mPrintf("Status\n ");
            systat(verbose);
            abort         = TRUE;
            break;
        
        case 'U':
            mPrintf("Userlog ");
            Readlog(verbose, revOrder);
            abort         = TRUE;
            break;
            
        case 'V':
            mPrintf("Verbose ");
            verbose       = TRUE;
            done          = FALSE;
            break;
        
        default:
            mPrintf("? ");
            abort    = TRUE;
            if(expert) break;
        case '?':
            tutorial("readopt.mnu");
            abort    = TRUE;
            break;
        }
        first = '\0';

    }
    while (!done && moreYet && !abort);

    if (abort) return;

    showMessages(whichMess, revOrder, verbose);
}


/************************************************************************/
/*      doXpert                                                         */
/************************************************************************/
void doXpert()
{
    mPrintf("Xpert %s", (expert) ? "Off" : "On");
    doCR();
    expert = (char)(!expert);
}

/************************************************************************/
/*     doNext() handles the '+' for next room                           */
/************************************************************************/
void doNext()
{
    mPrintf("Next Room: ");
    stepRoom(1);
}

/************************************************************************/
/*     doPrevious() handles the '-' for previous room                   */
/************************************************************************/
void doPrevious()
{
    mPrintf("Previous Room: ");
    stepRoom(0);
}

/************************************************************************/
/*     doNextHall() handles the '>' for next hall                       */
/************************************************************************/
void doNextHall()
{
    mPrintf("Next Hall: ");
    stephall(1);
}

/************************************************************************/
/*     doPreviousHall() handles the '<' for previous hall               */
/************************************************************************/
void doPreviousHall()
{
    mPrintf("Previous Hall: ");
    stephall(0);
}


/************************************************************************/
/*      doList() handles R(ead) command                                 */
/************************************************************************/
void doList(moreYet, first)
char moreYet;           /* TRUE to accept following parameters */
char first;             /* first parameter if TRUE             */
{
    char done, letter;
    char revOrder, verbose;

    if (moreYet)   first = '\0';

    mPrintf("List ");

    revOrder   = FALSE;
    verbose    = FALSE;

    do
    {
        done    = TRUE;

        letter = (char)(toupper(first ? (int)first : (int)iCharNE()));

        /* handle uponly flag! */
        if (    roomTab[thisRoom].rtflags.UPONLY && !pgroupseesroom() 
             && strchr("DILTZW\r\n", letter)
           )
        {
            mPrintf("\n\n  --Room is upload only.\n ");
            return;
        }

        if (    !roomBuf.rbflags.MSDOSDIR 
             && strchr("DILTZW\r\n", letter)
           )
        {
	    if (expert) mPrintf("Huh? ");
	    else        mPrintf("\n Not a directory room.");
	    return;
	}
	
	switch (letter)
	{
	/*
	 * Modifiers
	 */
	/* also: Byuser, New, Group only, Old, 
	 */    
	case 'F':
	    mPrintf("Forward ");
	    revOrder     = FALSE;
	    done         = FALSE;
	    break;
	
	case 'R':
	    mPrintf("Reverse ");
	    revOrder   = TRUE;
	    done       = FALSE;
	    break;
	
	case 'V':
	    mPrintf("Verbose ");
	    verbose       = TRUE;
	    done          = FALSE;
	    break;
	
	/*
	 * Commands
	 */
	case 'D':
	    mPrintf("Directory ");
	    readdirectory(verbose);
	    break;
	
	case '\n':
	case '\r':
	    moreYet = FALSE;
	case 'I':
	    mPrintf("Info file ");
	    readinfofile(verbose, moreYet);
	    break;
	    
	case 'L':
	    mPrintf("LZH-file ");
	    readlzh(verbose);
	    break;
	
	case 'T':
	    mPrintf("Textfile ");
	    readtextfile();
	    break;
	
	case 'Z':
	    mPrintf("ZIP-file ");
	    readzip(verbose);
	    break;
	
	case 'W':
	    mPrintf("WC-protocol download ");
	    if (!roomBuf.rbflags.MSDOSDIR)
	    {
		if (expert) mPrintf("Huh? ");
		else        mPrintf("\n Not a directory room.");
	    }
	    else readwc();
	    break;            
	/*
	 * Opps.. 
	 */    
	default:
	    mPrintf("? ");
	    if(expert) break;
	case '?':
	    tutorial("list.mnu");
	    break;
	}
        first = '\0';
    }
    while (!done);

    revOrder = revOrder;
}

/************************************************************************/
/*      doSmallChat() hit a ; at the room prompt, gives you a little    */
/*  one-line chat.                                                      */
/************************************************************************/
void doSmallChat(void)
{
    char str[51];
    
    oChar(';');
    
    getString("", str, 50, 1, ECHO, "");
    normalizeString(str);
    
    if (strcmpi(str, "xyzzy") == SAMESTRING)
    {
        if (
               (sysop || aide)
           &&  groupseesroom(AIDEROOM) 
	   )
	{
	    oldroom   = thisRoom;
	    ug_hall   = thisHall;
	    ug_lvisit = logBuf.lbroom[thisRoom].lvisit;
	    ug_bypass = logBuf.lbroom[thisRoom].bypass;
	    ug_new    = talleyBuf->room[thisRoom].new;
    
            logBuf.lbroom[thisRoom].lbgen    = roomBuf.rbgen;
            logBuf.lbroom[thisRoom].lvisit   = 0;
            logBuf.lbroom[thisRoom].mail     = 0;
        
            /* zero new count in talleybuffer */
            talleyBuf->room[thisRoom].new  = 0;
            
            getRoom(AIDEROOM);
            thisHall = 1 /* maintenance */;
            
            dumpRoom();
        }
        else
        {
            doCR();
            mPrintf("Nothing happens"); doCR();
        }   
    }
    else
    {
        doCR();
    }
}
