/* -------------------------------------------------------------------- */
/*  CHAT.C                   Dragon Citadel                             */
/* -------------------------------------------------------------------- */
/*                        Overlayed chat stuff                          */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  Includes                                                            */
/* -------------------------------------------------------------------- */
#include <alloc.h>
#include <bios.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include "ctdl.h"
#include "proto.h"
#include "global.h"

/* -------------------------------------------------------------------- */
/*                              Contents                                */
/* -------------------------------------------------------------------- */
/*  chat()          This is the chat mode                               */
/*  ringSysop()     ring the sysop                                      */
/*  doSmallChat()   The one line chat function...           		*/
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  HISTORY:                                                            */
/*                                                                      */
/*  09/01/90    (PAT)   New file, part of source breakup.               */
/*  05/02/92    (CJTK)  Moved SmallChat here from do.c...               */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  External data                                                       */
/* -------------------------------------------------------------------- */

/* -------------------------------------------------------------------- */
/*  chat()          This is the chat mode                               */
/* -------------------------------------------------------------------- */
void chat(void)
{
    int c, from, lastfrom, wsize = 0, i;
    char word[50];

    chatkey = FALSE;
    chatReq = FALSE;

    if (!gotCarrier())
    {
        dial_out();
        return;
    }

    lastfrom = 2;

    tutorial("chat.blb");
    
    outFlag = IMPERVIOUS;

    do
    {
        c = 0;

        if (KBReady())
        {
            c = ciChar();
            from = 0;
        }

        if (MIReady())
        {
            if (!onConsole)
            {
                c = getMod();
                from = 1;
            } else {
                getMod();
            }
        }

        c = ( c & 0x7F );

        c = filter[c];

        if (c && c != 26 /* CNTRLZ */)
        {
            if (from != lastfrom)
            {
                if (from)
                {
                    termCap(TERM_NORMAL);
                    ansiattr = cfg.attr;
                }
                else
                {
                    termCap(TERM_BOLD);
                    ansiattr = cfg.cattr;
                }
                lastfrom = from;
            }
            
            if (c == '\r' || c == '\n' || c == ' ' || c == '\t' || wsize == 50)
            {
                wsize = 0;
            } else {
                if (crtColumn >= (termWidth-1))
                {
                    if (wsize)
                    {
                        for (i = 0; i < wsize; i++)
                            doBS();
                        doCR();
                        for (i = 0; i < wsize; i++)
                            echocharacter(word[i]);
                    } else {
                        doCR();
                    }

                    wsize = 0;
                } else {
                    word[wsize] = (char)c;
                    wsize ++;
                }
            }

            echocharacter((char)c);
        }
    } while ( (c != 26 /* CNTRLZ */) && gotCarrier() );

    time(&lasttime);
    termCap(TERM_NORMAL);
    ansiattr = cfg.attr;

    doCR();
}

/* -------------------------------------------------------------------- */
/*  ringSysop()     ring the sysop                                      */
/* -------------------------------------------------------------------- */
void ringSysop(void)
{
    char i;
    char answered = FALSE;
    int  oldBells;
    static char shave[] = { 10, 5, 5, 10, 20, 10, 75 };
    char ringlimit = 30;
    int j = 0;

    /* turn the ringer on */
    oldBells = cfg.noBells;
    cfg.noBells = FALSE;
    
    mPrintf("\n Beeping yer sysop...");

    answered = FALSE;

    for (i = 0; (i < ringlimit) && !answered && CARRIER; i++)
    {
        oChar(7 /* BELL */); 

        pause(shave[j]);

        j++;
        if (j ==7)
        {
            j = 0;
        }

        if (debug)
        {
            mPrintf("%d", j);
        }


        if (BBSCharReady() || KBReady())
        {
            answered = TRUE;
        }
    }

    cfg.noBells = oldBells;

    if (KBReady())  
    {
        chat();
    }
    else if (i >= ringlimit)
    {
	mPrintf("  Sorry, yer sysop isn't around.\n ");
    }
    else iChar();
}


/************************************************************************/
/*      doSmallChat() hit a ; at the room prompt, gives you a little    */
/*  one-line chat.                                                      */
/*  >>Moved from do.c...  to make things a bit easer to understand...   */
/*									*/
/*  This is a very strange command...  try ;xyzzy some time...          */
/*  I don't know why it's there..  but it is...                         */
/************************************************************************/
void doSmallChat(void)
{
    char str[51];
    
    oChar(';');
    
    getString("", str, 50, 1, ECHO, "");
    normalizeString(str);
    
    if (strcmpi(str, "xyzzy") == SAMESTRING)
    {
        if (
               (sysop || aide)
           &&  groupseesroom(AIDEROOM) 
	   )
	{
	    oldroom   = thisRoom;
	    ug_hall   = thisHall;
	    ug_lvisit = logBuf.lbroom[thisRoom].lvisit;
	    ug_bypass = logBuf.lbroom[thisRoom].bypass;
	    ug_new    = talleyBuf->room[thisRoom].new;
    
            logBuf.lbroom[thisRoom].lbgen    = roomBuf.rbgen;
            logBuf.lbroom[thisRoom].lvisit   = 0;
            logBuf.lbroom[thisRoom].mail     = 0;
        
            /* zero new count in talleybuffer */
            talleyBuf->room[thisRoom].new  = 0;
            
            getRoom(AIDEROOM);
            thisHall = 1 /* maintenance */;
            
            dumpRoom();
        }
        else
        {
            doCR();
            mPrintf("Nothing happens"); doCR();
        }   
    }
    else
    {
        doCR();
    }
}