unit subs2;

{ $define testingdevices}   (* Activate this define for test mode *)

interface

uses printer,dos,crt,gentypes,configrt,gensubs,subs1,windows,modem,statret,chatstuf,
     overret1;


procedure writecon (k:char);
function charready:boolean;
function readchar:char;
function waitforchar:char;
procedure clearchain;
function charpressed (k:char):boolean;  { TRUE if K is in typeahead }
procedure addtochain (l:lstr);
procedure directoutchar (k:char);
procedure handleincoming;
procedure writechar (k:char);
{ $F+}
      function opendevice (var t:textrec):integer;
      function closedevice (var t:textrec):integer;
      function cleardevice (var t:textrec):integer;
      function ignorecommand (var t:textrec):integer;
      function directoutchars (var t:textrec):integer;
      function writechars (var t:textrec):integer;
      function directinchars (var t:textrec):integer;
      function readcharfunc (var t:textrec):integer;
{ $F-}
function getinputchar:char;
procedure getstr;
procedure writestr (s:anystr);
procedure cls;
procedure writehdr (q:anystr);
function minstr (blocks:integer):sstr;
procedure parserange (numents:integer; var f,l:integer);
function menu (mname:mstr; mfn:sstr; choices:anystr):integer;
function checkpassword (var u:userrec):boolean;
function getpassword:boolean;
procedure display (fn:lstr);
procedure allclear;
function validbirthdate:boolean;
procedure getbirthdate;
procedure setlastcall(a:char);
procedure pausenow;
procedure drawbox(x:integer; s:lstr);

implementation

procedure writecon (k:char);
var r:registers;
begin
  if k=^J
    then write (usr,k)
    else
      begin
        r.dl:=ord(k);
        r.ah:=2;
        intr($21,r)
      end
end;

function charready:boolean;
var k:char;
begin
  if modeminlock then while numchars>0 do k:=getchar;
  if hungupon or keyhit
    then charready:=true
    else if online
      then charready:=(not modeminlock) and (numchars>0)
      else charready:=false
end;

function readchar:char;

  Procedure Functionkey(a:integer);
  var m:macrorec;
      b:integer;
      mafil:string[80];
  begin
    assign(mafile,maindir+'macro');
    mafil := maindir+'macro';
    if exist (mafil) then
      begin
      reset (mafile);
      read (mafile,m);
      end
    else
      begin
      rewrite (mafile);
      for b :=1 to 10 do m[b]:='';
      write (mafile,m);
      end;
    close (mafile);
    macro:=m[a];
      if (not ineditor) then
        begin
        if inchat then
          begin
          ansicolor(urec.regularcolor);
          write (macro);
          end
        else
          addtochain(macro);
        end;
 end;

var k,ret:char;
    b:integer;
    dorefresh:boolean;

begin
  requestchat:=false;
  requestcom:=false;
  reqspecial:=false;
  if keyhit
    then
      begin
        k:=bioskey;
        ret:=k;
        if ord(k)>127 then begin
          ret:=#0;
          if (infunctkeys) then exit;
          dorefresh:=ingetstr;
          case ord(k)-128 of
            availtogglechar:
              begin
                toggleavail;
                chatmode:=false;
                dorefresh:=true
              end;
            sysopcomchar:
              begin
                requestcom:=true;
                requestchat:=true;
                closechat;
              end;
            breakoutchar:halt(e_controlbreak);
            lesstimechar:urec.timetoday:=urec.timetoday-1;
            moretimechar:urec.timetoday:=urec.timetoday+1;
            notimechar:settimeleft (-1);
            chatchar:requestchat:=true;
            sysnextchar:sysnext:=not sysnext;
            timelockchar:if timelock then timelock:=false else begin
                           timelock:=true;
                           lockedtime:=timeleft
                         end;
            inlockchar:modeminlock:=not modeminlock;
            outlockchar:setoutlock (not modemoutlock);
            tempsysopchar:toggletempsysop;
            bottomchar:bottomline;
            viewstatchar:togviewstats;
            sysophelpchar:if dorefresh then showhelp;
            texttrapchar:toggletexttrap;
            printerechochar:printerecho:=not printerecho;
            72:ret:=^E;
            75:ret:=^S;
            77:ret:=^D;
            80:ret:=^X;
            115:ret:=^A;
            116:ret:=^F;
            73:ret:=^R;
            81:ret:=^C;
            71:ret:=^Q;
            79:ret:=^W;
            83:ret:=^G;
            82:ret:=^V;
            117:ret:=^P;
            84:functionkey(1);
            85:functionkey(2);
            86:functionkey(3);
            87:functionkey(4);
            88:functionkey(5);
            89:functionkey(6);
            90:functionkey(7);
            91:functionkey(8);
            92:functionkey(9);
            93:functionkey(10);
          end;
          if dorefresh then bottomline
        end
      end
    else
      begin
        k:=getchar;
        if modeminlock
          then ret:=#0
          else ret:=k
      end;
  if ret='+' then write (' '^H);
  readchar:=ret
end;

function waitforchar:char;
var t:integer;
    k:char;
begin
  t:=timer+mintimeout;
  if t>=1440 then t:=t-1440;
  repeat
    if timer=t then forcehangup:=true
  until charready;
  waitforchar:=readchar
end;

procedure clearchain;
begin
  chainstr[0]:=#0
end;

function charpressed (k:char):boolean;  { TRUE if K is in typeahead }
begin
  charpressed:=pos(k,chainstr)>0
end;

procedure addtochain (l:lstr);
begin
  if length(chainstr)<>0 then chainstr:=chainstr+',';
  chainstr:=chainstr+l
end;

procedure directoutchar (k:char);
var n:integer;
begin
  if inuse<>1
    then writecon (k)
    else begin
      bottom;
      writecon (k);
      top
    end;
  if wherey>lasty then gotoxy (wherex,lasty);
    if online and (not modemoutlock) and ((k<>#10) or true) then sendchar(k);
  if texttrap then begin
    write (ttfile,k);
    n:=ioresult;
    if n<>0 then abortttfile (n);
  end;
  if (chattrap) and (capturechat) then begin
  write (ctfile,k);
  n:=ioresult;
  if n<>0 then abortctfile (n);
  end;
  if printerecho then write (lst,k)
end;

procedure handleincoming;
var k:char;
begin
  k:=readchar;
  case upcase(k) of
    'X',^X,^K,^C,#27,' ':begin
      writeln (direct);
      break:=true;
      linecount:=0;
      xpressed:=(upcase(k)='X') or (k=^X);
      if xpressed then clearchain
    end;
    ^S:k:=waitforchar;
    else if length(chainstr)<255 then chainstr:=chainstr+k
  end
end;

procedure writechar (k:char);

  procedure endofline;

    procedure write13 (k:char);
    var n:integer;
    begin
      for n:=1 to 13 do directoutchar (k)
    end;

  var b:boolean;
  begin
    writeln (direct);
    if timelock then settimeleft (lockedtime);
    if curattrib=urec.statcolor then ansicolor (urec.regularcolor);
    linecount:=linecount+1;
    if (linecount>=urec.displaylen-1) and (not dontstop)
          and (moreprompts in urec.config) then begin
      linecount:=1;
      write (direct,'More (Y/N/C)?');
      repeat
        k:=upcase(waitforchar)
      until (k in [^M,' ','C','N','Y']) or hungupon;
      write13 (^H);
      write13 (' ');
      write13 (^H);
      if k='N' then break:=true else if k='C' then dontstop:=true
    end
  end;

begin
  if hungupon then exit;
  if k<=^Z then
    case k of
      ^J,#0:exit;
      ^Q:k:=^H;
      ^B:begin
           clearbreak;
           exit
         end
    end;
  if break then exit;
  if k<=^Z then begin
    case k of
      ^G:beepbeep;
      ^L:cls;
      ^N,^R:ansireset;
      ^S:ansicolor (urec.statcolor);
      ^P:ansicolor (urec.promptcolor);
      ^U:ansicolor (urec.inputcolor);
      ^H:directoutchar (k);
      ^M:endofline
    end;
    exit
  end;

  { Place conversion shit I was telling Larry about here! }

  directoutchar (k);
  if (keyhit or ((not modemoutlock) and online and (numchars>0)))
     and (not nobreak) then handleincoming
end;

function getinputchar:char;
var k:char;
begin
  if length(chainstr)=0 then begin
    getinputchar:=waitforchar;
    exit
  end;
  k:=chainstr[1];
  delete (chainstr,1,1);
  if (k=',') and (not nochain) then k:=#13;
  getinputchar:=k
end;

{$ifdef testingdevices}

procedure devicedone (var t:textrec; m:mstr);
var r:registers;
    cnt:integer;
begin
  write (usr,'Device ');
  cnt:=0;
  while t.name[cnt]<>#0 do begin
    write (usr,t.name[cnt]);
    cnt:=cnt+1
  end;
  writeln (usr,' ',m,'... press any key');
  r.ax:=0;
  intr ($16,r);
  if r.al=3 then halt
end;

{$endif}

{ $F+}

function opendevice;
begin
  {$ifdef testingdevices}  devicedone (t,'opened');  {$endif}
  t.handle:=1;
  t.mode:=fminout;
  t.bufend:=0;
  t.bufpos:=0;
  opendevice:=0
end;

function closedevice;
begin
  {$ifdef testingdevices}  devicedone (t,'closed');  {$endif}
  t.handle:=0;
  t.mode:=fmclosed;
  t.bufend:=0;
  t.bufpos:=0;
  closedevice:=0
end;

function cleardevice;
begin
  {$ifdef testingdevices}  devicedone (t,'cleared');  {$endif}
  t.bufend:=0;
  t.bufpos:=0;
  cleardevice:=0
end;

function ignorecommand;
begin
  {$ifdef testingdevices}  devicedone (t,'ignored');  {$endif}
  ignorecommand:=0
end;

function directoutchars;
var cnt:integer;
begin
  for cnt:=t.bufend to t.bufpos-1 do
    directoutchar (t.bufptr^[cnt]);
  t.bufend:=0;
  t.bufpos:=0;
  directoutchars:=0
end;

function writechars;
var cnt:integer;
begin
  for cnt:=t.bufend to t.bufpos-1 do
    writechar (t.bufptr^[cnt]);
  t.bufend:=0;
  t.bufpos:=0;
  writechars:=0
end;

function directinchars;
begin
  with t do begin
    bufptr^[0]:=waitforchar;
    t.bufpos:=0;
    t.bufend:=1
  end;
  directinchars:=0
end;

function readcharfunc;
begin
  with t do begin
    bufptr^[0]:=getinputchar;
    t.bufpos:=0;
    t.bufend:=1
  end;
  readcharfunc:=0
end;

{ $F-}

procedure getstr;
var marker,cnt:integer;
    p:byte absolute input;
    k:char;
    oldinput:anystr;
    done,wrapped,hhh:boolean;
    wordtowrap:lstr;

  procedure bkspace;

    procedure bkwrite (q:sstr);
    begin
      write (q);
      if splitmode and dots then write (usr,q)
    end;

  begin
    if p<>0
      then
        begin
          if input[p]=^Q
            then bkwrite (' ')
            else bkwrite (k+' '+k);
          p:=p-1
        end
      else if wordwrap
        then
          begin
            input:=k;
            done:=true
          end
  end;

  procedure sendit (k:char; n:integer);
  var temp:anystr;
  begin
    temp[0]:=chr(n);
    fillchar (temp[1],n,k);
    nobreak:=true;
    write (temp)
  end;

  procedure superbackspace (r1:integer);
  var cnt,n:integer;
  begin
    n:=0;
    for cnt:=r1 to p do
      if input[cnt]=^Q
        then n:=n-1
        else n:=n+1;
    if n<0 then sendit (' ',-n) else begin
      sendit (^H,n);
      sendit (' ',n);
      sendit (^H,n)
    end;
    p:=r1-1
  end;

  procedure cancelent;
  begin
    superbackspace (1)
  end;

  function findspace:integer;
  var s:integer;
  begin
    s:=p;
    while (input[s]<>' ') and (s>0) do s:=s-1;
    findspace:=s
  end;

  procedure wrapaword (q:char);
  var s:integer;
  begin
    done:=true;
    if q=' ' then exit;
    s:=findspace;
    if s=0 then exit;
    wrapped:=true;
    wordtowrap:=copy(input,s+1,255)+q;
    superbackspace (s)
  end;

  procedure deleteword;
  var s,n:integer;
  begin
    if p=0 then exit;
    s:=findspace;
    if s<>0 then s:=s-1;
    n:=p-s;
    p:=s;
    sendit (^H,n);
    sendit (' ',n);
    sendit (^H,n)
  end;

  procedure addchar (k:char);
  begin
    if p<buflen
      then if (k<>' ') or (p>0) or wordwrap or beginwithspacesok
        then
          begin
            p:=p+1;
            input[p]:=k;
            if dots
              then
                begin
                  writechar (dotchar);
                  if splitmode then write (usr,k)
                end
              else writechar (k)
          end
        else
      else if wordwrap then wrapaword (k)
  end;

  procedure repeatent;
  var cnt:integer;
  begin
    for cnt:=1 to length(oldinput) do addchar (oldinput[cnt])
  end;

  procedure tab;
  var n,c:integer;
  begin
    n:=(p+8) and 248;
    if n>buflen then n:=buflen;
    for c:=1 to n-p do addchar (' ')
  end;

  procedure getinput;
  begin
    oldinput:=input;
    ingetstr:=true;
    done:=false;
    bottomline;
    if splitmode and dots then top;
    p:=0;
    repeat
      clearbreak;
      nobreak:=true;
      k:=getinputchar;
      if hungupon then begin
        input:='';
        k:=#13;
        done:=true
      end;
      case k of
        ^I:tab;
        ^H:bkspace;
        ^M:done:=true;
        ^R:repeatent;
        ^X,#27:cancelent;
        ^W:deleteword;
        ' '..'~':addchar (k);
        ^Q:if wordwrap and bkspinmsgs then addchar (k)
      end;
      if requestchat then begin
        p:=0;
        writeln (^B^N^M^M^B);
        chat (requestcom);
        write (^B^M^M^P,lastprompt);
        ansicolor(urec.inputcolor);
        requestchat:=false
      end
    until done;
    writeln;
    if splitmode and dots then begin
      writeln (usr);
      bottom
    end;
    ingetstr:=false;
    ansireset
  end;

  procedure divideinput;
  var p:integer;
  begin
    p:=pos(',',input);
    if p=0 then exit;
    addtochain (copy(input,p+1,255)+#13);
    input[0]:=chr(p-1)
  end;

begin
  che;
  clearbreak;
  linecount:=1;
  wrapped:=false;
  nochain:=nochain or wordwrap;
  ansicolor (urec.inputcolor);
  getinput;
  if not nochain then divideinput;
  while input[length(input)]=' ' do input[0]:=pred(input[0]);
  if not wordwrap then
    while (length(input)>0) and (input[1]=' ') do delete (input,1,1);
  if wrapped then chainstr:=wordtowrap;
  wordwrap:=false;
  nochain:=false;
  beginwithspacesok:=false;
  dots:=false;
  buflen:=80;
  linecount:=1
end;

procedure writestr (s:anystr);
var k:char;
    ex:boolean;
begin
  che;
  clearbreak;
  ansireset;
  k:=s[length(s)];
  s:=copy(s,1,length(s)-1);
  case k of
    ':':begin
          write (^P,s,': ');
          lastprompt:=s+': ';
          getstr
        end;
    ';':write (s);
    '*':begin
          write (^P,s);
          lastprompt:=s;
          getstr
        end;
    '&':begin
          nochain:=true;
          write (^P,s);
          lastprompt:=s;
          getstr
        end
    else writeln (s,k)
  end;
  clearbreak
end;

procedure cls;
begin
  bottom;
  clrscr;
  bottomline
end;

procedure writehdr (q:anystr);
var cnt:integer;
begin
  writeln (^B^M);
  for cnt:=1 to (40-length(q)) div 2 do write (' ');
  ansicolor(urec.highlightcolor);
  write (q,^M^M^B);
  ansicolor(urec.regularcolor);
end;

function minstr (blocks:integer):sstr;
var min,sec:integer;
    rsec:real;
    ss:sstr;
begin
  rsec:=1.38 * blocks * (1200/baudrate);
  min:=trunc (rsec/60.0);
  sec:=trunc (rsec-(min*60.0));
  ss:=strr(sec);
  if length(ss)<2 then ss:='0'+ss;
  minstr:=strr(min)+':'+ss
end;

procedure parserange (numents:integer; var f,l:integer);
var rf,rl:mstr;
    p,v1,v2:integer;
begin
  f:=0;
  l:=0;
  if numents<1 then exit;
  repeat
    writestr ('Range [1-'+strr(numents)+', CR=all, ?=help]:');
    if input='?' then printfile (textfiledir+'Rangehlp');
    if (length(input)>0) and (upcase(input[1])='Q') then exit
  until (input<>'?') or hungupon;
  if hungupon then exit;
  if length(input)=0 then begin
    f:=1;
    l:=numents
  end else begin
    p:=pos('-',input);
    v1:=valu(copy(input,1,p-1));
    v2:=valu(copy(input,p+1,255));
    if p=0 then begin
      f:=v2;
      l:=v2
    end else if p=1 then begin
      f:=1;
      l:=v2
    end else if p=length(input) then begin
      f:=v1;
      l:=numents
    end else begin
      f:=v1;
      l:=v2
    end
  end;
  if (f<1) or (l>numents) or (f>l) then begin
    f:=0;
    l:=0;
    writestr ('Invalid range!')
  end;
  writeln (^B)
end;

function menu (mname:mstr; mfn:sstr; choices:anystr):integer;
var k:char;
    sysmenu,percent,needsys,sysopshit:boolean;
    n,p,i:integer;
    prompt:lstr;
begin
  sysmenu:=false;
  percent:=false;
  sysopshit:=false;
  for p:=1 to length(choices)-1 do
    if choices[p]='%'then
         begin
         sysopshit:=true;
         if choices[p+1]='@' then percent:=true
         end
      else if choices[p+1]='@'
        then sysmenu:=true;
  writeln (^B);
  repeat
    if chatmode
      then for n:=1 to 2 do summonbeep;
    if (timeleft<1) or (timetillevent<=3) then
      begin
      writeln('Error! Brand-X time bug may have been encountered!');
    { display (textfiledir+'Timesup');
      forcehangup:=true;
      menu:=0;
      exit }
    end;
    ansicolor(urec.promptcolor);
    writerumor;
    prompt:='';
    if (showtime in urec.config) or (chatmode) then writeln;
    if showtime in urec.config
      then prompt:=prompt+'[Time left: '+strr(timeleft)+']';
    if (showtime in urec.config) and (chatmode)
      then prompt:=prompt+'-[CHAT ON]';
    if not (showtime in urec.config) and (chatmode)
      then prompt:=prompt+'[CHAT ON]';
    if (showtime in urec.config) or (chatmode) then prompt:=prompt+^M;
    prompt:=prompt+mname+'[?=help';
    if (ulvl>=sysoplevel) and (sysopshit) then prompt:=prompt+']-[%=SysOp';
    prompt:=prompt+']:';
    writestr (prompt);
    n:=0;
    if length(input)=0
      then k:='_'
      else
        begin
          if (match(input,'/OFF')) or (match(input,'BYE')) then begin
            forcehangup:=true;
            menu:=0;
            exit
          end;
          n:=valu(input);
          if n>0
            then k:='#'
            else k:=upcase(input[1])
        end;
    p:=1;
    i:=1;
    if k='?'
      then
        begin
          printfile (textfiledir+mfn+'M');
          if sysmenu and issysop then printfile (textfiledir+mfn+'S')
        end
      else
        while p<=length(choices) do begin
          needsys:=false;
          if p<length(choices)
            then if choices[p+1]='@'
              then needsys:=true;
          if upcase(choices[p])=k
            then if needsys and (not issysop)
              then
                begin
                  reqlevel (sysoplevel);
                  p:=255;
                  needsys:=false
                end
              else p:=256
            else
              begin
                p:=p+1;
                if needsys then p:=p+1;
                i:=i+1
              end
        end
  until (p=256) or hungupon;
  if hungupon
    then menu:=0
    else
      if k='#' then menu:=-n else menu:=i
end;

function getpassword:boolean;
var t:sstr;
begin
  getpassword:=false;
  splitscreen(3);
  top;
  writeln(usr,'Choosing Password');
  write(usr,'Has entered so far: ');
  bottom;
  dots:=true;
  buflen:=15;
  writestr ('Please choose a password:');
  unsplit;
  if input=''
    then exit
    else begin
      t:=input;
      splitscreen(4);
      top;
      writeln(usr,'Choosing Password');
      writeln(usr,'Password: ',t);
      write(usr,'Has entered so far: ');
      bottom;
      dots:=true;
      writestr ('Re-enter for verification:');
      if not match(t,input) then begin
        writeln ('They don''t match!');
        getpassword:=hungupon;
        unsplit;
        exit
      end;
      urec.password:=t;
      getpassword:=true;
      unsplit;
    end
end;

function checkpassword (var u:userrec):boolean;
var tries:integer;
begin
  tries:=0;
  checkpassword:=true;
  writeln; {writeln added to make it look nice}
  repeat
    splitscreen (5);
    top;
    writeln (usr,'Password Entry');
    writeln (usr,'User name: ',u.handle);
    writeln (usr,'Password: ',u.password);
    write (usr,'Has entered so far: ');
    bottom;
    dots:=true;
    writestr ('Password:');
    unsplit;
    if hungupon then begin
      checkpassword:=false;
      exit
    end;
    if (match(input,u.password))
      then
      begin
           repeat
           if u.level<sysoplevel then exit;
           if length(remotesysop) < 1 then exit;
           splitscreen (4);
           top;
           writeln(usr,'SysOp Password Entry');
           writeln(usr,'User name: ',u.handle);
           write(usr,'Has entered so far: ');
           bottom;
           dots:=true;
           writestr ('SysOp Password:');
           unsplit;
           if hungupon then begin
              checkpassword:=false;
              exit
              end;
           if match(input,remotesysop) then exit;
           tries:=tries+1
           until tries>3;
           checkpassword:=false;
           end;
  tries:=tries+1;
  until tries>3;
  checkpassword:=false
end;

procedure display(fn:lstr);
var add:mstr;
begin
    if ansigraphics in urec.config then add:='.ANS' else
    if asciigraphics in urec.config then add:='.ASC' else
    add:='';
    if (add='.ANS') and not exist(fn+add) then add:='.ASC';
    if (add='.ASC') and not exist(fn+add) then add:='';
    if not exist(fn+add) then exit;
    fn:=fn+add;
    printfile(fn);
end;

procedure allclear;
begin
    clrscr;
    sendchar('');
end;

function validbirthdate:boolean;
  var p:integer;
      k:char;
  begin
    validbirthdate:=false;
    p:=1;
    while p<=length(input) do
       begin
       k:=input[p];
       if k in ['0'..'9'] then p:=p+1 else delete (input,p,1);
       end;
    if length(input)<>6 then
       begin
       writestr ('The birthdate must be 6 digits long.');
       writeln;
       exit
       end;
    urec.birthdate.month:=valu(copy(input,1,2));
    urec.birthdate.day:=valu(copy(input,3,2));
    urec.birthdate.year:=valu(copy(input,5,2));
    if ((urec.birthdate.month>12) or (urec.birthdate.day>31)
       or (urec.birthdate.month<1) or (urec.birthdate.day<1)
       or (urec.birthdate.year<1)) then
       begin
       writestr ('Invalid birth date.');
       exit;
       end;
    validbirthdate:=true
  end;

procedure getbirthdate;
begin
  repeat
  writestr (^R'Enter your birthdate [MM-DD-YY]: *');
  until validbirthdate or hungupon;
end;


procedure setlastcall(a:char);

  function digit (k:char):boolean;
  begin
    digit:=ord(k) in [48..57]
  end;

  function validtime (inp:sstr):boolean;
  var c,s,l:integer;
      d1,d2,d3,d4:char;
      ap,m:char;
  begin
    validtime:=false;
    l:=length(inp);
    if (l<7) or (l>8) then exit;
    c:=pos(':',inp);
    if c<>l-5 then exit;
    s:=pos(' ',inp);
    if s<>l-2 then exit;
    d2:=inp[c-1];
    if l=7
      then d1:='0'
      else d1:=inp[1];
    d3:=inp[c+1];
    d4:=inp[c+2];
    ap:=upcase(inp[s+1]);
    m:=upcase(inp[s+2]);
    if d1='1' then if d2>'2' then d2:='!';
    if (d1>='0') and (d1<='1') and digit(d2) and (d3>='0') and (d3<='5')
       and digit(d4) and ((ap='A') or (ap='P')) and (m='M')
         then validtime:=true
  end;

  function validdate (inp:sstr):boolean;
  var k,l:char;

    function gchar:char;
    begin
      if length(inp)=0 then begin
        gchar:='?';
        exit
      end;
      gchar:=inp[1];
      delete (inp,1,1)
    end;

  begin
    validdate:=false;
    k:=gchar;
    l:=gchar;
    if not digit(k) then exit;
    if l='/'
      then if k='0'
        then exit
        else
      else begin
        if k>'1' then exit;
        if not digit(l) then exit;
        if (l>'2') and (k='1') then exit;
        l:=gchar;
        if l<>'/' then exit
      end;
    k:=gchar;
    l:=gchar;
    if l='/'
      then if k='0'
        then exit
        else
      else begin
        if k>'3' then exit;
        if not digit(l) then exit;
        if (k='3') and (l>'1') then exit;
        l:=gchar;
        if l<>'/' then exit
      end;
    if digit(gchar) and digit(gchar) then validdate:=true
  end;

begin
  if a='M' then begin
  writeln (^M'Your last newscan was: '^S,datestr(urec.lastonm),' at ',timestr(urec.lastonm));
  writestr (^M'Enter new date (mm/dd/yy):');
  if length(input)>0
    then if validdate (input)
      then urec.lastonm:=dateval(input)+timepart(urec.lastonm)
      else writestr ('Invalid date!');
  writestr (^M'Enter new time (hh:mm am/pm):');
  if length(input)>0
    then if validtime(input)
      then urec.lastonm:=timeval(input)+datepart(urec.lastonm)
      else writestr ('Invalid time!')
  end
  else
  begin
  writeln (^M'Your last newscan was: '^S,datestr(urec.lastont),' at ',timestr(urec.lastont));
  writestr (^M'Enter new date (mm/dd/yy):');
  if length(input)>0
    then if validdate (input)
      then urec.lastont:=dateval(input)+timepart(urec.lastont)
      else writestr ('Invalid date!');
  writestr (^M'Enter new time (hh:mm am/pm):');
  if length(input)>0
    then if validtime(input)
      then urec.lastont:=timeval(input)+datepart(urec.lastont)
      else writestr ('Invalid time!')
  end;
end;

  procedure pausenow;
  begin
  writestr('Press [ENTER] to continue...*');
  end;

  procedure drawbox(x:integer; s:lstr);
  var k,i:integer;
  begin
    allclear;
    if asciigraphics in urec.config then
      begin
      ansicolor(urec.bordercolor);
      write('');
      for k:=1 to x-2 do write('');
      writeln('');
      i:=(x-length(s)) div 2;
      tab('',i);
      ansicolor(urec.highlightcolor);
      write(s);
      for k:=1 to x-(i+length(s)+1) do write(' ');
      ansicolor(urec.bordercolor);
      writeln('');
      write('');
      for k:=1 to x-2 do write('');
      writeln('');
      ansicolor(urec.regularcolor);
      end;
  end;

begin
end.


