{$O+}
unit init;

interface

uses crt,dos,
     gentypes,modem,statret,configrt,gensubs,subs1,windows,subs2,userret2,mainr3;

procedure loadmenudat;
procedure setdefaultmenus;
procedure validconfiguration;
procedure initbrandx (checkfiles30:boolean);

implementation

  procedure loadmenudat;
  var tf:text;
      t:string[33];
      q:lstr;
      p,s,i,a:integer;
  begin
    assign(tf,'MENUS.DAT');
    reset(tf);
    a:=0;
    if ioresult=0 then
       while not eof(tf) do
          begin
          readln (tf,q);
          a:=a+1;
          sysopcommand.commandstr[a]:=copy(q,1,30);
          readln (tf,q);
          p:=pos(' ',q);
          if p<>0 then
             begin
             val (copy(q,1,p-1),i,s);
             if s=0 then
                begin
                delete (q,1,p);
                sysopmenus.commands[i]:=copy(q,1,33)
                end;
             end;
          end;
    close(tf);
  end;

  procedure setdefaultmenus;
  begin
     with brandxcommand do
       begin
       commandstr[1]:='Main command ';
       commandstr[2]:='SysOp command ';
       commandstr[3]:='EMPTY SET MENU ';
       commandstr[4]:='Feedback command ';
       commandstr[5]:='Bank command ';
       commandstr[6]:='Game command ';
       commandstr[8]:='Gfile command ';
       commandstr[9]:='Gfile sysop command ';
       commandstr[10]:='Rumor SysOp command ';
       commandstr[11]:='Rumor command ';
       commandstr[12]:='E-Mail Scan command ';
       commandstr[13]:='E-Mail SysOp command ';
       commandstr[14]:='E-Mail command ';
       commandstr[15]:='Color command ';
       commandstr[16]:='Configuration command ';
       commandstr[17]:='Protocol command ';
       commandstr[18]:='File change command ';
       commandstr[19]:='Newscan command ';
       commandstr[20]:='Transfer SysOp command ';
       commandstr[21]:='Transfer command ';
       commandstr[22]:='Voting SysOp command ';
       commandstr[23]:='Voting command ';
       commandstr[24]:='Database SysOp command ';
       commandstr[25]:='Database command ';
       commandstr[26]:='Message SysOp command ';
       commandstr[27]:='Message command ';
       commandstr[28]:='User edit command ';
       end;
    with brandxmenus do
       begin
       commands[1]:='ABCDEFGHIJKLMNOPRSTUVWXYZ+-!&%$|';
       commands[2]:='QTEANDUCIJSKVMFRZX';
       commands[3]:='';
       commands[4]:='Q#DEIR_AL';
       commands[5]:='$MPRQ';
       commands[6]:='$CRBDH!QP';
       commands[7]:='QACDU';
       commands[8]:='CLR%PQ';
       commands[9]:='AMDCRUQ';
       commands[10]:='MLQ';
       commands[11]:='QADL%@';
       commands[12]:='QSERDNAC_#';
       commands[13]:='QLSD';
       commands[14]:='QRSLN_%@DKAV#E@CFHI@';
       commands[15]:='QPIRSBGEXHK';
       commands[16]:='QLWOMGTUEDNYFAPHCBRS';
       commands[17]:='XCOZGFYLPQ';
       commands[18]:='QUDSNFPVX';
       commands[19]:='Q#_CEDRM0';
       commands[20]:='ACDFGKRNSMLOQEWXY';
       commands[21]:='UDLFYA*SQ%NVHRWXTC+-Z';
       commands[22]:='QACDR';
       commands[23]:='QS_VLR#*H%@';
       commands[24]:='QCDEKOR';
       commands[25]:='QA*SLVNH%@CD';
       commands[26]:='DLSTMWUEQRKC@BO@VA@H';
       commands[27]:='PRDFUKT*MQ#_%LNBAVCHES+-WZ';
       commands[28]:='SDHPLOEWTBQYNIRGCAFJ';
       end;
    end;

procedure validconfiguration;
var errs:integer;
    cnt:integer;
    flag:boolean;

  procedure error (q:anystr);
  begin
    if errs=0 then writeln (usr,'Configuration Errors:');
    errs:=errs+1;
    writeln (usr,errs,'. ',q)
  end;

  procedure ispath (var x:lstr; name:lstr);
  begin
    if not exist(x+'con') then error (name+' path bad: '+x)
  end;

  procedure isstring (x:anystr; name:lstr);
  var cnt:integer;
  begin
    if length(x)=0 then begin
      error (name+' has not been set!');
      exit
    end;
    for cnt:=1 to length(x) do if not (x[cnt] in [#32..#255])
      then begin
        error ('Bad '+name+' string');
        exit
      end
  end;

  procedure isinteger (n,r1,r2:integer; name:lstr);
  begin
    if (n<r1) or (n>r2) then error ('Bad '+name+' value: '+strr(n))
  end;

begin
  errs:=0;
  isstring (sysopname,'Sysop name');
  ispath (textdir,'Path to message base');
  ispath (textfiledir2,'Path to SysOp defined menus');
  ispath (boarddir,'Path to sub-board files');
  ispath (textfiledir,'Path to text files');
  ispath (doordir,'Path to door batch files');
  ispath (infodir,'Path to info-form files');
  isinteger (defbaudrate,110,19200,'default baud rate');
  isinteger (usecom,1,2,'COM: port');
  isinteger (mintimeout,1,maxint,'input time out');
  isinteger (sysoplevel,1,maxint,'co-sysop level');
  if errs>0 then halt(e_badconfig)
end;

procedure initbrandx (checkfiles30:boolean);

  procedure formatmfile;
  var m:mailrec;
  begin
    rewrite (mfile);
    fillchar (m,sizeof(m),255);
    write (mfile,m)
  end;

  procedure openmfile;
  var i:integer;
  begin
    close (mfile);
    i:=ioresult;
    assign (mfile,'Mail');
    reset (mfile);
    i:=ioresult;
    if i<>0
      then if i=2
        then formatmfile
        else begin
          writeln (usr,'Fatal error: Unable to open mail file!');
          halt (e_fatalfileerror)
        end
  end;

  procedure openufile;
  var u:userrec;
      n,cnt:integer;

    procedure createuhfile;
    var cnt:integer;
    begin
      rewrite (uhfile);
      if ioresult<>0 then
        begin
        writeln (usr,'Unable to create user index file.');
        halt (e_fatalfileerror)
        end;
      seek (ufile,0);
      while not eof(ufile) do
        begin
        read (ufile,u);
        write (uhfile,u.handle)
        end
    end;

  begin
    close (ufile);
    assign (ufile,'Users');
    reset (ufile);
    n:=ioresult;
    if n=0 then
      begin
      numusers:=filesize(ufile)-1;
      assign (uhfile,'Userindx');
      reset (uhfile);
      if ioresult<>0
        then createuhfile
        else if filesize(uhfile)<>filesize(ufile) then
          begin
          close (uhfile);
          createuhfile
          end;
      exit
    end;
    close (ufile);
    n:=ioresult;
    rewrite (ufile);
    fillchar (u,sizeof(u),0);
    write (ufile,u);                          { Creating SysOp's account }
    u.handle:=sysopname;
    u.realname:='None';
    u.voicenum:='5072826053';
    u.comment:='SysOp';
    u.handlechange:=true;
    u.password:='Brand-X';
    u.timeperday:=200;
    u.timetoday:=200;
    u.level:=sysoplevel+10;
    u.udlevel:=sysoplevel+10;
    u.glevel:=sysoplevel+10;
    u.udpoints:=100;
    u.config:=[postprompts,asciigraphics,fseditor,postbars,showinfeedback];
    u.emailannounce:=-1;
    u.displaylen:=23;
    u.regularcolor:=regularcolor;
    u.promptcolor:=promptcolor;
    u.statcolor:=statcolor;
    u.inputcolor:=inputcolora;
    u.bordercolor:=bordercolor;
    u.highlightcolor:=highlightcolor;
    u.backgroundcolor:=backgroundcolor;
    u.rumorchange:=true;
    fillchar (u.access2,32,255);
    u.config:=u.config+[ansigraphics];
    write (ufile,u);
    numusers:=1;
    createuhfile
  end;

  procedure initfile (var f:file);
  var fi:fib absolute f;
  begin
    fi.handle:=0;
    fi.name[0]:=chr(0)
  end;

  procedure openlogfile;

    procedure autodeletesyslog;
    var mx,cnt:integer;
        l:logrec;
        int4:datetime;
        t:word;
        logb : file of char;
        logbname : string[80];
        int1,int2,int6,int7: string[2];
        int3 : string[4];
        int5 : integer;
        finie : boolean;

    begin
      dontanswer;
      close (logfile);                                 { Creating backup log }
      getdate (int4.year,int4.month,int4.day,t);
      str(int4.day,int1);
      str(int4.month,int2);
      str(int4.year,int3);
      int7 := copy(int3,3,2);
      logbname := (int2 + '-' + int1 + '-' + int7 + '.LOG');
      int5 := 0;
      finie := false;
      repeat
        assign (logb,logbname);
        if exist (logbname) then
          begin
          int5 := int5 + 1;
          str(int5,int6);
          logbname := (int2 + '-' + int1 + '-' + int7 + '.' + int6);
          end
        else
          begin
          rename (logfile,logbname);
          rewrite (logfile);
          finie := true;
          end
      until finie;

      write (usr,'Autodeleting system log ... please stand by ... ');
      reset (logfile);
      mx:=filesize(logfile) div 2;
      for cnt:=1 to mx do
        begin
        seek (logfile,cnt+mx-1);
        read (logfile,l);
        seek (logfile,cnt-1);
        write (logfile,l)
        end;
      seek (logfile,mx-1);
      truncate (logfile);
      writeln (usr,'Done.');
      doanswer
    end;

  begin
    assign (logfile,'Syslog');
    reset (logfile);
    if ioresult<>0 then
      begin
      rewrite (logfile);
      if ioresult<>0 then
        begin
        writeln (usr,'Unable to create log file');
        halt (e_fatalfileerror)
        end
      end;
    if filesize(logfile)>maxsyslogsize then autodeletesyslog
  end;

  procedure loadsyslogdat;
  var tf:text;
      q:lstr;
      b1,b2,p,s,n:integer;
  begin
    numsyslogdat:=0;
    with syslogdat[0] do
      begin
      menu:=0;
      subcommand:=0;
      text:='SYSLOG.DAT entry not found: %'
      end;
    assign (tf,'syslog.dat');
    reset (tf);
    if ioresult=0 then
      begin
      while not eof(tf) do
        begin
        readln (tf,q);
        p:=pos(' ',q);
        if p<>0 then
          begin
          val (copy(q,1,p-1),b1,s);
          if s=0 then
            begin
            delete (q,1,p);
            p:=pos(' ',q);
            if p<>0 then
              begin
              val (copy(q,1,p-1),b2,s);
              if s=0 then
                begin
                delete (q,1,p);
                if numsyslogdat=maxsyslogdat
                  then writeln (usr,'Too many SYSLOG.DAT entries')
                  else
                    begin
                    numsyslogdat:=numsyslogdat+1;
                    with syslogdat[numsyslogdat] do
                      begin
                      menu:=b1;
                      subcommand:=b2;
                      text:=copy(q,1,30)
                      end
                    end
                end
              end
            end
          end
        end;
      textclose (tf)
      end;
    if numsyslogdat=0 then writeln (usr,'SYSLOG.DAT file missing or invalid')
  end;

  procedure doesfilesequal30;
  var f:array [1..14] of file;
      cnt,i:integer;
  begin
    for cnt:=1 to 13 do
      begin
      assign (f[cnt],'CON');
      reset (f[cnt]);
      i:=ioresult;
      if i<>0 then
        begin
        writeln (usr,^M^J'Fatal error:  You MUST put the command',
           ^M^J^J'FILES=40',
           ^M^J^J'in your CONFIG.SYS file on the disk from which you boot.',
           ^M^J^J'Note:  Brand-X may be leaving a file open.');
        halt (e_files30)
        end
      end;
    for cnt:=13 downto 1 do close(f[cnt])
  end;

var k:char;
    cnt:integer;
begin
  with textrec(system.output) do
    begin
    openfunc:=@opendevice;
    closefunc:=@closedevice;
    flushfunc:=@writechars;
    inoutfunc:=@writechars
    end;
  with textrec(system.input) do
    begin
    inoutfunc:=@readcharfunc;
    openfunc:=@ignorecommand;
    closefunc:=@ignorecommand;
    flushfunc:=@ignorecommand
    end;
  if checkfiles30 then doesfilesequal30;
  if not driverpresent then
    begin
    writeln (usr,'Modem driver not installed!');
    halt (e_nomodemdrv)
  end;
  fillchar (urec,sizeof(urec),0);
  urec.config:=[asciigraphics];
  iocode:=0;
  linecount:=0;                              { Initializing all variables }
  sysopavail:=bytime;
  errorparam:='';
  errorproc:='';
  unam:='';
  chainstr:='';
  chatreason:='';
  ulvl:=0;
  unum:=-1;
  logonunum:=-2;
  break:=false;
  nochain:=false;
  nobreak:=false;
  wordwrap:=false;
  beginwithspacesok:=false;
  dots:=false;
  online:=false;
  local:=true;
  chatmode:=false;
  chattrap:=false;
  doanon:=false;
  inchat:=false;
  ineditor:=false;
  macro:='';
  texttrap:=false;
  printerecho:=false;
  fillchar (urec,sizeof(urec),0);
  curattrib:=0;
  buflen:=80;
  rumorcount:=0;
  baudrate:=defbaudrate;
  parity:=false;
  timelock:=false;
  ingetstr:=false;
  modeminlock:=false;
  modemoutlock:=false;
  tempsysop:=false;
  sysnext:=false;
  forcehangup:=false;
  requestbreak:=false;
  disconnected:=false;
  regularlevel:=0;
  setparam (usecom,baudrate,parity);
  initwinds;
  for cnt:=1 to numsysfiles do initfile (sysfiles[cnt]);
  clrscr;
  loadsyslogdat;
  setdefaultmenus;
  if not usedefaultmenus then loadmenudat;
  readstatus;
  openufile;
  openlogfile;
  openmfile
end;

procedure assignname (var t:text; nm:lstr);
begin
  with textrec(t) do
    begin
    move (nm[1],name,length(nm));
    name[length(nm)]:=#0
    end
end;

var r:registers;
begin
{  textmode (bw80);}
  checkbreak:=false;
  checkeof:=false;
  checksnow:=checksnowmode;
  r.ah:=15;
  intr ($10,r);
  if r.al=7
    then screenseg:=$b000
    else screenseg:=$b800;
  textrec(system.input).mode:=fminput;
  move (output,usr,sizeof(text));           { Set up device drivers }
  move (output,direct,sizeof(text));
  move (system.input,directin,sizeof(text));
  with textrec(direct) do
    begin
    openfunc:=@opendevice;
    closefunc:=@closedevice;
    flushfunc:=@directoutchars;
    inoutfunc:=@directoutchars;
    bufptr:=@buffer
    end;
  with textrec(directin) do
    begin
    mode:=fminput;
    inoutfunc:=@directinchars;
    openfunc:=@ignorecommand;
    flushfunc:=@ignorecommand;
    closefunc:=@ignorecommand;
    bufptr:=@buffer
    end;
  with textrec(usr) do bufptr:=@buffer;
  assignname (usr,'USR');
  assignname (direct,'DIRECT');
  assignname (directin,'DIRECT-IN');
  assignname (system.output,'OUTPUT');
  assignname (system.input,'INPUT')
end.
