{$O+ }

unit gfiles;

interface

uses overlay,crt,dos,gentypes,subs1,subs2,configrt,gensubs,overret1,overret2;

procedure gfilesection;

implementation

var at:treerec;
    ai:inforec;
    al:listrec;
    path:lstr;

procedure gfilesection;

   procedure assigngfile;
   begin
      if length(path)=0 then
      begin
         assign (treefile,doordir+'areatree.dat');
         assign (infofile,doordir+'areainfo.dat');
         assign (listfile,doordir+'arealist.dat');
      end
      else
      begin
         assign (treefile,doordir+path+'\areatree.dat');
         assign (infofile,doordir+path+'\areainfo.dat');
         assign (listfile,doordir+path+'\arealist.dat');
      end;
   end;

   procedure closegfile;
   begin
      close(treefile);
      close(infofile);
      close(listfile);
   end;

   procedure formatgfile;
   begin
      closegfile;
      assigngfile;
      rewrite (treefile);
      rewrite (infofile);
      rewrite (listfile);
      seek(infofile,0);
      ai.downpath:='';
      ai.maxfiles:=100;
   end;

   procedure opengfile;
   var i:integer;
   begin
      closegfile;
      assigngfile;
      reset (treefile);
      i:=ioresult;
      reset (infofile);
      i:=i or ioresult;
      reset (listfile);
      i:=i or ioresult;
      if i<>0 then formatgfile;
   end;

   function numfiles:integer;
   begin
      numfiles:=filesize(listfile);
   end;

   function numareas:integer;
   begin
      numareas:=filesize(treefile);
   end;

   function nofiles:boolean;
   begin
      if (numfiles>0) or (numareas>0) then nofiles:=false else
      begin
         writeln ('Sorry, area appears to be empty!');
         nofiles:=true;
      end;
   end;

   procedure getpathname (fname:lstr; var path:lstr; var name:sstr);
   var p:integer;
   begin
      path:='';
      repeat
         p:=pos('\',fname);
         if p<>0 then
         begin
            path:=path+copy(fname,1,p);
            fname:=copy(fname,p+1,255)
         end;
      until p=0;
      name:=fname
   end;

   procedure listgfiles;
   var cnt,f,l:integer;
   begin
      writehdr('List Gfiles');
      if nofiles then exit;
      writeln;
      for cnt:=1 to numareas do
      begin
         seek(treefile,cnt-1);
         read(treefile,at);
         if ulvl>=at.arealevel then
         begin
            write(at.uppath:11,': ');
            writeln(at.des1);
            writeln('            ',at.des2);
            writeln('            ',at.des3);
         end;
         if break then exit;
      end;

      if numfiles>0 then
      begin
         parserange (numrumors,f,l);
         for cnt:=f to l do
         begin
            seek(listfile,cnt-1);
            read(listfile,al);
            write(cnt,': ');
            writeln(al.description);
            if break then exit;
         end;
      end;
   end;

   procedure curpath;
   begin
      writeln('Current path:');
      if length(path)=0 then writeln('   \') else writeln('   ',path);
   end;

   function cutname(name:lstr):lstr;
   var j:integer;
       ok:boolean;
   begin
      ok:=false;
      j:=length(name);
      repeat
         if name[j]='\' then ok:=true;
         delete(name,j,1);
      until (j=0) or (ok);
   end;

   procedure backone;
   begin
      path:=cutname(path);
      opengfile;
   end;

   procedure root;
   begin
      path:='';
      opengfile;
   end;

   procedure forwardone;
   begin
      path:=path+'\'+input;
      if exist(doordir+path+'\areainfo.dat') then opengfile else
         begin
         path:=cutname(path);
         writeln('Invalid area header!');
         end;
   end;

   procedure changesection;
   begin
      writehdr('Change Area');
      writeln;
      writestr('Area pointer: *');
      if input='-' then backone else if input='\' then root else
         forwardone;
   end;

   procedure readgfile;
   var cnt,f,l:integer;
   begin
      writehdr('Read Gfile');
      writeln;
      if numfiles=0 then
         begin
         writeln('There are no files in this area.');
         exit;
         end;
      parserange (numrumors,f,l);
      for cnt:=f to l do
      begin
         seek(listfile,cnt-1);
         read(listfile,al);
         printfile(textfiledir+'pregfile.txt');
         if break then exit;
         printfile(doordir+path+'\'+al.pathname);
         if break then exit;
      end;
   end;


   function addfile(fname:lstr):boolean;
   begin
      repeat
         write(fname);
         writestr(': *');
         if match(input,'VIEW') then printfile(doordir+path+'\'+fname);
      until (not match(input,'VIEW')) or hungupon;
      if length(input)=0 then
      begin
         addfile:=false;
         exit;
      end;
      seek(listfile,numfiles);
      al.description:=input;
      al.pathname:=doordir+path+'\'+fname;
      al.date:=now;
      write(listfile,al);
      addfile:=true;
   end;

   procedure addgfile;
   var spath,pathpart:lstr;
       dummy:sstr;
       f:file;
       ffinfo:searchrec;
       resident:boolean;
       cnt:integer;
   begin
      writehdr('Adding Gfiles for current area');
      writeln;
      spath:=doordir+path;
      assign (f,spath+'\con');
      reset (f);
      if ioresult=0 then
      begin
         close (f);
         spath:=spath+'\*.*'
      end;
       getpathname (spath,pathpart,dummy);
      findfirst (spath,$17,ffinfo);
      if doserror<>0 then writeln ('No files found!') else while doserror=0 do
      begin
         resident:=false;
         for cnt:=1 to numfiles do
         begin
            seek(listfile,cnt-1);
            read(listfile,al);
            if ffinfo.name=al.pathname then resident:=true;
         end;
         if not resident then if not addfile(ffinfo.name) then exit;
         findnext (ffinfo);
      end;
   end;


{  function checkrumor(x:integer):boolean;
   begin
      checkrumor:=false;
      if x>numrumors then
         begin
         writeln('Rumor number to large!');
         exit;
         end;
      if x<1 then
         begin
         writeln('Rumor number to small!');
         exit;
         end;
      seek (rfile,x-1);
      read (rfile,r);
      if (not (match(r.username,unam))) and (ulvl<sysoplevel) then
         begin
         writeln('You didn''t leave that rumor!');
         exit;
         end;
      checkrumor:=true;
   end;

   procedure delrumor(cnt:integer);
   var rnumber:integer;
   begin
      if cnt=numrumors then
         begin
         seek(rfile,numrumors-1);
         truncate(rfile);
         end
      else
         begin
         for rnumber:=cnt to numrumors do
            begin
            seek(rfile,rnumber);
            read(rfile,r);
            seek(rfile,rnumber-1);
            write(rfile,r);
            end;
         seek(rfile,numrumors-1);
         truncate(rfile);
         end;
   end;

   procedure deleterumor;
   var cnt:integer;
   begin
      writehdr('Delete rumor');
      openrfile;
      if nofiles then exit;
      writeln;
      writestr('Delete rumor number: *');
      cnt:=valu(input);
      if cnt < 1 then exit;
      if not checkrumor(cnt) then exit;
      if (cnt<1) or (cnt>numrumors) then exit;
      writelog(23,2,'');
      delrumor(cnt);
   end;

   procedure massdelete;
   var cnt,f,l:integer;
       range:sstr;
   begin
      writehdr('Mass delete rumors');
      openrfile;
      if nofiles then exit;
      writeln;
      parserange (numrumors,f,l);
      range:=strr(f)+'-'+strr(l);
      if (f=1) and (l=numrumors) then
         begin
         writestr('WARNING: You have chosen to destroy *ALL* rumors, continue? *');
         if not yes then exit;
         end;
      writelog(24,1,range);
      for cnt:=f to l do delrumor(cnt);
   end;

   procedure addrumor;
   var cnt:sstr;
   begin
      if not urec.rumorchange then
         begin
         writeln('Sorry, '+sysopname+' doesn''t want you adding rumors.');
         exit;
         end;
      writehdr('Add rumor');
      openrfile;
      seek(rfile,numrumors);
      writestr('Rumor: &');
      if length(input)<1 then exit;
      if length(input)>75 then
         begin
         writeln('Rumors must be 75 characters or less!');
         exit;
         end;
      r.rumor:=input;
      r.username:=unam;
      r.rdatetime:=now;
      write(rfile,r);
      cnt:=strr(numrumors);
      writelog(23,1,cnt);
   end;}

   procedure prestart;
   var num:integer;
   begin
      drawbox(19,'GFILE SECTION');
   end;

   procedure sysopmenu;
   var i:integer;
   begin
      if (ulvl<sysoplevel) then
      begin
         writeln (^B'Nice try, but level ',sysoplevel,' is required.');
         exit;
      end;
      repeat
         input:='';
         close(rfile);
         i:=menu (command.commandstr[9],'SGFILE',menus.commands[9]);
            case i of
            1:addgfile;
            2:{movegfile};
            3:{deletegfile};
            4:{createsection};
            5:{deletesection};
            6:{modifysection};
            end;
      until hungupon or (i=7);
   end;

var i:integer;
begin
  returnto:='A';
  opengfile;
   if not fromdoor then prestart else fromdoor:=false;
  path:='';
  repeat
  input:='';
  i:=menu (command.commandstr[8],'GFILE',menus.commands[8]);
    case i of
      1:changesection;
      2:listgfiles;
      3:readgfile;
      4:sysopmenu;
      5:curpath;
    end
  until hungupon or (i=6);
  closegfile;
end;

begin
end.