unit gentypes;

interface

uses overlay,dos;

const versionnum='Brand-X 2.0';
      thisversioncode=1;
      maxusers=30000;
      maxmenus=28;
      maxcommands=33;
      maxmessagesize=100;
      maxlastcallers=20;
      maxtopposters=10;
      maxtopics=10;
      maxcats=10;
      sectorsize=512;
      numsectors=2000;
      maxcatalogsize=50;
      maxgroupsize=50;
      maxsyslogdat=150;
      maxsyslogsize=1000;
      e_door=3;
      e_controlbreak=9;
      e_badconfig=100;
      e_fatalfileerror=90;
      e_files30=50;
      e_nomodemdrv=2;

{ All of these are extended keystroke values. }
      breakoutchar=    0;   {Control-Break}
      chatchar=        59;  {F1}
      sysopcomchar=    60;  {F2}
      sysnextchar=     65;  {F7}
      timelockchar=    66;  {F8}
      inlockchar=      67;  {F9}
      outlockchar=     68;  {F10}
      printerechochar= 114; {Ctrl-PrtSc}
      availtogglechar= 62;  {Alt-A}
      bottomchar=      48;  {Alt-B}
      texttrapchar=    18;  {Alt-E}
      sysophelpchar=   35;  {Alt-H}
      notimechar=      37;  {Alt-K}
      lesstimechar=    38;  {Alt-L}
      moretimechar=    50;  {Alt-M}
      tempsysopchar=   20;  {Alt-T}
      viewstatchar=    47;  {Alt-S}

type arra=array [1..30] of char;
     anystr=string[255];
     lstr=string[80];
     rstr=string[75];
     mstr=string[30];
     sstr=string[15];
     availtype=(available,bytime,notavailable);
     groupclass=(publicgroup,privategroup,personalgroup);
     voteset=array [1..maxtopics] of byte;
     boardorder=array [0..255] of byte;
     birthdatetype=record
       day,month,year:byte
       end;

     configtype=(spare4,postprompts,moreprompts,ansimusic,
                 asciigraphics,ansigraphics,wanted,showtime,EMPTY,fseditor,
                 postbars,showinfeedback,usesysopmenus,lockmail,spare1,spare2,
                 spare3);

     userrec=record
       handle,realname,blankmstr:mstr;
       password,comment,blanksstr:sstr;
       voicenum,datanum:string[10];
       birthdate:birthdatetype;
       blanklstr1,blanklstr2:lstr;
       laston,lastonm,lastont,totaltime,blanklongint1,blanklongint2:longint;
       numon,timetoday,timeperday,nbu,uploads,downloads,blankint1,blankint2,
       udlevel,glevel,udpoints,level,emailannounce,beepedpwd,blankint3:integer;
       blankreal1,blankreal2:real;
       regularcolor,promptcolor,statcolor,inputcolor,bordercolor,displaylen,
       highlightcolor,backgroundcolor,rumors,blankbyte1,blankbyte2:byte;
       handlechange,rumorchange,blankboo1,blankboo2:boolean;
       config:set of configtype;
       newscanconfig,access1,access2,sex:set of byte;
       lastread:array [0..255] of word;
       voted:voteset;
     end;

     userspecsrec=record
       name:mstr;
       minlevel,maxlevel,minlaston,maxlaston:integer;
       minpcr,maxpcr:real
     end;

     boardrec=record
       boardname,sponsor:mstr;
       level,autodel:integer;
       shortname:sstr
     end;

     bulrec=record
       title,leftby:mstr;
       when:longint;
       anon:boolean;
       line,plevel:integer;
       id:word;
       pcomment:sstr
     end;

     filerec=record
       descrip,password,fname:lstr;
       sentby:mstr;
       when:longint;
       downloaded:integer
     end;

     mailflag=(reed,toanon);

     mailrec=record
       title,sentby:mstr;
       when:longint;
       anon:boolean;
       flag:set of mailflag;
       sentto,line,fileindex:integer
     end;

     catalogrec=record
       nummail,additional:integer;
       mail:array [1..maxcatalogsize] of mailrec
     end;

     grouprec=record
       name:mstr;
       class:groupclass;
       creator,nummembers:integer;
       members:array [1..maxgroupsize] of integer
     end;

     message=record
       text:array [1..maxmessagesize] of lstr;
       title:mstr;
       anon:boolean;
       numlines:integer
     end;

     topicrec=record
       topicname:lstr;
       numvoted,addlevel:integer;
       mandatory:boolean
     end;

     choicerec=record
       choice:lstr;
       numvoted:integer
     end;

     lastrec=record
       name:mstr;
       callnum:longint;
       when:longint
     end;

     buffer=array [1..sectorsize] of char;

     baserec=record
       numcats,numents,level:integer;
       basename:mstr;
       catnames:anystr
     end;

     entryrec=record
       data:anystr;
       when:longint;
       addedby:integer
     end;

     parsedentry=array [1..maxcats] of anystr;

     udrec=record
       sentby:mstr;
       when,whenrated:longint;
       filename:sstr;
       path:string[50];
       points:integer;
       filesize:longint;
       descrip,password:lstr;
       downloaded:integer;
       newfile,specialfile:boolean
     end;

     arearec=record
       name,xmodemdir:lstr;
       sponsor:mstr;
       level:integer
     end;

     windowrec=record
       x1,y1,x2,y2,
       cx,cy,color:byte
     end;

     fib=textrec;

     minuterec=record
       started:boolean;
       startedat:integer;
       total:real
     end;

     logrec=record
       menu,subcommand:integer;
       param:string[41];
       when:longint
     end;

     syslogdatrec=record
       menu,subcommand:integer;
       text:mstr
     end;

     macrorec=array[1..10] of lstr;

     rumorrec=record
         rumor:rstr;
         username:mstr;
         rdatetime:longint;
     end;

     treerec=record
        des1,des2,des3:lstr;
        uppath:sstr;
        arealevel:integer;
     end;

     inforec=record
        downpath:sstr;
        maxfiles:integer;
     end;

     listrec=record
        description,pathname:rstr;
        date:longint;
     end;

     messagerec=record
       username:mstr
     end;

     commandmenu=string[maxcommands];

     menurec=record
       commands:array[1..maxmenus] of commandmenu;
     end;

     commandstring=string[30];

     commandrec=record
       commandstr:array[1..maxmenus] of commandstring;
     end;

     baudratetype=(b110,b300,b450,b1200,b2400,b4800,b9600,b19200);
     baudset=set of baudratetype;

     top_poster_rec = record
                         user_name : mstr;
                         num_posts : word;
                       end;

     top_poster_type = array[1..maxtopposters] of top_poster_rec;

const baudarray:array [b110..b19200] of integer=
         (110,300,450,1200,2400,4800,9600,19200);
      versioncodes:array [1..thisversioncode] of string[4]=
        ('1.1a');

const firstbaud=b110;
      lastbaud=b19200;

implementation

begin
ovrinit('Brand-X.OVR');
if memavail>65535 then ovrsetbuf(65535) else ovrsetbuf(memavail);
end.
