{$O+}
unit filexfer;

interface

uses crt,dos,
     gentypes,configrt,modem,statret,gensubs,subs1,subs2,windows,transfer,
     userret1,userret2,mainr1,mainr2,mainr3,overret1,overret2;

procedure udsection(gogetupload:boolean);

implementation

procedure udsection(gogetupload:boolean);

  const beenaborted:boolean=false;
  var oldname:sstr;

  procedure batchdownload (batchxfer:char);

  function timeval (blocks:integer):real;
  var min,sec:integer;
      rsec:real;
  begin
    rsec:=1.38 * blocks * (1200/baudrate);
    timeval:=rsec/60.0;
  end;

  function checkfile(pointsleft:integer;num:integer):boolean;
  var ud:udrec;
      fname:lstr;
      f:file;
      letdownload:boolean;
      x:integer;
  begin
    writeln;
    if num=0 then
      begin
      checkfile:=false;
      exit;
      end;
    seekudfile (num);
    read (udfile,ud);
    if (not issysop) and (ud.points>pointsleft) then
      begin
      writeln ('Sorry, that file requires ',ud.points,' points.');
      checkfile:=false;
      exit
      end;
    if (ud.specialfile) and (not issysop) then
      begin
      writeln ('Sorry, downloading that file requires special permission.');
      checkfile:=false;
      exit
      end;
    if (not exist(ud.path+ud.filename)) then
      begin
      writeln ('Sorry, that file is currently offline.');
      checkfile:=false;
      exit
      end;
    letdownload:=true;
    oldname:=input;
    if (length(ud.password)>0) then filepassword(ud.filename,ud.password,letdownload);
    input:=oldname;
    if not letdownload then
      begin
      checkfile:=false;
      exit;
      end;
    checkupdown(errorcode,ud.filename,ud.path);
    for x:=1 to length(ud.filename) do ud.filename[x]:=upcase(ud.filename[x]);
    if errorcode <> 0 then
      begin
      writestr(ud.filename+' has errors, do you wish to continue? *');
      if not yes then
        begin
        checkfile:=false;
        exit;
        end;
      end;
    fname:=getfname(ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    close (f);
    iocode:=ioresult;
    if iocode<>0 then
      begin
      fileerror ('BATCH DOWNLOAD',fname);
      checkfile:=false;
      exit
      end;
    checkfile:=true;
  end;

  procedure getfileinfo (var num:integer;var totalminsleft,realtime:real;
    var mins,fsize,actualsize:integer;var sender:mstr;
    var whensent,ratedwhen:longint;var nameoffile:sstr;var filepath:string;
    var filepoints:integer;var filedescrip:lstr;var timesdownloaded:integer;
    var isitspecial:boolean);
  var ud:udrec;
  f:file;
  fname:lstr;
  totaltime:sstr;
  secs:integer;
  begin
    seekudfile (num);
    read (udfile,ud);
    fname:=getfname (ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    fsize:=filesize(f);
    actualsize:=fsize;
    close (f);
    totaltime:=minstr(fsize);
    mins:=valu(copy(totaltime,1,pos(':',totaltime)-1));
    secs:=valu(copy(totaltime,pos(':',totaltime)+1,2));
    if secs<>0 then realtime:=mins+(secs/60) else realtime:=mins;
    if mins=0 then mins:=1;
    if ((mins>totalminsleft) and (not issysop)) then
      begin
      writestr ('Sorry, you don''t have enough time left!');
      mins:=-5;
      exit
      end;
    if (mins-5>timetillevent) then
      begin
      writestr ('Sorry, the timed event is coming up too soon!');
      mins:=-5;
      exit
      end;
    writeln (^B^M'Filename:       '^S,ud.filename);
    writeln ('Uploaded by:    '^S,ud.sentby);
    write ('Downloaded:     '^S,ud.downloaded,' time');
    if ud.downloaded=1 then writeln else writeln ('s');
    writeln ('Transfer time:  '^S,totaltime);
    writeln;
    sender:=ud.sentby;
    whensent:=ud.when;
    ratedwhen:=ud.whenrated;
    nameoffile:=ud.filename;
    filepath:=ud.path;
    filepoints:=ud.points;
    filedescrip:=ud.descrip;
    timesdownloaded:=ud.downloaded;
    isitspecial:=ud.specialfile;
  end;

  procedure check1(var abort:boolean);
  begin
    writestr ('Abort this batch transfer? *');
    if yes then abort:=true
    else abort:=false;
  end;

  procedure check2(var abort,readytostart:boolean);
  begin
    abort:=false;
    readytostart:=false;
    writestr('Ready to start batch transfer? *');
    input:=copy(input,1,1);
    if input='Y' then readytostart:=true else if input='y' then readytostart:=true;
    if readytostart then exit else writeln;
    check1 (abort);
  end;

  type textarray = array[1..9] of string;
       numberarray = array[1..9] of integer;
       realarray = array[1..9] of real;
       sentbyarray = array[1..9] of mstr;
       whenarray = array[1..9] of longint;
       filenamearray = array[1..9] of sstr;
       patharray = array[1..9] of string[50];
       descriparray = array[1..9] of lstr;
       booleanarray = array[1..9] of boolean;

  var totalblocks,b,pointsleft,points,num,mins,fsize,totalbytes,actualsize,
      filecounter,loopcounter,starttime,endtime,transfertime,
      estimatedtime:integer;
  var mins2,minsleft,timetotal:real;
      name,fname:string;
      f:file of byte;
      dirsave,command_line,switches,blocks,minutes:lstr;
      baudst,commst:mstr;
      singlecharacter:char;
      autohang,abort,readytostart:boolean;
      fnames:textarray;
      textname:textarray;
      fsizes,NUMB,filepoints,timesdownloaded,areanumber:numberarray;
      ftime:realarray;
      sender:sentbyarray;
      whensent,ratedwhen:whenarray;
      nameoffile:filenamearray;
      filepath:patharray;
      filedescrip:descriparray;
      isitspecial:booleanarray;
      batchfile:text;

  begin
    writeln;
    getdir (0, dirsave);   (* drive: 0 = cur. 1 = A: etc. - save cur. dir. *)
    str (baudrate:3, baudst);  (* cnvt baud and comm port to strings *)
    str (usecom:1, commst);
    filecounter:=1;
    pointsleft:=urec.udpoints;
    minsleft:=timeleft;
    totalbytes:=0;
    readytostart:=false;
      repeat
      estimatedtime:=timeleft-round(minsleft);
      if estimatedtime<1 then estimatedtime:=0;
      if ansigraphics in urec.config then
        begin
        ansicolor(urec.bordercolor);
        writeln ('Ŀ');
        write (' ');
        ansicolor(urec.statcolor);
        tab (^R'Points available: '^S+strr(pointsleft),27);
        tab (^R'Time available: '^S+strr(round(minsleft)),25);
        ansicolor(urec.bordercolor);
        writeln (' ');
        write (' ');
        tab (^R'Total D/L Time: '^S+strr(estimatedtime),27);
        tab (^R'Batch file #: '^S+strr(filecounter),25);
        ansicolor(urec.bordercolor);
        writeln (' ');
        writeln ('');
        ansicolor(urec.regularcolor);
        end
      else
        begin
        writeln (^R'Time available: '^S+strr(round(minsleft)));
        tab ('Total D/L Time: '^S+strr(estimatedtime),24);
        writeln (^R'Batch file #: '^S,filecounter);
        end;
      writeln;
      num:=getfilenumbatch('Batch Download');
      input:='';
      if num=0 then if filecounter = 1 then
        begin
        check1(abort);
        if abort then exit;
        end;
      if num=0 then if filecounter >1 then if filecounter <10 then
        begin
        check2(abort,readytostart);
        if abort then exit;
        if readytostart then writeln;
        end;
      if not checkfile (pointsleft,num) then if filecounter =1 then exit
        else
        else
        begin
        if tempsysop then
          begin
          ulvl:=regularlevel;
          tempsysop:=false;
          writeurec;
          bottomline
          end;
        getfileinfo(num,minsleft,mins2,mins,fsize,actualsize,sender[filecounter],
        whensent[filecounter],ratedwhen[filecounter],nameoffile[filecounter],
        filepath[filecounter],filepoints[filecounter],filedescrip[filecounter],
        timesdownloaded[filecounter],
        isitspecial[filecounter]);
        areanumber[filecounter]:=curarea;
        if (mins=-5) and (filecounter =1) then exit
        else if mins=-5 then readytostart:=true;
        if mins<>-5 then
          begin
          if (filepoints[filecounter]>0) and (not issysop) then
            pointsleft:=pointsleft-filepoints[filecounter];
          fnames[filecounter]:=getfname(filepath[filecounter],nameoffile[filecounter]);
          textname[filecounter]:=nameoffile[filecounter];
          fsizes[filecounter]:=fsize;
          totalbytes:=totalbytes+actualsize;
          ftime[filecounter]:=mins2;
          numb[filecounter]:=num;
          minsleft:=minsleft-mins2;
          filecounter:=filecounter+1;
          if filecounter=10 then readytostart:=true
          end;
        end;
      until readytostart;
    if readytostart then
      begin
      assign (batchfile,'batch.xfr');
      rewrite (batchfile);
      loopcounter:=1;
      timetotal:=0;
      totalblocks:=0;
        repeat
        if fsizes[loopcounter]>1 then blocks:=' 1 K Blocks' else blocks:='Block';
        if ftime[loopcounter]>1.0 then minutes:=' minutes' else minutes:='minute';
        totalblocks:=totalblocks+fsizes[loopcounter];
        timetotal:=timetotal+ftime[loopcounter];
        writeln (batchfile,fnames[loopcounter]);
        loopcounter:=loopcounter+1;
        until loopcounter=filecounter;
      textclose (batchfile);
      loopcounter:=1;
      if ansigraphics in urec.config then
        begin
        ansicolor(urec.bordercolor);
        writeln ('Ŀ');
        write ('');
        ansicolor(urec.highlightcolor);
        write ('                    Batch Download Statistics                    ');
        ansicolor(urec.bordercolor);
        writeln ('');
        writeln ('Ĵ');
        write ('');
        write (^R' #  Filename        Kbytes    Time to d/l (minutes)');
        ansicolor(urec.bordercolor);
        writeln ('              ');
        writeln ('Ĵ');
        end
      else
        begin
        writeln ('+-----------------------------------------------------------------+');
        writeln ('|                   Batch Download Statistics                     |');
        writeln ('+-----------------------------------------------------------------+');
        writeln ('| #  Filename         Kbytes     Time to d/l (minutes)            |');
        writeln ('+-----------------------------------------------------------------+');
        end;
        repeat
        if ansigraphics in urec.config then
          begin
          ansicolor(urec.bordercolor);
          write (' '^S);
          tab (strr(loopcounter),3);
          tab (nameoffile[loopcounter],17);
          tab (strr(round(fsizes[loopcounter])),11);
          tab (minstr(round(fsizes[loopcounter]*8)),33);
          ansicolor(urec.bordercolor);
          writeln ('');
          end
        else
          begin
          write ('| ');
         tab (strr(loopcounter),3);
          tab (nameoffile[loopcounter],18);
          tab (strr(round(fsizes[loopcounter])),12);
          tab (minstr(round(fsizes[loopcounter]*8)),31);
          writeln ('|');
          end;
        loopcounter:=loopcounter+1;
        until loopcounter=filecounter;
      if ansigraphics in urec.config then
        begin
        ansicolor(urec.bordercolor);
        writeln('Ĵ');
        write (' ');
        tab (^R+'Total Files:',14);
        tab (^S+strr(filecounter-1),5);
        tab (^R+'Total 1k blocks:',18);
        tab (^S+strr(totalblocks),7);
        tab (^R+'Apprx. d/l time:',18);
        tab (^S+minstr(totalbytes-round((totalbytes * 0.1))),8);
        ansicolor(urec.bordercolor);
        writeln ('');
        writeln ('');
        ansicolor(urec.regularcolor);
        end
      else
        begin
        writestr('+-----------------------------------------------------------------+');
        write ('| ');
        tab ('Total Files:',13);
        tab (strr(filecounter-1),4);
        tab ('Total 1k blocks:',17);
        tab (strr(totalblocks),6);
        tab ('Apprx. d/l time:',17);
        tab (minstr(totalbytes-round((totalbytes * 0.1))),7);
        writeln ('|');
        writestr('+-----------------------------------------------------------------+');
        end;
      writeln;
      writestr('Auto-disconnect after transfer? [y/N] *');
      if yes then autohang:=true else autohang:=false;
      writeln;
        case batchxfer of
          'Z':write('Zmodem');
          'G':write('Ymodem-G');
          'Y':write('Ymodem');
          'L':write('Lynx');
          'P':write('Puma');
        end;
      writeln (' Batch Download. [Ctrl-X][Ctrl-X][Enter] a few times to abort');
        case batchxfer of
          'Z':command_line:='DSZ.COM';
          'G':command_line:='DSZ.COM';
          'Y':command_line:='DSZ.COM';
          'L':command_line:='LYNX.EXE';
          'P':command_line:='PUMA.EXE';
        end;

        case batchxfer of
          'Z':switches:=' port '+commst+' speed '+baudst+' handshake both sz -m @'+dirsave+'\batch.xfr';
          'G':switches:=' port '+commst+' speed '+baudst+' handshake both sb -g @'+dirsave+'\batch.xfr';
          'Y':switches:=' port '+commst+' speed '+baudst+' handshake both sb -k @'+dirsave+'\batch.xfr';
          'L':switches:=' S /'+baudst+' /'+commst+' /S @'+dirsave+'\batch.xfr';
          'P':switches:=' E'+baudst+' P'+commst+' X+ S @'+dirsave+'\batch.xfr';
        end;
      starttime:=timer;
      runext(b,command_line,switches);
      endtime:=timer;
      if endtime<starttime then endtime:=endtime+1440;
      transfertime:=endtime-starttime;
      if b=1 then b:=2;
      beepbeepa(b);
      loopcounter:=1;
        repeat
        if transfertime-round(ftime[loopcounter])>0 then
          begin
          transfertime:=transfertime-round(ftime[loopcounter]);
          writelog (15,5,textname[loopcounter]);
          setareareset (areanumber[loopcounter]);
          seekudfile(numb[loopcounter]);
          fname:=getfname(filepath[loopcounter],nameoffile[loopcounter]);
          assign (f,fname);
          reset (f);
          ud.sentby:=sender[loopcounter];
          ud.when:=whensent[loopcounter];
          ud.whenrated:=ratedwhen[loopcounter];
          ud.filename:=nameoffile[loopcounter];
          ud.path:=filepath[loopcounter];
          ud.points:=filepoints[loopcounter];
          ud.filesize:=filesize (f);
          ud.descrip:=filedescrip[loopcounter];
          ud.downloaded:=timesdownloaded[loopcounter]+1;
          ud.specialfile:=isitspecial[loopcounter];
          urec.downloads:=urec.downloads+1;
          if (ud.points>0) and (not issysop) then urec.udpoints:=urec.udpoints-ud.points;
          write (udfile,ud);
          writeurec;
          close (f);
          loopcounter:=loopcounter+1;
          end
        else loopcounter:=filecounter;
      until loopcounter=filecounter;
    urec.udpoints:=pointsleft;
    writeln (^B'You now have ',numthings (urec.udpoints,'point','points'),' left in your account.');
    chdir (dirsave);
    if autohang then disconnect;
    end;
  end;

  procedure download (autoselect:integer);
  var totaltime:sstr;
      num,fsize,mins:integer;
      ud:udrec;
      fname:lstr;
      autohang,lettransfer:boolean;
      i,b,x:integer;
      f:file;
      extrnproto:char;
  begin
    if not allowxfer then exit;
    if nofiles then exit;
    i:=menu(command.commandstr[17],'PROTO',menus.commands[17]);
    if hungupon then exit;
      case i of
        1:extrnproto:='X';
        2:extrnproto:='C';
        3:extrnproto:='O';
        4:extrnproto:='Z';
        5:extrnproto:='G';
        6:extrnproto:='F';
        7:extrnproto:='Y';
        8:extrnproto:='L';
        9:extrnproto:='P';
       10:exit;
      end;
    if (extrnproto='G') or (extrnproto='Z') or (extrnproto='P') or
      (extrnproto='Y') or (extrnproto='L')  then
      begin
      batchdownload (extrnproto);
      exit;
      end;
    if autoselect=0 then num:=getfilenum('download') else num:=autoselect;
    if num=0 then exit;
    writeln;
    seekudfile (num);
    read (udfile,ud);
    if (not issysop) and (ud.points>urec.udpoints) then
      begin
      writeln ('Sorry, that file requires ',ud.points,' points.');
      exit
      end;
    if (ud.specialfile) and (not issysop) then
      begin
      writeln ('Sorry, downloading that file requires special permission.');
      exit
      end;
    if (not exist(ud.path+ud.filename)) then
      begin
      writeln('Sorry, that file is currently offline.');
      exit
      end;
    lettransfer:=true;
    oldname:=input;
    if (length(ud.password)>0) then filepassword(ud.filename,ud.password,lettransfer);
    input:=oldname;
    if not lettransfer then exit;
    errorcode:=0;
    checkupdown(errorcode,ud.filename,ud.path);
    for x:=1 to length(ud.filename) do ud.filename[x]:=upcase(ud.filename[x]);
    if errorcode <> 0 then
      begin
      writestr(ud.filename+' has errors, do you wish to continue? *');
      if not yes then exit;
      end;
    if tempsysop then
      begin
      ulvl:=regularlevel;
      tempsysop:=false;
      writeurec;
      bottomline
      end;
    fname:=getfname(ud.path,ud.filename);
    assign (f,fname);
    reset (f);
    iocode:=ioresult;
    if iocode<>0 then
      begin
      fileerror ('DOWNLOAD',fname);
      exit
      end;
    fsize:=filesize(f);
    close (f);
    totaltime:=minstr(fsize);
    mins:=valu(copy(totaltime,1,pos(':',totaltime)-1));
    if ((mins>timeleft) and (not issysop)) then
      begin
      writestr ('Sorry, you don''t have enough time left!');
      exit
      end;
    if (mins-5>timetillevent) then
      begin
      writestr ('Sorry, the timed event is coming up too soon!');
      exit
      end;
    writeln (^B^M'Filename:       '^S,ud.filename);
    writeln ('Uploaded by:    '^S,ud.sentby);
    write ('Downloaded:     '^S,ud.downloaded,' time');
    if ud.downloaded=1 then writeln else writeln ('s');
    writeln ('Transfer time:  '^S,totaltime);
    writeln;
    writestr('Auto-disconnect after transfer? [y/N] *');
    if upcase(input[1]) ='Y' then autohang:=true else autohang:=false;
      case extrnproto of
        'X':tab ('Xmodem',6);
        'C':tab ('Xmodem-CRC',10);
        'O':tab ('Ymodem',6);
        'F':tab ('Xmodem-1k-G',11);
      end;
    writeln (' transmit ready.  [Ctrl-X][Ctrl-X][Enter] a few times to abort');
    clrscr;
    b:=doext('S',extrnproto,ud.path,ud.filename,baudrate,usecom);
    if b<>0 then b:=2;
    modeminlock:=false;
    beepbeepa (b);
    if (b=0) then
      begin
      writelog (15,1,fname);
      ud.downloaded:=ud.downloaded+1;
      urec.downloads:=urec.downloads+1;
      seekudfile (num);
      write (udfile,ud);
      if (ud.points>0) and (not issysop) then
        begin
        urec.udpoints:=urec.udpoints-ud.points;
        writeln (^B'You now have ',numthings (urec.udpoints,'point','points'),'.')
        end;
      writeurec
      end;
    if autohang then disconnect;
  end;

  procedure upload;
  var ud:udrec;
      ok,goodbye:boolean;
      i,b,x,starttime,endtime,transfertimecredit,errcode:integer;
      dirsave,cddir,fn,filedesc,password,callfile,runline:lstr;
      time:string;
      extrnproto:char;
      f:file;
  begin
    if gogetupload then urec.timetoday:=deftime;
    goodbye:=false;
    if not allowxfer then exit;
    if timetillevent<30 then
      begin
      writestr ('Sorry, uploads are not allowed within one half hour of the timed event!');
      exit
      end;
    ok:=false;
    i:=menu(command.commandstr[17],'PROTO',menus.commands[17]);
    if hungupon then exit;
      case i of
        1:extrnproto:='X';
        2:extrnproto:='C';
        3:extrnproto:='O';
        4:extrnproto:='Z';
        5:extrnproto:='G';
        6:extrnproto:='F';
        7:extrnproto:='Y';
        8:extrnproto:='L';
        9:extrnproto:='P';
       10:exit;
      end;
    write ('Free disk space: ');
    if gogetupload then writefreespace (transdir) else writefreespace (area.xmodemdir);
    writeln;
      repeat
      writestr ('Target filename:');
      if length(input)=0 then exit;
      if not validfname(input) then
        begin
        writeln ('Invalid filename!');
        exit
        end;
      ud.filename:=input;
      if gogetupload then ud.path:=transdir else ud.path:=area.xmodemdir;
      fn:=getfname(ud.path,ud.filename);
      if hungupon then exit;
      writeln(fn);
      if exist(fn) then writeln ('Sorry!  File exists!') else ok:=true
      until ok;
    buflen:=40;
    writestr('Description of upload: &');
    filedesc:=input;
    if length(filedesc)=0 then filedesc:='<*> NO DESCRIPTION AT UPLOAD <*>';
    if ulvl>=sysoplevel then
      begin
      writestr ('Password: &');
      password:=input;
      end else password:='';
    writestr ('Auto-disconnect after transfer? [y/N] *');
    if yes then goodbye:=true;
      case extrnproto of
        'X':tab ('Xmodem',6);
        'C':tab ('Xmodem-CRC',10);
        'O':tab ('1k-Xmodem',6);
        'Z':tab ('Zmodem',6);
        'G':tab ('Ymodem-G',8);
        'F':tab ('1k-Xmodem-G',11);
        'Y':tab ('Ymodem',6);
        'L':tab ('Lynx',4);
        'P':tab ('Puma',4);
      end;
    writeln (' receive ready.  [Ctrl-X][Ctrl-X][Enter] a few times to abort');
    clrscr;
    if tempsysop then
      begin
      ulvl:=regularlevel;
      tempsysop:=false;
      writeurec;
      bottomline
      end;
    starttime:=timer;
    b:=doext('R',extrnproto,ud.path,ud.filename,baudrate,usecom);
    endtime:=timer;
    modeminlock:=false;
    modemoutlock:=false;
    if b<>0 then b:=2;
    beepbeepa (b);
    if b>=1 then
      begin
      if exist (fn) then
        begin
        assign(f,fn);
        erase (f);
        end;
      exit;
      end;
    if b=0 then
      begin
      for x:=1 to length(ud.filename) do ud.filename[x]:=upcase(ud.filename[x]);
      errorcode:=0;
      checkupdown(errorcode,ud.filename,ud.path);
      if errorcode <> 0 then ud.descrip:='<*> BAD UPLOAD <*>' else ud.descrip:=filedesc;
      if errorcode=0 then
        begin
        if (ud.filename[length(ud.filename)]='P') and (ud.filename[length(ud.filename)-1]='I') and
          (ud.filename[length(ud.filename)-2]='Z') and (ud.filename[length(ud.filename)-3]='.') then
          begin
          callfile:=maindir+'pkzip.exe';
          runline:=' -ex '+ud.path+ud.filename+' '+textfiledir+'bbs.ad';
          runext (errcode,callfile,runline);
          end;
        end;
      if gogetupload then writelog(0,7,ud.filename) else writelog (15,2,fn);
      ud.sentby:=unam;
      ud.when:=now;
      ud.whenrated:=now;
      ud.downloaded:=0;
      ud.specialfile:=false;
      ud.downloaded:=0;
      if length(password)=0 then ud.password:='' else ud.password:=password;
      writeln ('Thanks for uploading!');
      str(timeleft, time);
      writeln;
      writeln('You now have ',time,' minutes left!');
      getfsize (ud);
      ud.points:=(ud.filesize div 1000)+1;
      addfile (ud);
      urec.udpoints:=urec.udpoints+(ud.points*uploadfactor);
      urec.uploads:=urec.uploads+1;
      newuploads:=newuploads+1;
      if goodbye then disconnect;
    end;
  end;

  procedure yourudstatus;
  begin
  if asciigraphics in urec.config then
    begin
    ansicolor(urec.bordercolor);
    writeln('Ŀ');
    tab('',2);
    ansicolor(urec.regularcolor);
    tab('Access level:',17);
    ansicolor(urec.statcolor);
    tab(strr(urec.udlevel),6);
    ansicolor(urec.bordercolor);
    writeln('');
    tab('',2);
    ansicolor(urec.regularcolor);
    tab('Transfer points:',17);
    ansicolor(urec.statcolor);
    tab(strr(urec.udpoints),6);
    ansicolor(urec.bordercolor);
    writeln('');
    tab('',2);
    ansicolor(urec.regularcolor);
    tab('Uploads:',17);
    ansicolor(urec.statcolor);
    tab(strr(urec.uploads),6);
    ansicolor(urec.bordercolor);
    writeln('');
    tab('',2);
    ansicolor(urec.regularcolor);
    tab('Downloads:',17);
    ansicolor(urec.statcolor);
    tab(strr(urec.downloads),6);
    ansicolor(urec.bordercolor);
    writeln('');
    writeln('');
    ansicolor(urec.regularcolor);
    end
  else
    begin
    writeln (^B^M'Access level:    '^S,urec.udlevel,
               ^M'Transfer points: '^S,urec.udpoints,
               ^M'Uploads:         '^S,urec.uploads,
               ^M'Downloads:       '^S,urec.downloads)
    end;
  end;

  procedure newscanall;
  var cnt:integer;
      a:arearec;
  begin
    writehdr ('Newscanning...');
    beenaborted:=false;
    if aborted then exit;
    for cnt:=1 to filesize(afile) do
      begin
      seekafile (cnt);
      read (afile,a);
      if urec.udlevel>=a.level then
        begin
        if aborted then exit;
        setarea (cnt);
        writeln ('Scanning ',area.name,'...');
        if aborted then exit;
        newscan
        end;
      if aborted then exit
      end
  end;

  procedure addresidentfile (fname:lstr);
  var ud:udrec;
  begin
    getpathname (fname,ud.path,ud.filename);
    getfsize(ud);
    ud.points:=(ud.filesize div 1000)+1;
    writestr ('Sent by [CR='+unam+']:');
    if length(input)=0 then input:=unam;
    ud.sentby:=input;
    ud.when:=now;
    ud.whenrated:=now;
    ud.downloaded:=0;
    writestr ('Description: &');
    ud.descrip:=input;
    writestr ('Special request only? *');
    ud.specialfile:=yes;
    writestr ('Enter password: &');
    ud.password:=input;
    addfile (ud);
    writelog (16,8,fname)
  end;

  procedure sysopadd;
  var fn:lstr;
      upper:integer;
  begin
    if ulvl<sysoplevel then
      begin
      writeln('Sorry, you may not add resident files without true sysop access!');
      exit
      end;
    writehdr ('Add Resident File');
    writestr ('Path/name of file:');
    fn:=input;
    for upper:=1 to length(fn) do fn[upper]:=upcase(fn[upper]);
    if exist(fn) then
      begin
      writestr ('Confirm: '+fn+' [y/N]:');
      if yes then addresidentfile (fn)
      end
    else
      begin
      writestr ('File not found, add file anyway? *');
      if not yes then exit else addresidentfile (fn);
      end;
  end;

  procedure addmultiplefiles;
  var spath,pathpart:lstr;
      dummy:sstr;
      f:file;
      ffinfo:searchrec;
  begin
    if ulvl<sysoplevel then
      begin
      writeln ('Sorry, you may not add resident files without true sysop access!');
      exit
      end;
    writehdr ('Add Resident Files By Wildcard');
    writestr ('Search path/wildcard:');
    if length(input)=0 then exit;
    spath:=input;
    if spath[length(spath)]='\' then dec(spath[0]);
    assign (f,spath+'\con');
    reset (f);
    if ioresult=0 then
      begin
      close (f);
      spath:=spath+'\*.*'
      end;
    getpathname (spath,pathpart,dummy);
    findfirst (spath,$17,ffinfo);
    if doserror<>0 then writeln ('No files found!') else while doserror=0 do
      begin
      writeln;
      displayfile (ffinfo);
      writestr ('Add this file [y/N/x]? *');
      if yes then addresidentfile (getfname(pathpart,ffinfo.name)) else
        if (length(input)>0) and (upcase(input[1])='X') then exit;
      findnext (ffinfo)
      end
  end;

  procedure changef;
  var n,q:integer;
     ud:udrec;

    procedure showudrec (var ud:udrec);
    begin
      with ud do
        writeln(^M^J'   Filename: '^S,ud.filename,
                ^M^J'       Path: '^S,ud.path,
                ^M^J'       Size: '^S,ud.points,
                ^M^J'Description: '^S,ud.descrip,
                ^M^J'#downloaded: '^S,ud.downloaded,
                ^M^J'Special req: '^S,yesno(ud.specialfile),
                ^M^J'   Password: '^S,ud.password,
                ^M^J'    Sent by: '^S,sentby,
                ^M^J'    Sent on: '^S,datestr(when),
                ^M^J'    Sent at: '^S,timestr(when),^M^J);
    end;

  begin
    n:=getfilenum ('Change');
    if n=0 then exit;
    seekudfile (n);
    read (udfile,ud);
    writelog (16,4,ud.filename);
    showudrec (ud);
      repeat
      q:=menu (command.commandstr[18],'FCHANGE',menus.commands[18]);
        case q of
          2:getstring ('uploader',ud.sentby);
          3:begin
            nochain:=true;
            getstring ('description',ud.descrip)
            end;
          4:getboo ('special request only',ud.specialfile);
          5:;
          6:getstring ('filename',ud.filename);
          7:getstring ('path',ud.path);
          8:;
          9:getpwd ('password',ud.password);
        end
      until (q=1);
    getfsize(ud);
    if ud.filesize=-1 then writestr ('Warning:  Can''t open file!');
    seekudfile (n);
    write (udfile,ud)
  end;

  procedure deletef;
  var n,cnt:integer;
      fn:lstr;
      ud:udrec;
      f:file;
  begin
    n:=getfilenum ('delete');
    if n=0 then exit;
    seekudfile (n);
    read (udfile,ud);
    fn:=getfname(ud.path,ud.filename);
    writelog (16,7,fn);
    writestr ('Confirm: File '+fn+' ('+ud.descrip+') ? *');
    if not yes then exit;
    writestr ('Remove '+ud.sentby+'''s upload credit? *');
    if yes then
      begin
      end;
    removefile (n);
    if not (exist (fn)) then exit;
    writestr ('Erase disk file '+fn+'? *');
    if not yes then exit;
    assign (f,fn);
    erase (f)
  end;

  procedure killarea;
  var a:arearec;
      cnt,n:integer;
      oldname,newname:sstr;
  begin
    writestr ('Delete area #'+strr(curarea)+' ('+area.name+')? *');
    if not yes then exit;
    writelog (16,2,'');
    close (udfile);
    oldname:='Area'+strr(curarea);
    assign (udfile,oldname);
    erase (udfile);
    for cnt:=curarea to numareas-1 do
      begin
      newname:=oldname;
      oldname:='Area'+strr(cnt+1);
      assign (udfile,oldname);
      rename (udfile,newname);
      n:=ioresult;
      seekafile (cnt+1);
      read (afile,a);
      seekafile (cnt);
      write (afile,a)
      end;
    seekafile (numareas);
    truncate (afile);
    setarea (1)
  end;

  procedure modarea;
  var a:arearec;
  begin
    a:=area;
    getstring ('area name',a.name);
    writelog (16,3,a.name);
    getint ('access level',a.level);
    writelog (16,11,strr(a.level));
    if issysop then
      begin
      a.xmodemdir:=getapath;
      writelog (16,13,a.xmodemdir)
      end;
    seekafile (curarea);
    write (afile,a);
    area:=a
  end;

  procedure sortarea;
  var temp,mark,cnt:integer;
      u1,u2:udrec;
  begin
    writehdr ('Sort Area');
    writestr ('Confirm [y/N]:');
    if not yes then exit;
    writelog (16,6,'');
    mark:=numuds-1;
    repeat
      if mark<>0 then
        begin
        temp:=mark;
        mark:=0;
        for cnt:=1 to temp do
          begin
          seekudfile (cnt);
          read (udfile,u1);
          read (udfile,u2);
          if upstring(u1.filename)>upstring(u2.filename) then
            begin
            mark:=cnt;
            seekudfile (cnt);
            write (udfile,u2);
            write (udfile,u1)
            end
          end
        end
    until mark=0
  end;

  procedure movefile;
  var an,fn,oldn:integer;
      ud:udrec;
      oldpath,newpath:lstr;
      f1,f2:file;
      buffer:array[1..4096] of byte;
      fsize:longint;
  begin
    oldn:=curarea;
    fn:=getfilenum ('move');
    if fn=0 then exit;
    input:='';
    an:=getareanum;
    if an=0 then exit;
    writeln ('Moving file, please hold...');
    seekudfile (fn);
    read (udfile,ud);
    oldpath:=ud.path+ud.filename;
    writelog (16,5,ud.filename);
    removefile (fn);
    setarea (an);
    ud.path:=area.xmodemdir;
    addfile (ud);
    newpath:=area.xmodemdir+ud.filename;
    assign(f1,oldpath);
    assign(f2,newpath);
    reset(f1,1);
    rewrite(f2,1);
    fsize:=filesize(f1);
    while fsize >= 4096 do
      begin
      blockread(f1,buffer,4096);
      blockwrite(f2,buffer,4096);
      fsize:=fsize-4096;
      end;
    blockread(f1,buffer,fsize);
    blockwrite(f2,buffer,fsize);
    close(f2);
    erase(f1);
    close(f1);
    setarea (oldn);
  end;

  procedure renamefile;
  var fn:integer;
      ud:udrec;
      f:file;
  begin
    fn:=getfilenum ('rename');
    if fn=0 then exit;
    seekudfile (fn);
    read (udfile,ud);
    writestr ('Enter new filename:');
    if match(input,ud.filename) then ud.filename:=input
    else if length(input)>0 then
      if validfname(input) then
        if exist(getfname(ud.path,input)) then
          writeln ('Name already in use!')
            else
              begin
              assign (f,getfname(ud.path,ud.filename));
              rename (f,getfname(ud.path,input));
              if ioresult=0 then
                begin
                ud.filename:=input;
                writeln (^B^M'File renamed.')
                end
              else writeln (^B^M'Unable to rename file!')
              end
          else writeln ('Invalid filename!');
    seekudfile (fn);
    write (udfile,ud)
  end;

  procedure reorderareas;
  var numa,cura,newa:integer;
      a1,a2:arearec;
      f1,f2:file;
      fn1,fn2:sstr;
  label exit;
  begin
    writelog (16,9,'');
    writehdr ('Re-order Areas');
    numa:=filesize (afile);
    writeln ('Number of areas: ',numa);
    for cura:=0 to numa-2 do
      begin
      repeat
        writestr ('New area #'+strr(cura+1)+' [?=List, CR to quit]:');
        if length(input)=0 then goto exit;
        if input='?'
          then
            begin
              listareas;
              newa:=-1
            end
          else
            begin
              newa:=valu(input)-1;
              if (newa<0) or (newa>numa) then begin
                writeln ('Not found!  Please re-enter...');
                newa:=-1
              end
            end
      until (newa>=0);
      seek (afile,cura);
      read (afile,a1);
      seek (afile,newa);
      read (afile,a2);
      seek (afile,cura);
      write (afile,a2);
      seek (afile,newa);
      write (afile,a1);
      fn1:='Area';
      fn2:=fn1+strr(newa+1);
      fn1:=fn1+strr(cura+1);
      assign (f1,fn1);
      assign (f2,fn2);
      rename (f1,'Temp$$$$');
      rename (f2,fn1);
      rename (f1,fn2)
    end;
    exit:
    setarea (1)
  end;

  procedure arc;
  var path,runline,callfile:lstr;
      errcode,x:integer;
      arcname:string[60];
      arc:boolean;
  begin
    callfile:=maindir+'pkzip.exe';
    arc:=false;
    writehdr('Archive file menu');
    writestr('Name/path of file<s> to archive: &');
    path:=input;
    if length(path)=0 then exit;
    writestr('Name/path of file to create: &');
    arcname:=input;
    if length(arcname)=0 then exit;
    callfile:=maindir+'pkzip.exe';
         for x := 1 to 60 do
         begin
         if arcname[x]='.' then arc:=true;
         arcname[x]:=upcase(arcname[x]);
         end;
    if (arc=false) then arcname:=arcname+'.ZIP';
    runline:=' -ex '+arcname+' '+path;
    writeln('  One moment please...');
    runext (errcode,callfile,runline);
    writeln;
    if exist (arcname) then writeln('File '+arcname+' created!')
     else writeln('Error in creating file '+arcname);
  end;

  procedure dearc;
  var path,runline,callfile:lstr;
      errcode,x:integer;
      arcname:string[60];
      arc:boolean;
  begin
    arc:=false;
    writehdr('De-Archive file menu');
    writestr('Name/path of file<s> to de-archive: &');
    if length(input)=0 then exit else
         arcname:=input;
    writestr('De-archive path [CR for '+area.xmodemdir+']:');
    if length(input)=0 then path:=area.xmodemdir else
         path:=input;
    callfile:=maindir+'pkunzip.exe';
         for x := 1 to 60 do
         begin
         if arcname[x]='.' then arc:=true;
         arcname[x]:=upcase(arcname[x]);
         end;
    if (arc=false) then arcname:=arcname+'.ZIP';
    runline:=' '+arcname+' '+path;
    writeln('  One moment please...');
    runext (errcode,callfile,runline);
    writeln;
    writeln('File '+arcname+' may not have been successful.  The only way to');
    writeln('be sure is to check directory '+path);
  end;

  procedure testarchive;
  var callfile:lstr;
      arcname:string[60];
      errcode,x,n:integer;
      arc:boolean;
      ud:udrec;
    begin
    writehdr('Test Archive');
    if nofiles then exit;
    n:=getfilenum('list');
    if n=0 then exit;
    seekudfile (n);
    read (udfile,ud);
    for x:=1 to length(ud.filename) do ud.filename[x]:=upcase(ud.filename[x]);
    arcname:=getfname(ud.path,ud.filename);
    errcode:=0;
    arc:=false;
    callfile:=maindir+'pkunzip.exe';
    for x := 1 to 60 do
         begin
         if arcname[x]='.' then arc:=true;
         arcname[x]:=upcase(arcname[x]);
         end;
    if (arc=false) then arcname:=arcname+'.ZIP';
    arcname:=' -t '+arcname;
    writeln('Checking '+ud.filename+' integrity, please hold...');
    runext(errcode,callfile,arcname);
    writeln;
    if (errcode=0) then writeln(ud.filename+' has no errors.') else
         writeln(ud.filename+' has errors.');
    end;

    procedure transferpoints;
    var name:string[25];
        points,eunum:integer;
        eurec:userrec;
    begin
         writehdr('Transfer Points');
         if urec.udpoints<=0 then
              begin
              writeln('You don''t have any points!');
              exit;
              end;
         writestr('User Handle/ID# to give points: *');
         eunum:=lookupuser(input);
         if eunum=0 then
              begin
              writeln('User not found!');
              exit;
              end;
         writeln('You have ',urec.udpoints,' points.');
         writestr('Amount of points to give: *');
         points:=valu(input);
         if (points<=0) then exit;
         if (points>urec.udpoints) then
              begin
              writeln('You don''t have that many points!');
              exit;
              end;
         seek(ufile,eunum);
         read(ufile,eurec);
         eurec.udpoints:=eurec.udpoints+points;
         urec.udpoints:=urec.udpoints-points;
         writeln(points,' points have been given to '+eurec.handle+'.');
         writeufile(eurec,eunum);
    end;

  procedure sysopcommands;
  var i:integer;
  begin
    if not issysop then begin
      reqlevel (sysoplevel);
      exit
    end;
    writelog (22,7,'');
    writelog (15,3,area.name);
    repeat
      i:=menu(command.commandstr[20],'FSYSOP',menus.commands[20]);
     case i of
        1:sysopadd;
        2:changef;
        3:deletef;
        4:directory;
{        5:generatelist; }
        6:killarea;
        7:modarea;
        8:;
        9:sortarea;
        10:movefile;
        11:;
        12:reorderareas;
        14:renamefile;
        15:addmultiplefiles;
        16:arc;
        17:dearc
      end
    until hungupon or (i=13)
  end;

var i:integer;
    a:arearec;
    ms:boolean;
    fn:lstr;
label ok,exit;
begin
    if gogetupload then
       begin
       upload;
       gogetupload:=false;
       goto exit;
       end;
{  cursection:=udsysop; }
  returnto:='T';
  ms:=false;
  fn:=textfiledir+'WANTED';
  if not fromdoor then
     begin
     allclear;
     display (fn);
     if (exist (textfiledir+'WANTED')) or (exist (textfiledir+'WANTED.asc'))
     or (exist (textfiledir+'WANTED.ans')) then pausenow;
     allclear;
     drawbox(48,'FILE TRANSFER SYSTEM');
     end;
  input:='';
  assign (afile,'areadir');
  if exist ('Areadir') then
      begin
      reset (afile);
      if filesize (afile)>0 then goto ok
      end else rewrite (afile);
  writeln ('No areas have been defined!');
  area.xmodemdir:=transdir;
  if issysop
    then if makearea
      then goto ok;
  goto exit;
  ok:
  seekafile (1);
  read (afile,a);
  if urec.udlevel<a.level then begin
    writeln ('Sorry, you can''t access the first area!');
    goto exit
  end;
  setarea (1);
  drawarea;
  repeat
    if withintime (xmodemclosetime,xmodemopentime) then
      if not issysop then begin
        writestr (^M^M'Sorry, the file section is closed now!');
        writeln ('The time now is: '^S,timestr(now));
        writeln ('It will open at: '^S,xmodemopentime);
         goto exit
      end else if not ms then begin
        writeln ('(The file section is closed until ',xmodemopentime,')');
        ms:=true
      end;
    i:=menu (command.commandstr[21],'FILE',menus.commands[21]);
    if hungupon then goto exit;
    case i of
      1:upload;
      2:download (0);
      3:listfiles (false);
      4:;
      5:yourudstatus;
      6,7:getarea;
      8:searchfile;
      10:sysopcommands;
      11:begin newscanall; setarea(1); drawarea; end;
      12:;
      13:;
      14:listarchive;
      15:listfiles (true);
      16:transferpoints;
      17:;
      18:testarchive;
      19:nextarea;
      20:prevarea;
      21:setlastcall('T');
    end
  until hungupon or (i=9);
  exit:
  urec.lastont:=now;
  close (afile);
  close (udfile);
  i:=ioresult
end;

begin
end.