unit struct;

INTERFACE

uses directcm,mainvars,crt,dos,fastttt5,dispscr,tmpcom;

const alientypes:array[1..5] of string[15]=('Ferrengi','Klingon','Space Pirate','Alien','Unknown');
const fact:array[1..4] of string[10]=('Defensive','Offensive','Toll','Standard');
const scannertypes:array[1..6] of string[10]=('None','Density','Holo1','Holo2','Holo3',
	'LongRange');
const combatscanners:array[1..7] of string[10]=('None','Tact1','Tact2',
	'Tact3','ShieldSc','FightSc','SuprSc');
const Planetscanners:array[1..6] of string[10]=('None','Class1','Class2',
	'Class3','Class4','LaserSc');

const enginetypes:array[1..11] of string[11]=('Class1','Class2','Class3',
	'Class4','Hyperdrv1','Hyperdrv2','Hyperdrv3','Transwarp',
	'Dilithium','AntiMatter','SuperDrv');

const ptypes:array[1..5] of string[11]=('None',
	'Blaster','Photon','Antimatter','Class10');

const shipnames:array[1..20] of string[22]=('Star Cruiser','Battle Cruiser',
	'Federation Starship','Imperial Starship','Alien Starship','Destroyer',
	'Death Cruiser','Scout Mini','Super Scout','Warship','Romulon Cruiser',
 	'Ferrengi Cruiser','Klingon Cruiser','Strange Orb','Krypton Cruiser',
	'Fleet Commandship','Imperial Destroyer','Death Star','Planet Oblitorator',
	'Super Demon');

const pdef:array[1..10] of string[20]=('No Defenses','Planetary Base',
	'Planetary Command','Planetary lvl1','Planetary lvl2','Planetary lvl3',
	'Planetary lvl4','Shielded Base','Shielded Planet','Force Globe');
const ptyp:array[1..9] of string[20]=('Barren with sand','Barren with Rocks',
	'Volcanic','Lush Forest','Temperate','Super Hot','Arctic',
	'Sub-Arctic','Paradise');
const inhablvl:array[1..5] of string[20]=('Deserted','Military Only',
	'Small Population','Medium Population','Large Population');

type
Planet=record
	numberp:longint;
	Planetname:string;
	Createdby:string;
	Ownedby:integer;
	F1:longint;
	F2:longint;
	F3:longint;
	FOL:byte;		{Between 0 and 254 of fighter offensive lvl}
	PlantaryDefense:byte;   
	PlanetType:byte;
	InhabitationLevel:byte;
	LoyalColonists:longint;
	RebelColonists:longint;
	Diplomats:longint;
	StormTroopers:longint;
	Shields:longint;
	ForceGlobe:longint;
	Computerodds:byte;	{If citadel, this is combat odds for fighters}
	ProductionMoney:longint;{money production/day}
	ProductionFU:longint;	{Production of Fighter Units}
	PlanetaryBlaster:boolean;{Planetary Quasar Cannon}
	Sectorlevel:byte;	{0-254 of sector level}
	Fuel:longint;		{Fuel of Blaster&Transwrp}
	Atmoslevel:byte;	{0-254 of Atmospheric Level}
	Transwarp:boolean;	{Planetary Transwarp}
		
	
	end;


Sector=record
	PortClass:integer;		{Port Type for trading}
	Special:byte;			{Special Stuff RESERVED}
	Planet:array [1..5] of integer;	{Stores Planet Numbers 1-5}
	Nebulas:array[1..5] of integer;	{Nebulas/Wormholes}
	starports:byte;			{Starport Class (0 if none)}
	F1:longint;			{Fighters1 in sector}
	F1Actv:byte;			{Fighters1 behavior}
	F2:longint;			{..}
	F2Actv:byte;
	F3:longint;
	F3Actv:byte;
	FBT:integer;			{Fighters belong to play #}
	Minez:integer;			{Mines in sector}
	minezplayer:integer;		{Mines belong to?}
	Playerz:array[1..5] of integer; {Play # in sector}
	Fedspace:boolean;
	stealmoney:longint;		{Money avail to steal at port}
	end;


ALIENREC=record
	Alientype:byte;
	Aliennumber:integer;
	Fighters1,Fighters2,Fighters3,shields:longint;
	allignment,experience,money,cargoships:longint;
	aliendead:boolean;
	end;


PLAYER=record
       BBSName:string;
       PLAYERHANDLE:string;
	Mines:integer;		{Space Mines}
       Oncorp:integer;		{Corp # (- #)}
       lastplayed:integer;	{Day #}
       ShipName:string;  
       ShipNumber:integer;	   {Fleet Leader Ship #}
       PlayerNumber:integer;	   {Player #}
       Money:longint;              {Money onhand}
       BankMoney:longint;          {Bank Money}
       BankLoan:longint;        {Bank Loan}
       Superstock:longint;      {Super Stock}
       Fighters1:longint;        {Weak Fighters}
       Fighters2:longint;      {Medium Fighters}
       Fighters3:longint;	{Strong Fighters}       
	cloakon:boolean;
       Traders:longint;		{Trader ships carries 1 units each}
       Cloak:integer;		{Cloaking Devices}
       Shields:longint;		{Shields}
       Carbonites:longint;	{Carbonite devices}
       Scannertype:byte;	{0=none; 1=Bad; 2=Decent; 3=good; 4=excellent;
				5=new technol1; 6=new technol2; up to 10}
       CombatScanner:byte;	{Combat Scanner 1-100}
       PlanetScanner:byte;	{Planet Scanner 1,2,3,4,5}
       EngineType:byte;		{above type 5=hyperdrive also = max speed}
       colonists:longint;	{Colonists in fleet}
       totalpeopleinfleet:longint; {Total people in Fleet}
       PlanetWeapon:byte;	{Planet weapon type}
       StormTroopers:longint;	{Used to take over planets/ships}
       Diplomats:longint;	{People used to control planets}
       ANSI:boolean;		{Ansi or not}
       FASTPROT:boolean;	{Fast protocol or not}
       Turnsperday:longint;	{Turns per day}
       Turnstoday:longint;	{Turns left today}
       Blownup:boolean;		{Player blown up?}
       Reward:longint;		{Reward on player's head}
       Experience:longint;	{Experience points}
       Allignment:longint;	{Good/evil}
       TheForce:longint;	{Special}              
       end;

config=record
       turnsperday:longint;	{Turns per day}
       end;

var usernow:player;
usertemp:player;
    sectornow:sector;
usersectornow:integer;
    sf:file of sector;    
baud:longint;
    bbsname:string;
    cfg:config;
    usernowf:file of player;
    user2f:file of player;
	alien:alienrec;
	alienf:file of alienrec;
    cfgf:file of config;
    var abort:boolean;
    r:longint;
    i3,maint:longint;
    born,died:longint;
    c:char;
    s,s1:string;
	planetnow:planet;
	pf:file of planet;
    price:longint;
    i,i2:longint;
    kon:longint;
    code:integer;
    sectnum:integer;

function finduser(un:integer):integer;
procedure initsectors;
function MOVE2SEC(sectortomoveto:integer):integer;
procedure getsector(sectornum:integer);
procedure playgame;
procedure writecfg;
procedure dispsector(sectornum:integer);
procedure initplanet(planet1:boolean;planetnum:longint;planetnm:string);
procedure writeuser;
procedure stats;
procedure writesector;
procedure inituser(Userspot:integer);
procedure sendscreengg(s:string;local:boolean);
procedure findstarport;
procedure universestats;
procedure mainstarport;  {Returns money left}
procedure tmpuser(un:integer);
procedure initaliens;
function playername(un:integer):string;
procedure cloakingdevice(usersectornow1:integer;usernumber1:integer);
procedure removeusersector(sectr:integer;un:integer);
procedure placeuser(sectr:integer;un:integer;cloakn:boolean);
{function playerrank:longint;}

function removefighters(hits:longint):boolean;    {returns true if user dead}



IMPLEMENTATION

procedure mainstarport;  {Returns money left}
begin
end;



procedure writesector;
begin
assign(sf,'sector.dat');
reset(sf);
seek(sf,(usersectornow-1));
write(sf,sectornow);
close(sf);
end;

function MOVE2SEC(sectortomoveto:integer):integer;
var sectoractualnow:integer;
	i,i1,i2:integer;
	tmp5:char;
label 1,2,3,4,5;
begin
clrscr; cscrn;
sectoractualnow:=usersectornow;
if (sectortomoveto<usersectornow) then begin
	if ((usersectornow-sectortomoveto)>1500) then begin
	scs('That is a LONG ways away... It may take awhile.. still move? ',false);
	tmp5:=getchar;
	if (upcase(tmp5)<>'Y') then goto 1;
	clrscr; cscrn; scs('Moving...',true);
	end;
	for i:=(usersectornow-1) downto sectortomoveto do begin
		sectoractualnow:=i;
		getsector(sectoractualnow);
		for i1:=1 to 5 do begin
with sectornow do 
if ((minez<>0) or (F1<>0) or (F2<>0) or (F3<>0) or (playerz[i1]<>0) or (planet[i1]<>0)) then begin
			clrscr; cscrn;
			scs('Hyperspace impossible through this sector...',false);
			tmp5:=getchar;
			clrscr; cscrn;
				goto 1;
				end;
			end;
		usernow.turnstoday:=usernow.turnstoday-500;
		if ((i-1)>sectortomoveto) then dec(i);
		if ((i-2)>sectortomoveto) then dec(i);
		if ((i-3)>sectortomoveto) then dec(i);
		if ((i-4)>sectortomoveto) then dec(i);
		if ((i-5)>sectortomoveto) then dec(i);
		if ((i-6)>sectortomoveto) then dec(i);
		if ((i-7)>sectortomoveto) then dec(i);
		if ((i-8)>sectortomoveto) then dec(i);
		if ((i-9)>sectortomoveto) then dec(i);
		if ((i-10)>sectortomoveto) then dec(i);
		end;
	end;
if (sectortomoveto>usersectornow) then begin
	if ((sectortomoveto-usersectornow)>1500) then begin
	scs('That is a LONG ways away... It may take awhile.. still move? ',false);
	tmp5:=getchar;
	if (upcase(tmp5)<>'Y') then goto 1;
	clrscr; cscrn; scs('Moving...',true);
	end;
	for i:=(usersectornow+1) to sectortomoveto do begin
		sectoractualnow:=i;
		getsector(sectoractualnow);
		for i1:=1 to 5 do begin
with sectornow do 
if ((minez<>0) or (F1<>0) or (F2<>0) or (F3<>0) or (playerz[i1]<>0) or (planet[i1]<>0)) then begin
			clrscr; cscrn;
			scs('Hyperspace impossible through this sector...',false);
			tmp5:=getchar;
			clrscr; cscrn;
				goto 1;
				end;
			end;

		usernow.turnstoday:=usernow.turnstoday-500;
		
		if ((i+1)<sectortomoveto) then inc(i);
		if ((i+2)<sectortomoveto) then inc(i);
		if ((i+3)<sectortomoveto) then inc(i);
		if ((i+4)<sectortomoveto) then inc(i);
		if ((i+5)<sectortomoveto) then inc(i);
		if ((i+6)<sectortomoveto) then inc(i);
		if ((i+7)<sectortomoveto) then inc(i);
		if ((i+8)<sectortomoveto) then inc(i);
		if ((i+9)<sectortomoveto) then inc(i);
		if ((i+10)<sectortomoveto) then inc(i);
		end;	
	end;
1:
writeuser;
MOVE2SEC:=sectoractualnow;
end;

procedure cloakingdevice(usersectornow1:integer;usernumber1:integer);
begin
usernow.cloak:=usernow.cloak-1;
usernow.cloakon:=true;
writeuser;
placeuser(usersectornow1,usernumber1,true);
scs(' ',true);
scs('Your fleet has been cloaked...It will stay cloaked until tommorow.',true);
end;


function countferrengis:integer;
var i,i1:integer;
begin
assign(alienf,'aliens.dat');
reset(alienf);
i1:=0;
while not Eof(alienf) do begin
	read(alienf,alien);
	if ((alien.alientype=1) and (not alien.aliendead)) then inc(i1);
	end;
countferrengis:=i1;
close(alienf);
end;

function countaliens:integer;
var i,i1:integer;
begin
assign(alienf,'aliens.dat');
reset(alienf);
i1:=0;
while not Eof(alienf) do begin
	read(alienf,alien);
	if ((alien.alientype=4) and (not alien.aliendead)) then inc(i1);
	end;
countaliens:=i1;
close(alienf);
end;

function countunknown:integer;
var i,i1:integer;
begin
assign(alienf,'aliens.dat');
reset(alienf);
i1:=0;
while not Eof(alienf) do begin
	read(alienf,alien);
	if ((alien.alientype=5) and (not alien.aliendead)) then inc(i1);
	end;
countunknown:=i1;
close(alienf);
end;

function countklingons:integer;
var i,i1:integer;
begin
assign(alienf,'aliens.dat');
reset(alienf);
i1:=0;
while not Eof(alienf) do begin
	read(alienf,alien);
	if ((alien.alientype=2) and (not alien.aliendead)) then inc(i1);
	end;
countklingons:=i1;
close(alienf);
end;

function countspacepirates:integer;
var i,i1:integer;
begin
assign(alienf,'aliens.dat');
reset(alienf);
i1:=0;
while not Eof(alienf) do begin
	read(alienf,alien);
	if ((alien.alientype=3) and (not alien.aliendead)) then inc(i1);
	end;
countspacepirates:=i1;
close(alienf);
end;



procedure checkstuff(sectornum2:integer);
begin
{Mines go here}
{Fighters go here}
{Quasar Cannons go here}
{Other goes here}



end;


function howmany(fighterclass:byte;fighterfunction:byte):longint;
var s:string;
    i:longint;
    code:integer;
label 7,8;
begin
clrscr; cscrn;
usernow.fighters1:=usernow.fighters1+sectornow.f1;
usernow.fighters2:=usernow.fighters2+sectornow.f2;
usernow.fighters3:=usernow.fighters3+sectornow.f3;
writeuser;
if (fighterclass=1) then begin
	scs('You have '+i2s(usernow.Fighters1)+' total Class 1 fighters.',true);
	end;
if (fighterclass=2) then begin
	scs('You have '+i2s(usernow.Fighters2)+' total Class 2 fighters.',true);
	end;
if (fighterclass=3) then begin
	scs('You have '+i2s(usernow.Fighters3)+' total Class 3 fighters.',true);
	end;
scs('Deploy how many of these as '+fact[fighterfunction]+'? ',false);
s:=getstring(true);
val(s,i,code);
{if (s='0') then begin howmany:=0; goto 7; end;}
if (Code<>0) then begin howmany:=0; goto 7; end;
if (fighterclass=1) then begin
	if ((i>usernow.Fighters1) or (i<0)) then begin howmany:=0; goto 7; end;
	howmany:=i;
	goto 7;	
	end;
if (fighterclass=2) then begin
	if ((i>usernow.Fighters2) or (i<0)) then begin howmany:=0; goto 7; end;
	howmany:=i;
	goto 7;	
	end;
if (fighterclass=3) then begin
	if ((i>usernow.Fighters3) or (i<0)) then begin howmany:=0; goto 7; end;
	howmany:=i;
	goto 7;	
	end;
7:
end;

function removefighters(hits:longint):boolean;
var i,i2,i3:longint;
    hitsleft:longint;
label 1,2,3,4,5,6,7,99;
begin
hitsleft:=hits;
if (usernow.shields>=hitsleft) then begin
	usernow.shields:=usernow.shields-hitsleft;
	scs('You lost '+i2s(hitsleft)+' shields...',true);
	hitsleft:=0;
	writeuser;		
	removefighters:=false;
	goto 99;
	end;
hitsleft:=hitsleft-usernow.shields;
usernow.shields:=0;
if (((usernow.fighters2)*5)>=hitsleft) then begin
	usernow.fighters2:=usernow.fighters2-(hitsleft div 5);
	scs('You lost '+i2s((hitsleft div 5))+' Class 2 Fighters...',true);
	hitsleft:=0;
	writeuser;
	removefighters:=false;
	goto 99;	
	end;
hitsleft:=hitsleft-(usernow.fighters2*5);
usernow.fighters2:=0;
if (((usernow.fighters1))>=hitsleft) then begin
	usernow.fighters1:=usernow.fighters1-(hitsleft);
	scs('You lost '+i2s((hitsleft))+' Class 1 Fighters...',true);
	hitsleft:=0;
	writeuser;
	removefighters:=false;
	goto 99;	
	end;
hitsleft:=hitsleft-(usernow.fighters1);
usernow.fighters1:=0;
if (((usernow.fighters3)*20)>=hitsleft) then begin
	usernow.fighters1:=usernow.fighters1-(hitsleft div 20);
	scs('You lost '+i2s((hitsleft) div 20)+' Class 3 Fighters...',true);
	hitsleft:=0;
	writeuser;
	removefighters:=false;
	goto 99;	
	end;
hitsleft:=hitsleft-(usernow.fighters3*20);
usernow.fighters3:=0;
if (((usernow.Theforce)*100)>=hitsleft) then begin
	usernow.theforce:=usernow.theforce-(hitsleft div 100);
	scs('You lost '+i2s((hitsleft) div 100)+' points of The Force...',true);
	hitsleft:=0;
	writeuser;
	removefighters:=false;
	goto 99;	
	end;
removefighters:=true;
99:
end;

procedure fighterops;
var c:string;
	code:integer;
	i,i1,i2,i3,i4,i5,i6:longint;
	d,e:char;
	fighterclass:byte;
	amt:longint;
label 1,2,3,4,5,6,7,8,99;
begin
cscrn; clrscr;
scs('Class 1,2 or 3? ',false);
d:=getchar;
clrscr; cscrn;
if ((d<>'1') and (d<>'2') and (d<>'3')) then goto 99;
val(d,fighterclass,code);
{fighterclass:=ord(d);}
sendscreengg('FOPS.sw',local);
c:=getstring(true);
if (c='1') then begin
	amt:=howmany(fighterclass,1);
        if (amt<0) then goto 99;
	if (fighterclass=1) then usernow.fighters1:=usernow.fighters1-amt;
	if (fighterclass=2) then usernow.fighters2:=usernow.fighters2-amt;	
	if (fighterclass=3) then usernow.fighters3:=usernow.fighters3-amt;
	if (fighterclass=1) then sectornow.f1:=amt;
	if (fighterclass=2) then sectornow.f2:=amt;
	if (fighterclass=3) then sectornow.f3:=amt;		
	if (fighterclass=1) then sectornow.f1actv:=1;
	if (fighterclass=2) then sectornow.f2actv:=1;
	if (fighterclass=3) then sectornow.f3actv:=1;
	sectornow.fbt:=usernow.playernumber;
	writesector;
	writeuser;
	goto 99;
	end;
if (c='2') then begin
	amt:=howmany(fighterclass,2);
        if (amt<0) then goto 99;
        if (fighterclass=1) then usernow.fighters1:=usernow.fighters1-amt;
	if (fighterclass=2) then usernow.fighters2:=usernow.fighters2-amt;	
	if (fighterclass=3) then usernow.fighters3:=usernow.fighters3-amt;
	if (fighterclass=1) then sectornow.f1:=amt;
	if (fighterclass=2) then sectornow.f2:=amt;
	if (fighterclass=3) then sectornow.f3:=amt;		
	if (fighterclass=1) then sectornow.f1actv:=2;
	if (fighterclass=2) then sectornow.f2actv:=2;
	if (fighterclass=3) then sectornow.f3actv:=2;
	sectornow.fbt:=usernow.playernumber;
	writesector;
	writeuser;
	goto 99;
	end;
if (c='3') then begin
	amt:=howmany(fighterclass,3);
        if (amt<0) then goto 99;
	if (fighterclass=1) then usernow.fighters1:=usernow.fighters1-amt;
	if (fighterclass=2) then usernow.fighters2:=usernow.fighters2-amt;	
	if (fighterclass=3) then usernow.fighters3:=usernow.fighters3-amt;
	if (fighterclass=1) then sectornow.f1:=amt;
	if (fighterclass=2) then sectornow.f2:=amt;
	if (fighterclass=3) then sectornow.f3:=amt;		
	if (fighterclass=1) then sectornow.f1actv:=3;
	if (fighterclass=2) then sectornow.f2actv:=3;
	if (fighterclass=3) then sectornow.f3actv:=3;
	sectornow.fbt:=usernow.playernumber;
	writesector;
	writeuser;
	goto 99;
	end;
if (c='4') then begin
	amt:=howmany(fighterclass,4);
	if (amt<0) then goto 99;
        if (fighterclass=1) then usernow.fighters1:=usernow.fighters1-amt;
	if (fighterclass=2) then usernow.fighters2:=usernow.fighters2-amt;	
	if (fighterclass=3) then usernow.fighters3:=usernow.fighters3-amt;
	if (fighterclass=1) then sectornow.f1:=amt;
	if (fighterclass=2) then sectornow.f2:=amt;
	if (fighterclass=3) then sectornow.f3:=amt;		
	if (fighterclass=1) then sectornow.f1actv:=4;
	if (fighterclass=2) then sectornow.f2actv:=4;
	if (fighterclass=3) then sectornow.f3actv:=4;
	sectornow.fbt:=usernow.playernumber;
	writesector;
	writeuser;
	goto 99;
	end;

99:
end;

procedure commands(sectornum2:integer);
var s:string;
	ii,c:char;
	movetosector,code:integer;
label 1,2,3,4,99;
begin
1:
gotoportxy(1,22);
clreolr;
clreol;
scs('Command: ',false);
s:=getstring(true);
val(s,movetosector,code);
if (code<>0) then
			begin
if ((s='Q') or (usernow.turnstoday<=0)) then begin
	writeuser;
	cscrn; clrscr;
        if (usernow.cloak>0) then begin
	scs('Cloaking device available... use it today? ',true);
	c:=getchar;
	if (upcase(c)='Y') then begin
		cloakingdevice(usersectornow,usernow.playernumber);
		end;	
	end;
	writeuser;
	scs('Thanx for playing! Now returning to the BBS...',true);
	halt;
	end;


if (s='U') then begin
	Universestats;
	goto 1;
	end;

if (s='D') then begin 
	dispsector(sectornum2);
        scs('Turns Left: '+i2s(usernow.turnstoday),true);
	goto 1;
	end;
if (s='F') then begin
	if (sectornow.fedspace) then begin
		clrscr; cscrn;
		scs('You cannot deploy fighters in FedSpace!...',false);
		ii:=getchar;
		goto 1;
		end;
	fighterops;
	goto 1;
	end;

if (s='I') then begin
	stats;
	goto 1;
	end;
if (s='?') then begin
	sendscreengg('help.sw',local);
	goto 1;
	end;
			end else begin
        {MOVETOSECTOR}
	if (movetosector>20000) then goto 99;
	if (movetosector<1) then goto 99;
	if (movetosector=usersectornow) then goto 99;
	gotoportxy(1,23); clreolr; clreol;
	scs('Move to sector '+i2s(movetosector)+'? ',false);
	c:=getchar;
	if (upcase(c)='Y') then begin
	removeusersector(usersectornow,usernow.playernumber);
	usersectornow:=MOVE2SEC(Movetosector);
	placeuser(usersectornow,usernow.playernumber,false);
	end;
	goto 99;
	end;
99:

end;

function playername(un:integer):string;
begin
tmpuser(un);
playername:=usertemp.playerhandle;
end;

function planetnameandowner(planetn:longint):string;
var un:longint;
	s1,s2:string;
begin
assign(pf,'planet.dat');
reset(pf);
seek(pf,(planetn-1));
read(pf,planetnow);
un:=planetnow.ownedby;
s1:=planetnow.planetname;
close(pf);
if (planetnow.ownedby=0) then s2:=' (Nobody)' else begin
	assign(user2f,'users.sw');
	reset(user2f);
seek(user2f,(un-1));
	read(user2f,usertemp);
	close(user2f);
s2:=' ('+usertemp.playerhandle+')';
end;
planetnameandowner:=s1+s2;
end;

procedure tmpuser(un:integer);
begin
	assign(user2f,'users.sw');
	reset(user2f);
seek(user2f,(un-1));
	read(user2f,usertemp);
	close(user2f);
end;

procedure ditr2(c:char;msg:boolean);
var i:integer;
    x,y:integer;
    d:char;
label 1,2,3,4,5,6,7;
begin
if (c='1') then scs(i2s(usernow.mines),false);
if (c='5') then scs(i2s(usernow.money),false);
if (c='a') then scs(usernow.shipname,false);
if (c='0') then scs(shipnames[usernow.shipnumber],false);
if (c='b') then scs(i2s(usernow.fighters1),false);
if (c='c') then scs(i2s(usernow.fighters2),false);
if (c='d') then scs(i2s(usernow.fighters3),false);
if (c='e') then scs(i2s(usernow.traders),false);
if (c='f') then scs(i2s(usernow.cloak),false);
if (c='g') then scs(i2s(usernow.shields),false);
if (c='h') then scs(i2s(usernow.carbonites),false);
if (c='i') then scs(scannertypes[usernow.scannertype],false);
if (c='j') then scs(combatscanners[usernow.combatscanner],false);
if (c='k') then scs(planetscanners[usernow.planetscanner],false);
if (c='l') then scs(enginetypes[usernow.enginetype],false);
if (c='m') then scs(i2s(usernow.colonists),false);
if (c='n') then scs(i2s(usernow.totalpeopleinfleet),false);
if (c='o') then scs(ptypes[usernow.planetweapon],false);
if (c='p') then scs(i2s(usernow.stormtroopers),false);
if (c='q') then scs(i2s(usernow.diplomats),false);
if (c='r') then begin
	if (usernow.fastprot) then scs('Active',false) else
	scs('Inactive',false);
	end;
if (c='x') then scs(i2s(usernow.experience),false);
if (c='y') then scs(i2s(usernow.allignment),false);
if (c='z') then scs(i2s(usernow.theforce),false);
end;				
procedure ditr3(c:char;msg:boolean);
var i:integer;
    x,y:integer;
    d:char;
label 1,2,3,4,5,6;
begin
if (c='s') then scs(i2s(sectnum),false);
if (c='1') then begin
	if (sectornow.planet[1]=0) then scs('None',false) else
	begin
	scs(planetnameandowner(sectornow.planet[1]),false);
	{PLANET INFO GOES HERE}
	end;	
	end;
if (c='2') then begin
	if (sectornow.planet[2]=0) then begin end else
	begin
	scs(planetnameandowner(sectornow.planet[2]),false);
	{PLANET INFO GOES HERE}
	end;
	end;
if (c='3') then begin
	if (sectornow.planet[3]=0) then begin end else
	begin
	scs(planetnameandowner(sectornow.planet[3]),false);
	{PLANET INFO GOES HERE}
	end;
	end;
if (c='4') then begin
	if (sectornow.planet[4]=0) then begin end else
	begin
	scs(planetnameandowner(sectornow.planet[4]),false);
	{PLANET INFO GOES HERE}
	end;
	end;
if (c='5') then begin
	if (sectornow.planet[5]=0) then begin end else
	begin
	scs(planetnameandowner(sectornow.planet[5]),false);
	{PLANET INFO GOES HERE}
	end;
	end;
if (c='t') then begin
	if ((sectornow.playerz[1]<>0) and (sectornow.playerz[1]<>usernow.playernumber)) then begin tmpuser(sectornow.playerz[1]);
	if (usertemp.cloakon) then begin scs('Cloaked User',false);
	goto 1;
	end;
	end;
	
	if ((sectornow.playerz[1]=0) or (sectornow.playerz[1]=usernow.playernumber)) then begin scs('None',false); end else
	begin
	scs(playername(sectornow.playerz[1]),false);
	end;
	1:
	end;
if (c='T') then begin
	if ((sectornow.playerz[2]<>0) and (sectornow.playerz[2]<>usernow.playernumber)) then begin tmpuser(sectornow.playerz[2]);
	if (usertemp.cloakon) then begin scs('Cloaked User',false); 
	goto 2;				
	end;
	end;
	if ((sectornow.playerz[2]=0) or (sectornow.playerz[2]=usernow.playernumber))  then begin end else
	begin
	scs(playername(sectornow.playerz[2]),false);	{PLAYER INFO GOES HERE}
	end;
	2:
	end;
if (c='6') then begin           						   			
	if ((sectornow.playerz[3]<>0) and (sectornow.playerz[3]<>usernow.playernumber)) then begin tmpuser(sectornow.playerz[3]);
	if (usertemp.cloakon) then begin scs('Cloaked User',false);
	goto 3;
	end;
	end;	
	if ((sectornow.playerz[3]=0) or (sectornow.playerz[3]=usernow.playernumber))  then begin end else
	begin       			
	scs(playername(sectornow.playerz[3]),false);	{PLAYER INFO GOES HERE}
	end;
	3:
	end;
if (c='7') then begin  						         						   			
	if ((sectornow.playerz[4]<>0) and (sectornow.playerz[4]<>usernow.playernumber)) then begin tmpuser(sectornow.playerz[4]);
	if (usertemp.cloakon) then begin scs('Cloaked User',false);
	goto 4;
	end;
	end;
	if ((sectornow.playerz[4]=0) or (sectornow.playerz[4]=usernow.playernumber))  then begin end else
	begin				
	scs(playername(sectornow.playerz[4]),false);	{PLAYER INFO GOES HERE}
	end;
	4:
	end;
if (c='8') then begin           					   						
	if ((sectornow.playerz[5]<>0) and (sectornow.playerz[5]<>usernow.playernumber)) then begin tmpuser(sectornow.playerz[5]);
	if (usertemp.cloakon) then begin scs('Cloaked User',false);
	goto 5;
	end;
	end;
	if ((sectornow.playerz[5]=0) or (sectornow.playerz[5]=usernow.playernumber))  then begin end else
	begin				
	scs(playername(sectornow.playerz[5]),false);
	{PLAYER INFO GOES HERE}
	end;
	5:
	end;
if (c='9') then begin
	if (sectornow.minez=0) then begin scs('None',false); end else
	begin
	scs((i2s(sectornow.minez)+', belongs to '),false);
	scs(playername(sectornow.minez),true);
	end;
	end;
end;				


procedure sendscreengg(s:string;local:boolean);
label 1;
var f:text;
    g:string;
    k:char;
    c:char;
label 11,2;
begin
com_flush_rx;
{$I-}
assign(f,s);
reset(f);
close(f);
{$I+}
if IORESULT=0 then begin
   assign(f,s);
   reset(f);
   while not Eof(f) do begin
         if not local then
         repeat until com_tx_ready;
         read(f,k);
         if (k='|') then begin
            read(f,c);
            ditr2(c,false);
            goto 11;
            end;
         if ((not keypressed) and ((local) or (com_rx_empty))) then begin dosansi(k);
         if not local then com_tx(k) end else begin close(f); goto 1; end;
         11:
         end;
   close(f);
   end;
1:
if not com_carrier then begin dohangup; exit; end;
com_flush_rx;
while keypressed do k:=readkey;
end;

procedure ss5(s:string);
label 1;
var f:text;
    g:string;
    k:char;
    c:char;
label 11,2;
begin
com_flush_rx;
{$I-}
assign(f,s);
reset(f);
close(f);
{$I+}
if IORESULT=0 then begin
   assign(f,s);
   reset(f);
   while not Eof(f) do begin
         if not local then
         repeat until com_tx_ready;
         read(f,k);
         if (k='|') then begin
            read(f,c);
            ditr3(c,false);
            goto 11;
            end;
         if ((not keypressed) and ((local) or (com_rx_empty))) then begin dosansi(k);
         if not local then com_tx(k) end else begin close(f); goto 1; end;
         11:
         end;
   close(f);
   end;
1:
if not com_carrier then begin dohangup; exit; end;
com_flush_rx;
while keypressed do k:=readkey;
end;

procedure stats;
begin
sendscreengg('stats.sw',local);
c:=getchar;
end;

function finduser(un:integer):integer;
var i,i2:integer;
    ts:sector;
label 1,2,3;
begin
cscrn; clrscr;
scs('Searching Universe for your fleet...',false);
assign(sf,'sector.dat');
reset(sf);
for i:=1 to 20000 do begin
	read(sf,ts);
	for i2:=1 to 5 do begin
	if (ts.playerz[i2]=un) then begin
		finduser:=i; goto 1;
		end;
	
	end;
	end;
1:
close(sf);
clrscr; cscrn;
end;

procedure removeusersector(sectr:integer;un:integer);
var ts:sector;
    i,i2:integer;
label 1,2,3,4;
begin
assign(sf,'sector.dat');
reset(sf);
seek(sf,(sectr-1));
read(sf,ts);
if (ts.playerz[1]=usernow.playernumber) then begin
	ts.playerz[1]:=0;
	goto 1;
	end;
if (ts.playerz[2]=usernow.playernumber) then begin
	ts.playerz[2]:=0;
	goto 1;
	end;
if (ts.playerz[3]=usernow.playernumber) then begin
	ts.playerz[3]:=0;
	goto 1;
	end;
if (ts.playerz[4]=usernow.playernumber) then begin
	ts.playerz[4]:=0;
	goto 1;
	end;
if (ts.playerz[5]=usernow.playernumber) then begin
	ts.playerz[5]:=0;
	goto 1;
	end;

1:
seek(sf,(sectr-1));
write(sf,ts);
close(sf);
end;

procedure placeuser(sectr:integer;un:integer;cloakn:boolean);
var ts:sector;
    i,i2:integer;
label 1,2,3,4;
begin
assign(sf,'sector.dat');
reset(sf);
seek(sf,(sectr-1));
read(sf,ts);
if ((ts.playerz[1]=0) or (ts.playerz[1]=usernow.playernumber)) then begin
	ts.playerz[1]:=un;
	goto 1;
	end;
if ((ts.playerz[2]=0) or (ts.playerz[2]=usernow.playernumber)) then begin
	ts.playerz[2]:=un;
	goto 1;
	end;	
if ((ts.playerz[3]=0) or (ts.playerz[3]=usernow.playernumber)) then begin
	ts.playerz[3]:=un;
	goto 1;
	end;
if ((ts.playerz[4]=0) or (ts.playerz[4]=usernow.playernumber)) then begin
	ts.playerz[4]:=un;
	goto 1;
	end;
if ((ts.playerz[5]=0) or (ts.playerz[5]=usernow.playernumber)) then begin
	ts.playerz[5]:=un;
	goto 1;
	end;
1:
seek(sf,(sectr-1));
write(sf,ts);
close(sf);                end;

procedure getsector(sectornum:integer);
begin
assign(sf,'sector.dat');
reset(sf);
seek(sf,(sectornum-1));
read(sf,sectornow);
close(sf);
end;

procedure dispsector(sectornum:integer);
var i:integer;
begin
assign(sf,'sector.dat');
reset(sf);
seek(sf,(sectornum-1));
read(sf,sectornow);
close(sf);
sectnum:=sectornum;
ss5('sector.ans');
if (sectornow.starports<>0) then begin
	scs('Starport Class '+i2s(sectornow.starports)+' present.',true);
	end;
if (sectornow.fedspace) then begin
	scs('This Sector is in Federation Space.',true);
	end;
if (sectornow.F1<>0) then begin
	scs(fact[sectornow.F1actv]+' Class 1 Fighters: '+i2s(sectornow.F1)+' - Belong to '+playername(sectornow.fbt),true);
	end;
if (sectornow.F2<>0) then begin
	scs(fact[sectornow.F2actv]+' Class 2 Fighters: '+i2s(sectornow.F2)+' - Belong to '+playername(sectornow.fbt),true);
	end;
if (sectornow.F3<>0) then begin
	scs(fact[sectornow.F3actv]+' Class 3 Fighters: '+i2s(sectornow.F3)+' - Belong to '+playername(sectornow.fbt),true);
	end;
{scs('Warps Lead to: ',false);
for i:=1 to 5 do scs(i2s(sectornow.nebulas[i])+' / ',false);}
end;

procedure writecfg;
begin
assign(cfgf,'sre.cfg');
rewrite(cfgf);
write(cfgf,cfg);
close(cfgf);
end;

procedure writeuser;
begin
assign(usernowf,'users.sw');
reset(usernowf);
seek(usernowf,(usernow.playernumber-1));
write(usernowf,usernow);
close(usernowf);
end;



procedure playgame;


label 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
var y,m,d,dow:word;
begin
randomize;
abort:=false;

usersectornow:=finduser(usernow.playernumber);
getdate(y,m,d,dow);
if (usernow.lastplayed<>d) then begin
	usernow.lastplayed:=d;
	usernow.turnstoday:=usernow.turnsperday; {500,000}
	usernow.cloakon:=false;
	end;
writeuser;
1:
dispsector(usersectornow);
scs('Turns Left: '+i2s(usernow.turnstoday),true);
checkstuff(usersectornow);
commands(usersectornow);
goto 1;
end;





procedure inituser(Userspot:integer);
var s,s2:string;
    i,i2:integer;
    c,c2:char;

begin
usernow.playernumber:=Userspot;
usernow.BBSName:=bbsname;
sendscreen('welc.sw',local);
scs('',true);
with usernow do begin
Playerhandle:=getstring(false);
if (length(playerhandle)<2) then halt;
mines:=0;
shipname:=playerhandle;
shipnumber:=1;
Money:=1000000;
BankMoney:=0;
BankLoan:=0;
oncorp:=0;
lastplayed:=55;
SuperStock:=0;
fighters1:=1000;
fighters2:=500;
fighters3:=25;
traders:=50;
cloak:=2;
shields:=1000;
carbonites:=5;
scannertype:=1;
combatscanner:=1;
planetscanner:=1;
enginetype:=1;
colonists:=0;
totalpeopleinfleet:=5000;
planetweapon:=1;
stormtroopers:=500;
diplomats:=50;
cloakon:=false;
ANSI:=true;
FASTPROT:=false;
Turnsperday:=500000;
Turnstoday:=500000;
Blownup:=false;
reward:=500;
Experience:=10;
Allignment:=0;
TheForce:=1;
end;
if (userspot=1) then begin
   assign(usernowf,'users.sw');
   rewrite(usernowf);
   write(usernowf,usernow);
   close(usernowf);
   end;
if (userspot<>1) then begin
   assign(usernowf,'users.sw');
   reset(usernowf);
   seek(usernowf,userspot-1);
   write(usernowf,usernow);
   close(usernowf);
   end;
placeuser(1,usernow.playernumber,false);
end;

procedure initplanet(planet1:boolean;planetnum:longint;planetnm:string);
begin
with planetnow do begin
Planetname:=planetnm;
numberp:=planetnum;
if planet1 then Createdby:='Unknown' else Createdby:=usernow.playerhandle;
if planet1 then Ownedby:=0 else Ownedby:=usernow.playernumber;
F1:=0;
F2:=0;
F3:=0;
FOL:=0;		{Between 0 and 254 of fighter offensive lvl}
PlantaryDefense:=1;   
PlanetType:=5;;
if planet1 then InhabitationLevel:=5 else InhabitationLevel:=1;
if planet1 then LoyalColonists:=5000000 else LoyalColonists:=0;
RebelColonists:=0;
Diplomats:=0;
StormTroopers:=0;
Shields:=0;
ForceGlobe:=0;
Computerodds:=2;	{If citadel, this is combat odds for fighters}
ProductionMoney:=0;{money production/day}
ProductionFU:=0;	{Production of Fighter Units}
PlanetaryBlaster:=false;{Planetary Quasar Cannon}
Sectorlevel:=0;	{0-254 of sector level}
Fuel:=0;		{Fuel of Blaster&Transwrp}
Atmoslevel:=0;	{0-254 of Atmospheric Level}
Transwarp:=false;	{Planetary Transwarp}
end;
if (planet1) then begin
	assign(pf,'planet.dat');
	rewrite(pf);
	write(pf,planetnow);
	close(pf);
	end else begin
assign(pf,'planet.dat');
reset(pf);

close(pf);
end;
end;


procedure rstsec(sectornum:integer;hstarport:boolean);
var q:integer;
    g1,g2,g3,g4,g5:integer;
label 1;
begin
randomize;
with sectornow do begin
PortClass:=random(20);		{Port Type for trading}
Special:=random(500);			{Special Stuff RESERVED}

minezplayer:=0;
for q:=1 to 5 do Planet[q]:=0;	{Stores Planet Numbers 1-5}
if (sectornum=1) then begin
	initplanet(true,1,'Earth');
	planet[1]:=1;
	end;
	if (sectornum=1) then begin
	g1:=2;g2:=3;g3:=4;g4:=5;g5:=6;
	goto 1;
	end;
	if (sectornum=19997) then begin
	g1:=19998; g2:=19999; g3:=20000; g4:=19996; g5:=19995;
	goto 1;
	end;
	if (sectornum=19998) then begin
	g1:=19999; g2:=20000; g3:=19994; g4:=19996; g5:=19995;
	goto 1;
	end;
	if (sectornum=19999) then begin
	g1:=19993; g2:=20000; g3:=19994; g4:=19996; g5:=19995;
	goto 1;
	end;		
	if (sectornum=20000) then begin
	g1:=19993; g2:=19992; g3:=19994; g4:=19996; g5:=19995;
	goto 1;
	end;
	  g1:=sectornum-1;
	  g2:=sectornum+1;
	  g3:=sectornum+2;
	  g4:=sectornum+3;
	  g5:=sectornum+4;		
	
	1:
	nebulas[1]:=g1;
	nebulas[2]:=g2;
	nebulas[3]:=g3;
	nebulas[4]:=g4;
	nebulas[5]:=g5;
	if hstarport then starports:=random(5) else starports:=0;			{Starport Class (0 if none)}
	F1:=0;			{Fighters1 in sector}
	F1Actv:=0;			{Fighters1 behavior}
	F2:=0;			{..}
	F2Actv:=0;
	F3:=0;
	F3Actv:=0;
	FBT:=0;			{Fighters belong to play #}
	Minez:=0;			{Mines in sector}
	for q:=1 to 5 do Playerz[q]:=0; {Play # in sector}
	if ((sectornum<10) or (hstarport)) then	Fedspace:=true else fedspace:=false;
	stealmoney:=5000;		{Money avail to steal at port}
	end;
end;

procedure rstalien(sectornum:integer);
var q:integer;
    g1,g2,g3,g4,g5:integer;
label 1;
begin
randomize;
with alien do begin
alientype:=random(5);
while (alientype=0) do alientype:=random(5);		{Port Type for trading}
aliennumber:=sectornum;			{Special Stuff RESERVED}
experience:=random(4000);
money:=(random(30000)+random(30000)+random(30000)+random(30000)+random(30000));
money:=money+(random(30000)+random(30000)+random(30000)+random(30000)+random(30000)+(aliennumber*1250));
fighters1:=((experience div 5)+(money div 500)+random(200));
fighters2:=((experience div 20)+(money div 900)+random(100));
fighters3:=((experience div 50)+(money div 1200)+random(50));      
cargoships:=((money div 25000) + random(20));
shields:=((money div 450)+random(100));
aliendead:=false;
end;
end;


procedure initsectors;
var i,i1,i2,i3,i4,i5:integer;
    s:array [1..50] of integer;
label 1,2,3,4;
begin
randomize;
for i1:=1 to 50 do begin
	s[i1]:=random(19999);
	if (s[i1]=0) then s[i1]:=20000;
	end;
clrscr;
writeln('Sector data not found... Initializing Universe...');
assign(sf,'sector.dat');
rewrite(sf);
for i:=1 to 20000 do begin
	for i5:=1 to 50 do begin
	if (i=s[i5]) then begin rstsec(i,true); goto 4; end;
	end;	
	rstsec(i,false);
	4:
	writeat(1,3,15,0,'Finished Sector '+i2s(i)+'.');
	write(sf,sectornow);
	end;

close(sf);
{assign(sf,'sector.dat');
reset(sf);
clrscr;
writeln('Searching for Startports...');
for i:=1 to 20000 do begin
	read(sf,sectornow);
	if (sectornow.starports<>0) then begin
writeln('Sector '+i2s((filepos(sf)+1))+' has a Starport class '+i2s(sectornow.starports)+'.');
	end;
	end;	
	
close(sf);}
end;

procedure initaliens;
var i,i1,i2,i3,i4,i5:integer;
    s:array [1..50] of integer;
label 1,2,3,4;
begin
randomize;
clrscr;
writeln('Alien data not found... Initializing Aliens 0-500...');
assign(alienf,'aliens.dat');
rewrite(alienf);
for i:=1 to 500 do begin
	rstalien(i);
	4:
	writeat(1,3,15,0,'Finished Alien #'+i2s(i)+'.');
	write(alienf,alien);
	end;

close(alienf);

end;

procedure findstarport;
begin
assign(sf,'sector.dat');
reset(sf);
clrscr;
writeln('Searching for Startports...');
for i:=1 to 20000 do begin
	read(sf,sectornow);
	if (sectornow.starports<>0) then begin
writeln('S'+i2s((filepos(sf)))+'-'+i2s(sectornow.starports)+'.. ');
	end;
	end;	
	
close(sf);
end;

function totplanets:longint;
var i:longint;
begin
assign(pf,'planet.dat');
reset(pf);
i:=0;
while not Eof(pf) do begin
	read(pf,planetnow);
	inc(i);
	end;
close(pf);
totplanets:=i;
end;

procedure universestats;
var i,i1,i2,i3,i4,i5,i6:longint;
begin
clrscr; cscrn;
scs('Please wait... generating universe information...',false);
i6:=0;
assign(user2f,'users.sw');
reset(user2f);
while not Eof(user2f) do begin
	read(user2f,usertemp);
	inc(i6);
	end;
	close(user2f);
i1:=countferrengis;
i2:=countaliens;
i3:=countspacepirates;
i4:=countunknown;		{These appear 25% after other destroyed}
i5:=countKlingons;

clrscr; cscrn;
scs('There are '+i2s(i1)+' Ferrengi in the Universe',true);
scs('There are '+i2s(i2)+' Aliens in the Universe',true);
scs('There are '+i2s(i3)+' Space Pirates in the Universe',true);
scs('There are '+i2s(i4)+' Unknown Vessels in the Universe',true);
scs('There are '+i2s(i5)+' Klingons in the Universe',true);
i:=i1+i2+i3+i4+i5;
scs('There are '+i2s(i)+' Total Non-Player Ships in the Universe',true);
scs('There are '+i2s(i6)+' Human Players in the current game.',true);
scs('There are 20,000 Star Sectors active and 20,000 Trading ports',true);
scs('There are 50 Scattered Starbases throughout the Universe',true);
scs('There are '+i2s(totplanets)+' Planets in the Universe',true);

end;

end.