/*
**  --- XYZ_IO.C ---
**
**  Called by protocol code. Uses WIN_IO & LOGGER.
**
**  The protocol code's view of screen output is a single line
**  buffer of specified length. This code is written in terms of
**  the SESSION.C code, but can be re-written to suite.
**
**     xyzPutChar : Prints a character.
**   xyzPutString : Prints a string.
**  xyzPutInteger : Prints (unsigned) integer.
**     xyzPutLong : Prints (unsigned) long.
**   xyzPutHexInt : Prints hexidecimal integer.
**  xyzPutHexLong : Prints hexidecimal long.
**       xyzClear : Clears the line.
**   xyzSetString : Clears line then writes string.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "xyz_io.h"
#include "session.h"
#include "bbs.h"

static char Buffer[40];

void xyzPutChar(int Channel,unsigned char Chr)
{
 ssnPostChar(Channel,Chr);
}

void xyzPutString(int Channel,char *String)
{
 ssnPostString(Channel,String);
}

void xyzClear(int Channel)
{
 ssnPostChar(Channel,'\n');
}

void xyzSetString(int Channel,char *String)
{xyzClear(Channel);
 xyzPutString(Channel,String);
}

void xyzPutInteger(int Channel,int Value)
{char *Ptr;
 Ptr = &Buffer[0];
 if(Value==0)
   {xyzPutChar(Channel,'0');
    return;
   }
 sprintf(Ptr,"%d",Value);
 while(1)
   {if(*Ptr!='0') break;
    Ptr++;
   }
 xyzPutString(Channel,Ptr);
}

void xyzPutLong(int Channel,long Value)
{char *Ptr;
 Ptr = &Buffer[0];
 if(Value==0)
   {xyzPutChar(Channel,'0');
    return;
   }
 sprintf(Ptr,"%ld",Value);
 while(1)
   {if(*Ptr!='0') break;
    Ptr++;
   }
 xyzPutString(Channel,Ptr);
}

void xyzPutHexInt(int Channel,int Value)
{
 sprintf(Buffer,"%x",Value);
 xyzPutString(Channel,Buffer);
}

void xyzPutHexLong(int Channel,long Value)
{
 sprintf(Buffer,"%ld",Value);
 xyzPutString(Channel,Buffer);
}
