/* sio.c */

#include <stdio.h>
#include "dos_io.h"
#include "bbs.h"
#include "win_io.h"
#include "sio.h"

#define FALSE 0
#define TRUE  !FALSE

#define BYTE unsigned char

#define ULC  218
#define URC  191
#define LLC  192
#define LRC  217
#define VER  179
#define HOR  196
#define LC   195
#define RC   180
#define TC   194
#define BC   193

#define NORMAL 7

void sioInit(void)
{int Row;
 int Col;
 /* top line */
 Position(0,0); AttrWrite((BYTE)ULC,(BYTE)NORMAL);
 for(Col=1;Col<79;Col++)
    {Position(0,Col);
     AttrWrite((BYTE)HOR,(BYTE)NORMAL);
    }
 Position(0,79);
 AttrWrite((BYTE)URC,(BYTE)NORMAL);
 /* control area */
 for(Row=1;Row<=11;Row++)
   {Position((BYTE)Row,0);  AttrWrite((BYTE)VER,(BYTE)NORMAL);
    Position((BYTE)Row,79); AttrWrite((BYTE)VER,(BYTE)NORMAL);
   }
 /* second line */
 Position(12,0); AttrWrite((BYTE)LC,(BYTE)NORMAL);
 for(Col=1;Col<79;Col++)
   {Position(12,Col);
    AttrWrite((BYTE)HOR,(BYTE)NORMAL);
   }
 Position(12,79);
 AttrWrite((BYTE)RC,(BYTE)NORMAL);
 /* status area */
 for(Row=13;Row<=16;Row++)
   {Position((BYTE)Row,0);  AttrWrite((BYTE)VER,(BYTE)NORMAL);
    Position((BYTE)Row,79); AttrWrite((BYTE)VER,(BYTE)NORMAL);
   }
 /* third line */
 Position(17,0); AttrWrite((BYTE)LC,(BYTE)NORMAL);
 for(Col=1;Col<79;Col++)
   {Position(17,Col);
    AttrWrite((BYTE)HOR,(BYTE)NORMAL);
   }
 Position(17,79);
 AttrWrite((BYTE)RC,(BYTE)NORMAL);
 /* select & caller area */
 for(Row=18;Row<=23;Row++)
   {Position((BYTE)Row,0);  AttrWrite((BYTE)VER,(BYTE)NORMAL);
    Position((BYTE)Row,19); AttrWrite((BYTE)VER,(BYTE)NORMAL);
    Position((BYTE)Row,79); AttrWrite((BYTE)VER,(BYTE)NORMAL);
   }
 Position(17,19); AttrWrite((BYTE)TC,(BYTE)NORMAL);
 /* fourth line */
 Position(24,0); AttrWrite((BYTE)LLC,(BYTE)NORMAL);
 for(Col=1;Col<79;Col++)
   {Position(24,Col);
    AttrWrite((BYTE)HOR,(BYTE)NORMAL);
   }
 Position(24,79);
 AttrWrite((BYTE)LRC,(BYTE)NORMAL);
 Position(24,19); AttrWrite((BYTE)BC,(BYTE)NORMAL);
}

void sioStatus(int Port,char Stat)
{int Row;
 int Col;
 char Temp[10];
 Row = Port % 4;
 Col = 1 + 9 * (Port/4);
 WinSetPos(STATUS_WIN,Row,Col);
 sprintf(Temp,"COM%d:%c",1+Port,Stat);
 WinPutString(STATUS_WIN,Temp);
}

void sioSelect(int Port,char *User,char Protocol)
{char Temp[25];
 /* show port */
 WinSetPos(SELECT_WIN,1,1);
 sprintf(Temp,"Port : COM%d",1+Port);
 WinPutString(SELECT_WIN,Temp);
 /* show user name */
 WinSetPos(SELECT_WIN,2,8);
 WinPutString(SELECT_WIN,"        ");
 WinSetPos(SELECT_WIN,2,1);
 sprintf(Temp,"User : %s", User);
 WinPutString(SELECT_WIN,Temp);
 /* show protocol */
 WinSetPos(SELECT_WIN,3,1);
 sprintf(Temp,"Prot : %c", Protocol);
 WinPutString(SELECT_WIN,Temp);
}
