/*
**  --- LOGGER.C ---
**
**        LogInit : Initializes logger
**        LogOpen : Opens log file.
**       LogClose : Closes log file.
**     LogPutChar : Prints a character.
**   LogPutString : Prints a string.
**
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <io.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "bbs.h"
#include "logger.h"

static int FileID = -1;

#define BYTE  unsigned char
#define FALSE 0
#define TRUE  !FALSE
#define STRING_SIZE 64
#define CHANNELS NBR_PORTS

#define CR 0x0d
#define LF 0x0a

typedef struct StringListTag
  {BYTE Pos;
   char Text[STRING_SIZE];
  } StringListType;

static StringListType *StringPtr;
static StringListType *StringList[CHANNELS];
static int NbrChannels = 0;
static char Temp[80];
static char EOL = LF;

/*** PRIVATE ***/

static void FlushString(int Channel)
{int Pos;
 if(FileID>0)
   {StringPtr = StringList[Channel];
    if(StringPtr==NULL)
      {printf("[StringList(%d)==NULL]",Channel);
       return;
      }
    Pos = StringPtr->Pos;
    if(Pos>0)
      {StringPtr->Text[Pos] = '\0';
       sprintf(Temp,"%d: %s",Channel,&StringPtr->Text[0]);
       write(FileID,Temp,strlen(Temp));
       write(FileID,&EOL,1);
       StringPtr->Pos = 0;
      }
   }
}

/*** PUBLIC ***/

void LogDump(int Channel)
{if(FileID>0)
   {StringPtr = StringList[Channel];
    printf("[[LogDump: Chan=%d FileID=%d Pos=%d Text='%s']]\n",
      Channel,FileID,StringPtr->Pos,&StringPtr->Text[0]);
   }
}

int LogOpen(int NbrChans,char *Filename)
{int i;
 NbrChannels = NbrChans;
 for(i=0;i<NbrChannels;i++)
   {StringPtr = (StringListType *) malloc(sizeof(struct StringListTag));
    if(StringPtr==NULL)
       {puts("LogInit: Cannot malloc");
        return FALSE;
       }
    StringList[i] = StringPtr;
    StringList[i]->Text[0] = '\0';
    StringList[i]->Pos = 0;
   }
 /* create the log file */
#if 0
 FileID = creat(Filename,S_IWRITE);
#else
 FileID = open(Filename,O_WRONLY|O_CREAT|O_TRUNC|O_TEXT,S_IWRITE);
#endif
 return TRUE;
}

void LogClose(void)
{int i;
 if(FileID>0)
   {for(i=0;i<NbrChannels;i++) FlushString(i);
    close(FileID);
    FileID = -1;
   }
}

void LogPutChar(int Channel,BYTE Chr)
{if(Channel>=NbrChannels) return;
 StringPtr = StringList[Channel];
 if(Chr==LF) Chr = '\0';
 if(StringPtr->Pos<STRING_SIZE)
   {StringPtr->Text[StringPtr->Pos++] = Chr;
   }
 if(Chr=='\0') FlushString(Channel);
}

void LogPutString(int Channel,char *String)
{int i;
 int Len;
 Len = strlen(String);
 for(i=0;i<Len;i++) LogPutChar(Channel,String[i]);
}
