/* crc.c */

#include "crc.h"

#define BYTE unsigned char
#define WORD unsigned int
#define LONG unsigned long

#define CRC16POLY 0x1021
#define CRC32POLY 0xEDB88320L
#define FACTOR    0x00FFFFFF

static int  Init16Flag = 0;
static WORD Crc16Table[256];

static int  Init32Flag = 0;
static LONG Crc32Table[256];

static int Crc16Byte(WORD Octet,WORD Accum)
{int j;
 Octet <<= 8;
 for(j=1;j<=8;j++)
   {if((Octet ^ Accum) & 0x8000)
      {Accum <<= 1;
       Accum ^= CRC16POLY;
      }
    else Accum <<= 1;
    Octet <<= 1;
  }
  return Accum;
}

static void InitCrc16(void)
{int i;
 Init16Flag = 1;
 for(i=0;i<256;i++)
    Crc16Table[i] = Crc16Byte(i,0);
}

static LONG Crc32Byte(BYTE Octet, LONG Crc)
{int j;
 Crc = 0x00ff & (Crc ^ Octet);
 for(j=0;j<8;j++)
   {if(0x01 & Crc)
      {
       Crc >>= 1;
       Crc = Crc ^ (long)CRC32POLY;
      }
    else Crc >>= 1;
   }
 return Crc;
}

/* initialize CRC-32 table */

static void Init32Crc(void)
{int i;
 Init32Flag = 1;
 for(i=0;i<256;i++)
   {Crc32Table[i] = Crc32Byte((BYTE)i,0L);
   }
}

/* compute CRC-16 */

int ComputeCrc16(BYTE Octet,WORD Crc)
{if(!Init16Flag) InitCrc16();
 /* compute CRC-16 */
 return Crc16Table[0x00ff & (Crc>>8)] ^ (Crc<<8) ^ Octet;
}

/* compute CRC-16 (2nd flavor) */

int ComputeCRC(BYTE Octet,WORD Crc)
{if(!Init16Flag) InitCrc16();
 /* compute CRC */
 return  (Crc<<8) ^ (Crc16Table[(Crc>>8) ^ Octet]);
}

/* compute CRC-32 */

LONG ComputeCrc32(BYTE Octet,LONG Crc)
{int Index;
 if(!Init32Flag) Init32Crc();
 Index = 0x00ff & (Crc ^ Octet);
 return Crc32Table[Index] ^ ((Crc>>8) & FACTOR);
}
