/* BBS4C */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <conio.h>
#include <malloc.h>
#include "ascii.h"
#include "bbs.h"
#include "buffer.h"
#include "logger.h"
#include "dir_io.h"
#include "dos_io.h"
#include "session.h"
#include "sio.h"
#include "tsd.h"
#include "xyz_mem.h"
#include "pcl4c.h"
#include "win_io.h"
#if USE_XYMODEM
#include "xymodem.h"
#include "xyz_io.h"
#endif

#define FALSE    0
#define TRUE     !FALSE
#define CTLZ     0x1a
#define ONE_SEC  18


/*** Global Variables ***/

static int NbrPorts = 1;           /* Number COM ports */
static int CharPace = 3;           /* inter-char delay in tics */
static int CurrentPort = -1;       /* currently selected port */
static char PromptMsg[40] = "\0";  /* prompt message */
static int PortEnable[NBR_PORTS];  /* enabled port array */
static int Enabled = 0;            /* # enabled ports */
static int BaudCode = Baud19200;   /* baud rate code */
static char *BaudRate[10] =  {"300","600","1200","2400","4800","9600",
                              "19200","38400","57600","115200"};
static char InitString[] = "!!AT E1 S7=60 S11=60 V1 X1 Q0 S0=0!!";

/*** local prototypes ***/

static void ErrorCheck(int);
static void MyExit(char *);
static int BaudMatch(char *);
static void VerifyDir(char *,int);
static void SendTo(int,int,char *);

/*** macros ***/

#define MAX(a,b) ((a)>=(b)?(a):(b))

/*** main ***/

void main(int argc, char *argv[])
{int i;
 char c;
 int Port;
 char far *SegPtr;
 int  Seg;
 char Temp[25];
 short Version;
 int Row, Col;
 char Answer[5];
 /* begin */
 if(argc!=3)
   {printf("Usage: BBS <#ports> <baudrate>\n");
    exit(1);
   }
 /* get number of ports from command line */
 NbrPorts = atoi(argv[1]);
 if((NbrPorts<1) || (NbrPorts>NBR_PORTS))
   {printf("1st arg: Number ports must be 1 to %d\n",NBR_PORTS);
    exit(1);
   }
 /* get baud rate from command line */
 BaudCode = BaudMatch(argv[2]);
 if(BaudCode==-1)
   {printf("2nd arg: Baud rate (%s)\n",argv[2]);
    exit(1);
   }
 /* init tsd first */
 tsdInit();
 /* clear the screen */
 Scroll(0,0, 24,79, 0,7);
 /* create windows */
 WinCreate(CONTROL_WIN, 1,1,  11,78);
 WinCreate(STATUS_WIN,  13,1, 16,78);
 WinCreate(SELECT_WIN,  18,1, 22,18);
 WinCreate(CALLER_WIN, 18,20, 22,75);
 /* initialize modules */
 BufferInit(4);
 sioInit();
 LogOpen(NbrPorts,"BBS.LOG");
 ssnInit(NbrPorts);
#if USE_XYMODEM
 xyParms(NbrPorts,DEBUG,18,3);
#endif
 WinPutString(CONTROL_WIN,"BBS (5/15/96)\n");
 Version = SioInfo('V');
 sprintf(Temp,"PCL4C ver %d.%d\n",Version>>4,0x0f&Version);
 WinPutString(CONTROL_WIN,Temp);
 sprintf(Temp,"Baud rate = %s\n",BaudRate[BaudCode]);
 WinPutString(CONTROL_WIN,Temp);
 strcpy(PromptMsg,"\rQ)uit ");
 for(i=0;i<NBR_PORTS;i++) sioStatus(i,'*');
 /* verify (public) download directory */
 VerifyDir("DNLOAD",-1);
 /* verify (private) upload directories */
 for(i=0;i<NbrPorts;i++) VerifyDir("UPLOAD",i);
 /* setup each port */
 for(Port=COM1;Port<NbrPorts;Port++)
   {/* set up next port */
    sprintf(Temp,"\rCOM%d: ",1+Port);
    WinPutString(CONTROL_WIN,Temp);
    /* setup 2048 byte receive buffer */
    SegPtr = (char far *) _fmalloc(2048+16);
    Seg = FP_SEG(SegPtr) + ((FP_OFF(SegPtr)+15)>>4);
    SioRxBuf(Port,Seg,Size2048);
    /* setup 1024 byte transmit buffer */
    SegPtr = (char far *) _fmalloc(1024+16);
    Seg = FP_SEG(SegPtr) + ((FP_OFF(SegPtr)+15)>>4);
    SioTxBuf(Port,Seg,Size1024);
    /* set port parmameters */
    ErrorCheck( SioParms(Port,NoParity,OneStopBit,WordLength8) );
    /* reset the port */
    ErrorCheck( SioReset(Port,BaudCode) );
    /* set DTR and RTS */
    ErrorCheck( SioDTR(Port,'S') );
    ErrorCheck( SioRTS(Port,'S') );
    /* require DSR & CTS */
    /*if(SioDSR(Port)&&SioCTS(Port))*/
    if(SioDSR(Port))
       {Enabled++;
        PortEnable[Port] = TRUE;
        /* concatenate COM # to menu */
        c = '1' + Port;
        if(c>'9') c = 'A' + (Port - 9);
        Answer[0] = c;
        Answer[1] = ' ';
        Answer[2] = '\0';
        strcat(PromptMsg,Answer);
        /* set hardware flow control ON */
        SioFlow(Port,ONE_SEC);
        /* Set FIFO level */
        if( SioFIFO(Port,LEVEL_14) ) WinPutString(CONTROL_WIN," [16550 detected] ");
        WinPutString(CONTROL_WIN,"reset\n");
        sioStatus(Port,'I');

#if 0
        /* send initialization string to modem */
        SendTo(Port,CharPace,InitString);
        WinPutString(CONTROL_WIN,"modem initialized\n");
#endif

        /* start thread (thread==port) */
        ssnStart(Port,Port);
        if(CurrentPort==-1)
          {CurrentPort = Port;
           /* tell session manager */
           ssnSetChannel(Port);
          }
       }
    else
       {PortEnable[Port] = FALSE;
        SioDone(Port);
        sprintf(Temp,"DSR and CTS not both up for COM%d\n",1+Port);
        WinPutString(CONTROL_WIN,Temp);
       }
   } /* end for */

 /* got any enabled ports ? */

 if(Enabled==0)
   {WinPutString(CONTROL_WIN,"No ports enabled! Aborting!\n");
    for(i=0;i<NbrPorts;i++) SioDone(i);
    exit(1);
   }

 /* display info for current port in caller area */

 sioSelect(CurrentPort,ssnGetUser(CurrentPort),ssnGetProtocol(CurrentPort));
 strcat(PromptMsg,":");

 WinPutString(CONTROL_WIN,PromptMsg);

 /* main control loop */

 while(1)
   {
    /* run thread driver */
    tsdDriver();
    /* has user typed a key ? */
    if(kbhit())
      {/* process user request */
       c = (char) (0x00ff & getch());
       /* force to upper case */
       c = (char) toupper((int)c);
       switch(c)
         {case 'D': /* DEBUG */
             sprintf(Temp,"Port=%d State=0x%x Count=%ld Last='%c'\n",
                CurrentPort,tsdGetState(CurrentPort),
                tsdGetCounter(CurrentPort),
                (char)ssnDebug(CurrentPort) );
             WinPutString(CONTROL_WIN,Temp);
             sprintf(Temp,"Index=%d String='%s' User='%s'\n",
                ssnGetIndex(CurrentPort),ssnGetString(CurrentPort),
                ssnGetUser(CurrentPort));
             WinPutString(CONTROL_WIN,Temp);
             break;
          case 'Q': /* QUIT */
             WinPutString(CONTROL_WIN," [Quitting]");
             for(i=0;i<NbrPorts;i++) SioDone(i);
#if USE_XYMODEM
             LogClose();
#endif
             exit(1);
          default:
             /* select a port for caller display area */
             if( (c>='1') && (c<('1'+NbrPorts)) )
                {Port = c - '1';
                 if(PortEnable[Port])
                    {/* select new user for display */
                     CurrentPort = Port;
                     sioSelect(CurrentPort,ssnGetUser(Port),ssnGetProtocol(Port));
                     /* tell session manager */
                     ssnSetChannel(Port);
                     /* copy buffer data to caller window */
                     WinClear(CALLER_WIN);
                     Row = BufferRow(Port);
                     for(i=MAX(0,Row-4);i<=Row;i++)
                       {WinPutString(CALLER_WIN, BufferLine(Port,i) );
                        if(i<Row) WinPutChar(CALLER_WIN,'\n');
                       }
                    }
                 else WinPutString(CONTROL_WIN," [Port not enabled]\n");
                }
             else WinPutString(CONTROL_WIN," [Bad response]\n");
         } /* end - switch */
       /* ready for next command */
       WinPutString(CONTROL_WIN,PromptMsg);
      } /* end - if(kbhit()) */
   } /* end while(1) */
} /* end main */


/*** check return code ***/

void ErrorCheck(int Code)
{int i;
 /* trap PCL error codes */
 if(Code<0)
     {WinPutString(CONTROL_WIN,"\n");
      SioError(Code);
      for(i=COM1;i<NbrPorts;i++) SioDone(i);
#if USE_XYMODEM
      LogClose();
#endif
      exit(1);
     }
}

/*** common exit ***/

static void MyExit(char *S)
{int i;
 WinPutString(CONTROL_WIN,S);
 for(i=COM1;i<NbrPorts;i++) SioDone(i);
#if USE_XYMODEM
      LogClose();
#endif
 exit(0);
}

/*** find baud rate string in table ***/

static int BaudMatch(char *ptr)
{int i;
 /* find baud rate in table */
 for(i=0;i<10;i++) if(strcmp(BaudRate[i],ptr)==0) return(i);
 return(-1);
}

/*** verify existance of directory ***/

static void VerifyDir(char *Name,int Ext)
{char Temp[20];
 if(Ext>=0) sprintf(Temp,"%s.%d",Name,Ext);
 else sprintf(Temp,"%s.ALL",Name);
 if(!ChDir(Temp))
   {WinPutString(CONTROL_WIN,"ERROR: directory ");
    WinPutString(CONTROL_WIN,Temp);
    WinPutString(CONTROL_WIN," does not exist\n");
    exit(1);
   }
 ChDir("..");
}

/* send string to modem */

static void SendTo(int Port,int Pace,char *String)
{int i;
 int Len;
 char c;
 Len = strlen(String);
 for(i=0;i<Len;i++)
   {c = String[i];
    if(c=='!') c = CR;
    SioPutc(Port,c);
    WinPutChar(CONTROL_WIN,c);
    SioDelay(CharPace);
   }
 WinPutChar(CONTROL_WIN,'\n');
 if(Pace>0) SioDelay(Pace);
}