(*****************************************************************************)
(*>                                                                         <*)
(*>  SYSOP2J .PAS -  Written by Mike Wilson                                 <*)
(*>  Written Nov. 1991                                                      <*)
(*>  SysOp functions: System Configuration Editor -- "J" command.           <*)
(*>                                                                         <*)
(*>                                                                         <*)
(*****************************************************************************)
{$A+,B+,D-,E+,F+,I+,L+,N-,O+,R-,S+,V-}
unit sysop2j;

interface

uses
  crt, dos, overlay,
  common;

Procedure DOEditors;
Procedure LoadEditorFile( Var Editor: EditorRecord; Add : Boolean);{ Load Editor Into Memory }
Procedure WriteEditor(Editor : EditorRecord); { Write the EditorRecord }
Procedure DeleteEditor(RecToDel : Integer);

Implementation


Procedure DeleteEditor(RecToDel : Integer);
Var
  EditorFile2 : File Of EditorRecord;
  Editor2 : EditorRecord;
  Editor : EditorRecord;
  Int : Integer;

Begin
   assign(EditorFile,systat.gfilepath+'Editors.Dat');
   {$I-} reset(EditorFile); {$I+}
 if IOResult <> 0 then
 Begin
  print('Original Editor File NOT Found!');
  delay(1000);
  exit;
 End else

 Begin
 if (RecToDel >= FileSize(EditorFile)) or (REcToDel <= 0) then
  Begin
    print('Record number not found...');
    delay(1000);
   close(EditorFile);
   Exit;
   end else
  Begin
       assign(EditorFile2,systat.gfilepath+'Editor2.Dat');
       rewrite(EditorFile2);
       Int :=0;
       While Not EOF(EditorFile) Do
         Begin
         read(EditorFile,Editor);
         if Editor.Number <> RecToDel then
           Begin
            Editor2.Name :=  Editor.Name;
            Editor2.CommandLine := Editor.Commandline;
            Editor2.Number := Int;
            write(EditorFile2,Editor2);
            Inc(Int);     { KickUp Record Counter }
           end;  { IF }
         End; { IF }

         Close(EditorFile);
         Erase(EditorFile);
  ReName(EditorFile2,systat.GfilePath+'Editors.Dat');  { Rename to NEW }
         { Close(EditorFile2);  Causes 006 Error, Close before RENAME ? }
  End; { While }
 End;   { RecNum IF  }
End;   { Procedure }


Procedure WriteEditor(Editor : EditorRecord);

Begin
   assign(EditorFile,systat.gfilepath+'Editors.Dat');
   {$I-} reset(EditorFile); {$I+}
 if IOResult <> 0 then
 Begin
  print('File NOT Found!');
  delay(1000);
 End else
   Seek(EditorFile,Editor.Number);
   write(EditorFile,Editor);
 close(EditorFile);
End;


Procedure LoadEditorFile( Var Editor: EditorRecord; Add : Boolean);

Begin
   assign(EditorFile,systat.gfilepath+'Editors.Dat');
   {$I-} reset(EditorFile); {$I+}
 if IOResult <> 0 then
 begin
   rewrite(EditorFile);
   Editor.Name :='Standard Editor For BackDoor!';
   Editor.Commandline :='Chicken!';
   Editor.Number :=0;
   write(EditorFile,Editor);  { Rec 0 }

   Editor.Name :='TopED External ANSI Editor!';
   Editor.Commandline :='TopED.EXE 1';
   Editor.Number :=1;
   write(EditorFile,Editor);   { Rec 1 }
   End else

 if ADD then
 Begin
   Editor.Number := FileSize(EditorFile);
   Seek(EditorFile,FileSize(EditorFile));
   Write(EditorFile,Editor);
 End;

 Begin
    if ((NOT ADD) and (Editor.Number >= FileSize(EditorFile))) then
       Begin
         Print('Highest Editor Record!');
         Dec(Editor.Number);
         delay(1000);
       end else

 Begin
    if (Editor.Number <= 0) then
       Begin
         Print('Lowest Editor Record!');
         Inc(Editor.Number);
         delay(1000);
       end else
 Begin
       Seek(EditorFile,Editor.Number);
       Read(EditorFile,Editor);
  End;
 End;
 Close(EditorFile);
 end;
end;

Procedure DOEditors;
Var
    Editor : EditorRecord;
    Str : String;
    C:char;
    Done,Abort,Next : Boolean;

 Begin
Editor.Number :=1;
Repeat
    LoadEditorFile(Editor,FALSE);    Done:=FALSE;

    CLS;
    SPrint(#3#5+'Editor Configuration:');
    nl;
    Abort:=FALSE; Next:=FALSE;
    print('Editor Number :'+Cstr(Editor.Number));
    nl;nl;
    print('A. Editor Name/Description:'+Editor.Name);
    print('B. Editor Command Line    :'+Editor.CommandLine);
    nl;
printAcr(#3#3+'N'#3#2+')ext '+#3#3+'P'+#3#2+')revious '+#3#3+'M'+#3#2+')ake/Add '+#3#3+'D'+#3#2+')elete Editor',abort,Next);
    nl;
      prt('Enter selection or [Q]uit : ');
      onek(c,'QABDMNP'^M);
      nl;
      case c of
        'Q': Done:=TRUE;
        'A': Begin
              Print('Current Editor Name/Disc :'+Editor.Name);
              prt('New :');mpl(40);inputl(Str,40);
             if ((Str <> '') and (Str <> ' '))
              then
                Begin
                 Editor.Name := Str;
                 print('Saving...');
                 WriteEditor(Editor)
               End else
               nl;
             end;

        'B': Begin
                Print('Current Editor CommandLine :'+Editor.CommandLine);
                print('New :');
                mpl(79);
                inputl(Str,79);
        if ((Str <> '') and (Str <> ' '))
          then
             Begin
                Editor.CommandLine := Str;
                Print('Saving...');
                WriteEditor(Editor)
             End else
             nl;
           end;
          'D':Begin
                 If PynQ('Delete THIS Editor record [y/N] ') then
                  Begin
                    DeleteEditor(Editor.Number);
                    Editor.Number :=1; { Starts them out on 1 }
                   End else
                   print('Aborted.');
                  End;
          'M': Begin
                 prompt('Enter Editor Command Line ');
                 print(':');
                 mpl(79); input(Str,79);
               if ((Str = '') and (Str = ' '))
                  then  Begin
                   nl;
                  End else
                  Begin
                    Editor.CommandLine := Str
                  end;
                   prt('Enter Editor Name/Discription :');mpl(40);
                   inputL(Str,79);
               if ((Str = '') or (Str = ' '))
                  then  Begin
                    nl;
                  end else
                  Begin
                    Editor.Name := Str;
                    LoadEditorFile(Editor,TRUE);
                  End;
               End;

          'N' : Editor.Number := Editor.Number +1;


           'P' : Editor.Number := Editor.Number -1;
        End ; { Case }

Until ((HangUP) or (Done))
 end;

end.