/*******************************\
* UCOM.C			*
* (c)1986, Patrick E. Hughes	*
\*******************************/

#include <exec/types.h>
#include <time.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/

extern struct System System;
extern struct User User;

int UCom()
{
int x, stat, number;
struct User hoozer;
char str[133], string[81];

PutStr("User Listings\r\n");

UserMark1:

/* INPUT AND VERIFY TARGET ACCOUNT */
PutStr("\r\n[?] for pattern instructions, Q>uit\r\n");
PutStr("Enter Account Number (or Pattern) to search? ");
stat=LineInput("",str,31,120L);
if(stat<0) { return(stat); }
Check_Online_Status();
number=atoi(str);
if(number==0)
	{
	if(stat==1 && (toupper(str[0])=='Q' || str[0]=='@'))
		{
		PutStr("Quit\r\n");
		return(SUCCESS);
		}
	if(stat==0)
		{
		PutStr("Quit\r\n");
		return(SUCCESS);
		}
	if(stat==1 && str[0]=='?')
		{
		strcpy(str,System.Location);
		strcat(str,"Patterns.Help");
		MenuSend(str);
		goto UserMark1;
		}
	stat=Users_By_Name(str);
	if(stat<0 || stat=='@') { return(stat); }
	goto UserMark1;
	}

if(number>System.User_Defaults.Maximum)
	{
	PutStr("Invalid account number\r\n");
	goto UserMark1;
	}
	
Load_Account(number,&hoozer);
if(hoozer.Slot_Number==0)
	{
	PutStr("That account is deleted or unused\r\n");
	goto UserMark1;
	}
sprintf(string,"%s",ctime(&hoozer.Time_Last_On));
string[strlen(string)-1]='\0';
sprintf(str,"\r\n[%3d] %-30s Last on %s\r\n",
	hoozer.Slot_Number,
	hoozer.Name,
	string);
PutStr(str);
goto UserMark1;
}

/************************/
static int Users_By_Name(s)
	char *s;
{
struct User hoozer;
int slot, stat;
char str[81], string[81];

for(slot=1;slot<=System.User_Defaults.Maximum;++slot)
	{
	stat=Load_Account(slot,&hoozer);
	if(stat==FAILURE)
		{
		PutStr("File error reading an account\r\n");
		PutStr("Cannot continue the search\r\n");
		return(SUCCESS);
		}
	if(hoozer.Slot_Number==0)
		{
		SendChar('.');
		;
		}
	else if(jive(hoozer.Name,s)==SUCCESS)
		{
		sprintf(string,"%s",ctime(&hoozer.Time_Last_On));
		string[strlen(string)-1]='\0';
		sprintf(str,"\r\n[%3d] %-30s Last on %s",
			slot,
			hoozer.Name,
			string);
		PutStr(str);
		}
	else
		{
		SendChar('.');
		}
	Check_Online_Status();
	if(CheckInput())
		{
		stat=ReadChar(120L);
		switch(stat)
			{
			case '\023':
			case 'S':
			case 's':
			case 'P':
			case 'p':
			case ' ':
				PurgeLine();
				PutStr("Any key..");
				stat=ReadChar(120L);
			    if(stat==TIMEOUT||stat==NO_CARRIER){return(stat);}
			PutStr("\b\b\b\b\b\b\b\b\b         \b\b\b\b\b\b\b\b\b");
				break;
			case '\033': /* ESC Abort */
			case '\003': /* ^C */
			case '\020': /* ^P */
			case '\031': /* ^Y */
			case 'Q':
			case 'q':
			case 'X':
			case 'x':
				PutStr("\r\nAbort\r\n");
				goto ByNameMark1;
				break;
			default:
				PurgeLine();
				break;
			}
		}
	}
ByNameMark1:
PutStr("\r\nCompleted Matching Names\r\n");
return(SUCCESS);
}
