#include "devices/timer.h"
#define TRUE 1
#define FALSE 0

extern struct MsgPort     *TimerPort, *CreatePort();
extern struct timerequest *TimerMsg,  *CreateExtIO();

int OpenTimer()
{
int error;

if(!(TimerPort = CreatePort("",0L)))
	return(TRUE);
if(!(TimerMsg=CreateExtIO(TimerPort,(long)sizeof(struct timerequest))))
	return(TRUE);
if(error = OpenDevice(TIMERNAME,UNIT_VBLANK,TimerMsg,0L)) return(error);
return(FALSE);
}

int SetTimer(secs, micros)
  ULONG secs, micros;
{ 
TimerMsg->tr_node.io_Command = TR_ADDREQUEST; /* add a new timer request */
TimerMsg->tr_time.tv_secs    = secs;          /* seconds */
TimerMsg->tr_time.tv_micro   = micros;        /* microseconds */
SendIO(TimerMsg);     /* post the request to the timer device */
}

int CloseTimer()
{  
if(TimerMsg)
	{
	CloseDevice(TimerMsg);
	DeleteExtIO(TimerMsg, (long)sizeof(struct timerequest));
	if(TimerPort) DeletePort(TimerPort);
	}
}
