/*******************************\
* TAG.C				*
* (C)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/io.h>
#include <exec/types.h>
#include <stdio.h>
#include <intuition/intuition.h>
#include <devices/console.h>
#include <devices/serial.h>
#include <devices/timer.h>
#include <time.h>
#include <setjmp.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/
struct IntuitionBase *IntuitionBase;
struct Remember *RememberKey=NULL;

struct NewWindow NewWindow = {
	0,0,640,200,0,1,
	GADGETDOWN|MENUPICK,
	ACTIVATE|WINDOWDRAG|WINDOWDEPTH|SMART_REFRESH|BORDERLESS|NOCAREREFRESH,
	NULL,NULL,
"System Pane : TAG-BBS : Version 1.03                                        ",
	NULL,NULL,640,200,640,200,WBENCHSCREEN };
struct NewWindow PaneStatus = {
	0,0,640,40,3,2,
	NULL,WINDOWDEPTH|WINDOWDRAG|SMART_REFRESH|NOCAREREFRESH,
	NULL,NULL,"Status Pane : TAG-BBS : Version 1.03",
	NULL,NULL,0,0,640,40,WBENCHSCREEN };
struct Window *window=NULL, *StatusPane=NULL;
struct System System;
struct IOExtSer *WriteSerReq=NULL, *ReadSerReq=NULL;
struct IOStdReq *WriteConReq=NULL, *ReadConReq=NULL;
struct timerequest *TimerMsg=NULL;
struct MsgPort *WriteSerPort=NULL, *ReadSerPort=NULL, *TimerPort=NULL;
struct MsgPort *WriteConPort=NULL, *ReadConPort=NULL;
struct IOStdReq *StatWriteReq=NULL;
struct MsgPort *StatWritePort=NULL;

ULONG TimerSig, SerCharSig, ConCharSig, WindowSig;
UBYTE serin[20], conin[20];

int Boards_Are_Active, Libraries_Are_Active;
int Bulletins_Are_Active, Mail_Is_Active;
int Whence_The_Logon;
int Chat_Stat;
int Online_Baud;
int IO_Flags[7];
struct User User;

long Time_connect, Time_menu_entry, Time_system, Time_remaining, Time_limit;

jmp_buf Environment;

/***********************\
* MAIN()		*
\***********************/

main()
{
int status;
int logoff_type;
extern int Enable_Abort;

Enable_Abort=0;

Init_System();

FOREVER
	{
	setjmp(Environment);
	Reset_System();
	Whence_The_Logon=Await_Logon();

	switch(Whence_The_Logon)
		{
		case SYSOP_LOGON:
			Sysop_Account_Sequence();
			Append_Stat(STAT_LOGON);
			break;
		case BACKDOOR_LOGON:
			Sysop_Account_Sequence();
			StatRollMessage("");
			StatRollMessage("Guest Logon");
			Append_Stat(STAT_LOGON);
			break;
		case LOCAL_LOGON:
		case REMOTE_LOGON:
			status=Logon_Sequence();
			if(status!=SUCCESS) { continue; }
			Append_Stat(STAT_LOGON);
			if(User.Sec_Status==0)
				{
				Append_Stat(STAT_GUEST_CALL);
				}
			if(User.Sec_Status==1)
				{
				Append_Stat(STAT_NEW_CALL);
				}
			if(User.Sec_Status>=2 && User.Sec_Status<255)
				{
				Append_Stat(STAT_VALID_CALL);
				}
			break;
		}

	if( (logoff_type=setjmp(Environment))!=0 )
		{
		;
		}
	else
		{
		logoff_type=Menu();
		}

	Append_Stat(STAT_LOGOFF);
	if(User.Sec_Status!=0 && User.Slot_Number!=0)
		{
		User.Time_Last_On=time(NULL);
		Save_Account(&User);
		}
	}
}

/***********************\
* STUBROUTINES...	*
\***********************/
_cli_parse()
{;}
_wb_parse()
{;}
_stkover()
{
ShutDown("Stack Overflow\n\nTYPE \"STACK 10000\" FROM CLI BEFORE RUNNING TAG-BBS\n");
}

/***********************\
* SHUTDOWN()		*
\***********************/
int ShutDown(s)
	char *s;
{
puts("\n");
puts(s);
puts("\n");
Close_Stat();
CloseConsole();
CloseSerial();
CloseTimer();
if(StatusPane) { CloseWindow(StatusPane); }
if(window) { CloseWindow(window); }
FreeRemember(&RememberKey,TRUE);
exit(0L);
}
