/***********************\
* SYSTEM.H		*
\***********************/

#include <exec/types.h>
#include "modem.h"
#include "user.h"
#include "board.h"
#include "library.h"
#include "bulletin.h"
#include "mail.h"

/***********************\
* SYSTEM: name here		[31]
*   LOCAT: physical dir		[81]
*   SYSOP: name here		[31]
*
* USERS:
*   ACCOUNTS: maximum		[0-65535]
*   GUEST:
*     STSEC: security status	[0-255]
*     BDSEC: board
*     LBSEC: library
*     BUSEC: bulletin
*     TIME: limit in seconds	[0-65535]
*   NEW:
*     STSEC: security status	[0-255]
*     BDSEC: board
*     LBSEC: library
*     BUSEC: bulletin
*     TIME: limit in seconds	[0-65535]
*   VALID:
*     STSEC: security status	[0-255]
*     BDSEC: board
*     LBSEC: library
*     BUSEC: bulletin
*     TIME: limit in seconds	[0-65535]
*
* MAIL:
*   LOCAT: physical dir		[81]
*   WRITE: low,high		[0 - 255],[>=low - high]
*   LETTERS: maximum		[0-65535]
*
* MODEM:
*   OPEN:   major startup	[81]
*   RESET:  between call	[81]
*   RING:   incoming call	[81]
*   ANSWER: accept incoming	[81]
*   300:    baud report		[81]
*   1200:
*   2400:
*   4800:
*   9600:
\**********************/

struct Daily_Statistics {
	LONG	Time_Active,
		Time_Fallow;
	USHORT	Guest_Calls,
		New_Calls,
		Valid_Calls;
	USHORT	Messages_Written,
		Letters_Written;
	USHORT	Files_Uploaded,
		Files_Downloaded;
	USHORT	New_Accounts;
	char	Pad[64];
	};

struct Overall_Statistics {
	LONG	Time_Active,
		Time_Fallow,
		Time_First_Online;
	LONG	Guest_Calls,
		New_Calls,
		Valid_Calls;
	LONG	Files_Uploaded,
		Files_Downloaded;
	LONG	Messages_Written,
		Letters_Written;
	char	Pad[64];
	};

struct System {
	char	Name[31],
		Sysop[31],
		Location[81];
	struct	User_Defaults	User_Defaults;
	struct	Mail_Header	*Mail_List;
	struct	Board_Header	*Boards_List;
	struct	Library_Header	*Libraries_List;
	struct	Bulletin_Header	*Bulletins_List;
	struct	Modem Modem;
	struct	Daily_Statistics Daily_Statistics[7];
	struct	Overall_Statistics Overall_Statistics;
	char	Pad[64];
	};
