/*******************************\
* MENU.C			*
* (C)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/types.h>
#include <stdio.h>
#include <time.h>
#include <setjmp.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/

extern struct System System;

extern ULONG TimerSig, SerCharSig, ConCharSig, WindowSig;
extern UBYTE serin[], conin[];

extern int Boards_Are_Active, Libraries_Are_Active;
extern int Bulletins_Are_Active, Mail_Is_Active;
extern int Whence_The_Logon;
extern int Chat_Stat;
extern int IO_Flags[];
extern struct User User;
extern long Time_menu_entry, Time_system, Time_remaining, Time_limit,
	Time_connect;

extern jmp_buf Environment;

int Menu()
{
int input, command_accepted, stat;
long lstat;
char string[133];

Clear_Online_Status();
Time_menu_entry=time(NULL);
Time_system=time(NULL);

if( Time_menu_entry - User.Time_Last_On >= 43200L  /* then over 12 hrs */
    || User.Sec_Status==255 )
	{
	Time_limit=User.Time_Limit;
	User.Time_Used=0L;
	}
else
	{
	Time_limit=User.Time_Limit-User.Time_Used;
	}

if(Time_limit<=0L)
	{
	strcpy(string,System.Location);
	strcat(string,"Logon24hrs.Text");
	MenuSend(string);
	User.Sec_Status=0;
	User.Slot_Number=0;
	longjmp(Environment,OVERTIME_LOGOFF);
	}

if(User.Slot_Number==0) { ; }
else
	{
	if((stat=Mail_Count(System.Mail_List,User.Slot_Number))>0)
		{
		if(stat==1)
			{
			sprintf(string,"You Have A Letter Waiting!\r\n\r\n");
			}
		else
			{
			sprintf(string,"You Have %d Letters Waiting!\r\n\r\n",stat);
			}
		PutStr(string);
		stat=PCom();
		if(stat<0) { return(OVERTIME_LOGOFF); }
		Check_Online_Status();
		}
	}

FOREVER
	{
	StatRollMessage("Main Menu");
	if(User.Slot_Number==0)
		{
		PutStr("\r\n[J] to Join permanently\r\n");
		}
	sprintf(string,"\r\n%s Menu [?] ",System.Name);
	PutStr(string);

	FOREVER
		{
		input=ReadChar(120L);
		if(input==TIMEOUT) { return(SLEEP_LOGOFF); }
		Check_Online_Status();
		switch(toupper(input&0x7f))
			{
			case 'A':
				command_accepted=ACom(); /* account */
				break;
			case 'B':
				command_accepted=BCom(); /* bulletin */
				break;
			case 'C':
				command_accepted=CCom(); /* chat */
				break;
			case 'E':
				if(User.Sec_Status<255)
					{
					command_accepted=FAILURE;
					break;
					}
				Edit_Accounts();
				command_accepted=SUCCESS;
				break;
			case 'F':
				PutStr("Feedback\r\n");
				PutStr("Send a note direct to the sysop\r\n");
				Mail_Reply_To(System.Mail_List,1);
				command_accepted=SUCCESS;
				break;
			case 'G':
				PutStr("Goodbye\r\n\r\n");
				sprintf(string,"\r\n%s\r\n",System.Name);
				PutStr(string);
				PutStr("\r\n*                                                   *\r\n\r\n");
				return(STANDARD_LOGOFF); /* goodbye */
				break;
			case 'I':
				ICom();
				command_accepted=SUCCESS;
				break;
			case 'J':
				command_accepted=JCom(); /* join */
				break;
			case 'L':
				command_accepted=LCom(); /* library */
				break;
			case 'M':
				command_accepted=MCom(); /* messages */
				break;
			case 'P':
				command_accepted=PCom(); /* private mail */
				break;
			case 'T':
				command_accepted=TCom(); /* time */
				break;
			case 'U':
				command_accepted=UCom(); /* user listings */
				break;
			case '?':
			case '/':
				PutStr("Command summary\r\n");
				strcpy(string,System.Location);
				strcat(string,"MainMenu.Help");
				MenuSend(string);
				command_accepted=SUCCESS;
				break;
			case '\000': /* FN-KEY HIT */
				command_accepted=SUCCESS;
				PutStr("\r\n");
				break;
			default:
				command_accepted=FAILURE;
				break;
			}
		if(command_accepted==TIMEOUT) { return(SLEEP_LOGOFF); }
		if(command_accepted==NO_CARRIER) { return(CARRIER_LOGOFF); }
		if(command_accepted==FAILURE) { continue; }
		break;
		}
	}
}

/********************/
int TCom()
{
long temp;
char string[81];

StatRollMessage("Time Statistics");
Time_system=time(NULL);
PutStr("Time and you, what it all means\r\n\r\n");

sprintf(string,"  Connected at: %s",ctime(&Time_connect));
string[strlen(string)-1]='\0';
strcat(string,"\r\n");
PutStr(string);

sprintf(string," Count Started: %s",ctime(&Time_menu_entry));
string[strlen(string)-1]='\0';
strcat(string,"\r\n");
PutStr(string);

sprintf(string,"  Current Time: %s",ctime(&Time_system));
string[strlen(string)-1]='\0';
strcat(string,"\r\n");
PutStr(string);

Check_Online_Status();

sprintf(string,"Remaining Time: ~%ld minute(s)",Time_limit/60L);
strcat(string,"\r\n");
PutStr(string);

return(SUCCESS);
}

/***********************/
int CCom()
{
char str[81];

StatRollMessage("\007CHAT PAGE\007");
sprintf(str,"Chat with %s\r\n\r\n",System.Sysop);
PutStr(str);
PutStr("The Sysop has been paged\r\n");
PutStr("You may continue using the system\r\n");
PutStr("until ");
PutStr(System.Sysop);
PutStr(" answers your request.\r\n");
Check_Online_Status();
return(SUCCESS);
}

/***********************/
int ICom()
{
Report_Stat();
}

/**********************************************/
/* locally static for Online_Status functions */
static long Time_holder;
/***********************/
int Clear_Online_Status()
{
Time_holder=0L;
}

/***********************/
int Check_Online_Status()
{
int stat;
char string[133];

Time_system=time(NULL);

if(Time_holder==0L)
	{
	Time_holder=Time_system;
	}

if(Whence_The_Logon>=REMOTE_LOGON)
	{
	stat=CheckCarrier();
	if(stat==FALSE)	{ longjmp(Environment,CARRIER_LOGOFF); }
	}

User.Time_Used += Time_system-Time_holder;
User.Time_Total+= Time_system-Time_holder;
Time_limit -= Time_system-Time_holder;

Time_holder=Time_system;

if(Time_limit<=0L)
	{
	PutStr("\r\nYou have exceeded your time limit\r\n");
	User.Time_Used==User.Time_Limit;
	PutStr("Goodbye\r\n\r\n");
	PutStr("Disconnecting..");
	longjmp(Environment,OVERTIME_LOGOFF);
	}

if(Time_limit<=(long)60 && Time_limit>=(long)50)
	{
	PutStr("\r\nOne minute warning\r\n");
	}

sprintf(string,"%lu Min & %lu Sec",Time_limit/60L,Time_limit%60L);
string[80]='\000';
StatPrintTime(string);

}
