/*******************************\
* LOGON.C			*
* (C)1986-87, Patrick E. Hughes	*
\*******************************/

#include "System.h"
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
#include "defines.h"

extern struct System System;
extern struct User User;

int Logon_Sequence()
{
char string[133], acctfile[133];
int fd, stat;
int tries, acct;
long seekstat;

StatRollMessage("Logon Sequence");

strcpy(acctfile,System.Location);
strcat(acctfile,"User.Data");

strcpy(string,System.Location);
strcat(string,"Logon.Text");
MenuSend(string);

tries=0;

FOREVER
	{
	if(tries>=3)
		{
		PutStr("Three tries and you're out\r\n");
		PutStr("Now you get a Guest account\r\n");
		return(New_Account_Sequence());
		}
	PurgeLine();
	PutStr("\r\n0=NEW\r\nEnter Your Account Number? ");
	stat=LineInput("",string,6,20L);
	if(stat<0) { return(FAILURE); }
	acct=atoi(string);
	if(acct>System.User_Defaults.Maximum || acct<0)
		{
		PutStr("Invalid account\r\n");
		++tries;
		continue;
		}
	if(stat==0)
		{
		PutStr("Remember, '0' must be entered for a new account\r\n");
		++tries;
		continue;
		}
	if(acct==0)
		{
		return(New_Account_Sequence());
		}
	stat=Load_Account(acct,&User);
	if(stat==FAILURE)
		{
		PutStr("That account has file problems\r\n");
		continue;
		}
	if(User.Slot_Number==0)
		{
		PutStr("That account has been deleted.\r\n");
		continue;
		}
	PurgeLine();
	PutStr("Enter Your PassWord? ");
	stat=LineInputConverted("",string,8,20L);
	if(stat==TIMEOUT) { return(FAILURE); }
	stat=StringCompare(string,User.Pass);
	if(stat!=SUCCESS)
		{
		PutStr("Invalid PassWord\r\n");
		++tries;
		continue;
		}
	StatRollMessage("Successful");
	StatPrintUser(&User);
	return(SUCCESS);
	}
return(FAILURE);
}

/********************/
int New_Account_Sequence()
{
char string[133];

StatRollMessage("Guest Account");
strcpy(User.Name,"Guest Account");
strcpy(User.Pass,"");
User.Slot_Number=0;
User.Sec_Status=System.User_Defaults.Guest.Sec_Status;
User.Sec_Board=System.User_Defaults.Guest.Sec_Board;
User.Sec_Library=System.User_Defaults.Guest.Sec_Library;
User.Sec_Bulletin=System.User_Defaults.Guest.Sec_Bulletin;
User.Time_Limit=System.User_Defaults.Guest.Time_Limit;
User.Messages_Posted=0;
User.Mail_Sent=0;
User.Mail_Received=0;
User.Uploads=0;
User.Downloads=0;
User.Protocol=0;
User.Time_Last_On=0L;
User.Time_Used=0L;
User.Time_Total=0L;

StatPrintUser(&User);

strcpy(string,System.Location);
strcat(string,"GuestLogon.Text");
MenuSend(string);
return(SUCCESS);
}

/********************/
int Sysop_Account_Sequence()
{
char acctfile[133], string[133];
int fd, stat;

StatRollMessage("Sysop Account");
Load_Account(1,&User);
StatPrintUser(&User);

return(SUCCESS);
}
