/*******************************\
* JCOM.C			*
* (C)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/types.h>
#include <stdio.h>
#include <fcntl.h>
#include <intuition/intuition.h>
#include <time.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/

extern struct System System;

extern int Whence_The_Logon;
extern long Time_system;
extern struct User User;

/***********************/
int JCom()
{
int ch, stat;
char string[133];

if(User.Slot_Number>0) { return(FAILURE); }
PutStr("Join ");
PutStr(System.Name);
PutStr("\r\n\r\n");

StatRollMessage("Join");

PutStr("Enter [Y,N]: Become a permanent member? ");
PurgeLine();
FOREVER
	{
	ch=ReadChar(120L);
	if(ch==TIMEOUT) { return(TIMEOUT); }
	if(Whence_The_Logon>=REMOTE_LOGON)
		{
		stat=CheckCarrier();
		if(stat==FALSE) { return(NO_CARRIER); }
		}
	if(ch=='N' || ch=='n' || ch=='Q' || ch=='q')
		{
		PutStr("\r\n\r\n");
		StatRollMessage("Not Joining");
		return(SUCCESS);
		}
	if(ch=='Y' || ch=='y') { break; }
	else { continue; }
	}

PutStr("Yes, I want to join\r\n\r\n");
PutStr("Please wait, the search for an open account\r\n");
PutStr("may take a little while.\r\n\r\n");
PutStr("Searching..");

stat=Find_Open_Account(&User);
if(stat==FAILURE)
	{
	PutStr("\r\n\r\n");
	PutStr("Sorry, no openings are available\r\n");
	User.Slot_Number=0;
	StatRollMessage("No Open Account");
	return(SUCCESS);
	}

PutStr("\r\n");
strcpy(string,System.Location);
strcat(string,"Join.Text");
stat=MenuSend(string);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }

JLoop1:

PutStr("\r\n");
PurgeLine();
PutStr("Blank line to quit:\r\n");
PutStr("Enter your full board name: ");
stat=LineInput("",User.Name,30,120L);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }
if(strlen(User.Name)==0)
	{
	PutStr("Quit\r\n");
	strcpy(User.Name,"Guest Account");
	User.Sec_Status=0;
	return(SUCCESS);
	}
if(strlen(User.Name)==1)
	{
	PutStr("Your name must be longer than 1 character\r\n");
	goto JLoop1;
	}
if(atoi(User.Name)>0)
	{
	PutStr("Your name must not start with a number\r\n");
	goto JLoop1;
	}

PurgeLine();
PutStr("Blank line to retreat\r\n");
PutStr("Enter a PassWord: ");
stat=LineInput("",User.Pass,8,120L);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }
if(stat==0) { goto JLoop1; }

PurgeLine();

User.Comments[0][0]='\000';
User.Comments[1][0]='\000';
User.Comments[2][0]='\000';

PutStr("Now you enter three lines of Comments to ");
PutStr(System.Sysop);
PutStr("\r\n");
PutStr("A blank line will finish your comments\r\n\r\n");
PutStr("Line ONE:\r\n");
stat=LineInput("",&User.Comments[0][0],79,120L);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }
if(stat==0) { goto SkipComment; }

PurgeLine();
PutStr("Line TWO:\r\n");
stat=LineInput("",&User.Comments[1][0],79,120L);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }
if(stat==0) { goto SkipComment; }

PurgeLine();
PutStr("Line THREE:\r\n");
stat=LineInput("",&User.Comments[2][0],79,120L);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }

SkipComment:

PutStr("\r\n\r\n");
sprintf(string,"Full Name: %s\r\n",User.Name);
PutStr(string);
sprintf(string," PassWord: %s\r\n\r\n",User.Pass);
PutStr(string);
sprintf(string,"  ONE:\r\n%s\r\n",&User.Comments[0][0]);
PutStr(string);
sprintf(string,"  TWO:\r\n%s\r\n",&User.Comments[1][0]);
PutStr(string);
sprintf(string,"THREE:\r\n%s\r\n\r\n",&User.Comments[2][0]);
PutStr(string);

PurgeLine();
PutStr("[N] to re-enter, [Y] to approve\r\n");
PutStr("Is the information Correct? ");

FOREVER
	{
	ch=ReadChar(120L);
	if(ch==TIMEOUT || stat==NO_CARRIER) { return(stat); }
	if(Whence_The_Logon>=REMOTE_LOGON)
		{
		stat=CheckCarrier();
		if(stat==FALSE) { return(NO_CARRIER); }
		}
	if(ch=='N' || ch=='n' || ch=='Q' || ch=='q')
		{
		PutStr("No, please re-enter\r\n\r\n");
		goto JLoop1;
		}
	if(ch=='Y' || ch=='y') { break; }
	else { continue; }
	}
PutStr("Yes, it is correct\r\n\r\n");

User.Sec_Status=System.User_Defaults.New.Sec_Status;
User.Sec_Board=System.User_Defaults.New.Sec_Board;
User.Sec_Library=System.User_Defaults.New.Sec_Library;
User.Sec_Bulletin=System.User_Defaults.New.Sec_Bulletin;
User.Time_Limit=System.User_Defaults.New.Time_Limit;
User.Time_Used=0L;
User.Time_Total=0L;
User.Messages_Posted=0;
User.Mail_Sent=0;
User.Mail_Received=0;
User.Uploads=0;
User.Downloads=0;
User.Protocol=0;

Save_Account(&User);
PutStr("Your account has been saved\r\n\r\n");
StatPrintUser(&User);

PutStr("When you call again, you will NEED to know:\r\n\r\n");
sprintf(string,"Acount #: %hu\r\n",User.Slot_Number);
PutStr(string);
sprintf(string,"PassWord: %s\r\n\r\n",User.Pass);
PutStr(string);
PutStr("\r\n");
PurgeLine();
PutStr("WRITE THEM DOWN! then press any key to continue..");
ch=ReadChar(120L);
if(ch==TIMEOUT || stat==NO_CARRIER) { return(stat); }
PutStr("\r\n");

strcpy(string,System.Location);
strcat(string,"Joined.Text");
stat=MenuSend(string);
if(stat==TIMEOUT || stat==NO_CARRIER) { return(stat); }

Append_Stat(STAT_NEW_MEMBER);
Clear_Online_Status();
return(SUCCESS);
}
