/*******************************\
* GENERATE.C			*
* (C)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/types.h>
#include <stdio.h>
#include "System.h"
#include "Defines.h"

static void Create_Boards(), Create_Libraries(), Create_Bulletins();
static void Create_System();

static char Separator[] = "\t\t\t\t\b\253\253\253\253\253\253\253\253\253\n";
static char Clear[] 	= "\014";
static char Bold[] 	= "\2331m";
static char Normal[] 	= "\2330m";

static struct Board_Data board_template = {
	"Message Title Here----------30"
	,"Author Name----------------30",0,0,0,0L,""
	};
static struct Library_Data library_template = {
	"Transfer Filename Here------30",
	"Description-----------------------------\
------------------------------------79",
	"Source Person Name----------30",0,0,0L,""
	};
static struct Mail_Data mail_template = {
	"Letter Title Here-----------30",
	"Author Name-----------------30",0,0,0,0L,""
	};
static struct User user_template = {
	"User Name-------------------30",
	"Pass---8",
	"Comment #1------------------------------\
-------------------------------------79<",
	"Comment #2------------------------------\
-------------------------------------79<",
	"Comment #3------------------------------\
-------------------------------------79<",
	0,0,0,0,0,0,0,0,0,0,0,0L,0L,0L,0L,
	"Padding-----------------------------------------End of struct <"
	};
static char post_template[2500] = {'\0'};

main()
{
extern int Enable_Abort;

Enable_Abort=0;

printf(Clear);
printf(Bold);
printf("\t\t\t\tGENERATE 1.02\n");
printf(Normal);
printf("\t\t\t  \2511986, Patrick E. Hughes\n\n");

printf(Bold);
printf(Separator);
printf(Normal);

printf("\tTag_System - Mail - Accounts\n\n");
Create_System();

printf(Bold);
printf(Separator);
printf(Normal);

printf("\tTag_Boards\n\n");
Create_Boards();

printf(Bold);
printf(Separator);
printf(Normal);
printf("\tTag_Libraries\n\n");
Create_Libraries();

printf(Bold);
printf(Separator);
printf(Normal);
printf("Creation complete\n");
}

/*************************/
void Create_Boards(){
FILE *fp, *f;
int stat, count;
struct Board_Header bh;
struct Board_Data template;
int Boards_Are_Active;
char trashcan[132];

Boards_Are_Active=0;
fp=fopen("s:Tag_Boards","r");
if(fp==NULL)
	{
	puts("No boards configured\n\n");
	return;
	}

FOREVER
	{
	(void)fscanf(fp, "%[^B]",trashcan);
	stat=fscanf(fp, "BOARD:%30[^\n]", bh.Name);
	if(stat!=1)
		{
		fclose(fp);
		break;
		}
	(void)fscanf(fp, "%[^L]",trashcan);

	stat=fscanf(fp, "LOCAT:%80[^\n]", bh.Location);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s LOCAT error\n\n",bh.Name);
		return;
		}
	(void)fscanf(fp, "%[^R]",trashcan);

	stat=fscanf(fp, "READ:%hu", &bh.Read_Low);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s READ Low error\n\n",bh.Name);
		return;
		}
	stat=fscanf(fp, ",%hu", &bh.Read_High);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s READ High error\n\n",bh.Name);
		return;
		}
	(void)fscanf(fp, "%[^W]",trashcan);

	stat=fscanf(fp, "WRITE:%hu", &bh.Write_Low);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s WRITE Low error\n\n",bh.Name);
		return;
		}
	stat=fscanf(fp, ",%hu", &bh.Write_High);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s WRITE High error\n\n",bh.Name);
		return;
		}
	(void)fscanf(fp, "%[^P]",trashcan);

	stat=fscanf(fp, "POSTS:%hu", &bh.Maximum);
	if(stat!=1)
		{
		fclose(fp);
		printf("Board %s POSTS error\n\n",bh.Name);
		return;
		}
	/***/
	strcpy(trashcan,bh.Location);
	strcat(trashcan,"Board.Keys");
	f=fopen(trashcan,"x"); /* MUST NOT PREVIOUSLY EXIST */
	if(f==NULL)
		{
		printf("Board %s PREVIOUS KEYS exist, skipping creation\n",bh.Name);
		goto SkipPast1;
		}
	printf("Board %s KEYS: ",bh.Name);
	for(count=0;count<bh.Maximum;++count)
		{
		printf("%5d\b\b\b\b\b",count+1);
		stat=fwrite(&board_template,sizeof(struct Board_Data),1,f);
		if(stat!=1)
			{
			printf("\nBoard %s CREATE KEYS error, cannot write fully\n",bh.Name);
			break;
			}
		}
	printf("\n");
	fclose(f);
	strcpy(trashcan,bh.Location);
	strcat(trashcan,"Board.Data");
	f=fopen(trashcan,"w");
	if(f==NULL)
		{
		printf("Board %s CREATE DATA error, cannot make file\n",bh.Name);
		}
	printf("Board %s DATA: ",bh.Name);
	for(count=0;count<bh.Maximum;++count)
		{
		printf("%5d\b\b\b\b\b",count+1);
		stat=fwrite(&post_template[0],2500,1,f);
		if(stat!=1)
			{
			printf("\nBoard %s CREATE DATA error, cannot write fully\n",bh.Name);
			break;
			}
		}
	fclose(f);
	printf("\n\n");

SkipPast1:
	++Boards_Are_Active;
	}

printf("Total : %d boards confirmed\n\n",Boards_Are_Active);
}

/************************/
void Create_Libraries()
{
FILE *fp, *f;
int stat, count;
struct Library_Header lh;
struct Library_Data template;
int Libraries_Are_Active;
char trashcan[132];

Libraries_Are_Active=0;
fp=fopen("s:Tag_Libraries","r");
if(fp==NULL)
	{
	puts("No Libraries configured\n\n");
	return;
	}

FOREVER
	{
	(void)fscanf(fp, "%[^L]",trashcan);
	stat=fscanf(fp, "LIBRARY:%30[^\n]", lh.Name);
	if(stat!=1)
		{
		fclose(fp);
		break;
		}
	(void)fscanf(fp, "%[^L]",trashcan);

	stat=fscanf(fp, "LOCAT:%80[^\n]", lh.Location);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s LOCAT error\n\n",lh.Name);
		return;
		}
	(void)fscanf(fp, "%[^U]",trashcan);

	stat=fscanf(fp, "UPLOAD:%hu", &lh.Upload_Low);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s UPLOAD Low error\n\n",lh.Name);
		return;
		}
	stat=fscanf(fp, ",%hu", &lh.Upload_High);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s UPLOAD High error\n\n",lh.Name);
		return;
		}
	(void)fscanf(fp, "%[^D]",trashcan);

	stat=fscanf(fp, "DOWNLOAD:%hu", &lh.Download_Low);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s DOWNLOAD Low error\n\n",lh.Name);
		return;
		}
	stat=fscanf(fp, ",%hu", &lh.Download_High);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s DOWNLOAD High error\n\n",lh.Name);
		return;
		}
	(void)fscanf(fp, "%[^F]",trashcan);

	stat=fscanf(fp, "FILES: %hu", &lh.Maximum);
	if(stat!=1)
		{
		fclose(fp);
		printf("Library %s FILES error\n\n",lh.Name);
		return;
		}
	/***/
	strcpy(trashcan,lh.Location);
	strcat(trashcan,"Library.Keys");
	f=fopen(trashcan,"x");
	if(f==NULL)
		{
		printf("Library %s PREVIOUS KEYS exist, skipping creation\n",lh.Name);
		goto SkipPast2;
		}
	printf("Library %s KEYS: ",lh.Name);
	for(count=0;count<lh.Maximum;++count)
		{
		printf("%5d\b\b\b\b\b",count+1);
		stat=fwrite(&library_template,sizeof(struct Library_Data),1,f);
		if(stat!=1)
			{
			printf("Library %s CREATE KEYS error, cannot write fully\n",lh.Name);
			break;
			}
		}
	printf("\n\n");
	fclose(f);

SkipPast2:
	++Libraries_Are_Active;
	}

printf("Total : %d libraries confirmed\n\n",Libraries_Are_Active);
}

/************************/
void Create_Bulletins()
{
FILE *fp, *f;
int stat;
struct Bulletin_Header bh, template;
int Bulletins_Are_Active;
char trashcan[132];

Bulletins_Are_Active=0;
fp=fopen("s:Tag_Bulletins","r");
if(fp==NULL)
	{
	puts("No Bulletins available\n\n");
	return;
	}

FOREVER
	{
	(void)fscanf(fp, "%[^B]",trashcan);
	stat=fscanf(fp, "BULLETIN:%30[^\n]", bh.Filename);
	if(stat!=1)
		{
		fclose(fp);
		break;
		}
	(void)fscanf(fp, "%[^L]",trashcan);

	stat=fscanf(fp, "LOCAT:%80[^\n]", bh.Location);
	if(stat!=1)
		{
		fclose(fp);
		printf("Bulletin %s LOCAT error\n\n",bh.Filename);
		return;
		}
	(void)fscanf(fp, "%[^R]",trashcan);

	stat=fscanf(fp, "READ:%hu", &bh.Read_Low);
	if(stat!=1)
		{
		fclose(fp);
		printf("Bulletin %s READ Low error\n\n",bh.Filename);
		return;
		}
	stat=fscanf(fp, ",%hu", &bh.Read_High);
	if(stat!=1)
		{
		fclose(fp);
		printf("Bulletin %s READ High error\n\n",bh.Filename);
		return;
		}
	/***/
	++Bulletins_Are_Active;

	if(bh.Read_Low>bh.Read_High)
		{
		printf("Bulletin %s READ low greater than high\n",bh.Filename);
		}
	}

printf("Total : %d bulletins confirmed\n\n",Bulletins_Are_Active);
}

/************************/
void Create_System()
{
FILE *fp, *f;
int stat, count;
struct System sys;
struct Mail_Header maildummy;
struct Mail_Data template;
char trashcan[132];

sys.Mail_List=&maildummy;

fp=fopen("s:Tag_System","r");
if(fp==NULL)
	{
	puts("No System Configured\n\n");
	return;
	}

(void)fscanf(fp, "%[^S]",trashcan);
stat=fscanf(fp, "SYSTEM:%30[^\n]", sys.Name);
if(stat!=1)
	{
	printf("System SYSTEM error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^L]",trashcan);

stat=fscanf(fp, "LOCAT:%80[^\n]", sys.Location);
if(stat!=1)
	{
	printf("System LOCAT error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^S]",trashcan);

stat=fscanf(fp, "SYSOP:%30[^\n]", sys.Sysop);
if(stat!=1)
	{
	printf("System SYSOP error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^U]",trashcan);

(void)fscanf(fp, "USERS:", trashcan);
(void)fscanf(fp, "%[^A]",trashcan);

stat=fscanf(fp, "ACCOUNTS:%hu", &sys.User_Defaults.Maximum);
if(stat!=1)
	{
	printf("System USERS:ACCOUNTS error\n");
	fclose(fp);
	return;
	}
/*********/
strcpy(trashcan,sys.Location);
strcat(trashcan,"User.Data");
f=fopen(trashcan,"x");
if(f==NULL)
	{
	printf("User PREVIOUS DATA exists, skipping creation\n");
	goto SkipPast3;
	}
printf("User DATA: ");
for(count=0;count<sys.User_Defaults.Maximum;++count)
	{
	printf("%5d\b\b\b\b\b",count+1);
	stat=fwrite(&user_template,sizeof(struct User),1,f);
	if(stat!=1)
		{
		printf("\nUser CREATE DATA error, cannot write fully\n");
		break;
		}
	}

SkipPast3:
printf("\n");
fclose(f);

(void)fscanf(fp, "%[^G]",trashcan);

(void)fscanf(fp, "GUEST:", trashcan);
(void)fscanf(fp, "%[^S]",trashcan);

stat=fscanf(fp, "STSEC:%hu", &sys.User_Defaults.Guest.Sec_Status);
if(stat!=1)
	{
	printf("System GUEST:STSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BDSEC:%hu", &sys.User_Defaults.Guest.Sec_Board);
if(stat!=1)
	{
	printf("System GUEST:BDSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^L]",trashcan);

stat=fscanf(fp, "LBSEC:%hu", &sys.User_Defaults.Guest.Sec_Library);
if(stat!=1)
	{
	printf("System GUEST:LBSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BUSEC:%hu", &sys.User_Defaults.Guest.Sec_Bulletin);
if(stat!=1)
	{
	printf("System GUEST:BUSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^T]",trashcan);

stat=fscanf(fp, "TIME:%ld", &sys.User_Defaults.Guest.Time_Limit);
if(stat!=1)
	{
	printf("System GUEST:TIME error\n");
	fclose(fp);
	return;
	}

/***/
(void)fscanf(fp, "%[^N]",trashcan);

(void)fscanf(fp, "NEW:", trashcan);
(void)fscanf(fp, "%[^S]",trashcan);

stat=fscanf(fp, "STSEC:%hu", &sys.User_Defaults.New.Sec_Status);
if(stat!=1)
	{
	printf("System NEW:STSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BDSEC:%hu", &sys.User_Defaults.New.Sec_Board);
if(stat!=1)
	{
	printf("System NEW:BDSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^L]",trashcan);

stat=fscanf(fp, "LBSEC:%hu", &sys.User_Defaults.New.Sec_Library);
if(stat!=1)
	{
	printf("System NEW:LBSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BUSEC:%hu", &sys.User_Defaults.New.Sec_Bulletin);
if(stat!=1)
	{
	printf("System NEW:BUSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^T]",trashcan);

stat=fscanf(fp, "TIME:%ld", &sys.User_Defaults.New.Time_Limit);
if(stat!=1)
	{
	printf("System NEW:TIME error\n");
	fclose(fp);
	return;
	}
/***/
(void)fscanf(fp, "%[^V]",trashcan);

(void)fscanf(fp, "VALID:", trashcan);
(void)fscanf(fp, "%[^S]",trashcan);

stat=fscanf(fp, "STSEC:%hu", &sys.User_Defaults.Valid.Sec_Status);
if(stat!=1)
	{
	printf("System VALID:STSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BDSEC:%hu", &sys.User_Defaults.Valid.Sec_Board);
if(stat!=1)
	{
	printf("System VALID:BDSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^L]",trashcan);

stat=fscanf(fp, "LBSEC:%hu", &sys.User_Defaults.Valid.Sec_Library);
if(stat!=1)
	{
	printf("System VALID:LBSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^B]",trashcan);

stat=fscanf(fp, "BUSEC:%hu", &sys.User_Defaults.Valid.Sec_Bulletin);
if(stat!=1)
	{
	printf("System VALID:BUSEC error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^T]",trashcan);

stat=fscanf(fp, "TIME:%ld", &sys.User_Defaults.Valid.Time_Limit);
if(stat!=1)
	{
	printf("System VALID:TIME error\n");
	fclose(fp);
	return;
	}
/***/

(void)fscanf(fp, "%[^M]", trashcan);

(void)fscanf(fp, "MAIL:", trashcan);
(void)fscanf(fp, "%[^L]", trashcan);

stat=fscanf(fp, "LOCAT:%80[^\n]", sys.Mail_List->Location);
if(stat!=1)
	{
	printf("System MAIL:LOCAT error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^L]", trashcan);

stat=fscanf(fp, "LETTERS:%hu", &sys.Mail_List->Maximum);
if(stat!=1)
	{
	printf("System MAIL:LETTERS error\n");
	fclose(fp);
	return;
	}
/***/
strcpy(trashcan,sys.Mail_List->Location);
strcat(trashcan,"Mail.Keys");
f=fopen(trashcan,"x");
if(f==NULL)
	{
	printf("Mail PREVIOUS KEYS exist, skipping creation\n");
	goto SkipPast4;
	}
printf("Mail KEYS: ");
for(count=0;count<sys.Mail_List->Maximum;++count)
	{
	printf("%5d\b\b\b\b\b",count+1);
	stat=fwrite(&mail_template,sizeof(struct Mail_Data),1,f);
	if(stat!=1)
		{
		printf("\nMail CREATE KEYS error, cannot write fully\n");
		break;
		}
	}
printf("\n");
fclose(f);

strcpy(trashcan,sys.Mail_List->Location);
strcat(trashcan,"Mail.Data");
f=fopen(trashcan,"w");
if(f==(-1))
	{
	printf("Mail CREATE DATA error, cannot make file\n");
	}
printf("Mail DATA: ");
for(count=0;count<sys.Mail_List->Maximum;++count)
	{
	printf("%5d\b\b\b\b\b",count+1);
	stat=fwrite(&post_template,2500,1,f);
	if(stat!=1)
		{
		printf("Mail CREATE DATA error, cannot write fully\n");
		break;
		}
	}
printf("\n\n");
fclose(f);

SkipPast4:

(void)fscanf(fp, "%[^M]", trashcan);

(void)fscanf(fp, "MODEM:", trashcan);
(void)fscanf(fp, "%[^O]", trashcan);

stat=fscanf(fp, "OPEN:%80[^\n]", sys.Modem.Open);
if(stat!=1)
	{
	printf("System MODEM:OPEN error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^R]", trashcan);

stat=fscanf(fp, "RESET:%80[^\n]", sys.Modem.Reset);
if(stat!=1)
	{
	printf("System MODEM:RESET error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^R]", trashcan);

stat=fscanf(fp, "RING:%80[^\n]", sys.Modem.Ring);
if(stat!=1)
	{
	printf("System MODEM:RING error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^A]", trashcan);

stat=fscanf(fp, "ANSWER:%80[^\n]", sys.Modem.Answer);
if(stat!=1)
	{
	printf("System MODEM:ANSWER error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^3]", trashcan);

stat=fscanf(fp, "300:%80[^\n]", sys.Modem.B300);
if(stat!=1)
	{
	printf("System MODEM:300 error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^1]", trashcan);

stat=fscanf(fp, "1200:%80[^\n]", sys.Modem.B1200);
if(stat!=1)
	{
	printf("System MODEM:1200 error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^2]", trashcan);

stat=fscanf(fp, "2400:%80[^\n]", sys.Modem.B2400);
if(stat!=1)
	{
	printf("System MODEM:2400 error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^4]", trashcan);

stat=fscanf(fp, "4800:%80[^\n]", sys.Modem.B4800);
if(stat!=1)
	{
	printf("System MODEM:4800 error\n");
	fclose(fp);
	return;
	}
(void)fscanf(fp, "%[^9]", trashcan);

stat=fscanf(fp, "9600:%80[^\n]", sys.Modem.B9600);
if(stat!=1)
	{
	printf("System MODEM:9600 error\n");
	fclose(fp);
	return;
	}

/***/

fclose(fp);
return;
}

_stkover()
{
puts("TYPE \"STACK 10000\" IN CLI BEFORE RUNNING GENERATE\n");
exit(100);
}

_cli_parse()
{;}
_wb_parse()
{;}
