/*******************************\
* CORE.C			*
* (c)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/io.h>
#include <exec/types.h>
#include <exec/memory.h>
#include <stdio.h>
#include <fcntl.h>
#include <intuition/intuition.h>
#include <devices/console.h>
#include <devices/serial.h>
#include <devices/timer.h>
#include <time.h>
#include <setjmp.h>
#include <exec/tasks.h>
#include <libraries/dosextens.h>
#include <ctype.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/

extern struct IntuitionBase *IntuitionBase;
extern struct NewWindow PaneStatus;
extern struct Window *StatusPane;
extern struct NewWindow NewWindow;
extern struct Window *window;
extern struct System System;
extern struct User User;
extern struct IOExtSer *WriteSerReq, *ReadSerReq;
extern struct IOStdReq *WriteConReq, *ReadConReq, *StatWriteReq;
extern struct timerequest *TimerMsg;
extern struct MsgPort *WriteSerPort, *ReadSerPort, *TimerPort;
extern struct MsgPort *WriteConPort, *ReadConPort, *StatWritePort;

extern ULONG TimerSig, SerCharSig, ConCharSig, WindowSig;
extern UBYTE serin[], conin[];

extern int Boards_Are_Active, Libraries_Are_Active;
extern int Bulletins_Are_Active, Mail_Is_Active;
extern int Whence_The_Logon;
extern int IO_Flags[];
extern long Time_connect, Time_system, Time_menu_entry, Time_remaining,
	Time_limit;

extern jmp_buf Environment;

static int printer_file=(-1), transcript_file=(-1), macro_file=(-1);
static int ChatFlag=0;

/***********************\
* CHECKCSI()		*
\***********************/
CheckCSI()
{
int c,ch;

ch=GetConKey(1L);
if((ch>='A')&&(ch<'E')) { return(FALSE); }
while((c=GetConKey(2L))!='~') { ; }
switch(ch)
	{
	case '9': /* F10 - SER_OUT */
		IO_Flags[IOFLAG_SER_OUT]=!IO_Flags[IOFLAG_SER_OUT];
		if(IO_Flags[IOFLAG_SER_OUT]==0)
			{
			StatRollMessage("SER Output OFF");
			}
		else
			{
			StatRollMessage("SER Output ON");
			}
		break;
	case '8': /* F9 - SCR_OUT */
		IO_Flags[IOFLAG_SCR_OUT]=!IO_Flags[IOFLAG_SCR_OUT];
		if(IO_Flags[IOFLAG_SCR_OUT]==0)
			{
			StatRollMessage("SCR Output OFF");
			}
		else
			{
			StatRollMessage("SCR Output ON");
			}
		break;
	case '7': /* F8 - PRT_OUT */
		IO_Flags[IOFLAG_PRT_OUT]=!IO_Flags[IOFLAG_PRT_OUT];
		if(IO_Flags[IOFLAG_PRT_OUT]==0)
			{
			StatRollMessage("PRT Output OFF");
			if(printer_file!=-1) { close(printer_file); }
			printer_file=(-1);
			}
		else
			{
			StatRollMessage("PRT Output ON");
			}
		break;
	case '6': /* F7 - FIL_OUT */
		IO_Flags[IOFLAG_FIL_OUT]=!IO_Flags[IOFLAG_FIL_OUT];
		if(IO_Flags[IOFLAG_FIL_OUT]==0)
			{
			StatRollMessage("Transcript OFF");
			if(transcript_file!=-1) { close(transcript_file); }
			transcript_file=(-1);
			}
		else
			{
			StatRollMessage("Transcript ON");
			}
		break;
	case '5': /* F6 - SER_IN */
		IO_Flags[IOFLAG_SER_IN]=!IO_Flags[IOFLAG_SER_IN];
		if(IO_Flags[IOFLAG_SER_IN]==0)
			{
			StatRollMessage("SER Input OFF");
			}
		else
			{
			StatRollMessage("SER Input ON");
			}
		break;
	case '4': /* F5 - KBD_IN */
		IO_Flags[IOFLAG_KBD_IN]=!IO_Flags[IOFLAG_KBD_IN];
		if(IO_Flags[IOFLAG_KBD_IN]==0)
			{
			StatRollMessage("KBD Input OFF");
			}
		else
			{
			StatRollMessage("KBD Input ON");
			}
		break;
	case '3': /* F4 - FORCE LOGOFF */
		StatRollMessage("Force Logoff");
		longjmp(Environment,ILLEGAL_LOGOFF);
		break;
	case '2': /* F3 - DECREASE TIME LIMIT */
		StatRollMessage("Time Limit - 10min");
		Time_limit-=600L;
		break;
	case '1': /* F2 - INCREASE TIME LIMIT */
		StatRollMessage("Time Limit + 10min");
		Time_limit+=600L;
		break;
	case '0': /* F1 - CHAT TOGGLE */
		ChatFlag=!ChatFlag;
		if(ChatFlag==0) { return(FALSE); }
		Chat();
		return(1);
		break;
	}

return(0);
}

/***********************\
* CHECKMESSAGE()	*
\***********************/
CheckMessage()
{;}

/***********************\
* RESET_SYSTEM()	*
\***********************/
int Reset_System()
{
int count;
char string[81];
char statbuf[20];

StatRollMessage("Reset System");

IO_Flags[IOFLAG_KBD_IN]=1;
IO_Flags[IOFLAG_SER_IN]=1;
if(IO_Flags[IOFLAG_FIL_IN])
	{
	IO_Flags[IOFLAG_FIL_IN]=0;
	close(macro_file);
	}
IO_Flags[IOFLAG_SCR_OUT]=0;
IO_Flags[IOFLAG_SER_OUT]=0;

SetDTR(FALSE);
Delay(25L);
SetDTR(TRUE);
Delay(25L);
SerPutStr(System.Modem.Reset);
SerPutChar('\r');
Delay(25L);
PurgeLine();

sprintf(string,"\017\014\n\n\n\n\n\t\t\t%s\n\t\t\t",System.Name);
ConPutStr(string);
ConPutStr(">");
for(count=0;count<strlen(System.Name)/2;++count)
	{
	ConPutStr("XO");
	}
ConPutStr("\b<\n\n");

/* clean up StatusPane */
sprintf(statbuf,"\033c\14\2331m\0");	/* clear screen and text bold */
StatPrint(statbuf);
StatCursorTo(1,1);
StatPrint("Name:");		/* Name: */
StatCursorTo(7,2);
StatPrint("Number:");		/* Number: */
StatCursorTo(1,3);
StatPrint("Time Remains:");	/* Elapsed Time: */
StatCursorTo(23,2);
StatPrint("Status:");		/* Status: */
StatCursorTo(43,2);
StatPrint("Currently:");	/* Currently: */
StatCursorTo(41,1);
StatPrint("Last Action:");	/* Last Action: */
StatCursorTo(45,3);
StatPrint("Special:");		/* Special: */
StatCursorTo(79,2);
StatPrint("_");			  /* make a   */
StatCursorTo(78,3);		 /* home for */
StatPrint("|");			/*  cursor  */
sprintf(statbuf,"\2330m");     /* and set text to normal */
StatPrint(statbuf);
StatParkCursor();

}

/***************\
* AWAIT_LOGON()	*
\***************/
int Await_Logon()
{
extern int Online_Baud;
int stat;
int input;
char string[81];

StatRollMessage("Await Logon");

FOREVER
	{
	Cycle_The_Display();

	do{ input=LineInput("",string,80,1L); } while(input==0);

	if(input==TIMEOUT) { continue; }

	if(string[0]==' ')
		{
		IO_Flags[IOFLAG_SER_IN]=0;
		IO_Flags[IOFLAG_SER_OUT]=0;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		IO_Flags[IOFLAG_KBD_IN]=1;
		StatRollMessage("Local Logon");
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=9600;
		return(LOCAL_LOGON);
		}
	if(string[0]=='?')
		{
		StatRollMessage("Local Commands");
		ConPutStr("\014\n\nCommands Available While Waiting\n\n");
		ConPutStr("[0]     = EXIT TO CLI\n");
		ConPutStr("[space] = LOCAL LOGON\n");
		ConPutStr("[$]     = SYSOP IMMEDIATE LOGON\n");
		ConPutStr("[A]     = ACCOUNT EDITING\n");
		StatRollMessage("Await Logon");
		continue;
		}
	if(string[0]=='$')
		{
		IO_Flags[IOFLAG_SER_IN]=0;
		IO_Flags[IOFLAG_SER_OUT]=0;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		IO_Flags[IOFLAG_KBD_IN]=1;
		StatRollMessage("Sysop Logon");
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=9600;
		return(SYSOP_LOGON);
		}
	if(string[0]=='A'||string[0]=='a')
		{
		IO_Flags[IOFLAG_SER_IN]=0;
		IO_Flags[IOFLAG_SER_OUT]=0;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		IO_Flags[IOFLAG_KBD_IN]=1;
		StatRollMessage("Account Utility");
		SendChar('\014');
		Time_limit=3600L;
		Whence_The_Logon=LOCAL_LOGON;
		Edit_Accounts();
		Reset_System();
		IO_Flags[IOFLAG_KBD_IN]=1;
		IO_Flags[IOFLAG_SER_IN]=1;
		if(IO_Flags[IOFLAG_FIL_IN])
			{
			IO_Flags[IOFLAG_FIL_IN]=0;
			close(macro_file);
			}
		IO_Flags[IOFLAG_SCR_OUT]=0;
		IO_Flags[IOFLAG_SER_OUT]=0;
		StatRollMessage("Await Logon");
		continue;
		}
	if(string[0]=='0')
		{
		ShutDown("TAG-BBS exiting to CLI");
		}
	if((stat=StringCompare(string,System.Modem.Ring))==FAILURE)
		{
		continue;
		}
	/* OTHERWISE EQUAL, ANSWER AND SET BAUDS */
	StatRollMessage("Ring Ring");
	SerPutStr(System.Modem.Answer);
	SerPutChar('\r');
	input=LineInput("",string,80,30L);
	if(input==TIMEOUT)
		{
		StatRollMessage("False Alarm");
		StatRollMessage("Await Logon");
		continue;
		}
	input=LineInput("",string,80,30L);
	if(input==TIMEOUT) { continue; }
	if((stat=StringCompare(string,System.Modem.B9600))==SUCCESS)
		{
		/* set up 9600 baud, & return */
		StatRollMessage("Remote 9600");
		SetBaud(9600L);
		IO_Flags[IOFLAG_SER_OUT]=1;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=9600;
		return(REMOTE_LOGON);
		}
	if((stat=StringCompare(string,System.Modem.B4800))==SUCCESS)
		{
		/* set up 4800 baud, & return */
		StatRollMessage("Remote 4800");
		SetBaud(4800L);
		IO_Flags[IOFLAG_SER_OUT]=1;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=4800;
		return(REMOTE_LOGON);
		}
	if((stat=StringCompare(string,System.Modem.B2400))==SUCCESS)
		{
		/* set up 2400 baud, & return */
		StatRollMessage("Remote 2400");
		SetBaud(2400L);
		IO_Flags[IOFLAG_SER_OUT]=1;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=2400;
		return(REMOTE_LOGON);
		}
	if((stat=StringCompare(string,System.Modem.B1200))==SUCCESS)
		{
		/* set up 1200 baud, & return */
		StatRollMessage("Remote 1200");
		SetBaud(1200L);
		IO_Flags[IOFLAG_SER_OUT]=1;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=1200;
		return(REMOTE_LOGON);
		}
	if((stat=StringCompare(string,System.Modem.B300))==SUCCESS)
		{
		/* set up 300 baud, & return */
		StatRollMessage("Remote 300");
		SetBaud(300L);
		IO_Flags[IOFLAG_SER_OUT]=1;
		IO_Flags[IOFLAG_SCR_OUT]=1;
		SendChar('\014');
		Time_connect=time(NULL);
		Online_Baud=300;
		return(REMOTE_LOGON);
		}
	/* ELSE RESET, PURGE AND CONTINUE THE LOOP */
	SetDTR(FALSE);
	Delay(25L);
	SetDTR(TRUE);
	Delay(25L);
	SerPutStr(System.Modem.Reset);
	SerPutChar('\r');
	Delay(25L);
	PurgeLine();
	StatRollMessage("False Alarm");
	StatRollMessage("Await Logon");
	}
}

/***********************\
* CYCLE_THE_DISPLAY()	*
\***********************/
int Cycle_The_Display()
{
register char *t;

Time_system=time(NULL);
t=ctime(&Time_system);
t[strlen(t)-1]='\0';
StatPrintTime(t);
}

/***************\
* LINEINPUT()	*
\***************/
int LineInput(atstart,tohere,maxlen,time_allowed)
	register char atstart[],tohere[];
	register int maxlen;
	long time_allowed;
{
register int c, ch, x;

x=strlen(atstart);
PutStr(atstart);
strcpy(tohere,atstart);

FOREVER
	{
	c=ReadChar((long)time_allowed);
	if(c==TIMEOUT) { return(TIMEOUT); }
	c&=0x7f;
	if(x<maxlen)
		{
		switch(c)
			{
			case '\r': /*  RETURN, IGNORE \n  */
				tohere[x]='\0';
				PutStr("\r\n");
				return(x);
			case '\b': /*  BACKSPACE && DELETE  */
			case '\177':
				if(x)
					{
					tohere[--x]='\0';
					PutStr("\b \b");
					}
				break;
			case '\30': /*  ^X DELETE LINE */
				while(x)
					{
					PutStr("\b \b");
					--x;
					}
				tohere[x]='\0';
				break;
			case '\11': /* TAB */
				if(x%5==0)
					{
					tohere[x++]=' ';
					SendChar(' ');
					}
				if(x<(maxlen-5))
					{
					while(x%5)
						{
						tohere[x++]=' ';
						SendChar(' ');
						}
					}
				break;
			default:
				if(c<' ') { break; } /* CONTROL FILTER */
				tohere[x++]=(char)c;
				SendChar(c);
				break;
			}
		}
	else
		{
		switch(c)
			{
			case '\r': /*  RETURNS  */
				tohere[x]='\0';
				PutStr("\r\n");
				return(x);
			case '\b': /*  BACKSPACES  */
			case '\177':
				tohere[--x]='\0';
				PutStr("\b \b");
				break;
			case '\30': /*  ^X  */
				while(x)
					{
					PutStr("\b \b");
					--x;
					}
				tohere[x]='\0';
				break;
			}
		}
	}
}

/***********************\
* LINEINPUTCONVERTED()	*
\***********************/
int LineInputConverted(atstart,tohere,maxlen,time_allowed)
	register char atstart[],tohere[];
	register int maxlen;
	long time_allowed;
{
register int c, ch, x;

x=strlen(atstart);
PutStr(atstart);
strcpy(tohere,atstart);

FOREVER
	{
	c=ReadChar((long)time_allowed);
	if(c==TIMEOUT) { return(TIMEOUT); }
	c&=0x7f;
	if(x<maxlen)
		{
		switch(c)
			{
			case '\r': /*  returns  */
				tohere[x]='\0';
				PutStr("\r\n");
				return(x);
			case '\b': /*  backspaces  */
			case '\177':
				if(x)
					{
					tohere[--x]='\0';
					PutStr("\b \b");
					}
				break;
			case '\30': /*  ^X  */
				while(x)
					{
					PutStr("\b \b");
					--x;
					}
				tohere[x]='\0';
				break;
			case '\11': /* tab */
				if(x%5==0)
					{
					tohere[x++]=' ';
					SendChar(' ');
					}
				if(x<(maxlen-5))
					{
					while(x%5){
						tohere[x++]=' ';
						SendChar(' ');
						}
					}
				break;
			default:
				if(c<' ')
					break; /*  control char filter  */
				tohere[x++]=(char)c&0x7f;
				SendChar('?');
				break;
			}
		}
	else
		{
		switch(c)
			{
			case '\r': /*  returns  */
				tohere[x]='\0';
				PutStr("\r\n");
				return(x);
			case '\b': /*  backspaces  */
			case '\177':
				tohere[--x]='\0';
				PutStr("\b \b");
				break;
			case '\30': /*  ^X  */
				while(x)
					{
					PutStr("\b \b");
					--x;
					}
				tohere[x]='\0';
				break;
			}
		}
	}
}

/***********************\
* STRINGCOMPARE()	*
\***********************/
int StringCompare(s,t)
	register char *s, *t;
{
return(jive(s,t));
}

/***************\
* MENUSEND()	*
\***************/
int MenuSend(s)
	char *s;
{
FILE *fp;
int stat, count;
char c[256];

fp=fopen(s,"r");
if(fp==NULL)
	{
	sprintf(c,"File %s Unavailable\r\n",s);
	PutStr(c);
	return(FAILURE);
	}

FOREVER
	{
	count=0;
	do
		{
		stat=fgetc(fp);
		c[count++]=(char)stat;
		} while(stat!='\n' && stat!=EOF);
	c[--count]='\0';
	strcat(c,"\r\n");
	PutStr(c);
	if(stat==EOF) { break; }
	/* CHECK FOR INPUT && CARRIER */
	if(Whence_The_Logon>=REMOTE_LOGON)
		{
		stat=CheckCarrier();
		if(stat==FALSE)
			{
			fclose(fp);
			longjmp(Environment,CARRIER_LOGOFF);
			}
		}
	if(CheckInput())
		{
		stat=ReadChar(120L);
		stat&=0x7f;
		switch(stat)
			{
			case '\023': /* Pause */
			case 'S':
			case 's':
			case 'P':
			case 'p':
			case ' ':
				PutStr("Any Key");
				stat=ReadChar(240L);
				if(stat<0)
					{
					fclose(fp);
					longjmp(Environment,SLEEP_LOGOFF);
					}
				PutStr("\b\b\b\b\b\b\b       \b\b\b\b\b\b\b");
				break;
			case '\033': /* Esc Abort */
			case '\003': /* ^C */
			case '\020': /* ^P */
			case '\031': /* ^Y */
			case 'Q':
			case 'q':
			case 'X':
			case 'x':
				PutStr("\r\nCancel\r\n");
				goto MenuMark1;
				break;
			}
		}
	}

MenuMark1:
fclose(fp);
return(SUCCESS);
}

/***************\
* FILPUTSTR()	*
\***************/
int FilPutStr(s)
	char *s;
{
int status;
char le_nom[133];

if(transcript_file==(-1))
	{
	strcpy(le_nom,System.Location);
	strcat(le_nom,"Transcript.Text");
	transcript_file=open(le_nom,O_WRONLY+O_CREAT);
	if(transcript_file==(-1)){ IO_Flags[IOFLAG_FIL_OUT]=0; return; }
	}
lseek(transcript_file,(long)0,2); /* seek to end of file */
status=write(transcript_file,s,strlen(s));
if(status!=strlen(s))
	{
	close(transcript_file);
	IO_Flags[IOFLAG_FIL_OUT]=0;
	transcript_file=(-1);
	}
}

/***************\
* PRTPUTSTR()	*
\***************/
int PrtPutStr(s)
	char *s;
{
int status;
if(printer_file==(-1))
	{
	printer_file=open("prt:",O_WRONLY);
	if(printer_file==(-1)){ IO_Flags[IOFLAG_PRT_OUT]=0; return; }
	}
status=write(printer_file,s,strlen(s));
if(status!=strlen(s))
	{
	close(printer_file);
	IO_Flags[IOFLAG_PRT_OUT]=0;
	printer_file=(-1);
	}
}

/***************\
* PRTPUTSTR()	*
\***************/
int FilPutChar(c)
	char c;
{
int status;
char le_name[133];

if(transcript_file==(-1))
	{
	strcpy(le_name,System.Location);
	strcat(le_name,"Transcript.Text");
	transcript_file=open(le_name,O_WRONLY+O_CREAT);
	if(transcript_file==(-1)){ IO_Flags[IOFLAG_FIL_OUT]=0; return; }
	}
lseek(transcript_file,(long)0,2);
status=write(transcript_file,&c,1);
if(status!=1)
	{
	close(transcript_file);
	IO_Flags[IOFLAG_FIL_OUT]=0;
	transcript_file=(-1);
	}
}

/***************\
* PRTPUTSTR()	*
\***************/
int PrtPutChar(c)
	char c;
{
int status;

if(printer_file==(-1))
	{
	printer_file=open("prt:",O_WRONLY);
	if(printer_file==(-1))
		{
		IO_Flags[IOFLAG_PRT_OUT]=0;
		return;
		}
	}
status=write(printer_file,&c,1);
if(status!=1)
	{
	close(printer_file);
	IO_Flags[IOFLAG_PRT_OUT]=0;
	printer_file=(-1);
	}
}

/***************\
* CHAT()	*
\***************/
int Chat()
{
register int c, stat;

StatRollMessage("Enter Chat");

PutStr("\r\n>XOX< Chat With ");
PutStr(System.Sysop);
PutStr(">XOX<\r\n\r\n");

while(ChatFlag)
	{
	c=ReadChar(120L);
	if(c==TIMEOUT) { PutStr("\r\nTIMEOUT\r\n"); continue; }
	if(c=='\r') { PutStr("\r\n"); Check_Online_Status(); continue; }
	if(c=='\b' || c=='\177') { PutStr("\b \b"); continue; }
	if(c=='\001') { PutStr(" Ahh, you expected something? "); continue; }
	if(c=='\002') { PutStr(" Boo "); continue; }
	if(c=='\007') { PutStr("\007 The Bells, The Bells "); continue; }
	if(c=='\014') { PutStr(" {<Laughter>} "); continue; }
	if(c=='\017') { PutStr(" Obscurantist Drivel "); continue; }
	if(c=='\024') { PutStr(" \"Tea anyone,\" asks the Mad Hatter "); continue; }
	if(c=='\031') { PutStr(" Why? "); continue; }
	if(c=='\026')
		{
		PutStr("\r\nTAG-BBS Version 1.03\r\n");
		PutStr("(C)1986-87, Patrick E. Hughes\r\n");
		continue;
		}
	if(c=='\005')
		{
		Delay(40L);
		if( CheckCon() && (c=GetConKey(0)=='\005') )
			{
			ConPutStr("\r\n\r\nEdit Online Account\r\n");
			ConPutStr("Remember, F6=Ser-In, F10=Ser-Out\r\n");
			ConPutStr("if you wish to control what the user\r\n");
			ConPutStr("can DO and SEE while you edit his statistics\r\n");
			ConPutStr("Note that all changes are immediate and\r\n");
			ConPutStr("irreversible, being done directly to the\r\n");
			ConPutStr("account in memory; it is also saved that way\r\n");
			ConPutStr("just after logoff.\r\n");
			ConPutStr("any key..");
			c=GetConKey(1);
			ConPutStr("\r\n\r\n");
			Online_Edit();
			continue;
			}
		}
	if(c<' ') { continue; }
	SendChar(c);
	}

StatRollMessage("End Chat");
PutStr("\r\n\r\nEnding Chat.\r\n");
return(SUCCESS);
}

/*******************************************/
int StatCursorTo(x,y)
	register int x,y;
{
char statbuf[10];
sprintf(&statbuf[0],"\233%d;%dH",y,x);
StatWriteReq->io_Data=&statbuf[0];
StatWriteReq->io_Length=-1l;
StatWriteReq->io_Command=CMD_WRITE;
DoIO(StatWriteReq);
}
/*****************************************/
int StatPrint(s)
	register char *s;
{
StatWriteReq->io_Data=s;
StatWriteReq->io_Length=-1l;
StatWriteReq->io_Command=CMD_WRITE;
DoIO(StatWriteReq);
}
/******************************************/
int StatParkCursor()
{
StatCursorTo(80,3);
}
/*******************************************/
int StatMessage(x,y,s)
	register int x,y;
	register char *s;
{
StatCursorTo(x,y);
StatPrint(s);
StatParkCursor();
}
/******************************************/
int StatRollMessage(s)
	register char *s;
{
static char oldmessage[81];

StatMessage(54,1,"                         ");
StatMessage(54,1,oldmessage);
strcpy(oldmessage,s);
StatMessage(54,2,"                         ");
StatMessage(54,2,s);
}
/******************************************/
int StatPrintName(s)
	register char *s;
{
StatMessage(6,1,"                              ");
StatMessage(6,1,s);
}
/******************************************/
int StatPrintStatus(s)
	register char *s;
{
StatMessage(30,2,"        ");
StatMessage(30,2,s);
}
/******************************************/
int StatPrintSlot(s)
	register char *s;
{
StatMessage(14,2,"     ");
StatMessage(14,2,s);
}
/******************************************/
int StatPrintTime(s)
	register char *s;
{
StatMessage(14,3,"                         ");
StatMessage(14,3,s);
}
/********************************/
int StatPrintSpecial(s)
	register char *s;
{
StatMessage(54,3,"                        ");
StatMessage(54,3,s);
}
/******************************************/
int StatPrintUser(hoozer)
	register struct User *hoozer;
{
char string[81];

StatPrintName(hoozer->Name);

if(hoozer->Sec_Status==0) { StatPrintStatus("Guest"); goto Spu1; }
if(hoozer->Sec_Status==1) { StatPrintStatus("New"); goto Spu1; }
if(hoozer->Sec_Status>=2 && hoozer->Sec_Status<100){
	StatPrintStatus("Valid"); goto Spu1;
}
if(hoozer->Sec_Status>=100 && hoozer->Sec_Status<150){
	StatPrintStatus("BoardOp"); goto Spu1;
}
if(hoozer->Sec_Status>=150 && hoozer->Sec_Status<255){
	StatPrintStatus("LibOp"); goto Spu1;
}
if(hoozer->Sec_Status==255) { StatPrintStatus("Sysop"); goto Spu1; }
StatPrintStatus("None??");
Spu1:

sprintf(string,"%hu",hoozer->Slot_Number);
StatPrintSlot(string);

sprintf(string,"%lu Min & %lu Sec",
	(hoozer->Time_Limit-hoozer->Time_Used)/60L,
	(hoozer->Time_Limit-hoozer->Time_Used)%60L);
string[80]='\000';
StatPrintTime(string);
}

/*******************************/
jive(nam,pat)
	char *nam, *pat;
{
char *p;

for (;;)
	{
	if (tolower(*nam) == tolower(*pat))
		{
		if(*nam++ == '\0') { return(SUCCESS); }
		pat++;
		}
	else if (*pat == '?' && *nam != 0)
		{
		nam++;
		pat++;
		}
	else
		{
		break;
		}
	}
if (*pat != '*') { return(FAILURE); }
while (*pat == '*')
	{
	if (*++pat == '\0') { return(SUCCESS); }
	}

for (p=nam+strlen(nam)-1;p>=nam;p--)
	{
	if (tolower(*p) == tolower(*pat))
		{
		if (jive(p,pat) == SUCCESS) { return(SUCCESS); }
		}
	}
return(FAILURE);
}
/**************************/
int Online_Edit()
{
int flag, command, stat;

FOREVER
	{
	flag=0;
	Display_Account(User.Slot_Number,&User);
	command=ReadChar(120L);
	switch(command)
		{
		case '\033': /* NO-SAVE */
			PutStr("No-Save\r\n");
			flag=1;
			break;
		case '\177': /* DELETE */
			PutStr("Delete Inactive While Online\r\n");
			flag=0;
			break;
		case '1': /* SAVE */
			PutStr("Save\r\n");
			Save_Account(&User);
			flag=1;
			break;
		case '2': /* VALIDATE */
			PutStr("Validate\r\n");
			User.Sec_Status=
				System.User_Defaults.Valid.Sec_Status;
			User.Sec_Board=
				System.User_Defaults.Valid.Sec_Board;
			User.Sec_Library=
				System.User_Defaults.Valid.Sec_Library;
			User.Sec_Bulletin=
				System.User_Defaults.Valid.Sec_Bulletin;
			User.Time_Limit=
				System.User_Defaults.Valid.Time_Limit;
			User.Time_Used=0L;
			User.Time_Total=0L;
			flag=0;
			break;
		case '3': /* RE-ACTIVATE */
			PutStr("Re-Activate Is Pointless While Online\r\n");
			flag=0;
			break;
		case 'a': /* NAME */
		case 'A':
			PutStr("Name\r\n");
			stat=LineInput(User.Name,User.Name,30,120L);
			flag=0;
			break;
		case 'b': /* PASS */
		case 'B':
			PutStr("Pass\r\n");
			stat=LineInput(User.Pass,User.Pass,8,120L);
			flag=0;
			break;
		case 'c': /* COMMENT 1 */
		case 'C':
			PutStr("Comment 1\r\n");
			stat=LineInput(&User.Comments[0][0],
				&User.Comments[0][0],80,240L);
			flag=0;
			break;
		case 'd': /* COMMENT 2 */
		case 'D':
			PutStr("Comment 2\r\n");
			stat=LineInput(&User.Comments[1][0],
				&User.Comments[1][0],80,240L);
			flag=0;
			break;
		case 'e': /* COMMENT 3 */
		case 'E':
			PutStr("Comment 3\r\n");
			stat=LineInput(&User.Comments[2][0],
				&User.Comments[2][0],80,240L);
			flag=0;
			break;
		case 'f': /* SEC_STATUS */
		case 'F':
			PutStr("Sec_Status\r\n");
			User.Sec_Status=NumberInput();
			flag=0;
			break;
		case 'g': /* SEC_BOARD */
		case 'G':
			PutStr("Sec_Board\r\n");
			User.Sec_Board=NumberInput();
			flag=0;
			break;
		case 'h': /* SEC_LIBRARY */
		case 'H':
			PutStr("Sec_Library\r\n");
			User.Sec_Library=NumberInput();
			flag=0;
			break;
		case 'i': /* SEC_BULLETIN */
		case 'I':
			PutStr("Sec_Bulletin\r\n");
			User.Sec_Bulletin=NumberInput();
			flag=0;
			break;
		case 'j': /* MESSAGES_POSTED */
		case 'J':
			PutStr("Messages_Posted\r\n");
			User.Messages_Posted=NumberInput();
			flag=0;
			break;
		case 'k': /* MAIL_SENT */
		case 'K':
			PutStr("Mail_Sent\r\n");
			User.Mail_Sent=NumberInput();
			flag=0;
			break;
		case 'l': /* MAIL_RECEIVED */
		case 'L':
			PutStr("Mail_Received\r\n");
			User.Mail_Received=NumberInput();
			flag=0;
			break;
		case 'm': /* UPLOADS */
		case 'M':
			PutStr("Uploads\r\n");
			User.Uploads=NumberInput();
			flag=0;
			break;
		case 'n': /* DOWNLOADS */
		case 'N':
			PutStr("Downloads\r\n");
			User.Downloads=NumberInput();
			flag=0;
			break;
		case 'q': /* TIME_LIMIT */
		case 'Q':
			PutStr("Time_Limit\r\n");
			User.Time_Limit=(long)NumberInput();
			flag=0;
			break;
		default:
			flag=0;
			break;
		}
	if(flag) { break; }
	}
PutStr("\r\nCompleted Edit\r\n");
return(SUCCESS);
}

/******************************/

int Kill_SysReq(OnOff)
	BOOL OnOff;
{
extern struct Task *FindTask();
struct Process *moi;
static struct Window *orig_wind;

moi=FindTask(NULL);
if(OnOff==TRUE)
	{
	orig_wind = moi->pr_WindowPtr;
	moi->pr_WindowPtr = (-1L);
	return(0);
	}

if(OnOff==FALSE)
	{
	moi->pr_WindowPtr = orig_wind;
	return(0);
	}
}

/******************************/
