#include <exec/types.h>
#include <exec/io.h>
#include <intuition/intuition.h>
#include <devices/console.h>
#include <devices/serial.h>
#include <devices/timer.h>
#include "defines.h"

extern struct NewWindow PaneStatus;
extern struct Window *StatusPane;
extern struct IOStdReq *WriteConReq,  *ReadConReq,  *CreateStdIO(),
		       *StatWriteReq;
extern struct MsgPort  *WriteConPort, *ReadConPort, *CreatePort(),
                       *ReadSerPort,  *StatWritePort;
extern struct IOExtSer *ReadSerReq;
extern struct Window   *window;
extern struct MsgPort  *TimerPort;
extern struct timerequest *TimerMsg;

extern UBYTE conin[20], serin[20];
extern ULONG TimerSig, SerCharSig, ConCharSig, WindowSig;
extern int TimeOut, ConEcho, SerEcho;

extern int IO_Flags[];

/***************\
* INITCONSOLE()	*
\***************/
InitConsole()
{
int status;

StatWritePort=CreatePort("statwriteport",0l);
StatWriteReq=CreateStdIO(StatWritePort);
StatWriteReq->io_Data=StatusPane;
status=OpenDevice("console.device",0l,StatWriteReq,0l);

if (!(WriteConPort = CreatePort("con.write",0L))) return(FAILURE);
if (!(WriteConReq  = CreateStdIO(WriteConPort))) return(FAILURE);

if (!(ReadConPort  = CreatePort("con.read",0L)))  return(FAILURE);
if (!(ReadConReq   = CreateStdIO(ReadConPort)))  return(FAILURE);
if (OpenConsole())  return(FAILURE);

WriteConReq->io_Command = CMD_WRITE;

ReadConReq->io_Command  = CMD_READ;
ReadConReq->io_Length   = 1;
ReadConReq->io_Data     = conin;
SendIO(ReadConReq);
return(FALSE);
}

/***************\
* OPENCONSOLE()	*
\***************/
OpenConsole()
{
int error;

WriteConReq->io_Data   = window;
WriteConReq->io_Length = sizeof(*window);
error = OpenDevice("console.device",0L,WriteConReq,0L);
ReadConReq->io_Device  = WriteConReq->io_Device;
ReadConReq->io_Unit    = WriteConReq->io_Unit;

return(error);
}

/***************\
* CHECKCON()	*
\***************/
CheckCon()
{
return(CheckIO(ReadConReq));
}

/***************\
* CHECKINPUT()	*
\***************/
CheckInput()
{
return((CheckCon() || CheckSer()));
}

/***************\
* CONPUTCHAR()	*
\***************/
ConPutChar(ch)
	UBYTE ch;
{
WriteConReq->io_Data   = &ch;
WriteConReq->io_Length = 1;
DoIO(WriteConReq);
}

/***************\
* CONPUTSTR()	*
\***************/
ConPutStr(string)
	char *string;
{
WriteConReq->io_Data   = string;
WriteConReq->io_Length = strlen(string);
DoIO(WriteConReq);
}

/***************\
* PUTSTR()	*
\***************/
PutStr(string)
	char *string;
{
CheckMessage();
if (IO_Flags[IOFLAG_SER_OUT]) SerPutStr(string);
if (IO_Flags[IOFLAG_SCR_OUT]) ConPutStr(string);
if (IO_Flags[IOFLAG_FIL_OUT]) FilPutStr(string);
if (IO_Flags[IOFLAG_PRT_OUT]) PrtPutStr(string);
}

/***************\
* SENDCHAR()	*
\***************/
SendChar(ch)
	int ch;
{
CheckMessage();
if (IO_Flags[IOFLAG_SER_OUT]) SerPutChar(ch);
if (IO_Flags[IOFLAG_SCR_OUT]) ConPutChar(ch);
if (IO_Flags[IOFLAG_FIL_OUT]) FilPutChar(ch);
if (IO_Flags[IOFLAG_PRT_OUT]) PrtPutChar(ch);
}

/***************\
* GETCONKEY()	*
\***************/
GetConKey(wait)
	int wait;
{
unsigned char ch;

if (CheckIO(ReadConReq) || wait)
	{
	WaitIO(ReadConReq);
	ch = conin[0];
	SendIO(ReadConReq);
	return((int)ch);
	}

return(TIMEOUT);
}

/***************\
* READCHAR()	*
\***************/
ReadChar(wait)
	ULONG wait;
{
int ch,stat;

SetTimer((long)wait,0L);
FOREVER
	{
	Wait(WindowSig | SerCharSig | ConCharSig | TimerSig);
	CheckMessage();
	if(CheckIO(ReadConReq))
		{
		AbortIO(TimerMsg);
		WaitIO(ReadConReq);
		ch = (int)conin[0];
		SendIO(ReadConReq);
		if (ch == CSI)
			{
			if(CheckCSI()) { return(0); }
			}
		if(IO_Flags[IOFLAG_KBD_IN]>0)
			{ return(ch & 0x7f);
			}
		else
			{
			SetTimer((long)wait,0L);
			}
		}
	if(CheckIO(ReadSerReq))
		{
		AbortIO(TimerMsg);
		WaitIO(ReadSerReq);
		ch = (int)serin[0];
		SendIO(ReadSerReq);
		if(IO_Flags[IOFLAG_SER_IN]>0)
			{
			return(ch & 0x7f);
			}
		else
			{
			SetTimer((long)wait,0L);
			}
		}
	if(CheckIO(TimerMsg))
		{
		WaitIO(TimerMsg);
		return(TIMEOUT);
		}
	}
}

/***************\
* CLOSECONSOLE()*
\***************/
CloseConsole()
{
if(WriteConReq)
	{
	CloseDevice(WriteConReq);
	DeleteStdIO(WriteConReq);
	}
if(WriteConPort) { DeletePort(WriteConPort); }

if(StatWriteReq)
	{
	CloseDevice(StatWriteReq);
	DeleteStdIO(StatWriteReq);
	}
if(StatWritePort) { DeletePort(StatWritePort); }

if(ReadConReq) { DeleteStdIO(ReadConReq); }
if(ReadConPort) { DeletePort(ReadConPort); }
}
