/***********************\
* BOARD.H		*
\***********************/

#include <exec/types.h>

/***********************\
BOARD: name here		[31]
LOCAT: physical directory	[81]
  READ: low,high		[0 - 255],[>=low - high]
  WRITE: low,high		[0 - 255],[>=low - high]
  POSTS: maximum		[0 - 65535]
\***********************/

struct Board_Data {
	char	Title[31],
		Author[31];
	USHORT	Person_Code,
		Slot,
		Lock;
	long	Time;
	char	Pad[64];
	};

struct Board_Header {
	struct	Board_Header *Next_Board;
	struct	Board_Header *Last_Board;
	struct	Board_Data *Start_of_Data;
	char	Name[31],
		Location[81];
	USHORT	Read_Low,
		Read_High,
		Write_Low,
		Write_High;
	USHORT	Maximum,
		Highest_Post;
	long	Latest_Time;
	char	Pad[64];
	};
