/*******************************\
* BCOM.C			*
* (c)1986-87, Patrick E. Hughes	*
\*******************************/

#include <exec/types.h>
#include <stdio.h>
#include <time.h>
#include "System.h"
#include "Defines.h"

/***********************\
* GLOBAL VARIABLE LIST	*
\***********************/

extern struct System System;

extern int Boards_Are_Active, Libraries_Are_Active;
extern int Bulletins_Are_Active, Mail_Is_Active;
extern int Whence_The_Logon;
extern long system_time;
extern struct User User;

static char string[133];

/***************\
* BCOM()	*
\***************/
int BCom()
{
struct Bulletin_Header *bh;
int stat, which, count;

if(Bulletins_Are_Active==0) { return(FAILURE); }

bh=System.Bulletins_List;

PutStr("Bulletins\r\n");
StatRollMessage("Bulletins");

FOREVER
	{
	Check_Online_Status();
	PutStr("\r\n\tL>ist \tQ>uit\r\n");
	sprintf(string,"Bulletin to read [1,%d]? ",Bulletins_Are_Active);
	PutStr(string);
	stat=LineInput("",string,5,120L);
	if(stat<0) { return(stat); }

	if(toupper(string[0])=='L') { Bulletin_Listings(bh); continue; }
	if(string[0]=='?' || string[0]=='/') { Help(); continue; }
	if(toupper(string[0])=='Q') { return(SUCCESS); }
	if(string[0]=='@') { return(SUCCESS); }

	which=atoi(string);
	if(which==0) { continue; }
	if(which>Bulletins_Are_Active) { PutStr("Too high\r\n"); continue; }
	if(which<1) { PutStr("Too low\r\n"); continue; }
	stat=Read_Bulletin(bh,which);
	}
}

/*************************/
static int Bulletin_Listings(bh)
	struct Bulletin_Header *bh;
{
int count, stat;

PutStr("\r\n\tBulletin Listings:\r\n\r\n");

for(count=1;count<=Bulletins_Are_Active;++count)
	{
	if(User.Sec_Bulletin>=bh->Read_Low&&User.Sec_Bulletin<=bh->Read_High)
		{
		sprintf(string,"+%5d : %s\r\n",count,bh->Filename);
		}
	else
		{
		sprintf(string,"-%5d : %s\r\n",count,bh->Filename);
		}
	PutStr(string);
	Check_Online_Status();
	if(CheckInput())
		{
		stat=ReadChar(120L);
		switch(stat)
			{
			case '\023':
			case 'S':
			case 's':
			case 'P':
			case 'p':
			case ' ':
				PurgeLine();
				PutStr("Any key..");
				stat=ReadChar(120L);
			    if(stat==TIMEOUT||stat==NO_CARRIER){return(stat);}
			PutStr("\b\b\b\b\b\b\b\b\b         \b\b\b\b\b\b\b\b\b");
				break;
			case '\033': /* ESC Abort */
			case '\003': /* ^C */
			case '\020': /* ^P */
			case '\031': /* ^Y */
			case 'Q':
			case 'q':
			case 'X':
			case 'x':
				PutStr("\r\nAbort\r\n");
				goto ByMark1;
				break;
			default:
				PurgeLine();
				break;
			}
		}
	bh=bh->Next_Bulletin;
	}

ByMark1:
PutStr("\r\n");
return(SUCCESS);
}

/**************************/
static int Read_Bulletin(bh,number)
	struct Bulletin_Header *bh;
	int number;
{
int counter;

--number;

for(counter=0;counter<number;++counter)
	{
	bh=bh->Next_Bulletin;
	}

if(User.Sec_Bulletin>=bh->Read_Low && User.Sec_Bulletin<=bh->Read_High)
	{
	strcpy(string,bh->Location);
	strcat(string,bh->Filename);
	return(MenuSend(string));
	}

PutStr("Security too low to read\r\n");
return(SUCCESS);
}

/**************************/
static int Help()
{
strcpy(string,System.Location);
strcat(string,"Bulletin.Help");
return(MenuSend(string));
}
