*1988 P1103.ASM
 NOPAGE
 PLEN 86

CAPSIZ EQU 2440
SENSIZ EQU 2440 5(512-24)

_LVOAbortIO     EQU -$1E0
_LVOAddPort     EQU -$162
_LVOAllocMem    EQU -$C6
_LVOAllocSignal EQU -$14A
_LVOCheckIO     EQU -$1D4
_LVOClipBlit    EQU -$228
_LVOClose       EQU -$24
_LVOCloseDevice EQU -$1C2
_LVOCloseWindow EQU -$48
_LVODateStamp   EQU -$C0
_LVODelay       EQU -$C6
_LVODoIO        EQU -$1C8
_LVOExamine     EQU -$66
_LVOExecute     EQU -$DE
_LVOExit        EQU -$90
_LVOFindTask    EQU -$126
_LVOFreeMem     EQU -$D2
_LVOFreeSignal  EQU -$150
_LVOGetMsg      EQU -$174
_LVOLock        EQU -$54
_LVOMove        EQU -$F0
_LVOOpen        EQU -$1E
_LVOOpenDevice  EQU -$1BC
_LVOOpenLibrary EQU -$198
_LVOOpenWindow  EQU -$CC
_LVORead        EQU -$2A
_LVORectFill    EQU -$132
_LVORemPort     EQU -$168
_LVOReplyMsg    EQU -$17A
_LVOScrollRaster EQU -$18C
_LVOSendIO      EQU -$1CE
_LVOSetAPen     EQU -$156
_LVOSetDrMd     EQU -$162
_LVOText        EQU -$3C
_LVOUnLock      EQU -$5A
_LVOWait        EQU -$13E
_LVOWaitIO      EQU -$1DA
_LVOWrite       EQU -$30
DEV_BEGINIO     EQU -$1E

X SET 0
X SET X+4 DOSLIB

* DC.L 0       0)Mid Pointer
* DC.L BBS_DIR 4)*Filename
* DC.L 0       8)File Handle
* DC.L 0      12)Buffer Addr
* DC.L 0      16)Mem Size
* DC.L 0      20)Byte cnt

DIR_R_FIB SET X
DIR_W_FIB SET X+24
USR_R_FIB SET X+48
USR_W_FIB SET X+72
MSG_R_FIB SET X+96
MSG_W_FIB SET X+120
FWD_R_FIB SET X+144
BID_R_FIB SET X+168
BID_W_FIB SET X+192
X SET X+216

FSNEXT SET X
LHFLG  SET X+1 Print Lister header
BRATE  SET X+2
C_SIG  SET X+3
T_SIG  SET X+4
R_SIG  SET X+5
W_SIG  SET X+6
MON    SET X+7
B_ENAB SET X+8 1=BBS enabled
B_RUN  SET X+9 1=BBS running
C_RUN  SET X+10 1=Connected
B_HLT  SET X+11 1=BBS halted in talk mode
FR_RUN SET X+12 1=Forward in
F7_RUN SET X+13 1=F7 forced into forward out
*      SET X+14
BADCNT SET X+15 Counts bad commands
DSCFLG SET X+16 1=Disc in progress
BINFLG SET X+17 1=Binary input
ZFLG   SET X+18 ^Z inputed
TIMFLG SET X+19 1=Timing
DIEFLG SET X+20 1=Wait to die
CMPCHR SET X+21 Lx
C_HIST SET X+22 CON history
CLOCK1 SET X+23 Timeout in seconds
CLOCK2 SET X+24 Up counter
STATUS SET X+25 TNC Status
LLCNT  SET X+26 LL nn count
CK_FLG SET X+27 0=No Kill found
CR_FLG SET X+28 0=No Read found
DIRCHG SET X+29 0=No changes in DIR
GLINER SET X+30 1=GetLine error
NRNXT  SET X+31 1=Look for NETROM conn next
PORT   SET X+32 0=Main port 1=Alt port
FSFULL SET X+33 1=Ser Fifo full
SIDBID SET X+34 1=Bid type BBS
BIDCHG SET X+35 1=Bid table changed
ARROW  SET X+36 > in getlin
STACNT SET X+37 0=Status run out
X SET X+38

PLINW  SET X char cnt for line print
CAPCNT SET X+2
CX     SET X+4
CY     SET X+6
WD     SET X+8
HT     SET X+10
LINPTR SET X+12
SENCNT SET X+14
RS_IN  SET X+16
RS_OUT SET X+18
X SET X+20

A0SAV  SET X
X SET X+4

GFXBAS SET X
INTBAS SET X+4
FHCAPT SET X+8
FHSEND SET X+12
T_R    SET X+16
R_R    SET X+20
W_R    SET X+24
MYWIND SET X+28
CHRCNT SET X+32
LINCNT SET X+36
SENPNT SET X+40
STACKB SET X+44 Stack at start BBS
U_PTR  SET X+48 Pointer to USER data in file
LASTPT SET X+52 Ptr to DIR entry in file
NXTMSG SET X+56 Next Message number
CMPMSG SET X+60 Compare Msg #
SIZMSG SET X+64 Msg size cntr
NXTLST SET X+68 List msg# update
BIDADR SET X+72 > Bid
X SET X+76

TIMLIN SET X B.12 Time temp    861020230059
X SET X+12

U_LINE SET X
U_CALL SET X    B.8  User call
U_YEAR SET X+8  B.10 User last date 8803242027
U_BID  SET X+19 B.1  BBS Bid letter
U_CNT  SET X+20 B.4  User checkins
U_MSG  SET X+26 B.4  User last msg
U_NAME SET X+32 B.22 User name
X SET X+54

ABCDT1 SET X W.3  ASCII packed BCD Temp
X SET X+6+2
ABCDT2 SET X W.3  Second operand
X SET X+6+2
SCHARS SET X W.1  Chars sent over serial
X SET X+2

DAYCNT SET X L.3 DAYS since 780101, MINS, TICKS
X SET X+12

YEAR   SET X
MONTH  SET X+2
DAY    SET X+4
HOUR   SET X+6
MIN    SET X+8
SEC    SET X+10
X SET X+12

HEXTMP SET X B.10
X SET X+10
HDRLIN SET X L.21
X SET X+84
CONSTR SET X L.21
X SET X+84
CMPLIN SET X B.130
*Msg# TR  Size To     From   @ BBS  Date  Time Title
*  96 BN 65211 WB3HVJ WA3MNT KA3JAI 8701011311 AUTO
*012345678901234567890123456789012345678901234567890
X SET X+132

BIDBUF SET X L.21
X SET X+84

MONON  SET X  $A,7,'     ',0
X SET X+8

LSTLIN SET X L.21 DIR list line
X SET X+84
FWDTMP SET X L.21 SP N3ET < N3ET @ BBS $BID 
X SET X+84

BBS_MSG SET X 'B:'  DS.B 32
X SET X+36

X SET (X!7)+1  LONG WORD ALIGN
TMPMEM SET X B.$107  fib_SIZEOF=$107
X SET X+$108
CNAME  SET X B.32
X SET X+32
XNAME  SET X B.32
X SET X+32
TBUFF  SET X B.640
X SET X+640
SEROUT SET X
X SET X+256
FSBEGN SET X
X SET X+256
RBUFF  SET X B.512
X SET X+512
CBUFF  SET X B.12
X SET X+12
BUFSEN SET X B.SENSIZ
X SET X+SENSIZ
BUFCAP SET X B.CAPSIZ
X SET X+CAPSIZ

START
 LEA.L  DOSNAM(PC),A1
 MOVEQ  #0,D0
 MOVE.L 4,A6
 JSR    _LVOOpenLibrary(A6)
 MOVE.L D0,DOSP

 MOVE.L #X,D0
 BSR    ALLOC1
 MOVE.L D0,A4

 MOVE.L DOSP(PC),(A4)

 LEA    INTNAM(PC),A1
 JSR    _LVOOpenLibrary(A6)
 MOVE.L D0,INTBAS(A4)

 LEA    GRANAM(PC),A1
 JSR    _LVOOpenLibrary(A6)
 MOVE.L D0,GFXBAS(A4)
 BEQ    ABORT

 LEA    BBS_DIR(PC),A0
 MOVE.L A0,DIR_R_FIB+4(A4)
 MOVE.L A0,DIR_W_FIB+4(A4)
 LEA    BBS_USR(PC),A0
 MOVE.L A0,USR_R_FIB+4(A4)
 MOVE.L A0,USR_W_FIB+4(A4)
 LEA    BBS_MSG(A4),A0
 MOVE.W #'B:',(A0)
 MOVE.L A0,MSG_R_FIB+4(A4)
 MOVE.L A0,MSG_W_FIB+4(A4)
 LEA    BBS_FWD(PC),A0
 MOVE.L A0,FWD_R_FIB+4(A4)
 LEA    BBS_BID(PC),A0
 MOVE.L A0,BID_R_FIB+4(A4)
 MOVE.L A0,BID_W_FIB+4(A4)

 MOVE.W #14,CY(A4)
 MOVEQ  #1,D1
 MOVE.B D1,MON(A4)
* MOVE.B #3,BRATE(A4)    ;3=9600
 BSR    OPENW
 MOVE.L D0,A3
 MOVE.L $2E(A3),A1      ;wd_WScreen
 LEA    NewWindow+4(PC),A0
 MOVE.L 12(A1),(A0)     ;NewWindow sizes
 MOVE.L MYWIND(A4),A0
 JSR    _LVOCloseWindow(A6)
 BSR    OPENW
 BSR    SET_WDHT

 BSR    DO_ALLOC        ;Timer Request
 MOVE.L D0,T_R(A4)
 LEA    MT_RS(PC),A0
 BSR    DOCREATE
 MOVE.B D5,T_SIG(A4)
 MOVE.L T_R(A4),A1
 MOVE.L D0,$E(A1)       ;MN_REPLYPORT
 MOVEQ  #5,D0
 MOVE.L D0,8(A1)        ;LN_TYPE=NTMESSAGE
 CLR.B  9(A1)           ;LN_PRI=0
 BSR    OPEN_TIM

 BSR    DO_ALLOC        ;Read Request
 MOVE.L D0,R_R(A4)
 MOVE.L D0,A0
 MOVE.B #$34,$4F(A0)     ;io_SerFlags=SERF_SHARED|RAD_BOOGIE|7WIRE
 LEA    MR_RS(PC),A0
 BSR    DOCREATE
 MOVE.B D5,R_SIG(A4)
 MOVE.L R_R(A4),A1
 MOVE.L D0,$E(A1)
 BSR    OPEN_SERIAL
 MOVE.L R_R(A4),A0
 MOVE.W #2,$1C(A0)      ;IOSer.io_Command=CMD_READ
 MOVEQ  #1,D0
 MOVE.L D0,$24(A0)      ;IOSer.io_Length=1
 LEA    RS_IN(A4),A1
 MOVE.L A1,$28(A0)      ;IOSer.io_Data=(APTR) &RS_IN[0]

 BSR    DO_ALLOC        ;Write Request
 MOVE.L D0,W_R(A4)
 MOVE.L D0,A0
 MOVE.B #$34,$4F(A0)     ;io_SerFlags=SERF_SHARED|RAD_BOOGIE|7WIRE

 LEA    MW_RS(PC),A0
 BSR    DOCREATE
 MOVE.B D5,W_SIG(A4)
 MOVE.L W_R(A4),A1
 MOVE.L D0,$E(A1)
 BSR    OPEN_SERIAL

 MOVE.L W_R(A4),A0
 MOVE.W #3,$1C(A0)      ;IOSer.io_Command=CMD_WRITE
 LEA    RS_OUT(A4),A1
 MOVEQ  #1,D0
 MOVE.L D0,$24(A0)      ;IOSer.io_Length=1
 MOVE.L A1,$28(A0)      ;IOSer.io_Data=(APTR) &RS_OUT[0]

 MOVE.L R_R(A4),A0
 MOVE.B #$34,$4F(A0)    ;io_SerFlags=SERF_SHARED|RAD_BOOGIE|7WIRE
 MOVEQ  #8,D0
 MOVE.B D0,$4C(A0)      ;io_ReadLen=8
 MOVE.B D0,$4D(A0)      ;io_WriteLen=8
 MOVEQ  #1,D0
 MOVE.L D0,$30(A0)      ;io_CtlChar=1  XON,XOFF,INQ,ACK

 BSR    TIMSTR          ;Start Timer

 MOVEQ  #' ',D4         ;D4 is SPACE

 LEA    START(PC),A0    ;Start/end addr
 MOVE.L A0,CHRCNT(A4)
 MOVE.L A4,LINCNT(A4)
 BRA    F3_KEY

***
MAIN; main loop - Waits for Serial Read or Window input
*
 BSR    WAIT
CKIO ;
 BSR    GCHR_SER
 BEQ    CKKEY           ;No Serial
 TST.B  B_RUN(A4)
 BEQ.S  1$
 TST.B  B_HLT(A4)
 BNE.S  1$
 RTS

1$
 CMP.B  #$1A,D7         ;^Z
 BNE.S  5$
 MOVEQ #'^',D7
5$
 CMP.B #$1F,D7
 BLS.S 6$
 CMP.B #$7F,D7
 BCS.S 7$
6$
 CMP.B #7,D7            ;Drop ^ chars
 BCS   CKIO
 CMP.B #$A,D7
 BHI   CKIO
7$
 TST.B  MON(A4)
 BNE.S  FILL
 BSR    PCHR_W

***
FILL; RBUFF with line of text
*
 CMP.B  #8,D7           ;BS
 BNE.S  1$
 SUBQ.W #1,LINPTR(A4)
 BPL    CKIO
 BRA    ENDI

1$
 MOVE.W LINPTR(A4),D0
 CMP.W  #512,D0
 BEQ    CKIO
 LEA    RBUFF(A4),A0
 ADDA.W D0,A0
 MOVE.B D7,(A0)+
 ADDQ.W #1,D0
 MOVE.W D0,LINPTR(A4)
 CMP.B  #$A,D7
 BNE    CKIO
 CLR.B  (A0)
 TST.B  MON(A4)
 BEQ    CAPMOD          ;Plain text
 SUBQ.W #1,D0
 BEQ    ENDI            ;Blank line

***
ISCALL; Does RBUFF contain a call string
*
 MOVEQ  #0,D0
 LEA    RBUFF(A4),A0
1$
 ADDQ.W #1,D0
 MOVE.B (A0)+,D7
 BEQ.S  MONMOD   c=0
 CMP.B  #'-',D7  c=invalid
 BLT.S  MONMOD
 CMP.B  #4,D0    i<5
 BLT.S  1$
 CMP.B  #10,D0   i>10
 BGT.S  MONMOD
 CMP.B  #'>',D7  c=>
 BNE.S  1$

 LEA    RBUFF(A4),A0    ;New call ck
 LEA    CBUFF(A4),A1
 MOVEQ  #10,D3
NEWCAL
 CMPM.B (A0)+,(A1)+
 DBNE   D3,NEWCAL
 BEQ.S  ENDI            ;Same call

 LEA    RBUFF(A4),A0    ;Update call
 LEA    CBUFF(A4),A1
 MOVEQ  #10,D3
1$
 MOVE.B (A0)+,(A1)+
 DBEQ   D3,1$

 MOVEQ  #$A,D7
 BSR    PCHR_F_W
MONMOD
 LEA    RBUFF(A4),A0
 LEA    TBUFF(A4),A1
1$
 MOVE.B (A0),D0
 OR.B   (A1),D0
 BEQ.S  ENDI            ;DUPE
 CMPM.B (A0)+,(A1)+
 BEQ    1$

 LEA    RBUFF(A4),A0    ;New text
 LEA    TBUFF(A4),A1
2$
 MOVE.B (A0)+,(A1)+
 BNE    2$
 SUBQ.L #1,A0
 CMP.B  #$A,-(A0)
 BNE.S  4$
3$
 CMP.B  -(A0),D4      ;Wack trailing spaces
 BEQ.S  3$
 CMP.B  #9,(A0)
 BEQ    3$
 ADDQ.L #1,A0
 MOVE.B #$A,(A0)+
 CLR.B  (A0)
4$
 LEA    RBUFF(A4),A0
 BSR    PLIN_W
CAPMOD
 LEA    RBUFF(A4),A0
 BSR    PLIN_F
ENDI
 CLR.W  LINPTR(A4)
 BSR    CKBBS
 BRA    CKIO

***
CKKEY; Check for keyboard or mouse or send
*
 TST.B  FSFULL(A4)
 BNE.S  NXT_MSG
 TST.L  FHSEND(A4)
 BEQ.S  NXT_MSG
 BSR    GCHR_FIL   ;Get READ file char & send serial
 BSR    CTSTST
 BEQ    CKIO

NXT_MSG
 BSR    GET_MSG
 BEQ    MAIN
 BMI.S  FUNKY
 MOVE.B D0,D7
 BSR    PCHR_S  ;Send Serial, TNC echo
 BRA    NXT_MSG

FUNKY
 SUB.B  #$5F,D7 ;$5F
 BEQ    HELP_KEY
 ADDQ.B #6,D7   ;$59
 BEQ    ENDALL       ;F10
 ADDQ.B #1,D7   ;$58
 BEQ    F9_KEY       ;F9
 ADDQ.B #1,D7   ;$57
 BEQ    F8_KEY       ;F8
 ADDQ.B #1,D7   ;$56
 BEQ    MYFWD        ;F7
 ADDQ.B #1,D7   ;$55
 BEQ    DO_NEWCLI    ;F6
 ADDQ.B #1,D7   ;$54
 BEQ    F5_KEY       ;F5
 ADDQ.B #2,D7   ;$52
 BEQ    F3_KEY       ;F3
 ADDQ.B #1,D7   ;$51
 BEQ.S  F2_KEY       ;F2
 ADDQ.B #1,D7   ;$50
 BNE    NXT_MSG


***
F1_KEY; Capture toggle
*
 TST.L  FHCAPT(A4)
 BEQ.S  1$
 BSR    CLSCAP
 BRA    HELP_KEY
1$
 LEA    MCAPT(PC),A0
 BSR    PLIN_W
 LEA    CNAME(A4),A0
 BSR    FILENAME
 BEQ    DOMERROR
 BSR    OPNCAP
 BEQ    DOMERROR
 BRA    HELP1


***
F2_KEY; Open/close read file to send serial
*
 TST.L  FHSEND(A4)
 BEQ.S  NEW_READ
 BSR    CLSSND
 LEA    MERROR(PC),A0
 BSR    PLIN_W
 BRA    HELP_KEY

NEW_READ
 LEA    MSEND(PC),A0
 BSR    PLIN_W
 LEA    XNAME(A4),A0
 BSR    FILENAME
 BEQ    DOMERROR

*** Open read file to send chars over serial
 MOVE.L #1005,D2
 MOVE.L A0,D1           ;XNAME
 MOVE.L (A4),A6
 JSR    _LVOOpen(A6)
 MOVE.L D0,FHSEND(A4)
 BEQ    DOMERROR
 CLR.W  SENCNT(A4)
 BRA.S  HELP_KEY


***
F3_KEY; Next lower Baud rate
*
 MOVE.L R_R(A4),A1
 MOVE.L 4,A6
 JSR    _LVOAbortIO(A6)

 MOVEQ  #0,D0
 MOVE.B BRATE(A4),D0
 SUBQ   #1,D0
 BGE.S  F3K1
 MOVEQ  #3,D0           ;# rates-1
F3K1
 MOVE.B D0,BRATE(A4)
 ASL.W  #1,D0
 LEA    BRATEV(PC),A0
 MOVE.W 0(A0,D0.W),D0
 BSR    DO_RR_BEGIN
 BRA.S  HELP_KEY

***
F8_KEY; Toggle Halt BBS - talk mode
*
 LEA    MECHOY(PC),A0
 EOR.B  #1,B_HLT(A4)
 BNE.S  1$
 LEA    MECHON(PC),A0
1$
 MOVE.B B_HLT(A4),D3
 ADDQ.B #1,B_HLT(A4)
 BSR    DUMPER
 MOVE.B D3,B_HLT(A4)
 BRA.S  HELP_KEY

***
F9_KEY; Toggle BBS allowed
*
 EOR.B  #1,B_ENAB(A4)
HELP1
 CLR.B  C_HIST(A4)
 BRA.S  HELP_KEY

***
F5_KEY; Toggle MON mode
*
 EOR.B  #1,MON(A4)

***
HELP_KEY; Status
*
 LEA    MONON(A4),A0
* MOVE.W #$A07,(A0)+
 MOVEQ  #' ',D0
 TST.B  B_RUN(A4)
 BEQ.S  0$
 MOVEQ  #'^',D0
0$
 MOVE.B D0,(A0)+
 MOVEQ  #' ',D0
 TST.B  MON(A4)
 BEQ.S  1$
 MOVEQ  #'M',D0
1$
 MOVE.B D0,(A0)+
 MOVEQ  #' ',D0
 TST.B  B_ENAB(A4)
 BEQ.S  5$
 MOVEQ  #'B',D0
5$
 MOVE.B D0,(A0)+
 MOVEQ  #' ',D0
 TST.B  C_HIST(A4)
 BEQ.S  7$
 MOVEQ  #'C',D0
7$
 MOVE.B D0,(A0)+
 MOVE.W #$2000,(A0)+

 MOVEQ  #0,D0
 MOVE.B BRATE(A4),D0
 ASL.L  #1,D0
 LEA    BRATEV(PC),A1
 ADDA.W D0,A1
 MOVE.W (A1),D0
 MOVE.L $BFD000,-(SP)
 MOVE.L LINCNT(A4),-(SP)
 MOVE.L CHRCNT(A4),-(SP)
 MOVE.L D0,-(SP)
 LEA    MOPEN(PC),A0
 TST.L  FHCAPT(A4)
 BNE.S  9$
 LEA    MCLOSD(PC),A0
9$
 MOVE.L A0,-(SP)
 PEA    CNAME(A4)
 PEA    MONON(A4)
 PEA    START(PC)
 PEA    FMT2(PC)
 BSR    SPRINT
 LEA    36(SP),SP
 LEA    START(PC),A0

 BSR    PLIN_W
 BRA    NXT_MSG


***
DO_NEWCLI; DOS cmd
*
 LEA    NEWCLI(PC),A0
 MOVE.L A0,D1
 CLR.L  D2
 CLR.L  D3
 MOVE.L (A4),A6
 JSR    _LVOExecute(A6)
 BNE    NXT_MSG

***
DOMERROR; Print ERROR
*
 BSR    DOMERR1
 BRA    NXT_MSG


***
ENDALL; Clean up and exit program
*
 MOVE.B B_RUN(A4),D0
 BEQ.S  1$
 BRA    CMD_B
1$
 ADDQ.B #1,DIEFLG(A4)
 BSR    WAIT
 MOVE.B TIMFLG(A4),D0
 BNE    1$              ;Wait for timer to clear

 BSR    CLSCAP
 BSR    CLSSND
 MOVE.L R_R(A4),A1
 MOVE.L 4,A6
 JSR    _LVOCloseDevice(A6)
 MOVE.L R_R(A4),A0
 BSR    DELETEPORT
 MOVE.L W_R(A4),A1
 JSR    _LVOCloseDevice(A6)
 MOVE.L W_R(A4),A0
 BSR    DELETEPORT
 MOVE.L T_R(A4),A1
 JSR    _LVOCloseDevice(A6)
 MOVE.L T_R(A4),A0
 BSR    DELETEPORT
EXIT1
 MOVE.L MYWIND(A4),A0
 MOVE.L INTBAS(A4),A6
 JSR    _LVOCloseWindow(A6)
ABORT
 MOVE.L #X,D0
 MOVE.L A4,A1
 MOVE.L 4,A6
 JSR    _LVOFreeMem(A6)
MEMFAIL                 ;Needs A6 set!
 MOVE.L DOSP(PC),A6
 MOVEQ  #0,D1
 JMP    _LVOExit(A6)    ;gone

***
OPENW; Opens new window
*
 LEA    NewWindow(PC),A0
 MOVE.L INTBAS(A4),A6
 JSR    _LVOOpenWindow(A6)
 MOVE.L D0,MYWIND(A4)
 BEQ    ABORT
 RTS

***
SET_WDHT; Window Limits
*
 MOVE.L MYWIND(A4),A1
 MOVE.L 8(A1),WD(A4)
* MOVE.W $A(A1),HT(A4)
 RTS


***
GET_MSG; Get system msg and ack it
*
** BSR    SETTIM
 MOVE.L MYWIND(A4),A0
 MOVE.L $56(A0),A0      ;Mywindow->UserPort
 MOVE.L 4,A6
 JSR    _LVOGetMsg(A6)
 MOVE.L D0,D7
 BEQ.S  RTS2
 MOVE.L D0,A1
 MOVE.W $1A(A1),D5      ;NM_QUALIF
 MOVE.L $14(A1),D6      ;NM_CLASS
 MOVE.W $18(A1),D7      ;NM_CODE
 JSR    _LVOReplyMsg(A6)

 BTST.L #9,D6           ;CloseWindow=$200
 BNE    ENDALL
 BTST.B #1,D6           ;NEWSIZE=2
 BEQ.S  1$
 BSR    SET_WDHT
1$
 BTST.L #10,D6          ;RAWKEY=$400
 BEQ.S  GET_MSG

*** Convert keycode D7 & QUALIF D5 to ASCII D0
 MOVEQ  #-1,D0
 CMP.W  #$4A,D7
 BHI.S  RTS2

 LEA    KEYS(PC),A1
 CMP.B  #$3A,D7         ;No shift change
 BHI.S  2$
 MOVEQ  #3,D1           ;R L Shift
 AND.B  D5,D1
 BEQ.S  2$
 LEA    KEYS1(PC),A1
2$
 MOVE.B 0(A1,D7.W),D0   ;Convert
 CMP.B  #'a',D0
 BCS.S  RTS2
 CMP.B  #'z',D0
 BHI.S  RTS2

 BTST.B #3,D5           ;ctrl
 BEQ.S  3$
 SUB.B  #96,D0
 RTS

3$
 BTST.B #2,D5           ;CAPSLOCK
 BEQ.S  RTS2
 SUB.B  #32,D0
RTS2
 TST.B  D0
 RTS


***
FILENAME; get name
*
 MOVE.L A0,-(SP)
 CLR.W  -(SP) i=0
1$
 BSR    WAIT
 BSR    GET_MSG
 BLE    1$
 CMP.B  #$D,D0
 BEQ.S  4$
 MOVE.B D0,D7
 MOVEQ  #32,D0
 MOVE.L 2(SP),A0
 ADDA.W (SP),A0  i
 CMP.B  D0,D7
 BCS.S  3$
 SUB.W  (SP),D0
 BEQ    1$        ;> 32 char
 ADDQ.W #1,(SP)
 MOVE.B D7,(A0)+  ;put in name
 CLR.B  (A0)
 BSR.S  PCHR_W
 BRA    1$

3$
 CMP.B  #8,D7
 BNE    1$
 TST.W  (SP)
 BEQ    1$
 CLR.B  -(A0)
 SUBQ.W #1,(SP) i-=1
 BSR.S  PCHR_W
 BRA    1$

4$
 MOVE.W (SP)+,D0
 MOVE.L (SP)+,A0
 RTS


***
DOMERR1; Print *** ERROR
*
 LEA    MERROR(PC),A0
 BRA.S  PLIN_W

***
PLIN_S_W ;
*
 BSR    PLIN_S

***
PLIN_W; String of text to screen
*
 MOVEM.L D0/D7/A0/A1,-(SP)
 MOVE.L A0,A1
 MOVEQ  #-1,D0
1$
 ADDQ.L #1,D0
 CMP.B  (A1)+,D4
 BLE    1$
 MOVE.W D0,PLINW(A4)    ;Line cnt
 BEQ.S  2$
 BSR.S  PCHR_W
 CLR.W  PLINW(A4)
2$
 MOVE.B -(A1),D7

3$
 MOVE.B (A1)+,D7
 BEQ.S  6$
 BSR.S  PCHR_W
 BRA    3$

6$
 MOVEM.L (SP)+,D0/D7/A0/A1
 RTS


***
PCHR_F_S_W; Char to File,Ser,Win
*
 BSR    PCHR_S

***
PCHR_F_W; Char to File,Win
*
 BSR    PCHR_F

***
PCHR_W; Char D7 to screen
*
 MOVEM.L D0-D6/A0-A6,-(SP)
 MOVE.L D7,-(SP)
 MOVE.L A0,-(SP)
 MOVE.L GFXBAS(A4),A6

 MOVE.W CX(A4),D6       ;x=cx
 MOVE.W CY(A4),D5       ;y=cy
 MOVE.L MYWIND(A4),A3
 MOVE.L $32(A3),A3      ;RPORT

 MOVEQ  #2,D0           ;Complement - Remove cursor
 BSR    DRMDSET
 BSR    PUTCUR
 MOVEQ  #1,D0           ;JAM2
 BSR    DRMDSET
 MOVE.L (SP)+,A0
 MOVE.W PLINW(A4),D0
 BNE.S  PLINX
 MOVE.B D7,D0
 SUBQ.B #7,D0
 BLT.S  CASEDEF
 CMP.B  #7,D0
 BGE.S  CASEDEF
 ASL.L  #1,D0
 JMP    JMPTAB(PC,D0)

JMPTAB
 BRA.S  CASE7  7   BELL
 BRA.S  CASE8  8   BS
 BRA.S  CASE9  9   TAB
 BRA.S  CASE10 10  LF
 BRA.S  CASEDEF 11 CLS
 BRA.S  CASEDEF 12 CR
 BRA.S  CASE10 13  FF

CASE7 ;Bell ClipBlit(mywindow->RPort,0,0,mywindow->RPort,0,y-6,WD,HT,0x50)
 MOVEM.L D5-D6,-(SP)
 MOVE.L D5,D3      y
 SUBQ.L #6,D3      y-6
 MOVEQ  #$50,D6    $50
 MOVEQ  #8,D5      HT
 MOVE.W WD(A4),D4  WD
 CLR.L  D2         0
 MOVE.L A3,A1
 CLR.L  D1         0
 CLR.L  D0         0
 MOVE.L A3,A0
 JSR    _LVOClipBlit(A6)
 MOVEM.L (SP)+,D5-D6
 BRA.S  SCROLL

CASE8 ;Backspace
 SUBQ.W #8,D6
 CMP.W  #1,D6
 BGE.S  SCROLL
 MOVEQ  #0,D6
 BRA.S  SCROLL

CASE9 ;Tab
 ADD.W  #40,D6
 BRA.S  CKEOL

CASEDEF
 MOVEQ  #1,D0          ;Text(mywindow->RPort,&cc,1)
 LEA.L  3(SP),A0       ;Point to byte c
PLINX
 MOVE.L D0,-(SP)
 MULU   #8,D0
 ADD.W  D0,D6
 MOVE.L (SP)+,D0
 MOVE.L A3,A1
 JSR    _LVOText(A6)

CKEOL
 CMP.W  WD(A4),D6
 BLE.S  SCROLL

CASE10 ;LF
 MOVEQ  #0,D6           ;CR
 ADDQ.W #8,D5           ;LF

SCROLL
 CMP.W  HT(A4),D5
 BLE.S  MOVEXY          ;Not bottom yet
 MOVEQ  #0,D6           ;CR
 MOVEM.W WD(A4),D4/D5   ;ScrollRaster(mywindow->RPort,0,8,0,0,WD,HT)
 CLR.L  D3
 CLR.L  D2
 MOVEQ  #8,D1
 CLR.L  D0
 MOVE.L A3,A1           ;RPORT
 JSR    _LVOScrollRaster(A6)
 SUBQ.W #2,D5           ;Up

MOVEXY ;Move cursor
 MOVE.L D5,D1
 MOVE.L D6,D0
 MOVE.L A3,A1           ;RPORT
 JSR    _LVOMove(A6)

 BSR.S  PUTCUR         ;Put cursor

 MOVE.W D6,CX(A4)       ;Save Cursor position
 MOVE.W D5,CY(A4)
 MOVE.L (SP)+,D7
 MOVEM.L (SP)+,D0-D6/A0-A6
 RTS


***
DRMDSET; SetDrMd(mywindow->RPort,XX);
*
 MOVE.L A3,A1
 JMP    _LVOSetDrMd(A6)

PUTCUR
 MOVEQ  #3,D0
 BSR.S  PENSET
* RectFill(mywindow->RPort,x,y-6,x+6,y+1)
 MOVE.L D6,D2     x
 MOVE.L D5,D1     y
 SUBQ.L #6,D1     y-6
 ADDQ.L #6,D2     x+6
 MOVE.L D5,D3
 ADDQ.L #1,D3     y+1
 MOVE.L D6,D0     x
 MOVE.L A3,A1
 JSR    _LVORectFill(A6)
 MOVEQ  #1,D0

***
PENSET; Set Pen type  SetAPen(mywindow->RPort,XX)
*
 MOVE.L A3,A1
 JMP    _LVOSetAPen(A6)


***
WAIT; Wait for Ser rcv or Window msg
*
 MOVEM.L D0-D7/A0-A6,-(SP)
 MOVEQ  #0,D0
 MOVE.B T_SIG(A4),D1    ;Timer SigBit
 BSET   D1,D0

 MOVE.B R_SIG(A4),D1    ;SER receive SigBit
 BSET   D1,D0

 MOVE.B W_SIG(A4),D1    ;SER send SigBit
 BSET   D1,D0

 MOVE.L MYWIND(A4),A1
 MOVE.L $56(A1),A0      ;UserPort
 MOVE.B $F(A0),D1       ;MP_SigBit
* MOVE.B D1,C_SIG(A4)
 BSET   D1,D0
 MOVE.L 4,A6
 JSR    _LVOWait(A6)

 MOVE.B T_SIG(A4),D3
 BTST.L D3,D0
 BEQ.S  9$
 BSR    SETTIM
9$
 MOVEM.L (SP)+,D0-D7/A0-A6
 BSR    CTSDEL
 BNE    WAIT
 BRA    SERSND


***
GCHR_SER; Char from SER
*
 BSR.S  CK_SER
 MOVE.L D0,D7
 BEQ.S  1$              ;No Serial
 MOVE.L D0,A1
 JSR    _LVOWaitIO(A6)
 MOVE.B RS_IN(A4),D7    ;Get Serial char
 BSR.S  BeginIO_RR
 AND.B  #$7F,D7
 CMP.B  #$A,D7          ;Ignore LF's
 BEQ   GCHR_SER        ;GCHR_SER
 CMP.B  #$7F,D7
 BEQ    GCHR_SER
 CMP.B  #$D,D7
 BNE.S  1$
 CLR.B  CLOCK1(A4)      ;256 seconds timeout
 MOVEQ  #$A,D7          ;CR to LF
1$
 RTS

***
CK_SER
*
 MOVE.L R_R(A4),A1
 MOVE.L 4,A6
 JSR    _LVOCheckIO(A6)
 TST.L  D0
 RTS


***
DO_RR_BEGIN; Start Serial device
*
 MOVE.L R_R(A4),A1
 MOVE.L D0,$3C(A1)      ;io_Baud
 MOVE.W #$B,$1C(A1)     ;IOSer.io_Command=SDCMD_SETPARAMS
 MOVE.L 4,A6
 JSR    _LVODoIO(A6)
 MOVE.L R_R(A4),A0
 MOVE.W #2,$1C(A0)      ;IOSer.io_Command=CMD_READ

***
BeginIO_RR; BeginIO(Read_Request)
*
 MOVE.L R_R(A4),A1
 MOVE.L $14(A1),A6      ;IO_Device/Device_Node
 JMP    DEV_BEGINIO(A6)

***
OPEN_TIM; Open TIM Device
*
 LEA    TIMNAM(PC),A0
 MOVEQ  #1,D0           ;UNIT_VBLANK
 BRA.S  OPEN_DEV

***
OPEN_SERIAL; Open SER device
*
 LEA    SERNAM(PC),A0
 CLR.L  D0
OPEN_DEV
 CLR.L  D1              ;FLAGS
* A1=ReadRequest
 MOVE.L 4,A6
 JSR    _LVOOpenDevice(A6)
 TST.L  D0
 BNE    EXIT1
 RTS


***
DO_ALLOC; Allocate mem for msg ports
*
 MOVEQ  #$52,D0         ;Size IOExtSer
ALLOC1
 MOVE.L #$10001,D1      ;MEMF_PUBLIC|MEMF_CLEAR
 MOVE.L 4,A6
 JSR    _LVOAllocMem(A6)
 TST.L  D0
 BEQ    MEMFAIL
 RTS


***
PLIN_F_S_W ;
*
 BSR    PLIN_S
***
PLIN_F_W; Line of text to screen & file
*
 BSR    PLIN_W
***
PLIN_F; String of text to Capture
*
 MOVEM.L A0/D7,-(SP)
1$
 MOVE.B (A0)+,D7
 BEQ.S  2$
 BSR.S  PCHR_F
 BRA.S  1$

2$
 MOVEM.L (SP)+,A0/D7
 RTS


***
PCHR_F; put Captured byte in File
*
 TST.L  FHCAPT(A4)
 BEQ.S  2$
 CMP.L  #1800000,CHRCNT(A4)
 BEQ.S  2$
 MOVEM.L D0-D7/A0-A6,-(SP)
 CMP.B  D4,D7
 BGE.S  0$
 CMP.B  #9,D7
 BEQ.S  0$
 CMP.B  #$A,D7
 BEQ.S  00$
 CMP.B  #$D,D7
 BNE.S  1$
00$
 MOVE.B #$A,D7
 ADDQ.L #1,LINCNT(A4)
0$
 BSR.S  4$
1$
 MOVEM.L (SP)+,D0-D7/A0-A6
2$ RTS

4$
 ADDQ.L #1,CHRCNT(A4)
 LEA    BUFCAP(A4),A0
 MOVE.W CAPCNT(A4),D0
 MOVE.B D7,0(A0,D0.W)
 ADDQ.W #1,D0
 MOVE.W D0,CAPCNT(A4)
 CMP.W  #CAPSIZ,D0
 BNE.S  2$

***
CAP_FLUSH; write buffer to disk
*
 MOVE.L FHCAPT(A4),D1
 BEQ.S  RTS3
 LEA    BUFCAP(A4),A0
 MOVE.L A0,D2
 CLR.L  D3
 MOVE.W CAPCNT(A4),D3
 MOVE.L (A4),A6
 JSR    _LVOWrite(A6)
 CLR.W  CAPCNT(A4)
 TST.L  D0
 BMI.S  CLSCA1
RTS3 RTS

***
CLSCAP; Close Capture file
*
 BSR    CAP_FLUSH
CLSCA1
 MOVE.L FHCAPT(A4),D1
 BEQ    RTS3
 CLR.L  FHCAPT(A4)
 MOVE.L (A4),A6
 JMP    _LVOClose(A6)


***
OPNCAP; Open a Capture file
*
 MOVE.L #1006,D2        ;MODE_NEWFILE
 MOVE.L A0,D1           ;CNAME(A4)
 MOVE.L (A4),A6
 JSR    _LVOOpen(A6)
 MOVE.L D0,FHCAPT(A4)
 BEQ.S  1$
 CLR.L  CHRCNT(A4)
 CLR.L  LINCNT(A4)
1$
 TST.L  D0
 RTS


***
SEND_BUF_FILL; Fill transmit buffer
*
 MOVE.L FHSEND(A4),D1
 LEA    BUFSEN(A4),A0
 MOVE.L A0,SENPNT(A4)
 MOVE.L A0,D2
 MOVEQ  #0,D3
 MOVE.W #SENSIZ,D3
 MOVE.L (A4),A6
 JSR    _LVORead(A6)
 MOVE.W D0,SENCNT(A4)
 BMI    CLSSND1
 BEQ    CLSSND

***
GCHR_FIL; get char from read file
*
 SUBQ.W #1,SENCNT(A4)
 BMI.S  SEND_BUF_FILL
 MOVE.L SENPNT(A4),A0
 MOVE.B (A0)+,D7
 MOVE.L A0,SENPNT(A4)
 BRA    PCHR_S


***
PLIN_S; Line to SER
*
 MOVEM.L D7/A0,-(SP)
1$
 MOVE.B (A0)+,D7
 BEQ.S  2$
 BSR.S  PCHR_S
 BRA    1$
2$
 MOVEM.L (SP)+,D7/A0
 RTS

***
CTSDEL
*
 BSR.S  CTSTST
 BEQ.S  RTS80
***
DELAY4; 4 second delay
*
 MOVEM.L A0-A3/D0-D3,-(SP)
 MOVEQ  #100,D1          ;2 second delay
 ADD.L  D1,D1
 MOVE.L (A4),A6
 JSR    _LVODelay(A6)
 MOVEM.L (SP)+,A0-A3/D0-D3
CTSTST
 BTST.B #4,$BFD000
RTS80
 RTS


FSPUTW BSR WAIT
***
PCHR_S ;
*
 CMP.B  #-1,FSNEXT(A4)
 BEQ.S  FSPUTW
 TST.B  FSFULL(A4)
 BNE    FSPUTW
 BSR    CTSDEL
 BNE    FSPUTW
 MOVEM.L D0/D7/A0,-(SP)
 LEA    FSBEGN(A4),A0
 CLR.L  D0
 MOVE.B FSNEXT(A4),D0
 ADDA.W D0,A0
 MOVE.B D7,(A0)+
 CLR.B  (A0)
 ADDQ.B #1,FSNEXT(A4)
 CMP.B  #256-81,D0
 BCS.S  5$
 CMP.B  #$A,D7
 BNE.S  5$
 ADDQ.B #1,FSFULL(A4)
 BSR    WAIT
5$
 MOVEM.L (SP)+,D0/D7/A0
 CMP.B  #$D,D7
 BEQ.S  SERSN1
 RTS

***
SERSND ;
*
 TST.B  CLOCK1(A4)
 BEQ.S  SERSNR
SERSN1
 MOVEM.L D0-D2/D7/A0-A2,-(SP)
 LEA    FSBEGN(A4),A0
1$
 MOVE.B (A0)+,D7
 BEQ.S  8$
 CMP.B  #$A,D7
 BNE.S  5$
 TST.B  (A0)
 BEQ.S  2$
 MOVEQ  #$16,D7
 BSR.S  PCHRS
2$
 CLR.B  CLOCK1(A4)
 MOVEQ  #$D,D7
5$
 BSR.S  PCHRS
 BRA    1$
8$
 MOVEM.L (SP)+,D0-D2/D7/A0-A2
 CLR.B  FSNEXT(A4)
 CLR.B  FSBEGN(A4)
 CLR.B  FSFULL(A4)
SERSNR
 RTS


***
PCHRS; Serial output
*
 MOVE.L A0,-(SP)
1$
 BSR    CTSDEL
 BEQ.S  5$
 BSR    SETTIM
 BRA    1$
5$
 MOVE.L W_R(A4),A1
 MOVE.B D7,RS_OUT(A4)
 MOVE.L 4,A6
 JSR    _LVODoIO(A6)
 MOVE.L (SP)+,A0
R_22 RTS


CLSSND1
 BSR    DOMERR1
***
CLSSND ;Close read file
*
 MOVE.L FHSEND(A4),D1
 BEQ.S  R_22
 MOVE.L (A4),A6
 JSR    _LVOClose(A6)
2$
 BSR    WAIT
 TST.B  FSNEXT(A4)
 BNE    2$
 CLR.L  FHSEND(A4)
 LEA    MDONE(PC),A0
 BRA    PLIN_W


***
DELETEPORT; DeletePort(Read_Request->IOSer.io_Message.mn_ReplyPort)
*
 MOVE.L A0,A3
 MOVE.L $E(A0),A2
 MOVE.L A2,A1
 MOVE.L 4,A6
 JSR    _LVORemPort(A6)
 MOVEQ  #-1,D2
 MOVE.B D2,8(A2)
 MOVE.L D2,$14(A2)
 MOVEQ  #0,D0
 MOVE.B $F(A2),D0
 JSR    _LVOFreeSignal(A6)
 MOVEQ  #$22,D0
 MOVE.L A2,A1
 BSR.S  1$
 MOVEQ  #$52,D0         ;Size of request
 MOVE.L A3,A1
1$
 JMP    _LVOFreeMem(A6)


***
DOCREATE; Create a msg port
*
 MOVE.L A0,D4
 MOVE.L A2,-(SP)
 MOVEQ  #-1,D0
 MOVE.L 4,A6
 JSR    _LVOAllocSignal(A6)
 MOVE.B D0,D5
 MOVEQ  #$22,D0
 BSR    ALLOC1
 MOVE.L D0,A2
 MOVE.L D4,$A(A2)
 CLR.B  9(A2)
 MOVE.B #4,8(A2)
 CLR.B  $E(A2)
 MOVE.B D5,$F(A2)
 SUBA.L A1,A1
 JSR    _LVOFindTask(A6)
 MOVE.L D0,$10(A2)
 MOVE.L A2,A1
 JSR    _LVOAddPort(A6)
 MOVE.L A2,D0
 MOVE.L (SP)+,A2
 RTS


***
CKBBS;
*
 MOVEQ  #17,D3           ;was 7
 LEA    RBUFF(A4),A1
 MOVE.L A1,A0
 TST.B  NRNXT(A4)
 BEQ.S  CKNR            ;Not KA-NODE,SID next
 MOVE.W (A1)+,D0
 CMP.B  #'[',(A0)
 BEQ    CMD_BBS         ;for Bidflg
 CMP.B  #'?',(A0)
 BEQ.S  5$
 CMP.B  #'>',(A0)
 BNE.S  CKNR
5$
 CMP.B  (A1)+,D4
 BNE.S  RTS45
 CMP.B  #'C',D0
 BEQ    CONCPY
 CMP.B  #'X',D0
 BEQ    CONCPY
RTS45 RTS

CKNR
 MOVE.L A0,A1
8$
 MOVE.B (A1)+,D0
 CMP.B  #'#',D0
 BLT    RTS45
 CMP.B  #'>',D0
 BEQ.S  NRCON
 CMP.B  #'}',D0
 BEQ.S  NRCON
 CMP.B  #'*',D0
 DBEQ   D3,8$
 BNE.S  RTS9            ;NG
 CMP.B  (A1)+,D0
 BNE.S  RTS9
 CMP.B  (A1)+,D0
 BNE.S  RTS9
 CMP.B  (A1)+,D4
 BNE.S  RTS9
 CLR.B  NRNXT(A4)

 LEA    MCONCT(PC),A0   ;*** CONNECTED to XXXXXX
 BSR.S  CMPCON
 BNE.S  RTS9
 TST.B  -(A1)
 ADDQ.B #1,NRNXT(A4)    ;NETROM next?
 CLR.B  SIDBID(A4)
 CMP.B  #$A,-(A1)
 BNE.S  RTS9
 SUBQ.B #7,-(A1)
 BNE.S  RTS9
 SUBQ.B #7,-(A1)
 BNE.S  RTS9
 SUBQ.B #7,-(A1)
 BNE.S  RTS9
* CLR.B  RBUFF(A4)
 ADDQ.B #1,C_HIST(A4)   :Con history
 ADDQ.B #1,C_RUN(A4)    ;Con current
* CLR.W  SCHARS(A4)      ;Max 65k per connect
 MOVE.B B_ENAB(A4),D3
 BEQ.S  RTS9            ;BBS disabled
 BSR    MYBBS
 BRA    HELP_KEY

NRCON
 LEA    MNRCON(PC),A0   ;} Connected to XXXXXX
 TST.B  NRNXT(A4)
 BEQ.S  RTS9
CMPCON
 MOVEQ  #18,D3
1$
 CMPM.B (A0)+,(A1)+
 DBNE   D3,1$
 TST.B  -(A0)
 BNE.S  RTS9
 TST.B  -(A1)
CONCPY
 MOVEQ  #78,D3
 LEA    CONSTR(A4),A0
33$
 MOVE.B (A1)+,(A0)+
 DBEQ   D3,33$
 CLR.B  (A0)
RTS9
 RTS


DUMPER; 
 BSR    PLIN_S
1$
 BSR    CKIO
 CMP.B  #'$',D7
 BNE    1$              ;Clr rec buffer
DUMP2
3$
 BSR    CKIO
 CMP.B  #':',D7
 BNE    3$
 RTS

* SECTION data
*NewWindow Structure
* 0,0,WD,HT,0,1,
* RAWKEY|CLOSEWINDOW|NEWSIZE,
* ACTIVATE|BORDERLESS|SMART_REFRESH|SIZEBRIGHT|
* WINDOWCLOSE|WINDOWDEPTH|WINDOWDRAG|WINDOWSIZING,
* NULL, NULL, (title), NULL, NULL,
* 100,35,WD,HT, WBENCHSCREEN

NewWindow
 DC.W 0,0,20,20,1
 DC.L $602,$181F,0,0
 DC.L MTITLE,0,0
 DC.W 5,5,-1,-1,1

MTITLE DC.B 'P1103 F1=CAPT F2=SEND F3=BAUD F5=MON F6=CLI F7=FWD F9=BBS F10=QUIT',0

DOSNAM DC.B 'dos.library',0
INTNAM DC.B 'intuition.library',0
GRANAM DC.B 'graphics.library',0
SERNAM DC.B 'serial.device',0
TIMNAM DC.B 'timer.device',0,0

MCONCT DC.B 'CONNECTED to ',0
MNRCON DC.B ' Connected to ',0
MT_RS  DC.B 'TR'
MR_RS  DC.B 'PR'
MW_RS  DC.B 'PW',0
NEWCLI DC.B 'NEWCLI',0

MSEND  DC.B 10,'Send:',0
MCAPT  DC.B 10,'Capture:',0
MERROR DC.B 10,'*** Error',10,0
MOPEN  DC.B 'OPEN',0
MCLOSD DC.B 'CLOSED',0
BRATEV DC.W 300,1200,2400,9600

KEYS DC.B '`1234567890-=\',0
 DC.B '0qwertyuiop[]',0,'123'
 DC.B 'asdfghjkl;''',0,0,'456'
 DC.B  0,'zxcvbnm,./'
 DC.B  0,'.789 ',8,9,$D,$D,27,127,0,0,0,'-'

KEYS1 DC.B '~!@#$%^&*()_+|',0
 DC.B '0QWERTYUIOP{}',0,'123'
 DC.B 'ASDFGHJKL:"',0,0,'456'
 DC.B  0,'ZXCVBNM<>?'

 CNOP 0,4
*R102.ASM 870322
MYFWD
 ADDQ.B #1,F7_RUN(A4)
 BSR.S  MYBBS1
 BRA    HELP_KEY

MYBBS
 CLR.B  SIDBID(A4)
MYBBS1
 MOVE.L SP,STACKB(A4)
 MOVE.L (A4),A6
 CLR.B  BIDCHG(A4)
 CLR.L  BIDADR(A4)
 CLR.B  PORT(A4)
 CLR.B  BADCNT(A4)
 CLR.L  NXTLST(A4)
 CLR.B  B_HLT(A4)
 ADDQ.B #1,B_RUN(A4)
 ADDQ.B #1,C_RUN(A4)    ;Con current
 LEA    TNCINI(PC),A0
 BSR    DUMPER
 BSR    WAIT
 BSR    CKSTAT
 CLR.B  DSCFLG(A4)
 MOVE.B STATUS(A4),D0
 CMP.B  #'C',D0         ;Streamswitch OK?
 BEQ.S  2$
 CMP.B  #'R',D0         ;Reject frame sent
 BEQ.S  2$
 LEA    TNCSWI(PC),A0   ;Try other stream
 BSR    DUMPER
 ADDQ.B #1,PORT(A4)
2$
 BSR    DOBBS
ABORTB; BBS abort
 CLR.B  C_RUN(A4)
 CLR.B  FR_RUN(A4)
 CLR.B  F7_RUN(A4)
 CLR.B  BADCNT(A4)
 LEA    DIR_R_FIB(A4),A5
 BSR    A5_FREE_MEM
 LEA    USR_R_FIB(A4),A5
 BSR    A5_FREE_MEM
 LEA    MSG_R_FIB(A4),A5
 BSR    A5_FREE_MEM
 LEA    FWD_R_FIB(A4),A5
 BSR    A5_FREE_MEM
 LEA    BID_R_FIB(A4),A5
 BSR    A5_FREE_MEM
 LEA    MSG_W_FIB(A4),A5
 BSR    A5_CLOSE

 LEA    U_LINE(A4),A0
 BSR    PLIN_F_W
 CLR.B  B_RUN(A4)
 LEA    TNCEND(PC),A0
 BSR    PLIN_S
 BSR    DELAY4
 LEA    TNCDIS(PC),A0
 BSR    PLIN_S
 MOVE.L STACKB(A4),SP
 CLR.L  D0
 RTS


***
GETLIN; Get line of txt from serial
*       ;Strip binary. Terminate NULL, set ZFLG
 CLR.B  ZFLG(A4)
 CLR.B  ARROW(A4)
 LEA    RBUFF(A4),A0     ;buffer address
 MOVE.L A0,-(SP)
GMAX
 MOVEM.L A0/D7,-(SP)
1$
 BSR    CKIO
 CMP.B  #$1A,D7
 BNE.S  3$
 MOVE.B D7,ZFLG(A4)
 CLR.L  D7
3$
 MOVE.B D7,D1
 BEQ    1$
 CMP.B  D4,D1
 BGE.S  9$
 CMP.B  #$A,D1
 BEQ.S  9$
 CMP.B  #9,D1
 BNE    1$
9$
 MOVEM.L (SP)+,A0/D7

 MOVE.B D1,(A0)+
 CMP.B  #$A,D1
 BNE    GMAX
 MOVE.L (SP),A0
14$
 MOVE.L A0,A1
15$
 CMP.B  (A0)+,D4
 BEQ    15$
 CMP.B  #9,-1(A0)
 BEQ.S  15$
 CMP.B  #$A,-1(A0)
 BNE    14$
 CMP.B  #'>',-2(A0)
 BNE.S  16$
 ADDQ.B #1,ARROW(A4)
16$
 MOVE.L A1,A0
 MOVE.B #$A,(A0)+
 CLR.B  (A0)

 MOVE.L A0,D3
 SUB.L  (SP),D3

 MOVE.L (SP),A0
 BSR    PLIN_F_W
 MOVE.L (SP)+,A0
 CLR.B  GLINER(A4)
 CMP.L  #'cmd:',(A0)
 BEQ.S  17$
 CMP.L  #'*** ',(A0)
 BNE.S  18$
 CMP.L  #'conn',4(A0)
 BEQ    GETLIN          ;Connect Request
 CMP.L  #'DISC',4(A0)
 BNE.S  18$
17$
 ADDQ.B #1,GLINER(A4)
18$
 CLR.B  CLOCK1(A4)
 TST.B  DSCFLG(A4)
 BNE.S  19$
 TST.B  GLINER(A4)
19$
 RTS


***
PSTR; Print BIN terminated string A0+
*
 BSR    CK_SER
 BEQ.S  1$
 BSR    CKSTAT
 BMI    CMD_B  *ABORTB
1$
 MOVEQ  #0,D0                ??? was #-1
 MOVE.L D7,-(SP)
PS1
 ADDQ.L #1,D0
 MOVE.B (A0),D7
 BEQ.S  PS2
 BSR    PCHR_S
 CMP.B  #$A,(A0)+
 BNE.S  PS1
PS2
 MOVE.L (SP)+,D7
 RTS


***
DOBBS; BBS run
*
 BSR    TIME            ;Update RTC
 BSR.S  FND_CALL
 BEQ    ABORTB
 BSR    GET_USR_DATA
 BEQ    ABORTB
 CLR.B  DIRCHG(A4)       ;Clr DIR change flag
 LEA    U_LINE(A4),A0
 BSR    PLIN_F_W
 BSR    DIRRED
 BSR    WELCOME

* BSR    BIDRED

DOBB1
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),A6      ;Buff ADR
 MOVE.L (A6),D0        ;Last Msg
 BSR    INC_ABCD
 MOVE.L D0,NXTMSG(A4)

 BSR    DO_USR_CMD
 MOVE.B DSCFLG(A4),D0
 BEQ    DOBB1
 BRA    ABORTB


***
FND_CALL; Find Call in connect msg
*
 LEA    USR_NEW(PC),A0    ;NO-NAME fake out
 LEA    U_LINE(A4),A1
 MOVEQ  #50,D3
1$
 MOVE.B (A0)+,(A1)+
 DBEQ   D3,1$
 LEA    U_CALL(A4),A1
 LEA    CONSTR(A4),A0

***
MOVE_VALID_CALL; Move CALL A0 to A1 and ck valid
*
 MOVE.L A1,-(SP)
 MOVEQ  #6,D3
3$
 MOVE.B (A0)+,(A1)
 CMP.B  #'0',(A1)+
 DBLT   D3,3$        ;OK so far
 MOVEQ  #3,D3
 MOVE.B D4,-(A1)
 MOVE.L (SP)+,A1     ;Moved, now check valid
 MOVE.B (A1)+,D0
 CMP.B  #'A',D0
 BLT.S  6$
 CMP.B  #'Z',D0
 BGT.S  6$
 CMP.B  #'9',(A1)+
 BGT.S  7$
 CMP.B  #'A',(A1)+
 BGE.S  9$
6$
 BRA    BRTS

7$
 CMP.B  #'9',(A1)+
 BGT    6$
9$
 CMP.B  #'A',(A1)+
 BLT    6$
 SUBQ   #1,D3
 BMI    6$
 CMP.B  (A1),D4
 BNE    9$
 BRA    GRTS


***
WELCOME; Welcome user
*
 CLR.B  DSCFLG(A4)
 LEA    MAMIG1(PC),A0
 BSR    PLIN_F_S_W
 BSR    SETRTC         ;date for USR file
 TST.B  F7_RUN(A4)
 BNE.S  FARROW
 CMP.B  U_BID(A4),D4
 BNE    GRTS
 LEA    U_NAME(A4),A0
 BSR    PLIN_F_S_W
 LEA    MWELCM(PC),A0
 BSR    PLIN_F_S_W
 MOVEQ  #4,D7           ;TO LM or L>
 BSR    FILL_CMPLIN
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),(A5)     ;Mid Pointer
 MOVE.L 16(A5),20(A5)   ;Byte cntr
7$
 BSR    LISTER
 BNE    7$
 RTS


***
FARROW; Input until >
*
 BSR    GETLIN
 BNE    CMD_B
 TST.B  ARROW(A4)
 BEQ    FARROW
 RTS


***
DO_USR_CMD; Get and do User command
*
 MOVE.B #35,STACNT(A4)
 TST.B  DSCFLG(A4)
 BNE    CMD_B
 MOVE.B #-1,LHFLG(A4)
 TST.B  F7_RUN(A4)    ;Only once
 BNE    CMD_F         ;Forward out loop
 LEA    MFWD(PC),A0   ;F>
 TST.B  FR_RUN(A4)
 BNE.S  1$
 BSR    SETRTC        ;Set Prompt with time
* LEA    MPROMT(PC),A0
1$
 BSR    PLIN_F_S_W
 BSR    GETLIN
 BNE    CMD_B

 CMP.W  #'F>',(A0)
 BEQ    CMD_F
 CMP.B  #'[',(A0)     ;[BBSID]
 BEQ    CMD_BBS

 TST.B  ZFLG(A4)
 BNE    BRTS
 BSR    REM_SPC
 MOVE.B (A0)+,D0
 CMP.B  #'D',D0
 BEQ    CMD_D
 CMP.B  #'J',D0
 BEQ    CMD_J
 CMP.B  #'K',D0
 BEQ    CMD_K
 CMP.B  #'L',D0
 BEQ    CMD_L
 CMP.B  #'N',D0
 BEQ    CMD_NAME
 CMP.B  #'R',D0
7$
 BEQ    CMD_R
 CMP.B  #'S',D0
 BEQ    CMD_S
 CMP.B  #'T',D0
 BEQ    CMD_T
 CMP.B  #'V',D0
 BEQ    7$
 TST.B  FR_RUN(A4)
 BNE.S  CMD_B         ;Forwarding error
 CMP.B  #'B',D0
 BNE    CMD_HUH


***
CMD_B; Disc user
*
 MOVE.L NXTLST(A4),D0
 BEQ.S  3$
 MOVE.L D0,U_MSG(A4)    ;Set last read
3$
* ADDQ.B #1,DSCFLG(A4)
 LEA    TIMLIN(A4),A0
 LEA    U_YEAR(A4),A1
 MOVE.L (A0)+,(A1)+
 MOVE.L (A0)+,(A1)+
 MOVE.W (A0)+,(A1)+
 BSR    CLEAN_USR
 BSR    CLEAN_DIR_2     ;Write DIR changes to disk
 ADDQ.B #1,DSCFLG(A4)
 BRA    ABORTB


***
CMD_BBS; SID flags
*
1$
 MOVE.B (A0)+,D7
 BEQ.S  5$
 CMP.B  #'$',D7
 BNE    1$
 MOVE.B D7,SIDBID(A4)
5$
 RTS


***
CMD_D; D CMD
*
 CMP.B  (A0)+,D4
 BNE    BRTS
 LEA    BBS_MSG+2(A4),A1
 MOVE.L A1,LASTPT(A4)   ;Fakeout
 CLR.L  D7
 MOVEQ  #30,D3
CDL1
 MOVE.B (A0)+,(A1)+
 CMP.B  (A0),D4
 DBGE   D3,CDL1
 CLR.B  (A1)
 BRA    CM8A


***
CMD_J
*
 CMP.B  #$A,(A0)
 BNE.S  CJ_BAD
 LEA    TNCMH(PC),A0
 BSR    PLIN_S
 BSR    DUMP2

 LEA    TBUFF(A4),A0
 MOVE.W #639,D3
2$
 MOVEM.L D3/A0,-(SP)
 BSR    CKIO
 MOVEM.L (SP)+,D3/A0
 CMP.B  #$A,D7
 BLT    2$              ;Null
 MOVE.B D7,(A0)+
 CMP.B  #'$',D7
 DBEQ   D3,2$
 CLR.B  -7(A0)
 BSR    DUMP2
 LEA    TBUFF(A4),A0
 BRA    PLIN_F_S_W

CJ_BAD
 LEA    MJ_BAD(PC),A0
 BRA    PR_BAD


***
CMD_K ;
*
 MOVEQ  #4,D7           ;TO
 MOVE.B (A0)+,D0
 CMP.B  #'M',D0         ;ME
 BEQ.S  2$
 MOVEQ  #$D,D7          ;MSG FLG
 CMP.B  #'T',D0
 BNE.S  1$
 MOVE.B D0,CMPCHR(A4)
 MOVE.B (A0)+,D0
 MOVEQ  #3,D7           ;KT
1$
 CMP.B  D4,D0
 BNE.S  CK_BAD
 BSR    A0_GETNUM       ;Get decimal
 MOVE.L D0,CMPMSG(A4)
2$
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),(A5)
 MOVE.L 16(A5),20(A5)
 CLR.B  CK_FLG(A4)
3$
 TST.L  20(A5)
 BLE.S  5$              ;END
 BSR    LISTER
 BEQ.S  5$              ;Not Found
 MOVE.L LASTPT(A4),A0
 CMP.B  #'x',5(A0)
 BEQ    3$
 MOVE.B #'x',5(A0)      ;In DIR file
 LEA    MKILLD(PC),A0
 BSR    PLIN_F_S_W
 ADDQ.B #1,CK_FLG(A4)
 CMP.B  #4,D7           ;KM
 BEQ    3$
5$
 MOVE.B CK_FLG(A4),D0
 BEQ.S  CK_BAD
 ADDQ.B #1,DIRCHG(A4)
 BRA    GRTS

CK_BAD
 LEA    MK_BAD(PC),A0
 BRA    PR_BAD

***
CMD_F; F> Reverse forward
*
 MOVE.B #50,STACNT(A4)
 LEA    FWD_R_FIB(A4),A5
 TST.L  12(A5)
 BNE.S  1$
 BSR    A5_READ_FILE
1$
 BSR    BIDRED
 MOVE.L BIDADR(A4),D3
 BNE.S  3$
 BSR    CLEAN_DIR_2     ;Update for last forward
3$
 BSR    BIDUPD
 BSR    CKSTAT
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),(A5)
 MOVE.L 16(A5),20(A5)
 BLE    CF_END         ;END

 MOVEQ  #0,D7          ;All
 BSET.B #7,D7          ;NoList
CF1
 BSR    LISTER
 BEQ    CF_END         ;Not Found
* LEA    LSTLIN(A4),A0
 CLR.L  BIDADR(A4)
 MOVE.W 6(A0),D0
 TST.B  SIDBID(A4)
 BEQ.S  01$
 CMP.B  #'$',6(A0)
 BNE.S  01$
 CMP.B  U_BID(A4),D0
 BEQ    CF1            ;Sent already
 BSR    BIDMSG
 BNE.S  02$
01$
 CMP.W  #'N ',D0       ;Past Forward/Read
 BNE    CF1
02$
 CMP.B  #'/',4(A0)
 BEQ    CF5            ;Forced forward

 LEA    LSTLIN+28(A4),A0
 CMP.B  (A0),D4
 BNE.S  1$             ;No @BBS
 LEA    LSTLIN+14(A4),A0  ;To call
1$
 LEA    U_CALL(A4),A1
 BSR    STR_CMP
 BEQ.S  CF5            ;@ BBS

 TST.L  BIDADR(A4)
 BNE.S  109$
 MOVE.L LSTLIN+28(A4),D0
 MOVEQ  #3,D3
102$
 SUBQ.B #1,D3
 BMI    CF1
 ROL.L  #8,D0
 CMP.B  #'0',D0
 BLT    CF1             ;@fmt needs number for non-bid
 CMP.B  #'9',D0
 BGT    102$

109$
 MOVE.L FWD_R_FIB+12(A4),A0     ;Match co-bbs call
2$
 MOVEQ  #127,D3
3$
 CMP.B  (A0)+,D4        ;Skip line
 DBGT   D3,3$
 CMP.B  #$A,-1(A0)
 BNE    CF1

 LEA    LSTLIN+28(A4),A1 ;@BBS
 CMP.B  (A1),D4
 BNE.S  4$
 LEA    LSTLIN+14(A4),A1 ;To call or zip
4$
 BSR    STR_CMP
 BEQ.S  5$              ;All 6 match
 MOVEQ  #'!',D0
 CMP.B  #'?',-(A0)
 BEQ.S  5$              ;Wildcard
 CMP.B  (A0),D0
 BLT    2$
 CMP.B  -(A1),D0
 BLE    2$

5$
 MOVE.B (A0)+,D0
 BEQ    CF1             ;To BBS not found
 CMP.B  #'*',D0
 BNE    5$

 LEA    U_CALL(A4),A1   ;Is this the BBS
 BSR    STR_CMP
 BEQ.S  CF5             ;All 6 match
 MOVEQ  #'!',D0
 CMP.B  -(A0),D0
 BLT    2$
 CMP.B  -(A1),D0
 BLE    2$

CF5
 MOVE.L LSTLIN(A4),D0   ;Msg #
 BSR    FIXNAM

*R:871030/1318z 439@N3ET [Allentown,PA] N:EPA/HTN3 Z:18103
 LEA    HDRLIN(A4),A1
 MOVE.W #'R:',(A1)+
 LEA    LSTLIN+35(A4),A0  ;Date/Time
 MOVEQ  #10,D3
1$
 MOVE.B (A0)+,(A1)+
 DBEQ   D3,1$
 LEA    HDRLIN+4(A4),A0
 BSR    TIMUTC
 ADDQ.L #4,A0
 MOVE.L (A0),D0
 MOVE.B #'/',(A0)+
 MOVEQ  #3,D3
020$
 ROL.L  #8,D0
 MOVE.B D0,(A0)+
 DBRA   D3,020$

 MOVE.B #'z',(A1)+
 MOVE.B D4,(A1)+
 LEA    LSTLIN(A4),A0
021$
 CMP.B  (A0)+,D4
 BEQ    021$
 SUBQ.L #1,A0
023$
 MOVE.B (A0)+,(A1)+     ;Msg#
 CMP.B  #'0',(A0)
 BGE    023$

 MOVE.L FWD_R_FIB+12(A4),A0
 MOVEQ  #79,D3
3$
 MOVE.B (A0)+,(A1)
 CMP.B  (A1)+,D4
 DBGT   D3,3$
 CLR.B  (A1)

 LEA    MSG_R_FIB(A4),A5
 BSR    A5_READ_FILE
 BEQ    CF_END

 LEA    FWDTMP(A4),A1
 MOVE.B #'S',(A1)+      ;SP WA3MNT < N3ET @ N3DPU
 MOVE.B LSTLIN+5(A4),(A1)+
 MOVE.B D4,(A1)+
 LEA    LSTLIN+14(A4),A0
 BSR    PLSPC
 MOVE.B #'<',(A1)+
 MOVE.B D4,(A1)+
 LEA    LSTLIN+21(A4),A0
 BSR    PLSPC
 LEA    LSTLIN+28(A4),A0
 CMP.B  (A0),D4
 BGE.S  8$
 MOVE.B #'@',(A1)+
 MOVE.B D4,(A1)+
 BSR    PLSPC
8$
 MOVE.L BIDADR(A4),D3
 BEQ.S  88$
 MOVE.L D3,A0

 LEA    45(A0),A0
 MOVEQ  #29,D3
83$
 MOVE.B (A0)+,(A1)+
 CMP.B  (A0),D4        ;Space
 DBGE   D3,83$

88$
 MOVE.B #$A,(A1)+
 CLR.B  (A1)
 LEA    FWDTMP(A4),A0
 BSR    PLIN_F_S_W

 BSR    FAKE          ;~Enter Title
 TST.B  SIDBID(A4)
 BEQ.S  89$
 CMP.B  #'O',(A0)
 BEQ.S  89$
 SUB.B  #'N',(A0)
 MOVE.B (A0),DSCFLG(A4)
 BNE    CF_END        ;Already got, but ??
 BSR    BIDUPD
 CLR.L  BIDADR(A4)
 BSR    FARROW
 BRA    CMD_F

89$
 MOVE.L LASTPT(A4),A0
 LEA    46(A0),A0     ;Title
92$
 MOVE.B (A0),D7
 BSR    PCHR_F_S_W
 CMP.B  (A0)+,D4
 BLE    92$
 TST.B  SIDBID(A4)
 BNE.S  9$
 BSR    FAKE          ;~Enter Text
9$
 LEA    HDRLIN(A4),A0
 BSR    PLIN_F_S_W
 MOVE.L 12(A5),A0     ;Mid Pointer
CF2
 BSR    PSTR
 SUB.L  D0,16(A5)
 BGT    CF2
 BSR    W_STAT
 LEA    CTLZ(PC),A0     ;^Z LF
 BSR    PLIN_S_W
 BSR    FARROW          ;Forces bye if disconnect
 ADDQ.B #1,CR_FLG(A4)   ;A file was read
 ADDQ.B #1,DIRCHG(A4)   ;DIR changed for 'Y'
 MOVEQ  #'x',D0
 MOVE.L LASTPT(A4),A0
 CMP.B  #'$',6(A0)
 BNE.S  9$
 MOVE.B U_BID(A4),D0
9$
 MOVE.B D0,7(A0)
 BRA    CMD_F

CF_END
 BSR    CLEAN_DIR_2     ;Update last forward
 MOVE.B F7_RUN(A4),FR_RUN(A4)  ;Send F> next
 BEQ.S  2$
 CLR.B  F7_RUN(A4)
 RTS

2$
 LEA    MDONE(PC),A0
 BRA    PR_BAD

PLSPC
 MOVEQ  #8,D3
1$
 MOVE.B (A0)+,(A1)
 CMP.B  (A1)+,D4        ;Space
 DBGE   D3,1$
 RTS

FAKE
 BSR    GETLIN
 BNE    CMD_B
 RTS


***
CMD_L; List file directory
*
 MOVE.B #127,LLCNT(A4) ;For msg hdr
 MOVEQ  #$20,D7        ;>Msg
 CMP.B  #$A,(A0)
 BNE.S  1$
 MOVE.L U_MSG(A4),CMPMSG(A4)
 BRA.S  5$

1$
 MOVE.B (A0)+,D0
 MOVE.B D0,CMPCHR(A4)
 CLR.L  D7

 CMP.B  #'L',D0         ;LL nn
 BNE.S  2$
 CMP.B  (A0)+,D4
 BNE.S  CL_BAD
 BSR    A0_GETNUM
 BGT.S  CL_BAD
 AND.W  #$F0F,D0
 MOVE.W D0,-(SP)
 LSR.W  #5,D0    x8
 ADD.W  D0,(SP)
 LSR.B  #2,D0    x2
 ADD.W  (SP)+,D0
 MOVE.B D0,LLCNT(A4)    ;LL count
 BRA.S  5$

2$
 CMP.B  #$A,(A0)
 BNE.S  CL_BAD
 MOVEQ  #4,D7           ;TO LM or L>
 CMP.B  #'M',D0
 BEQ.S  5$
 CMP.B  #'>',D0
 BEQ.S  5$
 MOVEQ  #8,D7           ;FROM L<
 CMP.B  #'<',D0
 BEQ.S  5$
 CMP.B  D4,D0
 BEQ.S  CL_BAD

 MOVEQ  #2,D7           ;BFLAG
5$
 BSR    FILL_CMPLIN
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),(A5)     ;Mid Pointer
 MOVE.L 16(A5),20(A5)   ;Byte cntr
7$
 BSR    LISTER
 BEQ.S  9$
 MOVE.B LLCNT(A4),D0
 BGT.S  7$
9$
 MOVE.L NXTMSG(A4),NXTLST(A4)    ;Set last read
 CMP.B  #127,LLCNT(A4)
 BEQ    PNONE
 BRA    GRTS            ;EOF

CL_BAD
 LEA    ML_BAD(PC),A0
 BRA    PR_BAD


***
W_STAT
*
 CLR.B  CLOCK1(A4)
2$
 BSR    WAIT
 MOVE.B CLOCK1(A4),D0
 BEQ    2$
 BTST.B #2,D0
 BNE    2$
 BSR.S  CKSTAT
 BMI    CMD_B
 CMP.B  #'C',STATUS(A4)
 BNE    W_STAT
 RTS


***
CKSTAT ;Poll TNC Status
*
 MOVEM.L D0-D7/A0-A6,-(SP)
 CLR.B  STATUS(A4)
0$
 LEA    TNCSTA(PC),A0
 BSR    PLIN_S
 BSR    DUMP2
 BSR    GETLIN
 LEA    12(A0),A0
 MOVE.L #' IO ',D0
 CMP.L  (A0)+,D0
 BNE.S  9$
 SUBQ.B #1,STACNT(A4)
 BEQ.S  5$
 MOVE.B (A0),STATUS(A4)
 CMP.B  #'D',(A0)
 BNE.S  9$
5$
 MOVE.B #-1,STATUS(A4)
 ADDQ.B #1,DSCFLG(A4)
9$
 LEA    TNCCON(PC),A0
 BSR    DUMPER
 TST.B  STATUS(A4)
 BEQ    0$
 MOVEM.L (SP)+,D0-D7/A0-A6
 RTS


***
CMD_NAME; Get user name
*
 CMP.B  #$A,(A0)
 BEQ.S  11$
 MOVE.L A0,-(SP)
 CMP.B  (A0)+,D4
 BNE.S  CN_BAD
 MOVEQ  #17,D3
1$
 CMP.B  #'A',(A0)+
 DBLT   D3,1$
 CLR.B  (A0)
 CMP.B  #$A,-(A0)
 BNE.S  CN_BAD

 MOVE.L (SP)+,A0
 LEA    U_NAME(A4),A1
 MOVEQ  #19,D3
2$
 MOVE.B (A0)+,(A1)+
 DBEQ   D3,2$
11$
 LEA    U_NAME(A4),A0
 BRA    PLIN_F_S_W

CN_BAD
 MOVE.L (SP)+,A0
 LEA    MN_BAD(PC),A0
 BRA    PR_BAD


***
CMD_R; Read cmd
*
 CMP.W  #$560A,RBUFF(A4)
 BNE.S  2$
 LEA    MAMIG1(PC),A0   ;Version
 BRA    PLIN_F_S_W

2$
 CLR.B  CR_FLG(A4)
 MOVE.B (A0)+,D0
 MOVEQ  #4,D7           ;Comp flags - TO
 CMP.B  #'M',D0
 BEQ.S  3$
 CMP.B  D4,D0
 BNE    CR_BAD
 BSR    A0_GETNUM       ;Get decimal
 MOVE.L D0,CMPMSG(A4)
 MOVEQ  #1,D7           ;MSG FLG
3$
 LEA    DIR_R_FIB(A4),A5
 MOVE.L 12(A5),(A5)
 MOVE.L 16(A5),20(A5)

CR1
 TST.L  20(A5)
 BLE.S  CR_END         ;END
 BSR    LISTER
 BEQ.S  CR_END         ;Not Found

 MOVE.L LSTLIN(A4),D0  ;Msg
 BSR    FIXNAM         ;Fix Filename

CM8A
 LEA    MSG_R_FIB(A4),A5
 BSR    A5_READ_FILE
 BEQ    BRTS
 BSR    WAIT
 MOVE.L 12(A5),A0
 CMP.B  #'R',RBUFF(A4)
 BNE.S  5$
 BSR    PATHER
 LEA    TMPMEM(A4),A0
 BSR    PLIN_F_S_W
 MOVE.L A0SAV(A4),A0
5$
 MOVE.B DSCFLG(A4),D0
 BNE.S  CR_BAD
 BSR    PSTR
 MOVE.L 12(A5),D0
 ADD.L  16(A5),D0
 CMP.L  A0,D0           ;Curraddr,endaddr
 BGT    5$
 ADDQ.B #1,CR_FLG(A4)   ;A file was read
 ADDQ.B #1,DIRCHG(A4)   ;DIR changed for 'Y'
 MOVE.L LASTPT(A4),A0
 MOVE.B #'.',7(A0)
 BTST.L #2,D7           ;RM
 BEQ    GRTS            ;EOF
 LEA    DIR_R_FIB(A4),A5
 BRA    CR1

CR_END
 MOVE.B CR_FLG(A4),D0
 BNE    GRTS
 BTST.L #2,D7
 BNE    PNONE
CR_BAD
 LEA    MR_BAD(PC),A0
 BRA    PR_BAD


***
CMD_S; Send cmd
*
 CLR.B  BIDBUF+45(A4)
 MOVE.L A0,-(SP)
 MOVE.L NXTMSG(A4),D0
 BSR    FIXNAM      ;Fix Filename
 BSR    FILL_CMPLIN
 LEA    CMPLIN(A4),A1
 MOVE.L NXTMSG(A4),(A1)+  ;Message number
 MOVE.L (SP)+,A0
 ADDQ.L #1,A1
 MOVE.B (A0),(A1)+        ;Sx
 BEQ    CS_BAD
 MOVE.B #'N',(A1)
 CMP.B  (A0)+,D4
 BGT    CS_BAD
 BEQ.S  1$
 CMP.B  (A0)+,D4
 BNE    CS_BAD
1$
 LEA    CMPLIN+14(A4),A1   ;TO
 BRA.S  5$

2$
 LEA    CMPLIN+28(A4),A1   ;@ BBS
 BRA.S  5$

4$
 LEA    CMPLIN+21(A4),A1   ;FROM
5$
 MOVEQ  #5,D3
 CMP.B  (A0),D4
 BNE.S  6$
 ADDQ.L #1,A0
6$
 MOVE.B (A0)+,D0
 CMP.B  D4,D0
 BLT.S  8$         ;Drop C/R
 CMP.B  #'@',D0
 BEQ    2$
 CMP.B  #'<',D0
 BEQ    4$
 MOVE.B D0,(A1)+
 CMP.B  D4,D0
 DBEQ   D3,6$
7$
 MOVE.B (A0)+,D0
 BEQ.S  8$
 CMP.B  #'<',D0
 BEQ    4$
 CMP.B  #'@',D0
 BEQ    2$
 CMP.B  #'$',D0
 BNE    7$
 TST.B  SIDBID(A4)
 BEQ    CMD_B           ;Not BIDABLE BBS
 BSR    BIDRED
 MOVE.B D0,CMPLIN+6(A4)
 LEA    BIDBUF(A4),A1
 MOVE.L NXTMSG(A4),(A1)+
 MOVEQ  #40,D3      ;End at +45
70$
 MOVE.B D4,(A1)+
 DBRA   D3,70$
 MOVEQ  #32,D3
 SUBQ.L #1,A0
71$
 MOVE.B (A0)+,(A1)+
 DBEQ   D3,71$
 CLR.B  -(A1)
 MOVE.B #$A,-(A1)
 BSR    BIDCHK
 BNE.S  8$
 MOVE.L A0,BIDADR(A4)
 MOVEQ  #'N',D7
 BSR    PCHR_F_S_W
 LEA    BIDBUF+45(A4),A0
 BSR    PLIN_F_S_W
 BRA    BIDUPD            ;Flag as got

8$
 LEA    CMPLIN+21(A4),A0  ;FROM
 MOVE.L A0,A1
 BSR    MOVE_VALID_CALL   :Dummy move to check call
 BNE.S  9$                ;OK
 LEA    U_CALL(A4),A0
 LEA    CMPLIN+21(A4),A1
 MOVE.B D4,5(A1)          ;N3ET won't overwrite KAA3MN
 BSR    MOVE_VALID_CALL
 BEQ    ABORTB            ;Bad user call ~ELK
9$
 LEA    TIMLIN(A4),A0
 LEA    CMPLIN+35(A4),A1  ;Date
 MOVEQ  #9,D3
10$
 MOVE.B (A0)+,(A1)+
 DBRA   D3,10$

 LEA    MS_TIT(PC),A0   ;Enter Title
 BSR    PLIN_F_S_W
 LEA    BBS_MSG+2(A4),A0
 BSR    PLIN_F_S_W
 MOVEQ  #$A,D7
 BSR    PCHR_F_S_W
 BSR    GETLIN
 BNE    CMD_B  *ABORTB
 LEA    CMPLIN+46(A4),A1 ;Title
* MOVEQ  #31,D3           ;32 CHR + LF + NULL
 MOVEQ  #80,D3           ;80 CHR + LF + NULL
20$
 MOVE.B (A0)+,(A1)+
 CMP.B  (A0),D4
 DBGT   D3,20$
 MOVE.B #$A,(A1)+
 CLR.B  (A1)

 MOVE.B BIDBUF+45(A4),D0
 OR.B   SIDBID(A4),D0
 BNE.S  222$
 LEA    MS_MSG(PC),A0   ;Enter message
 BSR    PLIN_F_S_W
222$
 LEA    MSG_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BEQ    CMD_B
 CLR.L  SIZMSG(A4)
 LEA    BUFSEN(A4),A1
 MOVE.L A1,12(A5)
 MOVE.L A1,(A5)
 CLR.L  20(A5)
21$
 TST.B  ZFLG(A4)
 BNE.S  30$
 BSR    GETLIN          ;D3=Length
 BNE.S  FLUSHA
 MOVE.L (A5),A1
 CMP.B  #$A,(A0)
 BNE.S  25$
 TST.B  ZFLG(A4)
 BNE.S  30$
25$
 MOVE.B (A0)+,(A1)+
 BEQ    21$
 MOVE.L A1,(A5)
 ADDQ.L #1,20(A5)
 CMP.L  #SENSIZ,20(A5)
 BNE.S  25$
 BSR.S  FLUSH
 TST.W  SIZMSG(A4)      ;65k max
* BNE.S  FLUSHA
* TST.B  ZFLG(A4)
 BEQ    25$
30$
 BSR.S  FLUSH
 BSR    A5_CLOSE
 MOVE.L SIZMSG(A4),-(SP)
 PEA    CMPLIN+7(A4)    ;To
 PEA    FMT1(PC)        ;Format spec
 BSR    SPRINT
 LEA    12(SP),SP
 MOVE.B D4,CMPLIN+13(A4) ;Over NULL
 BSR    BIDADD
 BRA    CLEAN_DIR

CS_BAD
 LEA    MS_BAD(PC),A0
 BRA.S  PR_BAD

FLUSHA; Flush msg and abort
 BSR.S  FLUSH
 BRA    CMD_B

FLUSH
 MOVE.L A0,-(SP)
 BSR    A5_WRITE
 ADD.L  D0,SIZMSG(A4)
 MOVE.L 12(A5),(A5)
 MOVE.L (A5),A1
 CLR.L  20(A5)
 MOVE.L (SP)+,A0
 RTS


***
CMD_T; Talk to SYSOP
*
 LEA    MTALK(PC),A0
 BRA.S  PR_BAD

PNONE
 LEA    MNONE(PC),A0
 BRA.S  PR_BAD

***
CMD_HUH; Not valid command
*
 LEA    MHUH(PC),A0
PR_BAD
 ADDQ.B #1,BADCNT(A4)
 BRA    PLIN_F_S_W


***
A5_GET_LINE; Get line from send buffer
*
 LEA    LSTLIN(A4),A0
 MOVE.L A0,-(SP)
 MOVE.L (A5),A6
 MOVE.L A6,LASTPT(A4)
 MOVEQ  #78,D3          ;79 CHR+NULL
GL1
 MOVE.B (A6),(A0)+
GL2
 SUBQ.L #1,20(A5)
 BLE.S  GL4
 CMP.B  #$A,(A6)+
 BEQ.S  GL4
 SUBQ.L #1,D3
 BPL    GL1
 BRA    GL2
GL4
 MOVE.L A6,(A5)
 CLR.B  (A0)
 MOVE.B #$A,-(A0)
 MOVE.L (SP)+,A0
 RTS


***
GET_USR_DATA; Get User data from BBS.USR
*
 CLR.L  U_PTR(A4)
 LEA    USR_R_FIB(A4),A5
 BSR    A5_READ_FILE
 BEQ.S  BRTS
*
 MOVE.L 12(A5),A0      ;Buff
* MOVE.L 16(A5),20(A5)  ;Byte cnt
 BRA.S  2$

1$
 SUBQ.L #1,20(A5)
 BEQ.S  GRTS           ;EOF, Call not found
 CMP.B  #$A,(A0)+
 BNE    1$
2$
 MOVE.L A0,A6
 LEA    U_CALL(A4),A1
 MOVEQ  #8,D3
3$
 CMP.B  (A0)+,(A1)+    ;Compare call
 DBNE   D3,3$
 BNE    1$             ;Try next
 MOVE.L A6,U_PTR(A4)
 LEA    U_LINE(A4),A1
4$
 MOVE.B (A6)+,(A1)+
 CMP.B  #'.',(A6)
 BEQ.S  BRTS           ;Call not allowed
 CMP.B  (A6),D4
 BLE    4$
 MOVE.B #$A,(A1)+
 CLR.B  (A1)
* BRA    GRTS

GRTS; True
 MOVEQ  #1,D0
 RTS

BRTS; False
 CLR.L  D0
 RTS

***
CLEAN_USR; Update USR disk file
*
 LEA    USR_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BEQ.S  5$
 MOVE.L U_CNT(A4),D0
 BSR    INC_ABCD
 MOVE.L D0,U_CNT(A4)
 LEA    U_LINE(A4),A0
 MOVE.L A0,A1
1$
 CMP.B  (A1)+,D4
 BLE    1$
 MOVE.B #$A,-1(A1)
 SUBA.L A0,A1
 MOVE.L A0,12(A5)       ;TOP_ADR
 MOVE.L A1,20(A5)       ;TOP_SIZ
 BSR    A5_WRITE        ;User on top
 BEQ.S  5$
 LEA    USR_R_FIB+12(A4),A6
 MOVE.L (A6)+,12(A5)    ;Buff
 MOVE.L (A6),20(A5)     ;Size
 BSR    A5_WRITE
5$
 BRA    A5_CLOSE


***
CLEAN_DIR; After a 'S' command
*
 LEA    DIR_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BEQ    ABORTB
 LEA    CMPLIN(A4),A0
 MOVE.L A0,A1
 MOVEQ  #127,D3         ;#79,D3
1$
 CMP.B  (A1)+,D4
 DBGT   D3,1$
 MOVE.B #$A,-1(A1)
 SUB.L  A0,A1
 MOVE.L A0,12(A5)       ;TOP_ADR
 MOVE.L A1,20(A5)       ;TOP_SIZ
 MOVE.L A1,D0
 BEQ    ABORTB          ;Zero lenght user call? ELK
 BSR    A5_WRITE        ;User line added on top
 BEQ    ABORTB
 BRA.S  CLD3

CLEAN_DIR_2             ;After a 'K' command
 TST.B  DSCFLG(A4)
 BNE    ABORTB
 MOVE.B DIRCHG(A4),D0
 BEQ    GRTS            ;DIR not changed
 LEA    DIR_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BEQ    ABORTB
CLD3
 LEA    DIR_R_FIB+12(A4),A6
 MOVE.L (A6)+,(A5)   ;Mid Ptr
 MOVE.L (A6),20(A5)  ;Byte cntr
1$
 MOVEQ  #0,D7
 BSET.B #7,D7        ;No list
 BSR    LISTER
 MOVE.L LASTPT(A4),A6
 ADDQ.L #6,A6
 CMP.B  #'$',(A6)+
 BEQ.S  3$
 MOVE.B (A6),D0
 MOVE.B D4,(A6)      ;Clean '.' from DIR
 CMP.B  #'.',D0
 BNE.S  2$
 LEA    LSTLIN+14(A4),A0
 LEA    U_CALL(A4),A1
 BSR    STR_CMP
 BNE.S  3$           ;Not TO call
 MOVE.B #'Y',-(A6)
2$
 CMP.B  #'x',D0
 BNE.S  3$
 MOVE.B #'F',-(A6)   ;Flag as Forwarded

3$
 TST.L  20(A5)
 BGT    1$           ;Not EOF

 LEA    DIR_R_FIB+12(A4),A6
 MOVE.L (A6)+,12(A5)   ;Buff
 MOVE.L (A6),20(A5)    ;Size
 BSR    A5_WRITE
 BEQ    ABORTB
 BSR    A5_CLOSE
 CLR.B  DIRCHG(A4)
DIRRED
 LEA.L  DIR_R_FIB(A4),A5
 BSR    A5_READ_FILE    ;Force DIR_R update
 BEQ    ABORTB
 RTS


***
A5_OPEN_READ; Open read file
*
 MOVE.L #1005,D2
 BRA.S  OW1

***
A5_OPEN_WRITE; Open write file
*
 MOVE.L #1006,D2
OW1
 MOVE.L 4(A5),D1       ;*Name
 MOVE.L (A4),A6
 JSR    _LVOOpen(A6)
 MOVE.L D0,8(A5)       ;0=ERROR else *FH
 RTS


***
A5_ALLOC_MEM; Grab free mem
*
 MOVE.L 16(A5),D0      ;Bytes
 ADDQ.L #8,D0
 CLR.L  D1             ;Any kind of mem
 MOVE.L 4,A6
 JSR    _LVOAllocMem(A6)
 MOVE.L D0,12(A5)      ;Addr
* BEQ    BRTS
 RTS


***
A5_FREE_MEM; Give back mem
*
 BSR    A5_CLOSE
 MOVE.L 12(A5),D0      ;Addr
 BEQ    BRTS
 CLR.L  12(A5)
 MOVE.L D0,A1
 MOVE.L 16(A5),D0      ;Bytes
 CLR.L  16(A5)
 ADDQ.L #8,D0
 MOVE.L 4,A6
 JMP    _LVOFreeMem(A6)


***
A5_READ; Read file per A5
*
 MOVE.W #_LVORead,D0
 MOVE.L 16(A5),20(A5)
 BRA.S  A5_R_W

***
A5_WRITE; Write file per A5
*
 MOVE.W #_LVOWrite,D0
A5_R_W
 MOVE.L 8(A5),D1       ;Handle
 BEQ    ABORTB
 MOVE.L 12(A5),D2      ;Buff
 MOVE.L 20(A5),D3      ;Bytes
 MOVE.L (A4),A6
 JSR    0(A6,D0.W)
 MOVE.L D0,20(A5)      ;bytes
 BMI    ABORTB
 RTS


***
A5_EXAMINE; Get disk info about file
*
 BSR    A5_FREE_MEM    ;Free if old
 MOVE.L 4(A5),D1       ;*Filename
 MOVEQ  #-2,D2         ;ACCESS_READ
 MOVE.L (A4),A6
 JSR    _LVOLock(A6)
 MOVE.L D0,D1          ;Lock
 BEQ    BRTS           ;Fail
 MOVE.L D1,-(SP)
 LEA    TMPMEM(A4),A0
 MOVE.L A0,D2
 JSR    _LVOExamine(A6)
 BEQ.S  1$             ;Fail
 MOVE.L TMPMEM+$7C(A4),16(A5)  ;fib_Size
1$
 MOVE.L (SP)+,D1
 JMP    _LVOUnLock(A6)

***
BIDRED ;Open, Read, close BID file
*
 MOVEM.L A0-A6/D0-D6,-(SP)
 LEA    BID_R_FIB(A4),A5
 BSR.S  A5_READ_FILE
 LEA    MPATH+5(PC),A1
 MOVE.L FWD_R_FIB+12(A4),A2     ;Mycall for pather
 CMP.B  #'@',(A2)+
 BNE.S  1$
 MOVEQ  #8,D3
0$
 MOVE.B (A2)+,(A1)
 CMP.B  (A1)+,D4
 DBGE   D3,0$
 CLR.B  (A1)
1$
 MOVEM.L (SP)+,A0-A6/D0-D6
 RTS

***
A5_READ_FILE; Get mem & fill with file
*
 MOVE.L 8(A5),D1
 BNE    GRTS            ;Already open
 BSR    A5_EXAMINE
 MOVE.L 16(A5),20(A5)   ;Size
 BEQ    BRTS
 BSR    A5_ALLOC_MEM
 BEQ    BRTS            ;Fail
 BSR    A5_OPEN_READ
 BEQ    BRTS
 BSR    A5_READ
 BEQ    BRTS
 
***
A5_CLOSE; Close file per A5
*
 MOVE.L 8(A5),D1
 BEQ    GRTS
 MOVE.L (A4),A6
 JSR    _LVOClose(A6)
 CLR.L  8(A5)          ;Handle
 BRA    GRTS


***
REM_SPC; Remove spaces, A0, lower to UPPER, NULL terminate
*
 MOVE.L A0,-(SP)
 MOVE.L A0,A1
1$
 MOVE.B (A0),D0
 CMP.B  #'a',D0
 BLT.S  2$
 CMP.B  #'z',D0
 BGT.S  2$
 AND.B  #$5F,D0
2$
 MOVE.B D0,(A1)+
 CMP.B  D4,D0
 BLT.S  4$
3$
 CMP.B  (A0)+,D4
 BNE    1$
 CMP.B  (A0),D4
 BEQ    3$
 BRA    1$

4$
 CLR.B  (A1)
* CMP.B  -(A1),D4
* BLE.S  4$
 MOVE.L (SP)+,A0
 RTS


***
FILL_CMPLIN; Fill compare line with spaces
*
 LEA    CMPLIN(A4),A0
 MOVEQ  #127,D3
1$
 MOVE.B D4,(A0)+
 DBEQ   D3,1$
 MOVE.B #$A,(A0)+
 CLR.B  (A0)+
 RTS


***
INC_ABCD; Inc ASCII packed BCD number D0
*
*FORMAT; 20203939 = "  99"
 CLR.L  D1
 ROXL.B #1,D1           ;Clr X bit ??
 MOVEQ  #1,D1
 LEA    ABCDT1(A4),A0
 LEA    ABCDT2(A4),A1
 MOVE.L D0,(A0)+
 MOVE.L D1,(A1)+
 CLR.B  (A0)
 MOVEQ  #3,D0
IA1
 ABCD   -(A1),-(A0)    ;+X ??
 CMP.B  #$40,(A0)
 BNE.S  IA2
 MOVE.B #$30,(A0)
 ADDQ.B #1,-1(A1)      ;Watch for overflow!
IA2
 CMP.B  #$21,(A0)
 DBEQ   D0,IA1
 BNE.S  IA3
 MOVE.B #$31,(A0)
IA3
 MOVE.L ABCDT1(A4),D0
 RTS


***
SPRINT; Format
*
 MOVEM.L D0/A0/A1/A2/A3/A6,-(SP)
 MOVE.L 28(SP),A0       ;Spec
 LEA    36(SP),A1       ;FromBuff
 LEA    1$(PC),A2       :Operation
 MOVE.L 32(SP),A3       ;ToBuff
 MOVE.L 4,A6
 JSR    -522(A6)        ;sprint
 MOVEM.L (SP)+,D0/A0/A1/A2/A3/A6
 RTS
1$
 MOVE.B D0,(A3)+
 RTS


***
STR_CMP; Compare *A0 to *A1 - 6 chars
**
 MOVEQ  #5,D3
SC1
 CMP.B  (A0)+,(A1)+
 DBNE   D3,SC1
 RTS


***
LISTER; Get valid line from DIR and list
*00=ALL 0=MSG 1=BFLAG 2=TO 3=FROM 4=@BBS 5=>MSG 6=DELETED 7=NoList
*
LE1
 TST.L  20(A5)
 BLE    BRTS            ;END
 BSR    A5_GET_LINE
 CMP.B  #'x',5(A0)
 BEQ    LE1             ;Deleted
 MOVE.L D7,D0           ;ALL
 BEQ.S  LE_TO
 LSR.L  #1,D0           ;MSG
 BCS.S  LE_MSG
 LSR.L  #1,D0           ;LB
 BCS.S  LE_B
 LSR.L  #1,D0           ;TO
 BCS.S  LE_TO
 LSR.L  #1,D0           ;FROM
 BCS.S  LE_FROM
 LSR.L  #1,D0           ;@BBS
 BCS.S  LE_AT
 LSR.L  #1,D0           ;>MSG
 BCS.S  LE_MSG
 LSR.L  #2,D0           ;No list
 BCS.S  LE_LIST
LE_MSG
 MOVE.L CMPMSG(A4),D0
 CMP.L  (A0),D0
 BGT.S  LE1             ;Not number
 BEQ.S  LE_TO
 BTST.L #5,D7           ;>MSG
 BEQ    LE1

LE_TO
 CMP.B  #3,D7           ;KT
 BEQ.S  LE_B
 LEA    U_CALL(A4),A0
 LEA    LSTLIN+14(A4),A1
 BSR    STR_CMP
 BEQ.S  LE_LIST
 CMP.B  #$D,D7          ;Kill
 BEQ.S  LE_FROM
 BTST.L #2,D7           ;TO
 BNE    LE1

LE_FROM
 LEA    U_CALL(A4),A0
 LEA    LSTLIN+21(A4),A1
 BSR    STR_CMP
 BEQ.S  LE_LIST
 BTST.L #3,D7
 BNE    LE1

 CMP.B  #'P',LSTLIN+5(A4)
 BEQ    LE1
 BRA.S  LE_LIST

LE_AT
 LEA    U_CALL(A4),A0
 LEA    LSTLIN+28(A4),A1
 CMP.B  (A1),D4
 BNE.S  LE_LIST
 BRA    LE1

LE_B
 MOVE.B CMPCHR(A4),D0
 CMP.B  5(A0),D0
 BNE    LE1
LE_LIST
 LEA    LSTLIN(A4),A0
 BTST.B #7,D7           ;No list
 BNE    GRTS
 ADDQ.B #1,LHFLG(A4)
 BNE.S  1$
 LEA    MLHEAD(PC),A0
 BSR.S  5$
 LEA    LSTLIN(A4),A0
1$
 SUBQ.B #1,LLCNT(A4)    ;LL count
5$
 BSR    PLIN_F_S_W
 BRA    GRTS


***
A0_GETNUM; Parse number from A0 to D0
*
 MOVE.L #'    ',D0
1$
 LSL.L  #8,D0
 MOVE.B (A0)+,D0
 CMP.B  #'9',D0
 BGT.S  2$              ;BAD
 CMP.B  #'0',(A0)       ;Next byte number?
 BGE.S  1$
2$
 RTS

***
FIXNAM; Remove spaces, put filename for R/W
*
 ROL.L  #8,D0
 SUB.B  D4,D0
 BEQ    FIXNAM
 ADD.B  D4,D0
 ROR.L  #8,D0
 MOVE.L D0,BBS_MSG+2(A4)
 CLR.B  BBS_MSG+6(A4)
 RTS


***
TIMUTC; Convert ASCII time A0 to UTC 880901/1229
*
 MOVEQ  #3,D3   ;+5 hrs
0$
 BSR.S  1$
 DBRA   D3,0$
1$
 CMP.B  #'9',5(A0)
 BLT.S  2$
 MOVE.B #'0',5(A0)
 ADDQ.B #1,4(A0)
 RTS

2$
 ADDQ.B #1,5(A0)
 CMP.W  #'24',4(A0)
 BLT.S 99$
 MOVE.W #'00',4(A0)
 ADDQ.B #1,3(A0)
 CMP.B  #'9',3(A0)
 BLE.S  80$
 MOVE.B #'0',3(A0)
 ADDQ.B #1,2(A0)
80$
 CMP.W  #'29',2(A0)
 BLT.S  99$
 CMP.W  #'02',(A0)   ;2
 BEQ.S  97$
 CMP.W  #'31',2(A0)  ;1,3,5,7,8,10,12
 BLT.S  99$
 BNE.S  97$
 CMP.W  #'11',(A0)   ;11
 BEQ.S  97$
 CMP.W  #'09',(A0)
 BNE.S  90$
 MOVE.W #'10',(A0)   ;9
 BRA.S  98$
90$
 CMP.W  #'04',(A0)   ;4
 BEQ.S  97$
 CMP.W  #'06',(A0)   ;6
 BNE.S  99$
97$
 ADDQ.W #1,(A0)
98$
 MOVE.W #'01',2(A0)
99$
 RTS
 

***
TIME; fill 3 longwords with DAYS,MINS,SECS
*
 MOVEM.L A0/D1,-(SP)
 LEA.L  DAYCNT(A4),A0
 MOVE.L A0,D1
 MOVE.L (A4),A6
 JSR    _LVODateStamp(A6)
 LEA    DAYCNT+8(A4),A0
 MOVE.L (A0),D1
 CLR.W  (A0)+
 DIVU.W #50,D1         ;50 TICKS per second
 MOVE.W D1,(A0)        ;SEC
 MOVEM.L (SP)+,D1/A0
 RTS


***
SETRTC; convert 3 longwords to readable form
*
 BSR    TIME
 MOVE.L DAYCNT(A4),D3  ;DAYS
 SUB.W  #1096,D3       ;REF 810101
 DIVU.W #1461,D3       ;365*4+1
 ASL.W  #2,D3          ;x4
 MOVE.W D3,YEAR(A4)
 CLR.W  D3
 SWAP.W D3
 CMP.W  #1154,D3  365*3+31+29-1 ex:880229
 BLT.S  2$
 SUB.W  #1095,D3  365*3
 SWAP.W D3
 ADDQ.W #3,D3
 MOVEQ  #29,D0
 BRA.S  3$

2$
 MOVEQ  #28,D0
 DIVU.W #365,D3
3$
 LEA.L  MONTHS(PC),A3
 MOVE.B D0,1(A3)        ;FEB leap year fix
 ADD.W  YEAR(A4),D3
 ADD.W  #81,D3
 MOVE.W D3,YEAR(A4)
 SWAP.W D3
 ADDQ.W #1,D3           ;1-1-XX = DAY 0
 CLR.W  MONTH(A4)
 CLR.L  D0
4$
 ADDQ.W #1,MONTH(A4)
 MOVE.B (A3)+,D0
 SUB.W  D0,D3
 BGT.S  4$
 ADD.W  D0,D3
 MOVE.W D3,DAY(A4)

 MOVE.L DAYCNT+4(A4),D3 MINS
 DIVU.W #60,D3          ;60 minutes per hour
 MOVE.W D3,HOUR(A4)
 SWAP.W D3
 MOVE.W D3,MIN(A4)      ;Div remainder in MIN

 MOVE.L DAYCNT+8(A4),D3
 MOVE.W D3,SEC(A4)

 LEA    YEAR(A4),A0     ;YYMMDDHHMMSS
 LEA    TIMLIN(A4),A1
 MOVEQ  #4,D3
7$
 MOVE.W (A0)+,D2
 BSR.S  PUT2D
 DBRA   D3,7$
 LEA    MPROMT(PC),A0
 MOVE.L TIMLIN+6(A4),(A0)
 RTS


PUT2D
 CLR.L  D0
 MOVE.W D2,D0
 DIVU   #10,D0
 BSR.S  2$
 SWAP.W D0
2$
 ADD.B  #$30,D0
 MOVE.B D0,(A1)+
 RTS


***
PATHER; Get path from file =>A0
*
 MOVE.L A0,A0SAV(A4)
 LEA    TMPMEM(A4),A1
 CLR.L  (A1)
 CMP.W  #'R:',(A0)
 BNE    GRTS
 LEA    MPATH(PC),A2
 MOVEQ  #11,D3          ;PATH:WA3MNT_
0$
 MOVE.B (A2)+,(A1)+
 CMP.B  #'0',(A2)
 DBLT   D3,0$
 MOVE.B D4,(A1)+
1$
 MOVE.B (A0)+,D0
 CMP.B  #'R',D0
 BNE.S  99$
 CMP.B  #':',(A0)
 BNE.S  99$
2$
 MOVE.B (A0)+,D0
 CMP.B  D4,D0
 BLT    1$
 CMP.B  #'@',D0
 BNE    2$
 CMP.B  #':',(A0)
 BNE.S  5$
 ADDQ.L #1,A0
5$
 MOVEQ  #5,D3
7$
 MOVE.B (A0),D0
 CMP.B  #'0',D0
 BLT.S  8$
 MOVE.B (A0)+,(A1)+
 DBRA   D3,7$
8$
 MOVE.B D4,(A1)+
9$
 CMP.B  (A0)+,D4
 BLE    9$
 BRA    1$
 
99$
 CLR.B  (A1)
 MOVE.B #$A,-(A1)
 SUBQ.L #1,A0
 MOVE.L A0,A0SAV(A4)
 RTS

***
BIDMSG; Get $BID from Msg#
*
 MOVEM.L D0-D2/A0-A2,-(SP)
 MOVE.L A0,D1
 MOVE.L BID_R_FIB+12(A4),A0  ;Buff
 MOVE.L BID_R_FIB+16(A4),D0  ;Size
 BRA.S  2$
1$
 SUBQ.L #1,D0
 BLE.S  99$            ;EOF, Call not found
 CMP.B  #$A,(A0)+
 BNE    1$
2$
 MOVE.L A0,A2
 MOVE.L D1,A1
 MOVEQ  #4,D2
3$
 CMP.B  (A0)+,(A1)+    ;Compare MSG#
 DBNE   D2,3$
 MOVE.L A2,A0
 BNE    1$             ;Try next
 CMP.B  #'$',7(A0)     ;Old
 BEQ.S  99$
 CLR.L  D0
 MOVE.B U_BID(A4),D0
 SUB.B  #$41,D0
 BMI.S  99$            ;Not a Bid User
 CMP.B  11(A2,D0),D4
 BNE.S  99$            ;Got already
98$
 MOVE.L A2,BIDADR(A4)
 MOVEM.L (SP)+,D0-D2/A0-A2
 RTS

99$
 SUB.L  A2,A2
 BRA    98$


***
BIDCHK; Check for dupe $BID
*
 MOVE.L BID_R_FIB+12(A4),A0  ;Buff
 MOVE.L BID_R_FIB+16(A4),D0  ;Size
 BRA.S  2$
1$
 SUBQ.L #1,D0
 BLE    GRTS           ;EOF, Call not found
 CMP.B  #$A,(A0)+
 BNE    1$
2$
 MOVE.L A0,A6
 LEA    7(A0),A0
 CMP.B  #'$',(A0)      ;Old
 BEQ.S  25$
 LEA    38(A0),A0      ;45-7=38
25$
 LEA    BIDBUF+45(A4),A1
 MOVEQ  #30,D3
3$
 CMP.B  (A0)+,(A1)+    ;Compare Bid
 DBNE   D3,3$
 MOVE.L A6,A0
 TST.B  -(A1)
 BNE    1$             ;Try next
 RTS


***
BIDADD; Add new Bid
*
 LEA    BIDBUF(A4),A0
 CLR.L  D0
 MOVE.B U_BID(A4),D0
 MOVE.L D0,D1
 SUB.B  #$41,D0
 BMI.S  0$
 MOVE.B D1,11(A0,D0)    ;A-Z
0$
 LEA    45(A0),A1
 TST.B  (A1)+
 BEQ    GRTS
1$
 TST.B  (A1)+
 BNE    1$
 SUBQ.L #1,A1
 SUBA.L A0,A1
 MOVE.L A0,D7       ;TOP_ADR
 MOVE.L A1,D6       ;TOP_SIZ

 LEA    BID_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BEQ    ABORTB      BIDERR
 MOVE.L D7,12(A5)   ;TOP_ADR
 MOVE.L D6,20(A5)   ;TOP_Bytes
 BSR    A5_WRITE    ;New on top
 BEQ    ABORTB      BIDERR
BIDWRI
 LEA    BID_R_FIB+12(A4),A6
 MOVE.L (A6)+,12(A5) ;Adr
 MOVE.L (A6),20(A5)  ;Bytes
 BSR    A5_WRITE
 BSR    A5_CLOSE
 CLR.B  BIDCHG(A4)
 BRA    BIDRED


***
BIDUPD; Update old Bid
*
 MOVE.L BIDADR(A4),D0
 BEQ    BRTS
 MOVE.L D0,A0
 CMP.B  #'$',7(A0)
 BEQ    BRTS            ;Old
 CLR.L  D0
 MOVE.B U_BID(A4),D0
 MOVE.L D0,D1
 SUB.B  #$41,D0
 BMI    BRTS
 CMP.B  11(A0,D0),D4
 BNE    BRTS            ;Got already
 MOVE.B D1,11(A0,D0)    ;A-Z
* ADDQ.B #1,BIDCHG(A4)
 LEA    BID_W_FIB(A4),A5
 BSR    A5_OPEN_WRITE
 BNE    BIDWRI
BIDERR
 BSR    A5_CLOSE
 BRA    BIDRED


TIMSTR
 MOVEM.L A0/A1/D0/D7,-(SP)
 BRA.S  SETT1

***
SETTIM; Start timer
*
 MOVEM.L A0/A1/D0/D7,-(SP)
 MOVE.L T_R(A4),A0
 MOVE.L $E(A0),A0       ;TIMERPORT
 MOVE.L 4,A6
 JSR    _LVOGetMsg(A6)
 MOVE.L D0,D0
 BEQ.S  SETT2           ;No Timeout

SETT1
* MOVE.B CLOCK2(A4),D0
* ADDQ.B #1,D0
* CMP.B  #60,D0
* BNE.S  0$
* MOVEQ  #0,D0
*0$
* MOVE.B D0,CLOCK2(A4)
 CLR.B  TIMFLG(A4)
 TST.B  DIEFLG(A4)
 BNE.S  SETT2
 MOVE.L T_R(A4),A1
 MOVE.W #9,$1C(A1)      ;io_Command=TR_ADDREQUEST
 MOVEQ  #1,D0
 MOVE.L D0,$20(A1)      ;Seconds
 CLR.L  $24(A1)         ;Micros
 MOVE.L 4,A6
 JSR    _LVOSendIO(A6)
 ADDQ.B #1,TIMFLG(A4)

 CMP.B  #5,BADCNT(A4)
 BGE.S  1$              ;Bad commands
 SUBQ.B #1,CLOCK1(A4)
 BNE.S  SETT2
 TST.B  C_RUN(A4)
 BEQ.S  SETT2
1$
 ADDQ.B #1,DSCFLG(A4)
 CLR.B  BADCNT(A4)
 CLR.B  C_RUN(A4)
 LEA    MTIMOT(PC),A0
 BSR    PLIN_F_S_W
 LEA    TNCEND(PC),A0
 BSR    PLIN_S
 TST.B  B_RUN(A4)
 BNE    CMD_B
SETT2
 MOVEM.L (SP)+,A0/A1/D0/D7
 RTS


* SECTION data,DATA
TNCINI DC.B 1,'E N',$D,'U NONE',$D,'MCON N',$D,'STATS Y',$D
       DC.B 'MON N',$D,2,'A'
TNCCON DC.B 7,$D,'CONV',$D,0
MTIMOT DC.B '*** TIMEOUT/ERROR',$D,0
TNCEND DC.B 1,$19,$18,'D',$D,$19,$A,0
TNCDIS DC.B 1,$19,'D',$D,'MON Y',$D,'E Y',$D,'DA',$19,$D,0
TNCSWI DC.B 1,3,'A',7,$D,'CONV',$D,0
TNCSTA DC.B 1,'S',$D,0
TNCMH  DC.B 1,'MH',7,$D,'CONV',$D,0
MECHOY DC.B 1,7,$D,'E Y',$D,'CONV',$D,0
MECHON DC.B 1,7,$D,'E N',$D,'CONV',$D,0
MFWD   DC.B 'F>',$D,0
MAMIG1 DC.B '[Amiga-65-P1103-$]',$D,0
FMT1   DC.B '%6ld',0
FMT2   DC.B $A,7,'%1s%1s=%-6s%5ld BAUD',7,'%9ld%9ld%9lx',$A,0

MONTHS DC.B 31,28,31,30,31,30,31,31,30,31,30,31
MWELCM DC.B 'Welcome to AmigaBBS',$A,0
MS_TIT DC.B 'OK, Title for msg #',0
MS_MSG DC.B 'Send msg, ^Z to end:',$A,0
MLHEAD DC.B 'Msg# TS  Size To     From   @ BBS  Date  Time',$A,0
CTLZ   DC.B $1A,$A,0

MJ_BAD DC.B '*** J',$A,0
MK_BAD DC.B '*** K nnnn or KM',$A,0
ML_BAD DC.B '*** L or LM or LL nn',$A,0
MN_BAD DC.B '*** N NAME',$A,0
MR_BAD DC.B '*** R nnnn or RM',$A,0
MS_BAD DC.B '*** S CALL @ BBS',$A,0
MHUH   DC.B '*** R 1 for help',$A,0
MKILLD DC.B '*** KILLED',$A,0
MDONE  DC.B '*** Done',$A,0
MNONE  DC.B '*** None found',$A,0
MPATH  DC.B 'PATH:        ',0
MTALK  DC.B 'If here, I will call back after you disc',$A,0

 CNOP 0,2
*MBID
*DC.B'           abcdefghijklmnopqrstuvwxyz ',0
*     0123456789012345678901234567890123456789012345678901234567890
*     999999     abcdefghijklmnopqrstuvwxyz 880323$0000_N3ET
 CNOP 0,2
USR_NEW
 DC.B '        8701010000     0     0  NoName?',$A,0
*      WA3MNT..8610292400..0001..2359..RANDY^0
*      012345678901234567890123456789012345678901
 CNOP 0,2
MPROMT DC.B '     (B,J,K,L,N,R,S,T,V) >',$D,0
 CNOP 0,2
BBS_DIR  DC.B 'B:DIR',0
BBS_USR  DC.B 'B:USR',0
BBS_FWD  DC.B 'B:FWD',0
BBS_BID  DC.B 'B:BID',0
DOSP DC.L $4E334554 DOS Lib for exit

 END

