' **********************************************************************
' ***
' ***	rcp.b		Remote file copy
' ***			(C)opright 1994 Morgan Davis Group
' ***

#define	IDENT_PROG "rcp"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "15may94"
#define	IDENT_NAME "Morgan_Davis"

#define	VERSION		"ProLine " IDENT_PROG " " IDENT_VERS

#include <basic.h>
#include <proline/proline.h>

#define	ASCII	0
#define	BINARY	1

	gosub AppInit

	mode = BINARY		' Binary mode is the default
	from$ = ID$[uName]

	options$ = "atbf:qs:?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "a" or optchar$ = "t" then mode = ASCII
		if optchar$ = "b" then mode = BINARY
		if optchar$ = "f" and SuperUser then from$ = optarg$
		if optchar$ = "s" then Subject$ = optarg$
		if optchar$ = "q" then quiet = TRUE
		if optchar$ = "?" then showUsage = TRUE
	until optchar$ = ""

	if showUsage or nargc < 3 then
		print "Usage: " argv$[0] " [ -abq ] [ -f from ] [ -s subject ] file user..."
		goto ExitError
	endif

	RealName$ = nargv$[1]
	AccFile$ = RealName$
	& getinfo AccFile$, info$
	if info$ = "" then
		print argv$[0]": can't find " AccFile$
		goto Exit
	endif

	if asc(mid$(info$,5)) = 15 then 
		print argv$[0]": can't send a directory"
		goto Exit
	endif

	AccMode = accRead
	gosub CheckAccess
	if not accOK then 
		print argv$[0]": can't access " AccFile$
		goto Exit
	endif

	& getinfo ADM_PATH + ID$[uName] + "/mailstop", i$
	mailStop% = i$ > ""

	gosub MakeFullPath
	AccFile$ = i$

	if Subject$ = "" then
		& pos right$ (AccFile$,"/"),p
		Subject$ = chr$(34) + mid$ (AccFile$,p + 1) + chr$(34) \
			+ " file"
	endif

	a$ = ""
	for i = 2 to nargc - 1
		& pos (nargv$[i], "!"), bang
		& pos (nargv$[i], "@"), atSign
		& pos (nargv$[i], "%"), percentSign
		if (bang or atSign or percentSign) and mailStop% then
			print argv$[0] ": offsite mail delivery denied"
			goto Exit
		endif
	next

	contents$[BINARY]	= "Binary"
	wrapper$[BINARY]	= "PL-RCP1"

	contents$[ASCII]	= "ASCII"
	wrapper$[ASCII]		= "None"

	gosub UniqueName
	
	if not quiet then
		print argv$[0]": sending " RealName$ " to ";
		gosub ShowTo
	endif

	f$ = SPOOL_MAIL_PATH + msgID$

	fOpen f$
	fWrite f$
		gosub MakeFromTime
		print "From " from$ " " fromTime$
		print "Date: " dateTime$
		print "From: " from$
		print "To: "; : gosub ShowTo
		print "Subject: " Subject$
		print "X-Mailer: " VERSION
		if mode = BINARY then
			print "X-Content: " contents$[mode]
			print "X-Content-Type: " wrapper$[mode]
		endif
		print 

		if mode = BINARY then
			print "I sent you " chr$(34) RealName$ chr$(34) \
				".  Look for it in your area."
			print "^J---- Remote CoPy ----"
			print AccFile$
			for i = 1 to len(info$)
				& right$(str$(asc(mid$(info$,i))),3),i$
				print i$;
			next 
			print 
		endif
	fClose
	fFre
	& add(AccFile$ to f$)
	if mode = BINARY then
		& getinfo f$,i$
		& mid$ (i$,5) = chr$(6)
		& setinfo f$,i$
	endif
goto Exit


ShowTo:
	for i = 2 to nargc - 1
		print nargv$[i];
		if i = nargc - 1 then
			print
		else
			print ", ";
		endif
	next
return



MakeFullPath:
	i$ = AccFile$
	if asc(i$) < > 47 then 
		fPrefix
		& get i$
		i$ = i$ + AccFile$
	endif
	& lcase(i$)
return 




' ====================
  MakeFromTime:
' ====================
	& time(t$)
	fromTime$ = left$ (t$,3) + mid$ (t$,8,5) + mid$ (t$,6,3) + \
		right$ (t$,8) + " 19" + mid$ (t$,13,2)
	dateTime$ = left$(t$,5) + str$(val(mid$(t$,6))) + \
		 mid$(t$,8) + " " + Sysinfo$[plZone]
return

' ====================
  UniqueName:
' ====================
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
	j = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + \
		val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),a$
	msgID$ = chr$ (64 + i / 2) + chr$ (48 + j + 7 * (j > 9)) + a$
	& lcase (msgID$)
	if msgID$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = msgID$
	msgID$ = msgID$ + seq$
return


#include <proline/proline.lib>
#include <proline/access.lib>
#include <proline/getopt.lib>
