'=========================================================================
'                               M K N U L L
'
'                             by Dean K. Fick
'=========================================================================
'
' History:
'
' When    Who Ver   What
' ======= === ===== ======================================================
' 13aug91 dkf 1.0   Added option to allow making null files for sites
'                   given in shell arguments (instead of only those
'                   specified in resource file).
' 08dec91 dkf 1.1   Added option to allow making null files for ALL connected
'                   sites without specifying them individually -- triggered
'                   when first argument is "-a".
' 06jun92 dkf 1.2   Integrated getopt.lib.  Added -f option
'                   which makes a null file for a site or sites only if
'                   there are files already queued for transfer.
'=========================================================================

#define	IDENT_PROG "mknull"
#define	IDENT_VERS "1.2"
#define	IDENT_DATE "14jun92"
#define	IDENT_NAME "Dean_Fick"

#include <proline/proline.h>

#define MknullVers            IDENT_VERS " " IDENT_DATE
#define StandardRsrcName      "mknull.rsrc"
#define MaxFiles              300
#define MaxRsrcLines          100
#define TotalSites            100
#define EndOfData             5      'errcode for "end of data"
#define Century               20     'what century this is (for printing
                                     'dates
#define SubDirType            15     'ProDOS subdirectory file type

#define MakeHeader(string1, string2) \
        FromInfo$ = string1 : ToInfo$ = string2 : gosub _MakeHeader


' ****************************************************************
' **
' **  Initialize, check shell arguments and run subroutines as needed.
' **
' **
' **
     gosub AppInit
     if not SuperUser then
          print argv$[0]": can't run"
          goto ExitError
     endif
     gosub GetArgs

     if argc > 2 then
          if AllSites and not onlyQueuedSites
               print argv$[0]": can't use sitenames with -a option"
               goto ExitError
          endif
     endif

     if argc = 1 then
          gosub Dimension_Arrays
          gosub Read_Rsrc_File
          gosub Make_Nulls
          goto Exit
     endif

     if argc = 2 and AllSites then
          gosub Dimension_Arrays
          gosub Get_SiteNames
          gosub Make_Nulls
          goto Exit
     endif

     if argc = 2 and onlyQueuedSites then
          gosub Dimension_Arrays
          gosub Read_Rsrc_File
          gosub Make_Nulls
          goto Exit
     endif

     if AllSites and onlyQueuedSites then
          gosub Dimension_Arrays
          gosub Get_SiteNames
          gosub Make_Nulls
          goto Exit
     endif

     if onlyQueuedSites and nargc > 1 then
          gosub Dimension_Arrays
          gosub Make_Nulls
          goto Exit
     endif

     if argc > 1 and ((not AllSites) and (not onlyQueuedSites)) then
          gosub Dimension_Arrays
          gosub Make_Nulls
          goto Exit
     endif


' ****************************************************************
' **
' ** Get shell arguments via getopt
' **
' **

GetArgs:
     optchar$ = ""
     options$ = "af"
     repeat
          gosub getopt
          if optchar$ = "a" then AllSites= True
          if optchar$ = "f" then onlyQueuedSites = True
          if optchar$ = "?" then goto ExitError
     until optchar$ = ""
return

' ****************************************************************
' **
' ** Dimension Arrays
' **
' **
' **

Dimension_Arrays:

         dim SiteName$[TotalSites], DummyArray$[1], FileArray$[MaxFiles],\
         BadPrefix$[3], Prefix$[3]

         return

' ****************************************************************
' **
' ** Figure out how many sites there are in $/mdss, and put those
' ** subdirectory names found in $/mdss in the SiteName$[] array.
' ** (Used only when -a arg exists)
' **

Get_SiteNames:

          MDSSdir$ = MDSS_PATH

          & files (MDSSdir$, SiteName$, SubDirType), CountofSites,\
          ActualFiles

          for Karen = 1 to CountofSites
               & lcase (SiteName$[Karen])
          next

          return

' ****************************************************************
' **
' ** Open the mknull resource file and read each line into a
' ** SiteName$[] array element.
' **
' **

Read_Rsrc_File:

     RsrcFile$ = RSRC_PATH + StandardRsrcName

     & getinfo RsrcFile$, Info$
     if Info$ = "" then
          pop
          print argv$[0]": "RsrcFile$" not found"
          goto ExitError
     endif

     fOpen RsrcFile$
     fRead RsrcFile$

     onerr goto TrapEndOfRsrc

     for Counter = 1 to MaxRsrcLines

GetRsrcLine:

          & get SiteName$[Counter]
          & lcase (SiteName$[Counter])
          & spc (SiteName$[Counter]), SiteName$[Counter]
          if len (SiteName$[Counter]) < 2 then goto GetRsrcLine

     next


' ****************************************************************
' **
' ** Sort the SiteName$[] array elements.  Define several prefixes
' ** for evaluating the resource file lines in the SiteName$[]
' ** array.
' **

Make_Nulls:

          onerr goto HandleError

          if not AllSites and nargc > 1 then
                for Hannah = 1 to nargc - 1
                        SiteName$[Hannah] = nargv$[Hannah]
                next
          endif

          if Counter then
                & sort (SiteName$, Counter - 1)
          else
               if AllSites then
                    & sort (SiteName$, CountofSites)
               else
                    & sort (SiteName$, nargc -1)
               endif
          endif

          BadPrefix$[1] = "pro."
          BadPrefix$[2] = "gnh."
          BadPrefix$[3] = "rti."

          Prefix$[1] = "pro-"
          Prefix$[2] = "gnh-"
          Prefix$[3] = "rti-"


' ****************************************************************
' **
' ** Change site names in the SiteName$[] array that are defined as
' ** legal ProDOS names into true site names.  Example: change
' ** "pro.carolina" into "pro-carolina".
' **

          if AllSites then
               Limit = CountofSites
          else
               if nargc > 1 then
                    Limit = nargc - 1
               else
                    Limit = Counter - 1
               endif
          endif


          for Counter2 = 1 to Limit

               UnixNameFound = False

               for Counter3 = 1 to 3

                    & pos (SiteName$[Counter2], BadPrefix$[Counter3]),\
                    Position

                    if Position then

                         RightLineLength = len (SiteName$[Counter2]) \
                         - Position - 3

                         RightLine$ = right$ (SiteName$[Counter2], \
                         RightLineLength)

                         SiteName$[Counter2] = left$ (BadPrefix$[Counter3],\
                         3) + "-" + RightLine$

                    endif


' ****************************************************************
' **
' ** Look at each resource file line in SiteName$[] searching for
' ** Unixnames-style site names.  Convert a Unixname into a legal
' ** ProDOS name (exchange the "-" for a ".") for use in scanning
' ** directories in the $/mdss/* series.

                    & pos (SiteName$[Counter2], Prefix$[Counter3]), Position

                    if Position then

                         UnixNameFound = True

                         RightLineLength = len (SiteName$[Counter2]) \
                         - Position - 3

                         RightLine$ = right$ (SiteName$[Counter2], \
                         RightLineLength)

                         LegalName$ = left$ (Prefix$[counter3], 3) +"."\
                         + RightLine$

                    endif

               next

               if not UnixNameFound then LegalName$ = SiteName$[Counter2]

               CurrentMDSSDir$ = MDSS_PATH + LegalName$

               & getinfo CurrentMDSSDir$, Info$

               if Info$ = "" then
                    print argv$[0]": skipping "SiteName$[Counter2]\
                    " (not a direct site)"
                    goto EndOfLoop
               endif

' ****************************************************************
' **
' ** Find out if a file named "a0" exists in the current MDSS dir.
' ** If so, skip to the next MDSS directory in the resource file.
' ** If not: see if there are any files at all in the current
' ** MDSS dir.  If so: rename one of them to "a0".  If not,
' ** create a null file called "a0".

               CurrentNullFile$ = MDSS_PATH + LegalName$ + "/a0"

               & getinfo CurrentNullFile$, Info$

               if Info$ <> "" then
                    print argv$[0]": null already exists for "\
                    SiteName$[Counter2]
                    goto EndOfLoop
               endif

               & files (CurrentMDSSDir$, DummyArray$), CountofFiles,\
               ActualFiles

               if not ActualFiles and onlyQueuedSites then
                    print argv$[0]": nothing queued for "SiteName$[Counter2]
                    goto EndofLoop
               endif

               if ActualFiles > MaxFiles then goto ForceNull

               print argv$[0]": setting null for "SiteName$[Counter2]

               if ActualFiles then
                    & files (CurrentMDSSDir$, FileArray$), CountofFiles
                    & sort (FileArray$, CountofFiles)
                    Counter4 = 0
                    repeat
                         Counter4 = Counter4 + 1
                         & pos (FileArray$[Counter4],"RNEWS"), Position
                         if Counter4 > CountofFiles then goto ForceNull
                    until not Position
                    OldFile$ = CurrentMDSSDir$ + "/" + FileArray$[Counter4]
                    fRename OldFile$","CurrentNullFile$
                    goto EndofLoop
               endif

ForceNull:
               MakeHeader ("root", "null")

EndOfLoop:
          next
          return


' ****************************************************************
' **
' ** Create a mail header whose name is given in CurrentNullFile$.
' **
' **
' **

_MakeHeader:
     & time (Timestring$)
     Day$ = left$ (Timestring$,3)
     Date$ = mid$ (Timestring$,6,2)
     Month$ = mid$ (Timestring$,9,3)
     Year$ = mid$ (Timestring$,13,2)
     Time$ = right$ (Timestring$,8)
     Hour$ = mid$ (Timestring$,16,2)
     Minute$ = mid$ (Timestring$,19,2)
     Second$ = right$ (Timestring$,2)

     fAppend CurrentNullFile$

     print "From "SysInfo$[plNode]"!"FromInfo$" "Day$" "Month$" "Date$" "\
     Time$" "Century - 1;Year$

     print "Date: "Day$", "Date$" "Month$" "Year$\
     " "Time$" "SysInfo$[plZone]

     print "Ppath: "SiteName$[Counter2]"!"ToInfo$

     print "From: "FromInfo$"@"SysInfo$[plNode] + SysInfo$[plDomain]\
     " (System Administrator)"

     print "To: "ToInfo$"@"SiteName$[Counter2]

     print "Subject: "

     print "X-Mailer: Mknull ("MknullVers")"CHR$(13)

     fClose CurrentNullFile$

     return


' ************************************************************ *****
' **
' ** Trap end of resource file and return to processing.  Exit if
' ** error is not "end of data."
' **

TrapEndOfRsrc:
     & onerr errCode, errLine
     fClose
     if errCode = EndOfData then return
     print "Err:"errCode"@"errLine
     pop
     goto ExitError


' *****************************************************************
' **
' ** Standard ProLine library routines
' **
' **
' **

#include <proline/getopt.lib>
#include <proline/proline.lib>
