'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'	mdssclean.b	Cleans out MDSS directories
'			(C)opyright 1994 Morgan Davis Group
'
'	Usage: mdssclean [ options ] [ site... ]
'
'	-d		okay to delete files
'	-a days		specifies the age of news and mail
'	-r		act on rnews bundles only
'	-i		read invisible mdss directories as well
'	-l lines	number of lines included in bounce
'	-?		print usage info
'
' Date	   Who	Ver	What
' -------------------------------------------------------------------------
' 11feb92  dzd		Daniel Z. Davidson started mdssclean.
'  8jul92  dzd	1.0	First release with ProLine 2.0
' 18aug93  dig	1.1b0	Updated 1.0 source from decompiled 1.1 executable
' 10sep93  mwd	2.0	Major rewrite
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

#define	IDENT_PROG "mdssclean"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "6feb94"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>


        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ' Function interfaces
        '
        '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define CleanUp()	gosub _CleanUp
#define IsLeapYear(y)	not mod(y,4) and mod(y,100) or not mod(y,400)
#define MonthDays(m)	val(mid$(DaysInMonth$, m * 2, 2))
#define GetJDate(m,d,y) val(mid$(Julian$,m*3,3))+d+(m>2 and IsLeapYear(y))
#define Today() 	gosub _Today
#define Ckage() 	gosub _Ckage
#define MakeUniqueName	gosub _MakeUniqueName
#define Bounce(str)	letter$ = str : gosub _Bounce

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' Some Helpful Constants for this program
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define MAX_SITES	100
#define MAX_MSGS	500
#define EPOC		1970
#define EXPECTED	10	   ' decimal # of FILE LOCKED error
#define BIN		6

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' Mail header fields we care about
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#define	STD_FIELDS	"1:Errors-To;2:Sender;3:Ppath"
#define SENDER_COUNT	2
#define	PPATH_FIELD	3
#define	FIELD_COUNT	3

	Julian$		= "??000031059090120151181212243273304334"
	DaysInMonth$	= "?312831303130313130313031"
	Months$		= "?anebarprayunulugepctovec"

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' The start of the main program
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				     
	gosub AppInit
	if not SuperUser then
		&print argv$[0]": cannot execute"
		goto ExitError
	endif

	fields$		= STD_FIELDS

	deleteOK	= FALSE
	newsonly	= FALSE
	visMode%	= visible_only

	' 
	' Load default settings from resource file
	'
	temp$ = RSRC_PATH + "mdssclean.rsrc"
	&getinfo temp$, i$
	if i$ > "" then
		fFre
		fOpen temp$
		fRead temp$
		input maxage, maxlines, numnames
		dim nobounce$[numnames]
		for x = 1 to numnames
			&get nobounce$[x]
			&spc (nobounce$[x]), nobounce$[x]
		next x
		fClose
	else
		maxage		= 10		' Defaults
		maxlines	= -1
		numnames	= 4
		dim nobounce$[numnames]
		nobounce$[1]	= "mdss"
		nobounce$[2]	= "uucp"
		nobounce$[3]	= "postmaster"
		nobounce$[4]	= "mailer-daemon"
	endif

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' Parse arguments
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	options$ = "dira:l:?"
	optchar$ = ""
	repeat
		gosub getopt
		if optchar$ = "d" then deleteOK = TRUE
		if optchar$ = "i" then visMode% = vis_and_invis
		if optchar$ = "r" then newsonly = TRUE
		if optchar$ = "a" then maxage	= val(optarg$)
		if optchar$ = "l" then maxlines	= val(optarg$)
		if optchar$ = "?" then
			print "Usage: " argv$[0] \
				" [ -dir ] [ -l lines ] [ -a age ] [ site... ]"
			goto ExitError
		endif
	until optchar$ = ""
	fFre

	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	' If after processing options there are no arguments left,
	' load nargv$[] with list of files from $/mdss.
	'
	'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	if nargc = 1 then
		temp$ = MDSS_PATH
		&files(temp$, nargv$, 15, visMode%), temp, temp
		&erase(nargv$)
		dim nargv$[temp]
		&files(temp$, nargv$, 15, visMode%), nargc
		userSupplied% = FALSE
	else
		nargc = nargc - 1
		userSupplied% = TRUE
	endif

	if not nargc then
		&print argv$[0] ": not sites to cleanup"
		goto ExitError
	endif
	
	Today() 		' get today's date and time

	for usite = 1 to nargc
		mdssSite$ = nargv$[usite]
		&lcase(mdssSite$)
		if userSupplied% then
			i$ = mdssSite$
			repeat
				&pos(i$, "-"), temp
				if temp then &mid$ (i$,temp) = "."
			until not temp
			mdssPath$ = MDSS_PATH + i$
			&getinfo mdssPath$, temp$
			if temp$ = "" then
				&print argv$[0]": " mdssPath$ " not found"
			else
				CleanUp()
			endif
		else
			mdssPath$ = MDSS_PATH + mdssSite$
			repeat
				& pos (mdssSite$, "."), temp
				if temp then &mid$ (mdssSite$,temp) = "-"
			until not temp
			CleanUp()
		endif
	next usite
goto Exit


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' CleanUp is the part that does the dirty work,  Pass it
' a sitename that has been ProDos-ized and it cleans things up.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
_CleanUp:
	print mdssSite$ ": ";
	fFre
	msg$[0] = ""
	&erase(msg$)
	dim msg$[1]
	&files (mdssPath$, msg$,,vis_and_invis), number, number
	print number
	if number then
		&erase(msg$)
		dim msg$[number]
		&files (mdssPath$, msg$,,vis_and_invis), number
		for counter = 1 to number
			name$ = msg$[counter]
			&lcase(name$)
			if not newsonly then
				gosub checkFile
			else
				if name$ = "finder.data" or left$(name$, 5) = "rnews" then
					gosub checkFile
				endif
			endif
		next
	endif

	' now before returning, try to compact the mdss directory
	' for the current site.  How?  Try to delete it, and remake it
	' if possible.	If the directory is not empty, it will create a
	' ProDOS File Locked err, so we trap that error number.
	' If there is no error, put the normal error trapping back.

	if deleteOK then
		&getinfo mdssPath$, temp$
		blocks = asc(mid$(temp$,9)) + asc(mid$(temp$,10)) * 256
		if blocks > 1 then
			onerr goto myerr
			fDelete mdssPath$
			fCreate mdssPath$
			&setinfo mdssPath$, temp$
			onerr goto HandleError
			&print "^I(blocks gained: " blocks - 1 ")"
		endif
	endif
return

myerr:
	&onerr errCode, errLine
	onerr goto HandleError
	if errCode <> EXPECTED then
		&print argv$[0] ": error " errCode " at " errLine
		goto ExitError
	endif
return


				
checkFile:
	&print "^I" name$ " -> ";
	file$ = mdssPath$ + "/" + name$
	if name$ = "finder.data" then
		if deleteOK then
			fDelete file$
			&print "deleted"
		endif
	else
		&getinfo file$, info$
		Ckage()
		if not delta then
			&print "new";
		else
			&print delta left$(" days", 5 - (delta = 1));
		endif

		if deleteOK and (delta >= maxage) then
			if left$(name$, 5) <> "rnews" then
				Bounce(file$)
				&print ", bounced";
			endif
			fDelete file$
			&print ", deleted";
		endif
		&print
	endif
return


_Ckage:
	' Pull the info we want from info$
	CDateL = asc(mid$(info$,15,1))
	CDateH = asc(mid$(info$,16,1))

	'Now convert it from bit fields to some usable numbers
	FDay   = CDateL - int(CDateL / 32) *32
	FYear  = int( CDateH /2)
	FMonth = (CDateH - FYear *2)  * 8 + int( CDateL / 32)

	'compare file creation date with current date
	date1 = GetJDate(CMonth, CDay, CYear) \
		+ int((CYear - Epoc) * 365.25)
	date2 = GetJDate(FMonth, FDay, FYear) \
		+ int((FYear - Epoc) * 365.25)
	delta = abs(date1 - date2)
return


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
'     Get the current Date info for later comparison
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
_Today:
	&time	(theTime$)
	CDay	= val(mid$(theTime$,6, 2))
	CYear	= val(mid$(theTime$,12,3))
	&pos	(Months$, mid$(theTime$,10,2)), CMonth
	CMonth	= CMonth / 2
return

 
 '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ' Take a message letter$, and return it to the sender by
 ' opening it up and reading the From: line to get the 
 ' sender's name.
 '
 '~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
_Bounce:
	fFre
	hdr$[0] = ""
	&erase(hdr$)
	dim hdr$[FIELD_COUNT]

	type = asc(mid$(info$,5))
	fOpen letter$ ",T" type
	fRead letter$
	& get from$		' Snatch the From return path first
	repeat			' Then loop through header, collecting fields
		& get a$
		& pos (a$, ":"), p
		if p then
			i$ = left$(a$, p - 1)
			&spc(mid$(a$, p + 1)), j$
			&pos(fields$, ":" + i$ + ";"), p
			if p then hdr$[val(mid$(fields$, p - 1, 1))] = j$
		endif
	until a$ = ""
	fClose

	sender$ = ""
	for i = 1 to SENDER_COUNT
		if hdr$[i] > "" then
			sender$ = hdr$[i]
			i = SENDER_COUNT
		endif
	next

	if sender$ = "" then
		& pos (7, from$, " "), p
		sender$ = mid$(from$, 6, p - 6)
	endif

	to$ = sender$	
	gosub StripMailAddress
	sender$ = to$
	gosub GetUserFromAddress
	& lcase(user$)
        
	bounce% = TRUE
	for x = 1 to numnames
		if nobounce$[x] = user$ then
			bounce% = FALSE
			x = numnames
		endif
	next

	if not bounce% then return

	ppath$ = hdr$[PPATH_FIELD]
	job$ = ppath$ + "  (" + str$(delta) + left$(" days", 5 - (delta = 1)) \
		+ " ago)"

        if type = BIN then
     		Subject$ = "Failed RCP"
         	gosub StartNewMessage
		print "Remote file copy failed; job cancelled."
		stopOn$ = "---- Remote CoPy ----"
	else
        	Subject$ = "Returned Mail from MDSS"
        	gosub StartNewMessage
        	print "The message is undeliverable and is being returned."
		stopOn$ = ""        	
	endif

	print
	print "^ISincerely,"
	print
	print "^Imdss@" SITE_NAME
	print
	&left$("",45,$23), i$
	print i$
	& mid$(i$, 6) = " Message Follows: "
	print i$

	if maxlines < 0 and stopOn$ = "" then
		fClose
	      	&add (letter$ to theFile$)
	      	return
	endif

        fOpen letter$ ",T" type
	onerr goto fragEOF
	repeat
		fRead letter$
		& get temp$
		fWrite theFile$
		print temp$
	until temp$ = ""
	written = 0
        repeat
        	fRead letter$
                &get temp$
                if stopOn$ > "" then
                	&pos(temp$, stopOn$), temp
                	if temp then
                		error(5)
                	endif
                endif
                fWrite theFile$
                print temp$
                written = written + (maxlines > 0)
      	until written > maxlines
	error(5)
	fragEOF:     	
	& onerr errCode, errLine
	onerr goto HandleError

	if stopOn$ > "" or (written > maxlines) then
		fWrite theFile$
		& mid$(i$, 6) = " End Message Fragment "
		print i$
		&left$("",45,$23), i$
		print i$
	endif
        fClose
return


StartNewMessage:
     	MakeUniqueName
        theFile$ = SPOOL_MAIL_PATH + msgID$
        fAppend theFile$
        print "From mdss " left$(theTime$,3) mid$(theTime$,8,5) \
        	mid$(theTime$,6,3) right$(theTime$,8) " 19" mid$(theTime$,13,3)
        print "Date: " left$(theTime$,5) val(mid$(theTime$,6)) \
               mid$(theTime$,8) " " SysInfo$[plZone]
        print "From: mdss (Mail Delivery SubSystem)"
        print "To: " sender$
        print "Subject: " Subject$
        print
	print "There has been no contact with '" mdssSite$ "' since you mailed this job:"
	print
	print "^I" job$
	print
return


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' This routine is entered with a field from the header.
' The field in to$ will be in some address notation:
'	jdoe@site.domain
'	John Doe <jdoe@site.domain>
'	jdoe@site.domain (John Doe)
' Strip out the address and return in to$.
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
StripMailAddress:
	& pos (to$, "<"), p
	if p then
		&pos right$(to$, ">"), q
		&spc(mid$(to$,p + 1, q - p - 1)), to$
	else
		& pos (to$, "("), p
		if p then &spc(left$(to$, p - 1)), to$
	endif
return


    
' ==============================
  GetUserFromAddress:
'
' On entry:	to$ = e-mail address
'
' Returns:	user$ = recipient
'		to$ = munged
' ==============================

	' Replace all %'s with @'s
	repeat
		& pos (to$, "%"), p
		if p then & mid$(to$,p) = "@"
	until not p

	' Check for an @ address format.  If found, convert to bang.
	' Reverse build the path if there are multiple @'s.
	user$ = ""
	repeat
		& pos right$ (to$,"@"), p
		if p then
			user$ = user$ + mid$ (to$, p + 1) + "!"
			to$ = left$(to$, p - 1)
		endif
	until not p
	user$ = user$ + to$
	
	' Now determine if path contains any addresses at all!
	
	& pos right$ (user$, "!"), p
	if p then user$ = mid$(user$, p + 1)
return		


'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Build a filename (theFile$) from theTime$ in the format:
'
'	ddSSSSS
'
' Where dd is an alphabetic variant of the combined month and date
' values, and SSSSS are the number of seconds that have elapsed since
' midnight.
'
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
_MakeUniqueName:
	& time(t$)
	& pos ("?anebarprayunulugepctovec", mid$ (t$,10,2)),i
	j = val (mid$ (t$,6))
	& right$ (str$ (val (mid$ (t$,16)) * 3600 + \
		val (mid$ (t$,19)) * 60 + val (right$ (t$,2))),5,48),a$
	msgID$ = chr$ (64 + i / 2) + chr$ (48 + j + 7 * (j > 9)) + a$
	& lcase (msgID$)
	if msgID$ = lastMsgID$ then
		seq$ = "." + str$(fnSeq)
		fnSeq = fnSeq + 1
	else
		fnSeq = 0
		seq$ = ""
	endif
	lastMsgID$ = msgID$
	msgID$ = msgID$ + seq$
return


#include <proline/proline.lib>
#include <proline/getopt.lib>
