'| ARBITRON v1.1
'| =============
'| Second Module
'|
'| 07-22-93 18:51
'| by Doug Granzow

#define	IDENT_PROG "arbitron2"
#define	IDENT_VERS "1.1"
#define	IDENT_DATE "22jul93"
#define	IDENT_NAME "Doug_Granzow"

#include <proline/proline.h>		' plus modemworks.h
#define parse(string)	x$=string : gosub _Parse
#define find(string)	group$=string : x=1 : gosub _Find
#define getgroupname(string)	i$=string : gosub _GetGroupName

'|
'|
'| Startup

  gosub AppInit
  if argc < 3  or argc > 4 then
    print "usage: " argv$[0] " [-a] [-v] infile outfile"
    goto Exit
  endif
  option$=""
  workfile$ = argv$[1]
  outfile$ = argv$[2]
  numgroups = 0
  newsys$ = ETC_PATH + "newsys"

  if argc = 4 then
    if argv$[1] <> "-a" and argv$[1] <> "-v" then
      print "usage: " argv$[0] " [-a] [-v] infile outfile"
      goto Exit
    endif
    option$ = right$(argv$[1],1)
    workfile$ = argv$[2]
    outfile$ = argv$[3]
  endif

  fOpen newsys$
  fRead newsys$
  onerr goto newsyseof

  print argv$[0]": counting newsgroups"
CountGroups:
  &get i$
  getgroupname(i$)
  if groupname$ <> "" then numgroups = numgroups + 1
  goto CountGroups

newsyseof:
  &onerr errCode, errLine
  if errCode <> 5 then goto HandleError
  fClose
  onerr goto HandleError

  dim newsgroup$[numgroups], posts[numgroups]
  fOpen workfile$
  print argv$[0]": scanning "workfile$
  gosub ReadGroups
  onerr goto eoferror
  fRead workfile$

InputLoop:
  &get x$
  parse(x$)
  find(group$)
  posts[x] = posts[x] + count
  goto InputLoop

eoferror:
  &onerr errCode, errLine
  if errCode <> 5 then goto HandleError
  fClose
  onerr goto HandleError

  if option$ <> "" then
    print argv$[0]": sorting"
    for x = 1 to numgroups
      if option$ = "a" then newsgroup$[x] = newsgroup$[x] +"#"+ str$(posts[x])
      if option$ = "v" then
        newsgroup$[x] = right$("0000"+str$(posts[x]),5) + "#" + newsgroup$[x]
      endif
    next x
    &srt(newsgroup$, numgroups)
    for x = 1 to numgroups
      &pos (newsgroup$[x], "#"), y
      if option$ = "a" then
        posts[x] = val(mid$(newsgroup$[x], y+1))
        newsgroup$[x] = left$(newsgroup$[x], y-1)
      else
        posts[x] = val(newsgroup$[x])
        newsgroup$[x] = mid$(newsgroup$[x], y+1)
      endif
    next x
  endif

  print argv$[0]": writing to "outfile$
  &/ outfile$, x$
  if x$ then fDelete outfile$
  fCreate outfile$",TTXT"
  fOpen outfile$
  fWrite outfile$
  print
  print "# of messages received in each newsgroup over the past 7 days:"
  print
  print "Count   Newsgroup name"
  print
  for x = 1 to numgroups
    print posts[x] chr$(9) newsgroup$[x]
  next x
  fClose  
  goto Exit

'|
'|
'| Subroutines

ReadGroups:
  fOpen newsys$
  fRead newsys$
  y = 1
  onerr goto GroupEof
GroupLoop:
  &get i$
  getgroupname(i$)
  if groupname$ <> "" then
    newsgroup$[y] = groupname$
    y = y + 1
  endif
  if y <= numgroups then goto GroupLoop
  goto EndGroupLoop
GroupEof:
  &onerr errCode, errLine
  if errCode  <> 5 then goto HandleError
EndGroupLoop:
  fClose newsys$
  return

_Parse:
  &pos(x$,"batched"),x
  y$ = mid$(x$,x+8)
  count = val(y$)
  &pos(y$," "),x
  group$ = mid$(y$,x+1)  
  return

_Find:						' X=1 upon entry
  if group$ = newsgroup$[x] then return
  x = x + 1
  if x > numgroups then
    x = 0
    return
  endif
  goto _Find

_GetGroupName:	' Checks i$ for newsgroup name, and places it in groupname$
  groupname$ = ""
  &pos(i$,"."),x
  if x = 0 then return		' All newsgroups have dots in them
				' (this test eliminates blank lines)
				' [if i$=""] might fail if i$=" "
  &pos(i$,"#"),x
  if x then return		' # indicates a comment line
  &pos(i$,"@"),x
  if x then return		' @ indicates a path, not a newsgroup
  &pos(i$,"!"),x
  if x then return		' ! indicates a path, not a newsgroup
  &pos(i$,"="),x
  if x then i$=left$(i$,x-1)
  groupname$ = i$
  return

#include <proline/proline.lib>
