' **********************************************************************
' **
' **    babyBACKUP.b  - Simple File Backup/Restore program
' **                    (C)opyright 1994 Morgan Davis Group
' **
' **    History:
' **
' **      18dec89 mwd - Creation
' **      10jan90 mwd - Added Fweep to end of backup routine
' **      14feb90 mwd - Reworked macro calls
' **      15jan91 mwd - Added automatic support for restore target
' **      21jul92 mwd - Fixed OS bug after copying a disk-worth
' **	  17mar94 mwd - Added VDIR$ to pass disk name
' **
' **********************************************************************

#define	VERSION	"babyBACKUP 3.0"

rem "@(#) " VERSION " 30mar94 Morgan_Davis @(#)"


#reserve EXIT$, DISK$, REST$, VDIR$, OS%

#include <fileio.h>
#include <romcall.h>
#include <appleio.h>
#include <amperworks.h>

#define MAXFILES	1000

#define GotoXY(x, y)		htab x : vtab y
#define PrintAt(x, y, string)	GotoXY(x, y) : print string
#define NewScreen(str)		title$ = str : gosub _newscreen
#define Error(str)		errMsg$ = str : goto _errorRtn
#define Message(str)		errMsg$ = str : gosub _messageRtn

	text
	home
	print chr$(21)
	poke _INBUF, 0
	onerr goto Load_AmperWorks
	&pop
	goto SetUp

Load_AmperWorks:
	print "Requires AmperWorks"
	end

SetUp:
	poke _ERRFLG, 0
	dim file$[MAXFILES], size%[MAXFILES]

	if VDIR$ = "" then VDIR$ = "/BB."

	consecutive% = 0
	
	if REST$ > "" then
		gosub Restore_Files
		goto Quit_Program
	endif
        
' ==============================
' Main Menu
' ==============================

MainMenu:
	&pop
	NewScreen (VERSION " Main Menu")
	PrintAt (11, 10, "<Q>  Quit")
	PrintAt (11, 12, "<B>  Backup Files")
	PrintAt (11, 14, "<R>  Restore Files")
	PrintAt (1, 23, "Selection? ");
	get a$
	htab 1
	call _CLREOL
	&ucase (a$)
	&pos ("BRQ", a$), i

	diskNum = 0
	copied = 0

	on i gosub Backup_Files, Restore_Files, Quit_Program
goto MainMenu

Quit_Program:
	if EXIT$ > "" then
		repeat
			&GETINFO EXIT$, info$
			if info$ = "" then
				Message ("Insert " + DISK$)
			endif
		until info$ > ""
		home
		fLaunch EXIT$
	endif
	home
end

_errorRtn:
	fClose
	gosub _messageRtn
goto MainMenu

_messageRtn:
	GotoXY(1, 23)
	call _CLREOP
	print errMsg$ " ";
	gosub Fweep
	get a$
	GotoXY(1, 23)
	call _CLREOP
return	      

_newscreen:
	home
	htab 21 - len(title$) / 2
	print title$
	&str$ (40, $3d)
	vtab 22
	&str$ (40, $2d)
return

' ==============================
' Backup Files
' ==============================

Backup_Files:
	BackupFlag = TRUE
	NewScreen ("Backup Files")
	PrintAt (1, 23, "Backup From: /");
	&read (64), startDir$
	vtab 23
	call _CLREOP
	&spc (startDir$, $2f), startDir$
	&ucase (startDir$)
	startDir$ = "/" + startDir$ + "/"
	&GETINFO startDir$, info$
	if info$ = "" then
		Error (startDir$ + " not found!")
	endif

	notBlank = 1
	mustScan = TRUE
        
	repeat
		gosub GetNextDisk
		targetDir$ = diskName$
		filesThisDisk = 0
		totalBlocks = asc(mid$(info$,6)) + asc(mid$(info$,7)) * 256
		blocksUsed  = asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256
		if mustScan then gosub ScanForFiles
        
		repeat
			gosub GetNextFile
			if file$ > "" then
				gosub CommonStats
				PrintAt (5, 13,"Free: " totalBlocks - blocksUsed);
				call _CLREOL
				onerr goto backupErr

			   backAgain:
				fFre
				&copy (startDir$ + file$ to target$)
				blocksUsed = blocksUsed + size%[qIndex]
				file$[qIndex] = ""
				size%[qIndex] = 0
				copied = copied + 1
				filesThisDisk = filesThisDisk + 1
				if filesThisDisk / 12 = int(filesThisDisk / 12) then
					blocksUsed = blocksUsed + 1
				endif
				goto noBackErr

			   backupErr:
				&onerr err, line
				if err = 9 then
					blocksUsed = totalBlocks
					goto noBackErr
				endif
				gosub PathMaker
				fCreate left$(path$, p)
				blocksUsed = blocksUsed + 1
				goto backAgain

			  noBackErr:
				poke _ERRFLG, 0 		        
			endif
		until copied = fileCount or blocksUsed >= totalBlocks
		fVerify diskName$
	until copied = fileCount
	PrintAt (1, 23, "Successful Backup ");
	gosub Fweep
	get a$
return

PathMaker:
	if err <> 6 and err <> 19
		Error ("Error #" + str$(err) + " at " + str$(line))
	endif
	q = p + 1
	&pos (q, path$, "/"),p
	if not p then
		Error ("Error at pathmaker")
	endif
return

CommonStats:
	target$ = targetDir$ + file$
	&PREVDIR target$, path$
	path$ = path$ + "/"
	PrintAt (5, 9, "Path: " mid$(path$, len(targetDir$) + 1)); : call _CLREOL
	PrintAt (5, 11, "File: " mid$(target$, len(path$) + 1)); : call _CLREOL
	PrintAt (10, 19, "Files Remaining: " fileCount - copied - 1 " ")
return


GetNextDisk:
	fFre
	diskNum = diskNum + 1
	diskName$ = VDIR$ + str$(diskNum) + "/"
		        
	repeat
		&GETINFO diskName$, info$
		if info$ = "" then
			if consecutive% > 1 then
				quit = TRUE
				return
			endif
			consecutive% = 0
			& spc(diskName$, $2F), a$
			PrintAt (1, 23, "Insert next disk: " a$)
			print "Press RETURN (or ESC if no more disks) ";
			gosub Fweep
			get a$
			GotoXY (1, 23)
			call _CLREOP
			if a$ = chr$(27) then
				quit = TRUE
				return
			endif
		else
			consecutive% = consecutive% + 1
		endif
	until info$ > ""
	PrintAt (3, 7, "Source: " diskName$)
	PrintAt (3, 13, "Target: " targetDir$)
return


GetNextFile:
	file$ = ""
	while file$[notBlank] = "" and notBlank < MAXFILES
		notBlank = notBlank + 1
	wend
	qIndex = notBlank
	loopThru = FALSE
    findAgain:
	repeat
		if file$[qIndex] > "" and \
			(size%[qIndex] + blocksUsed) < (totalBlocks + 5) then
			file$ = file$[qIndex]
		else
			qIndex = qIndex + 1
		endif
	until file$ > "" or (qIndex >= pIndex)
	if file$ = "" and not loopThru then
		&GETINFO diskName$, info$
		blocksUsed = asc(mid$(info$,9)) + asc(mid$(info$,10)) * 256
		loopThru = TRUE
		goto findAgain
	else
		if file$ = "" then blocksUsed = totalBlocks
	endif
return

ScanForFiles:
	mustScan = FALSE
	GotoXY (1, 19)
	call _CLREOL
	qIndex = 0
	pIndex = 1
	fileCount = 0
	totalSize = 0
	file$[0] = ""

	repeat
		fOpen startDir$ file$[qIndex]",tdir"
		fRead startDir$ file$[qIndex]
		&get : &get : &get
		piCopy = pIndex
		repeat
			input a$
			if a$ > "" then
				type$ = mid$(a$,18,3)
				if type$ <> "BAD" then
					size%[pIndex] = val(mid$ (a$,22,7))
					if BackupFlag and size%[pIndex] > totalBlocks then
						Error ("A file is larger than the target disk.")
					endif
					totalSize = totalSize + size%[pIndex]
					&spc(mid$(a$,2,15)),a$
					file$[pIndex] = file$[qIndex] + a$
					if type$ = "DIR" then
						size%[pIndex] = 0
						file$[pIndex] = file$[pIndex] + "/"
					endif
					fileCount = fileCount + 1
					pIndex = pIndex + 1
					if pIndex > MAXFILES then
						Error ("Too many files.")
					endif
				endif
			endif
		until a$ = ""
		fClose
		if pIndex = piCopy then size%[qIndex] = 1

		' Search for the next directory to open
		' (size%[i] = 0 means a directory at file$[i])

		repeat
			qIndex = qIndex + 1
		until not size%[qIndex] or qIndex >= pIndex
		PrintAt (10, 19, "Counting Files: " fileCount);
		call _CLREOL
		if BackupFlag then
			PrintAt (5, 20, "Disks Needed: " \
				int((totalSize + fileCount) / (totalBlocks - blocksUsed)) \
				+ 1 " (" totalBlocks / 2 "K)")
		endif
	until qIndex >= pIndex
return

Restore_Files:
	BackupFlag = FALSE
	NewScreen ("Restoring Files")
	if REST$ = "" then
		PrintAt (1, 23, "Restore To: ");
		&read (64), targetDir$
	else
		targetDir$ = REST$
	endif
	vtab 23
	call _CLREOP
	&ucase (targetDir$)
	if right$(targetDir$, 1) <> "/" then targetDir$ = targetDir$ + "/"
	&GETINFO targetDir$, info$
	if info$ = "" then
		Error (targetDir$ + " not found!")
	endif
        
	quit = FALSE
	gosub GetNextDisk
	while not quit
		startDir$ = diskName$
		gosub ScanForFiles
		copied = 0
		for i = 1 to fileCount
			file$ = file$[i]
			gosub CommonStats
			onerr goto restErr

		  restAgain:
			if OS% or (file$ <> "PRODOS" and file$ <> "BASIC.SYSTEM") then
				fFre
				&copy (diskName$ + file$ to target$)
			endif
			copied = copied + 1
			file$[i] = ""
			fFre
			goto noRestErr

		  restErr:
			&onerr err, line
			gosub PathMaker
			fCreate left$(path$, p)
			goto restAgain

		  noRestErr:
			poke _ERRFLG, 0
		next
		gosub GetNextDisk
	wend
return
 
Fweep:
	& poke 768,162,37,160,4,44,48,192,138,32,168,252,136,208,246, \
		202,208,241,169,112,76,168,252
	call 768
return
