' *****************************************************************************
' ***
' ***	tc.b	Termcap Editor for ModemWorks 3.0 termcaps
' ***		(C)opyright 1994 Morgan Davis Group
' ***

#define	IDENT_PROG "tc"
#define	IDENT_VERS "1.0"
#define	IDENT_DATE "14jan92"
#define	IDENT_NAME "Morgan_Davis"

#include <basic.h>
#include <proline/proline.h>

#ifdef STAND_ALONE
 #define TCAPS	AppPrefix$ + "/Termcaps/"
#else
 #define TCAPS	SYS_PATH + "termcaps/"
#endif

#define	o_tchars	0	' offset to terminal characters
#define	o_leadin	128	' offset to leadin byte
#define	o_homerow	129	' offset to homerow
#define	o_cursoff	130	' offset to cursor x/y offsets

#define	termcapAddr	$300
#define	TCAPSIZE	131

#define	NUMFUNCS	29

#define	MENULEFT	40
#define	GRIDTOP		3
#define	GRIDLEFT	4
#define	STATUSX		50

#define	HEXOUT		$300
#define	INSTALL_HEXOUT	& poke HEXOUT, $a9, 0, $4c, $da, $fd

	MODELINE	= GRIDTOP + 16
	FUNCLINE	= MODELINE + 1

' ________________________________________
'
'	       TERMCAP EDITOR
' ________________________________________

	gosub AppInit

#ifdef STAND_ALONE
	& < AppPath$, AppPrefix$
	& < AppPrefix$, AppPrefix$
	& read "Termcap to edit: ", argv$[1]
	argc = argc + (argv$[1] > "")
	SuperUser = TRUE
#endif

	if not SuperUser then
		print argv$[0] ": can't execute"
		goto Exit
	endif

	dim tchars[128], func$[NUMFUNCS]
	hex$ = "0123456789ABCDEF"
	Arrows$ = "^H^U^K^J1352"
	movex[1] = -1 : movex[2] = 1 : movex[5] = -1 : movex[6] = 1
	movey[3] = -1 : movey[4] = 1 : movey[7] = -1 : movey[8] = 1
	Commands$ = "nwpsfalhcvx^Lq'#$"
	YN$[FALSE] = "N"
	YN$[TRUE]  = "Y"
	order$[TRUE] = "XY"
	order$[FALSE] = "YX"
	oldFunc = NUMFUNCS

	& setdata FunctionList
	i = 0
	repeat
		read i$
		if i$ <> "*" then
			func$[i] = i$
			i = i + 1
		endif
	until i$ = "*"

	if argc > 1 then tcFile$ = argv$[1]
	gosub xOpen

	whereX = 0
	whereY = 0
	repeat
		gosub drawStatus
		& ioctl (ioGotoXY, whereX * 4 + GRIDLEFT, whereY + GRIDTOP)
		get cmd$
		&lcase(cmd$)
		& pos (Arrows$, cmd$), p
		if p then
			whereX = whereX + movex[p]
			if whereX < $00 then whereX = $07
			if whereX > $07 then whereX = $00
			whereY = whereY + movey[p]
			if whereY < $00 then whereY = $0F
			if whereY > $0F then whereY = $00
		else
			& pos (Commands$, cmd$), p
			if p then
				on p gosub xNew, xWrite,  \
					xPrefix, xSuppress, xFunc, xANSI, \
					xLeadin, xHomerow, xCursOff, \
					xVT52, xOrder, xRedraw, xQuit, \
					xGoto, xGoto, xGoto
			endif
		endif
	until cmd$ = "q"
goto Exit

FunctionList: data \
	"Unused", \
	"GotoXY", \
	"ClrScrn", \
	"ClrEOS", \
	"ClrEOL", \
	"InsLine", \
	"DelLine", \
	"InsChar", \
	"DelChar", \
	"Home", \
	"Beep", \
	"CR", \
	"Inverse", \
	"Normal", \
	"ScrllUp", \
	"ScrllDn"

fl2:	data \
	"Up", \
	"Down", \
	"Right", \
	"Left", \
	"SoftTab", \
	"HardTab", \
	"EraseLn", \
	"InsOn", \
	"InsOff", \
	"UndLnOn", \
	"UnLnOff", \
	"MsTxtOn", \
	"MsTxOff", \
	"Unused", \
	"*"

xRedraw:
	oldFunc = NUMFUNCS
	
drawDisplay:
	& ioctl(ioNormal)
	& ioctl(ioClearScreen)
	INSTALL_HEXOUT
	& ioctl (ioGotoXY, GRIDLEFT - 4, GRIDTOP - 1)
	& ioctl (ioInverse)
	i$ = tcFile$
	& pos right$(i$, "/"), p
	i$ = mid$(i$, p + 1)
	& ucase (i$)
	& print "    0x  1x  2x  3x  4x  5x  6x  7x" spc(6) i$;
	& ioctl(ioClearEOL)
	& print
	for x = $00 to $0F
		& ioctl(ioInverse)
		& print "x" mid$(hex$, x + 1, 1);
		& ioctl (ioNormal)
		for y = $00 to $07
			poke $301, tchars[y * $10 + x]
			& print "  ";
			call HEXOUT
		next
		print "  |"
	next

	& setdata CommandList
	i = GRIDTOP + 1
	repeat
		read i$
		if i$ <> "*" then
			& ioctl(ioGotoXY, MENULEFT, i)
			& print i$;
			i = i + 1
		endif
	until i$ = "*"

	& ioctl (ioGotoXY, 0, FUNCLINE)
	i = 0
	repeat
		i$ = func$[i]
		if i <> 9 and i <> 19 and i <> 29 then & left$(i$, 8), i$
		& print i$;
		if i = 9 or i = 19 then & print
		i = i + 1
	until i > NUMFUNCS	
	
showModes:
	& ioctl(ioGotoXY, 0, MODELINE)
	& ioctl(ioInverse)
	& print "  ANSI:" YN$[ansi] "  VT52:" YN$[vt52clear] \
		"  Leadin:" leadin "  Row:" homerow  "  Curs:" \
		order$[xFirst]"+" cursoff "      ";
	& ioctl(ioNormal)

showCode:
	& ioctl (ioGotoXY, whereX * 4 + GRIDLEFT, whereY + GRIDTOP)
	index = whereX * $10 + whereY
	poke $301, tchars[index]
	call HEXOUT
return

drawStatus:
	index = whereX * $10 + whereY
	gosub getCharCodes
	if j <> oldFunc then gosub drawFunc
	if index > 32 and index < 127 then
		i$ = chr$(index)
	else
		if index < 32 then
			i$ = "^~" + chr$(index + 64)
		else
			if index = 32 then i$ = "spc"
			if index = 127 then i$ = "del"
		endif
	endif
	& ioctl(ioGotoXY, STATUSX, MODELINE)
	& ioctl(ioInverse)
	& print "Pos:" index "/$" mid$(hex$,whereX + 1,1) \
		mid$(hex$, whereY + 1, 1) "/" i$ \
		"  Sup:" YN$[suppress] "  Pfx:" YN$[prefix];
	& ioctl(ioClearEOL)
	if j <> oldFunc then
		oldFunc = j
		gosub drawFunc
	endif
	& ioctl(ioNormal)
return

drawFunc:
	i = int(oldFunc / 10)
	k = mod(oldFunc, 10)
	& ioctl(ioGotoXY, k * 8, FUNCLINE + i)
	& print func$[oldFunc];
return

getCharCodes:
	j = tchars[index]
	suppress = (j > 127)
	if suppress then j = j - 128
	prefix = (j > 63)
	if prefix then j = j - 64
return


CommandList: data \
	"File^In = new", \
	"^Iw = write", \
	"^Iq = quit", \
	""

cl2:	data \
	"Edit^If = function^I' = goto char", \
	"^Ip = prefix^I# = goto dec", \
	"^Is = suppress^I$ = goto hex", \
	"", \
	"Mode^Ia = ANSI", \
	"^Ic = cursor offset", \
	"^Ih = homerow", \
	"^Il = leadin prefix", \
	"^Iv = VT52 screen clear", \
	"^Ix = XY order", \
	"*"

	
getTermcap:
	fBload tcFile$ ",A" termcapAddr ",T0,L" TCAPSIZE

	for i = o_tchars to o_leadin - 1
		tchars[i] = peek(termcapAddr + i)
	next
	
	leadin = peek(termcapAddr + o_leadin)
	homerow = peek(termcapAddr + o_homerow)
	cursoff = peek(termcapAddr + o_cursoff)

	ansi = leadin < 128
	if not ansi then leadin = leadin - 128
	vt52clear = homerow > 127
	if vt52clear then homerow = homerow - 128
	xFirst = cursoff > 127
	if xFirst then cursoff = cursoff - 128
return


putTermcap:
	for i = o_tchars to o_leadin - 1
		poke termcapAddr + i, tchars[i]
	next

	i = leadin
	if not ansi then i = i + 128
	j = homerow
	if vt52clear then j = j + 128
	k = cursoff
	if xFirst then k = k + 128
	
	& poke termcapAddr + o_leadin, i, j, k

	fBsave tcFile$ ",A" termcapAddr ",T0,L"TCAPSIZE
	INSTALL_HEXOUT
return

getFileName:
	gosub clearModeLine
	i$ = tcFile$
	& read (-64, i$), "Termcap file name: ", tcFile$
	& ioctl(ioNormal)
return

getFileInfo:
	if tcFile$ > "" then
		& pos (tcFile$, "/"), p
		if not p then tcFile$ = TCAPS + tcFile$
		& getinfo tcFile$, i$
	else
		i$ = ""
	endif
return


xNew:
	gosub askSave
	gosub getFileName
xOpen:
	saved = TRUE
	gosub getFileInfo
	on (i$ > "") + 1 gosub xClear, getTermcap
goto drawDisplay

xClear:
	& erase(tchars)
	dim tchars[128]
	for i = 0 to 31
		tchars[i] = $80
	next
	tchars[7] = ioBeep
	tchars[8] = ioLeft
	tchars[9] = ioTab
	tchars[10] = ioDown
	tchars[12] = ioClearScreen
	tchars[13] = ioCR
	tchars[127] = $80
	leadin = 27
	homerow = 0
	cursoff = 32
	ansi = FALSE
	vt52clear = FALSE
	xFirst = FALSE
return

xWrite:
	noUpdate = cmd$ = "n" or cmd$ = "q"
	oldName$ = tcFile$
	gosub getFileName
	gosub getFileInfo
	if tcFile$ = "" then
		tcFile$ = oldName$
	else
		updateName = tcFile$ <> oldName$
		if i$ = "" then fCreate tcFile$ ",T0"
		gosub putTermcap
		saved = TRUE
		if updateName and not noUpdate then goto drawDisplay
	endif
	if not noUpdate then goto showModes
return

xQuit:
	gosub askSave
	& ioctl(ioGotoXY, 0, FUNCLINE)
	& ioctl(ioClearEOS)
	& print
return

askSave:
	if not saved then
		gosub clearModeLine
		i$ = "y"
		& read (-2, i$),"Save changes? (y/n) ",a$
		&lcase(a$)
		if a$ = "y" then gosub xWrite
		& ioctl(ioNormal)
	endif
return

xGoto:
	gosub clearModeLine
	j$ = cmd$
	& read (-4, j$),"Goto: ", i$
	if i$ > "" then
		& pos ("'#$", left$(i$,1)), p
		if p then
			i$ = mid$(i$, 2)
		else
			p = 1
		endif
		if i$ > "" then
			on p gosub xgChar, xgDec, xgHex
			if p < 0 or p > 127 then p = 0
			whereX = int(p / $10)
			whereY = mod(p, $10)
		endif
	endif
goto showModes

xgChar:
	p = asc(i$)
return

xgDec:
	p = val(i$)
return

xgHex:
	&ucase(i$)
	if len(i$) < 2 then i$ = "0" + i$
	&pos(hex$, left$(i$, 1)), i
	&pos(hex$, right$(i$, 1)), p
	p = (p - 1) + (i - 1) * $10
return

xPrefix:
	gosub getCharCodes
	prefix = not prefix
	tchars[index] = j + (suppress * 128) + (prefix * 64)
	saved = FALSE
goto showModes

xSuppress:
	gosub getCharCodes
	suppress = not suppress
	tchars[index] = j + (suppress * 128) + (prefix * 64)
	saved = FALSE
goto showModes
	
xFunc:
	& ioctl(ioInverse)
	gosub showCode
	gosub clearModeLine2
	& print "Use arrows and RETURN to choose a function:"
	gosub getCharCodes
	oldFunc = j
	repeat
		& ioctl(ioInverse)
		gosub drawFunc
		& ioctl(ioNormal)
		get a$
		& pos (Arrows$, a$), p
		if p then
			gosub drawFunc
			k = k + movex[p]
			if k < $00 then k = 9
			if k > 9 then k = 0
			i = i + movey[p]
			if i < $00 then i = 2
			if i > 2 then i = 0
			oldFunc = i * 10 + k
		endif
	until a$ = "^M"
	if oldFunc = NUMFUNCS then
		gosub drawFunc
		oldFunc = 0
		& ioctl(ioInverse)
		gosub drawFunc
	endif
	if leadin and index > 31 then prefix = TRUE
	tchars[index] = oldFunc + (suppress * 128) + (prefix * 64)
	saved = FALSE
goto showModes

return

clearModeLine:
	& ioctl (ioInverse)
clearModeLine2:
	& ioctl (ioGotoXY, 0, MODELINE)
	& ioctl (ioClearEOL)
return

xANSI:
	ansi = not ansi
	saved = FALSE
goto showModes

xLeadin:
	gosub clearModeLine
	i$ = str$(leadin)
	& read (-3,i$), "Leadin prefix (ASCII): ", a$
	leadin = val(a$)
	saved = FALSE
goto showModes

xHomerow:
	gosub clearModeLine
	i$ = str$(homerow)
	& read (-2,i$), "Home row (0-24): ", a$
	homerow = val(a$)
	saved = FALSE
goto showModes

xCursOff:
	gosub clearModeLine
	i$ = str$(cursoff)
	& read (-2,i$), "Cursor offset (0-32): ", a$
	cursoff = val(a$)
	saved = FALSE
goto showModes

xVT52:
	vt52clear = not vt52clear
	saved = FALSE
goto showModes

xOrder:
	xFirst = not xFirst
	saved = FALSE
goto showModes

#include <proline/proline.lib>
