' ***************************************************************************
' ***
' ***	boot.b		Boots out of ProLine and into something else
' ***			(C)opyright 1994 Morgan Davis Group
' ***

#define	IDENT_PROG "boot"
#define	IDENT_VERS "3.0"
#define	IDENT_DATE "21mar94"
#define	IDENT_NAME "Morgan_Davis"

#define COPR	"(C)opyright 1984-1994"

#define	BOOTSTRAP	"ProLine"

#include <basic.h>
#include <appleio.h>
#include <romcall.h>
#include <proline/proline.h>

	gosub AppInit
	if not SuperUser then 
		print argv$[0]": cannot execute"
		goto Exit
	endif

	options$ = "bhqr?"
	optchar$ = ""
	repeat
		gosub getOpt
		if optchar$ = "b" then stayInBASIC = TRUE
		if optchar$ = "h" then noHangUp = TRUE
		if optchar$ = "q" then quitFlag = TRUE
		if optchar$ = "r" then restartProLine = TRUE
		if optchar$ = "?" then
			print "Usage: "argv$[0] "[-bhqr] [app] [slot]"
			goto Exit
		endif
	until optchar$ = ""

	& pos(2, SysInfo$[plDir], "/"), p
	vol$ = left$(SysInfo$[plDir], p)

	rebootFlag = FALSE
	if quitFlag then
		b$ = "Quitting"
	else
		if nargc > 1 then
			a$ = nargv$[1]
			slot% = val(a$)
			if slot% then
				if slot% < 1 or slot% > 7 then
					print argv$[0]": bad slot " slot%
					goto Exit
				endif
				b$ = "Booting slot " + a$
			else
				& getinfo a$, i$
				if i$ = "" then
					& print argv$[0]": " a$ " not found"
					ExitStatus% = -1
					goto Exit
				endif
				b$ = "Launching " + a$
				slot% = 0
			endif
		else
			if stayInBASIC then
				b$ = "Staying in BASIC"
			else
				if restartProLine then
					b$ = "Restarting"
					a$ = SysInfo$[plDir] + BOOTSTRAP
				else
					b$ = "Rebooting"
					rebootFlag = TRUE
				endif
			endif
		endif
	endif
	
	poke 34,0			' kill status line
	& ioctl(ioClearScreen)
	print "ProLine Version " SysInfo$[plVersion]
	print COPR
	print "By Morgan Davis Group"
	print "World Rights Reserved"
	print
	& time(t$)
	print b$ " on "t$
	print 
	if SysInfo$[plAdmin] > "" then
		j$ = mid$ (t$,1)
		& lcase(t$)
		fAppend SPOOL_LOGS_PATH "syslog"
		i$ = mid$ (t$,16,2) + mid$ (t$,19,2)
		print mid$ (t$,6,2) mid$ (t$,9,3) mid$ (t$,13,3) \
			"-----  cron " i$ "-" i$ "=0000 !DOWNTIME: " j$
		fClose
	endif

	& fn fnCarrier,i
	if not noHangUp and i then
		& wait 1
		& hangup
	endif

	onerr goto fatalError
	& scrn(stdAppleIO)
	print "Unloading . . ."
	print
	& ioctl(ioULOn)
	print ommTableHeader
	& ioctl(ioULOff)
	& load trace
	& load fre
	print
	print "Successful shutdown."

	if stayInBASIC then
		print "Welcome to Applesoft..."
		new
	endif
	
	if quitFlag then fBye

	if slot% then
		fOutPort slot%
		print
		fOutPort 0
		print "ERROR!  Could not boot slot " slot%
		goto waitBoot
	endif

	if rebootFlag then goto Restart

	fLaunch a$
new 

fatalError:
	print "ERROR!  Code " ERR " in " ERL
	poke 216, 0
waitBoot:
	clear
	for i = 1 to 2000 : next
Restart:
	i = peek(_PWREDUP)
	poke _PWREDUP, i + (i < 255) - (i = 255)
	call _RESET
stop 

#include <proline/proline.lib>
#include <proline/getopt.lib>
